/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.descriptor;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.deployment.ui.Inspector;
import com.sun.enterprise.tools.deployment.ui.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.descriptor.MyTableModel;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.NotificationEvent;
import com.sun.enterprise.util.NotificationListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.help.CSH;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableModel;

public class WebAppContextParametersInspector
extends JPanel
implements Inspector {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$descriptor$WebAppContextParametersInspector != null ? class$com$sun$enterprise$tools$deployment$ui$descriptor$WebAppContextParametersInspector : (class$com$sun$enterprise$tools$deployment$ui$descriptor$WebAppContextParametersInspector = WebAppContextParametersInspector.class$("com.sun.enterprise.tools.deployment.ui.descriptor.WebAppContextParametersInspector")));
    WebBundleDescriptor descriptor;
    private InspectorTable contextParametersTable = new InspectorTable();
    String[] columns = new String[]{localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.contextparam", "Context Parameter"), localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.value", "Value")};
    private NotificationListener tableEditListener;
    private static String helpSetMapID = "WIContext";
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$descriptor$WebAppContextParametersInspector;

    public WebAppContextParametersInspector() {
        CSH.setHelpIDString((Component)this, (String)helpSetMapID);
        this.initializeLayout();
    }

    public void addAction() {
        Vector<String> v2 = new Vector<String>();
        Enumeration e10 = this.descriptor.getContextParameters();
        while (e10.hasMoreElements()) {
            EnvironmentProperty ep2 = (EnvironmentProperty)e10.nextElement();
            v2.addElement(ep2.getName());
        }
        this.descriptor.addContextParameter(new EnvironmentProperty(Descriptor.createUniqueNameAmongst("contextParameter", v2), "value", ""));
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public void deleteAction() {
        int i2 = this.contextParametersTable.getSelectedRow();
        if (i2 != -1) {
            int n2 = JOptionPane.showConfirmDialog(this, localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.askdelete", "Are you sure you want to delete selected parameter?"), "Delete parameter", 0);
            if (n2 == 0) {
                String key = (String)((MyTableModel)this.contextParametersTable.getModel()).getValueAt(i2, 0);
                Enumeration e10 = this.descriptor.getContextParameters();
                while (e10.hasMoreElements()) {
                    EnvironmentProperty ep2 = (EnvironmentProperty)e10.nextElement();
                    if (!ep2.getName().equals(key)) continue;
                    this.descriptor.removeContextParameter(ep2);
                }
            }
        } else {
            JOptionPane.showMessageDialog(this, localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.warnselect", "You must first select a parameter from the list"));
        }
    }

    private void initializeLayout() {
        this.setLayout(new BorderLayout());
        Object[][] data = new Object[][]{{"a", "b"}, {"b", "b"}};
        MyTableModel tableModel = new MyTableModel(data, this.columns, 0);
        this.contextParametersTable.setAutoResizeMode(4);
        this.contextParametersTable.setModel(tableModel);
        this.contextParametersTable.setSelectionMode(0);
        JPanel cpPanel = new JPanel();
        cpPanel.setLayout(new BorderLayout());
        cpPanel.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        cpPanel.add(new JScrollPane(this.contextParametersTable));
        this.add("Center", cpPanel);
        JButton addButton = new JButton(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.add", "Add"));
        JButton deleteButton = new JButton(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.delete", "Delete..."));
        JPanel buttonPanel = new JPanel(new GridLayout(2, 1, 0, 5));
        buttonPanel.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        buttonPanel.add(addButton);
        buttonPanel.add(deleteButton);
        JPanel wrapperPanel = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        wrapperPanel.setLayout(gb);
        GridBagConstraints c10 = new GridBagConstraints();
        c10.gridx = 0;
        c10.gridy = 0;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.weightx = 0.0;
        c10.weighty = 0.0;
        c10.anchor = 10;
        c10.fill = 2;
        gb.setConstraints(buttonPanel, c10);
        wrapperPanel.add(buttonPanel);
        this.add("East", wrapperPanel);
        addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                WebAppContextParametersInspector.this.addAction();
            }
        });
        deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                WebAppContextParametersInspector.this.deleteAction();
            }
        });
        this.tableEditListener = new NotificationListener(){

            public void notification(NotificationEvent ne) {
                WebAppContextParametersInspector.this.tableChanged();
            }
        };
    }

    public static void main(String[] args) {
        JFrame f2 = new JFrame();
        ((Component)f2).setBounds(0, 0, 300, 300);
        f2.getContentPane().add(new WebAppContextParametersInspector());
        f2.show();
    }

    private void refresh() {
        Object[][] tableData = new Object[this.descriptor.getContextParametersSet().size()][2];
        Vector cps = new Vector(this.descriptor.getContextParametersSet());
        int i2 = 0;
        while (i2 < this.descriptor.getContextParametersSet().size()) {
            EnvironmentProperty ep2 = (EnvironmentProperty)cps.elementAt(i2);
            tableData[i2][0] = ep2.getName();
            tableData[i2][1] = ep2.getValue();
            ++i2;
        }
        MyTableModel tableModel = new MyTableModel(tableData, this.columns, 0);
        tableModel.addNotificationListener(this.tableEditListener);
        this.contextParametersTable.setModel(tableModel);
        this.contextParametersTable.sizeColumnsToFit(0);
    }

    public void setObject(Object object) {
        if (object instanceof WebBundleDescriptor) {
            this.descriptor = (WebBundleDescriptor)object;
            this.refresh();
        }
    }

    public void tableChanged() {
        if (this.descriptor != null) {
            this.descriptor.getContextParametersSet().removeAll(this.descriptor.getContextParametersSet());
            TableModel tableModel = this.contextParametersTable.getModel();
            int i2 = 0;
            while (i2 < tableModel.getRowCount()) {
                String next = (String)tableModel.getValueAt(i2, 0);
                String value = (String)tableModel.getValueAt(i2, 1);
                this.descriptor.getContextParametersSet().add(new EnvironmentProperty(next, value, ""));
                ++i2;
            }
            this.descriptor.changed();
        }
    }
}

