/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.descriptor;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.ErrorPageDescriptorImpl;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.deployment.ui.Inspector;
import com.sun.enterprise.tools.deployment.ui.InspectorTable;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.help.CSH;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class WebAppFileRefsInspector
extends JPanel
implements Inspector {
    WebBundleDescriptor descriptor;
    WelcomeTable welcomeTable;
    JScrollPane scrlWelcomeTable;
    JButton btnDeleteWelcomeFile = new JButton("Delete...");
    JButton btnAddWelcomeFile = new JButton("Add");
    JPanel pnlErrorMapping = new JPanel();
    ErrorMappingTable errorMappingTable;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$descriptor$WebAppFileRefsInspector != null ? class$com$sun$enterprise$tools$deployment$ui$descriptor$WebAppFileRefsInspector : (class$com$sun$enterprise$tools$deployment$ui$descriptor$WebAppFileRefsInspector = WebAppFileRefsInspector.class$("com.sun.enterprise.tools.deployment.ui.descriptor.WebAppFileRefsInspector")));
    static final String[] columnNames = new String[]{localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.errorlabel", "Error/exception"), localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.url", "URL")};
    private static String helpSetMapID = "WIFileRef";
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$descriptor$WebAppFileRefsInspector;

    public WebAppFileRefsInspector() {
        CSH.setHelpIDString((Component)this, (String)helpSetMapID);
        this.initializeLayout();
    }

    private void addErrorMappingAction() {
        Vector<String> v2 = new Vector<String>();
        Enumeration e10 = this.descriptor.getErrorPageDescriptors();
        while (e10.hasMoreElements()) {
            ErrorPageDescriptorImpl next = (ErrorPageDescriptorImpl)e10.nextElement();
            v2.addElement(next.getErrorSignifierAsString());
        }
        String nexFilename = Descriptor.createUniqueNameAmongst("error code / exception", v2);
        this.descriptor.addErrorPageDescriptor(new ErrorPageDescriptorImpl(nexFilename, "url"));
    }

    private void addWelcomeFileAction() {
        Vector v2 = new Vector();
        Enumeration e10 = this.descriptor.getWelcomeFiles();
        while (e10.hasMoreElements()) {
            v2.addElement(e10.nextElement());
        }
        String nexFilename = Descriptor.createUniqueNameAmongst("indexPage", v2);
        this.descriptor.addWelcomeFile(nexFilename);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private void deleteErrorMappingAction() {
        int i2 = this.errorMappingTable.getSelectedRow();
        if (i2 != -1) {
            int n2 = JOptionPane.showConfirmDialog(this, localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.askdeleteerror", "Are you sure you want to delete the selected error mapping?"), "Delete error mapping", 0);
            if (n2 == 0) {
                String key = (String)((ErrorMappingTableModel)this.errorMappingTable.getModel()).getValueAt(i2, 0);
                ErrorPageDescriptorImpl epd = (ErrorPageDescriptorImpl)this.descriptor.getErrorPageDescriptorBySignifier(key);
                this.descriptor.removeErrorPageDescriptor(epd);
                this.errorMappingTable.setSelectedRow(-1);
            }
        } else {
            JOptionPane.showMessageDialog(this, localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.warnselecterror", "You must first select an error mapping from the list"));
        }
    }

    private void deleteWelcomeFileAction() {
        int i2 = this.welcomeTable.getSelectedRow();
        if (i2 != -1) {
            int n2 = JOptionPane.showConfirmDialog(this, localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.askdeletewelcome", "Are you sure you want to delete the selected welcome file?"), "Delete welcome file", 0);
            if (n2 == 0) {
                String welcomeFilename = (String)((WelcomeTableModel)this.welcomeTable.getModel()).getValueAt(i2, 0);
                this.descriptor.removeWelcomeFile(welcomeFilename);
                this.welcomeTable.setSelectedRow(-1);
            }
        } else {
            JOptionPane.showMessageDialog(this, localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.warnselectwelcome", "You must first select a welcome file from the list"));
        }
    }

    private void initializeLayout() {
        this.setLayout(new BorderLayout());
        JPanel pnlCenter = new JPanel();
        pnlCenter.setLayout(new BoxLayout(pnlCenter, 0));
        this.welcomeTable = new WelcomeTable(new WelcomeTableModel(this));
        JScrollPane scrlWelcomeTable = new JScrollPane(this.welcomeTable);
        JPanel pnlWelcomeFiles = new JPanel();
        pnlWelcomeFiles.setBorder(new TitledBorder(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.welcomefiles", "Welcome files")));
        pnlWelcomeFiles.setLayout(new BorderLayout());
        this.btnAddWelcomeFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                WebAppFileRefsInspector.this.addWelcomeFileAction();
            }
        });
        this.btnDeleteWelcomeFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                WebAppFileRefsInspector.this.deleteWelcomeFileAction();
            }
        });
        JButton btnAddErrorMapping = new JButton(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.add", "Add"));
        btnAddErrorMapping.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                WebAppFileRefsInspector.this.addErrorMappingAction();
            }
        });
        JButton btnDeleteErrorMapping = new JButton();
        btnDeleteErrorMapping.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                WebAppFileRefsInspector.this.deleteErrorMappingAction();
            }
        });
        btnDeleteErrorMapping.setText(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.delete", "Delete..."));
        JPanel pnlErrorMapping = new JPanel();
        pnlErrorMapping.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 134)), localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.errormapping", "Error mapping")));
        pnlErrorMapping.setLayout(new BorderLayout());
        this.errorMappingTable = new ErrorMappingTable(new ErrorMappingTableModel(this));
        JScrollPane scrlErrorTable = new JScrollPane(this.errorMappingTable);
        scrlErrorTable.setPreferredSize(new Dimension(335, 100));
        this.add((Component)pnlCenter, "Center");
        pnlCenter.add(pnlWelcomeFiles);
        pnlWelcomeFiles.add((Component)scrlWelcomeTable, "Center");
        JPanel pnlWelcomeFileButtons = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints c10 = new GridBagConstraints();
        c10.gridx = 0;
        c10.gridy = 0;
        c10.insets = new Insets(0, 0, 5, 0);
        c10.fill = 2;
        c10.anchor = 10;
        pnlWelcomeFileButtons.setLayout(gb);
        pnlWelcomeFiles.add((Component)pnlWelcomeFileButtons, "East");
        pnlWelcomeFileButtons.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        gb.setConstraints(this.btnAddWelcomeFile, c10);
        pnlWelcomeFileButtons.add(this.btnAddWelcomeFile);
        c10.gridy = 1;
        c10.insets = new Insets(0, 0, 0, 0);
        gb.setConstraints(this.btnDeleteWelcomeFile, c10);
        pnlWelcomeFileButtons.add(this.btnDeleteWelcomeFile);
        this.add((Component)pnlErrorMapping, "South");
        JPanel pnlErrorMappingButtons = new JPanel();
        GridBagLayout gb1 = new GridBagLayout();
        c10.gridx = 0;
        c10.gridy = 0;
        c10.insets = new Insets(0, 0, 5, 0);
        c10.fill = 2;
        c10.anchor = 10;
        pnlErrorMappingButtons.setLayout(gb1);
        pnlErrorMapping.add((Component)scrlErrorTable, "Center");
        pnlErrorMapping.add((Component)pnlErrorMappingButtons, "East");
        pnlErrorMappingButtons.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        gb1.setConstraints(btnAddErrorMapping, c10);
        pnlErrorMappingButtons.add(btnAddErrorMapping);
        c10.gridy = 1;
        c10.insets = new Insets(0, 0, 0, 0);
        gb1.setConstraints(btnDeleteErrorMapping, c10);
        pnlErrorMappingButtons.add(btnDeleteErrorMapping);
    }

    private void refresh() {
        WelcomeTableModel welcomeTableModel = new WelcomeTableModel(this);
        Enumeration welcomeFiles = this.descriptor.getWelcomeFiles();
        while (welcomeFiles.hasMoreElements()) {
            welcomeTableModel.addRow((String)welcomeFiles.nextElement());
        }
        this.welcomeTable.setModel(welcomeTableModel);
        this.welcomeTable.setAutoResizeMode(4);
        this.welcomeTable.sizeColumnsToFit(0);
        ErrorMappingTableModel errorMappingTableModel = new ErrorMappingTableModel(this);
        Enumeration errorPageDescriptors = this.descriptor.getErrorPageDescriptors();
        while (errorPageDescriptors.hasMoreElements()) {
            ErrorPageDescriptorImpl errorPageDescriptor = (ErrorPageDescriptorImpl)errorPageDescriptors.nextElement();
            errorMappingTableModel.addRow(errorPageDescriptor.getErrorSignifierAsString(), errorPageDescriptor.getLocation());
        }
        this.errorMappingTable.setModel(errorMappingTableModel);
        this.errorMappingTable.setAutoResizeMode(4);
        this.errorMappingTable.sizeColumnsToFit(0);
    }

    public void setObject(Object object) {
        if (object instanceof WebBundleDescriptor) {
            this.descriptor = (WebBundleDescriptor)object;
            this.refresh();
        }
    }

    private class WelcomeTable
    extends InspectorTable {
        int selectedRow = -1;

        public WelcomeTable(WelcomeTableModel model) {
            super(model);
            this.setToolTipText(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.welcometable", "Table of Welcome Files"));
            this.setSelectionMode(0);
            ListSelectionModel rowSM = this.getSelectionModel();
            rowSM.addListSelectionListener(new ListSelectionListener(this){
                private final /* synthetic */ WelcomeTable this$1;
                {
                    this.this$1 = this$1;
                }

                public void valueChanged(ListSelectionEvent e10) {
                    ListSelectionModel lsm = (ListSelectionModel)e10.getSource();
                    if (!lsm.isSelectionEmpty()) {
                        WelcomeTable.access$0(this.this$1, lsm.getMinSelectionIndex());
                    } else {
                        WelcomeTable.access$0(this.this$1, -1);
                    }
                }
            });
        }

        private void setSelectedRow(int index) {
            Integer oldIndex = new Integer(this.selectedRow);
            this.selectedRow = index;
        }

        void setupColNameColumn() {
            TableColumn colNameColumn = this.getColumnModel().getColumn(1);
            JTextField colNameText = new JTextField();
            colNameColumn.setCellEditor(new DefaultCellEditor(colNameText));
            DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
            renderer.setToolTipText(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.edittext", "Click to edit text"));
            colNameColumn.setCellRenderer(renderer);
        }
    }

    public class WelcomeTableModel
    extends AbstractTableModel {
        ArrayList fields = new ArrayList();
        WebAppFileRefsInspector inspector;
        String[] columnNames = new String[]{""};

        public WelcomeTableModel(WebAppFileRefsInspector inspector) {
            this.inspector = inspector;
        }

        public void addRow(String welcomefile) {
            FieldInfo field = new FieldInfo();
            field.welcomefile = welcomefile;
            this.fields.add(field);
            this.fireTableRowsInserted(this.fields.size() - 1, this.fields.size() - 1);
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public String getColumnName(int col) {
            return this.columnNames[col].toString();
        }

        public int getRowCount() {
            return this.fields.size();
        }

        public Object getValueAt(int row, int col) {
            FieldInfo fieldInfo = (FieldInfo)this.fields.get(row);
            Object value = fieldInfo.getElement(col);
            return value;
        }

        public boolean isCellEditable(int row, int col) {
            return true;
        }

        public void setValueAt(Object value, int row, int col) {
            FieldInfo fieldInfo = (FieldInfo)this.fields.get(row);
            fieldInfo.setElement(col, value);
            this.writeFieldInfosToModel();
        }

        private void writeFieldInfosToModel() {
            HashSet<String> welcomeFiles = new HashSet<String>();
            Iterator itr = ((AbstractList)this.fields).iterator();
            while (itr.hasNext()) {
                FieldInfo next = (FieldInfo)itr.next();
                welcomeFiles.add(next.welcomefile);
            }
            WebAppFileRefsInspector.this.descriptor.setWelcomeFiles(welcomeFiles);
        }

        private class FieldInfo {
            String welcomefile;

            FieldInfo() {
            }

            Object getElement(int col) {
                String elem = null;
                switch (col) {
                    case 0: {
                        elem = this.welcomefile;
                        break;
                    }
                }
                return elem;
            }

            void setElement(int col, Object elem) {
                switch (col) {
                    case 0: {
                        this.welcomefile = elem.toString();
                        break;
                    }
                }
            }
        }
    }

    private class ErrorMappingTable
    extends InspectorTable {
        int selectedRow = -1;

        public ErrorMappingTable(ErrorMappingTableModel model) {
            super(model);
            this.setToolTipText(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.contexttable", "Table of context parameters"));
            this.setSelectionMode(0);
            ListSelectionModel rowSM = this.getSelectionModel();
            rowSM.addListSelectionListener(new ListSelectionListener(this){
                private final /* synthetic */ ErrorMappingTable this$1;
                {
                    this.this$1 = this$1;
                }

                public void valueChanged(ListSelectionEvent e10) {
                    ListSelectionModel lsm = (ListSelectionModel)e10.getSource();
                    if (!lsm.isSelectionEmpty()) {
                        ErrorMappingTable.access$0(this.this$1, lsm.getMinSelectionIndex());
                    } else {
                        ErrorMappingTable.access$0(this.this$1, -1);
                    }
                }
            });
        }

        private void setSelectedRow(int index) {
            Integer oldIndex = new Integer(this.selectedRow);
            this.selectedRow = index;
        }

        void setupColNameColumn() {
            TableColumn colNameColumn = this.getColumnModel().getColumn(1);
            JTextField colNameText = new JTextField();
            colNameColumn.setCellEditor(new DefaultCellEditor(colNameText));
            DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
            renderer.setToolTipText(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.edittext", "Click to edit text"));
            colNameColumn.setCellRenderer(renderer);
        }

        void setupTypeColumn() {
            TableColumn typeColumn = this.getColumnModel().getColumn(2);
            JComboBox typeComboBox = new JComboBox();
            typeColumn.setCellEditor(new DefaultCellEditor(typeComboBox));
            DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
            renderer.setToolTipText(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.edittext", "Click to edit text"));
            typeColumn.setCellRenderer(renderer);
        }
    }

    public class ErrorMappingTableModel
    extends AbstractTableModel {
        ArrayList fields = new ArrayList();
        WebAppFileRefsInspector inspector;
        String[] columnNames = new String[]{WebAppFileRefsInspector.access$4().getLocalString("enterprise.tools.deployment.ui.descriptor.errorlabel", "Error/Exception"), WebAppFileRefsInspector.access$4().getLocalString("enterprise.tools.deployment.ui.descriptor.url", "URL")};

        public ErrorMappingTableModel(WebAppFileRefsInspector inspector) {
            this.inspector = inspector;
        }

        public void addRow(String anomaly, String url) {
            FieldInfo field = new FieldInfo();
            field.anomaly = anomaly;
            field.url = url;
            this.fields.add(field);
            this.fireTableRowsInserted(this.fields.size() - 1, this.fields.size() - 1);
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public String getColumnName(int col) {
            return this.columnNames[col].toString();
        }

        public int getRowCount() {
            return this.fields.size();
        }

        public Object getValueAt(int row, int col) {
            FieldInfo fieldInfo = (FieldInfo)this.fields.get(row);
            Object value = fieldInfo.getElement(col);
            return value;
        }

        public boolean isCellEditable(int row, int col) {
            return true;
        }

        public void setValueAt(Object value, int row, int col) {
            FieldInfo fieldInfo = (FieldInfo)this.fields.get(row);
            ErrorPageDescriptorImpl epd = (ErrorPageDescriptorImpl)WebAppFileRefsInspector.this.descriptor.getErrorPageDescriptorBySignifier(fieldInfo.anomaly);
            fieldInfo.setElement(col, value);
            if (col == 0) {
                epd.setErrorSignifierAsString((String)value);
            }
            if (col == 1) {
                epd.setLocation((String)value);
            }
            WebAppFileRefsInspector.this.descriptor.changed();
        }

        private class FieldInfo {
            String anomaly;
            String url;

            FieldInfo() {
            }

            Object getElement(int col) {
                String elem = null;
                switch (col) {
                    case 0: {
                        elem = this.anomaly;
                        break;
                    }
                    case 1: {
                        elem = this.url;
                        break;
                    }
                }
                return elem;
            }

            void setElement(int col, Object elem) {
                switch (col) {
                    case 0: {
                        this.anomaly = elem.toString();
                        break;
                    }
                    case 1: {
                        this.url = elem.toString();
                        break;
                    }
                }
            }
        }
    }
}

