/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.descriptor;

import com.sun.enterprise.deployment.ApplicationArchivist;
import com.sun.enterprise.deployment.FileContentsDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.deployment.ui.ContentWizard;
import com.sun.enterprise.tools.deployment.ui.IconChanger;
import com.sun.enterprise.tools.deployment.ui.IconInspector;
import com.sun.enterprise.tools.deployment.ui.Inspector;
import com.sun.enterprise.tools.deployment.ui.Wand;
import com.sun.enterprise.tools.deployment.ui.descriptor.MimeMappingDialog;
import com.sun.enterprise.util.FileUtil;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.help.CSH;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

public class WebAppGeneralInspector
extends JPanel
implements Inspector,
Wand,
IconChanger {
    WebBundleDescriptor descriptor;
    String mode = "DeployerMode";
    private static final String CHOOSE_LARGE_ICON_TITLE = "Choose Large Icon";
    private static final String CHOOSE_SMALL_ICON_TITLE = "Choose Small Icon";
    JTextField warFileText;
    JTextField displayNameText;
    JTextArea descriptionText;
    JTextField contentsRootDirText;
    JTextField sessionTimeoutText;
    JCheckBox distributableCheckBox = new JCheckBox();
    JButton mimeMappingPB;
    IconInspector iconInspector;
    DefaultListModel contentsListModel;
    JList contentsList;
    JButton addPB;
    JButton delPB;
    MimeMappingDialog mimeMappingDialog;
    ContentWizard contentWizard;
    private JComponent targetChooser;
    private static String helpSetMapID = "WIGeneral";
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$descriptor$WebAppGeneralInspector != null ? class$com$sun$enterprise$tools$deployment$ui$descriptor$WebAppGeneralInspector : (class$com$sun$enterprise$tools$deployment$ui$descriptor$WebAppGeneralInspector = WebAppGeneralInspector.class$("com.sun.enterprise.tools.deployment.ui.descriptor.WebAppGeneralInspector")));
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$descriptor$WebAppGeneralInspector;
    static /* synthetic */ Class class$javax$swing$JFrame;
    static /* synthetic */ Class class$java$awt$Frame;

    public WebAppGeneralInspector() {
        CSH.setHelpIDString((Component)this, (String)helpSetMapID);
        this.initializeLayout();
        this.addListeners();
    }

    public WebAppGeneralInspector(String mode) {
        this();
        this.mode = mode;
    }

    public WebAppGeneralInspector(String mode, JComponent targetChooser) {
        CSH.setHelpIDString((Component)this, (String)helpSetMapID);
        this.targetChooser = targetChooser;
        this.initializeLayout();
        this.addListeners();
        this.mode = mode;
    }

    private void addAllContentsAction() {
        try {
            Set allFiles = FileUtil.getAllFilesUnder(new File(this.getContentRoot()), null);
            this.getContentList().setListData(new Vector(allFiles));
        }
        catch (Throwable throwable) {}
    }

    private void addContentAction() {
        if (this.contentWizard == null) {
            Frame frame = (Frame)SwingUtilities.getAncestorOfClass(class$java$awt$Frame != null ? class$java$awt$Frame : (class$java$awt$Frame = WebAppGeneralInspector.class$("java.awt.Frame")), this);
            this.contentWizard = new ContentWizard(frame);
            this.contentWizard.show();
        } else {
            ((Component)this.contentWizard).setVisible(true);
        }
        if (this.contentWizard.didComplete()) {
            this.refresh();
        }
    }

    public void addLargeIcon(File iconFile) {
        if (!this.mode.equals("DeveloperMode")) {
            ApplicationArchivist archivist = this.descriptor.getApplication().getApplicationArchivist();
            try {
                archivist.add32Icon(this.descriptor, this.descriptor, iconFile);
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(this, localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.iconcouldnotbeadded", "Icon could not be added.\n {0}", new Object[]{ioe.getMessage()}));
            }
        } else {
            if (!"".equals(this.descriptor.getLargeIconUri())) {
                this.getContentsDescriptor().removeFile(new File(this.descriptor.getLargeIconUri()));
            }
            File absoluteIconFile = new File(iconFile.getAbsolutePath());
            this.getContentsDescriptor().add(new File(absoluteIconFile.getName()), absoluteIconFile.getParentFile());
            this.descriptor.setLargeIconUri(absoluteIconFile.getName());
            this.refresh();
        }
    }

    private void addListeners() {
        this.displayNameText.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent fe2) {
                WebAppGeneralInspector.this.descriptor.setName(WebAppGeneralInspector.this.displayNameText.getText().trim());
            }
        });
        this.displayNameText.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                if (ke.getKeyCode() == 10) {
                    WebAppGeneralInspector.this.descriptor.setName(WebAppGeneralInspector.this.displayNameText.getText());
                }
            }
        });
        this.sessionTimeoutText.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent fe2) {
                try {
                    WebAppGeneralInspector.this.descriptor.setSessionTimeout(Integer.parseInt(WebAppGeneralInspector.this.sessionTimeoutText.getText().trim()));
                }
                catch (NumberFormatException numberFormatException) {}
            }
        });
        this.sessionTimeoutText.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                block2: {
                    if (ke.getKeyCode() != 10) break block2;
                    try {
                        WebAppGeneralInspector.this.descriptor.setSessionTimeout(Integer.parseInt(WebAppGeneralInspector.this.sessionTimeoutText.getText().trim()));
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
        });
        this.descriptionText.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent fe2) {
                WebAppGeneralInspector.this.descriptor.setDescription(WebAppGeneralInspector.this.descriptionText.getText().trim());
            }
        });
        this.descriptionText.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                if (ke.getKeyCode() == 10) {
                    WebAppGeneralInspector.this.descriptor.setDescription(WebAppGeneralInspector.this.descriptionText.getText());
                }
            }
        });
    }

    public void addSmallIcon(File iconFile) {
        if (!this.mode.equals("DeveloperMode")) {
            ApplicationArchivist archivist = this.descriptor.getApplication().getApplicationArchivist();
            try {
                archivist.add16Icon(this.descriptor, this.descriptor, iconFile);
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(this, "Icon could not be added.\n " + ioe.getMessage());
            }
        } else {
            if (!"".equals(this.descriptor.getSmallIconUri())) {
                this.getContentsDescriptor().removeFile(new File(this.descriptor.getSmallIconUri()));
            }
            File absoluteIconFile = new File(iconFile.getAbsolutePath());
            this.getContentsDescriptor().add(new File(absoluteIconFile.getName()), absoluteIconFile.getParentFile());
            this.descriptor.setSmallIconUri(absoluteIconFile.getName());
            this.refresh();
        }
    }

    public boolean canLeaveBackward() {
        return true;
    }

    public boolean canLeaveForward() {
        if (this.warFileText.getText().equals("")) {
            JOptionPane.showMessageDialog(this, localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.mustspecifywarfile", "You must specify a .war file"));
            return false;
        }
        return true;
    }

    private void checkMode() {
        if ("DeveloperMode".equals(this.mode)) {
            this.addPB.setEnabled(true);
            this.delPB.setEnabled(true);
        } else {
            this.contentsRootDirText.setEnabled(false);
            this.warFileText.setEnabled(false);
            this.addPB.setEnabled(false);
            this.delPB.setEnabled(false);
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private void deleteContentAction() {
        Object[] selection = this.contentsList.getSelectedValues();
        if (selection != null) {
            int i2 = 0;
            while (i2 < selection.length) {
                this.getClassDescriptor().removeFile((File)selection[i2]);
                this.getContentsDescriptor().removeFile((File)selection[i2]);
                ++i2;
            }
            this.refresh();
        }
    }

    public FileContentsDescriptor getClassDescriptor() {
        return this.getContentWizard().getClassDescriptor();
    }

    public JList getContentList() {
        return this.contentsList;
    }

    public String getContentRoot() {
        return this.contentsRootDirText.getText();
    }

    private ContentWizard getContentWizard() {
        if (this.contentWizard == null) {
            Frame frame = (Frame)SwingUtilities.getAncestorOfClass(class$java$awt$Frame != null ? class$java$awt$Frame : (class$java$awt$Frame = WebAppGeneralInspector.class$("java.awt.Frame")), this);
            this.contentWizard = new ContentWizard(frame);
        }
        return this.contentWizard;
    }

    public FileContentsDescriptor getContentsDescriptor() {
        return this.getContentWizard().getContentsDescriptor();
    }

    public WebBundleDescriptor getDescriptor() {
        return this.descriptor;
    }

    public String getWarLocation() {
        return this.warFileText.getText();
    }

    private void initializeLayout() {
        CSH.setHelpIDString((Component)this, (String)"War_General_Inspector_Tab");
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        GridBagConstraints c10 = new GridBagConstraints();
        c10.fill = 1;
        c10.weightx = 0.5;
        JLabel warFileLabel = new JLabel(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.warfile", "WAR file:"));
        c10.weightx = 0.0;
        c10.weighty = 0.0;
        c10.gridx = 0;
        c10.gridy = 0;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(5, 5, 0, 5);
        gridbag.setConstraints(warFileLabel, c10);
        this.add(warFileLabel);
        this.warFileText = new JTextField();
        this.warFileText.setText(new File("webapp.war").getAbsolutePath());
        c10.weightx = 0.0;
        c10.weighty = 0.0;
        c10.gridx = 0;
        c10.gridy = 1;
        c10.insets = new Insets(0, 5, 0, 5);
        if (this.targetChooser != null) {
            gridbag.setConstraints(this.targetChooser, c10);
            this.add(this.targetChooser);
        } else {
            gridbag.setConstraints(this.warFileText, c10);
            this.add(this.warFileText);
        }
        JLabel displayNameLabel = new JLabel(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.displayname", "Display name:"));
        c10.weightx = 0.0;
        c10.weighty = 0.0;
        c10.gridx = 0;
        c10.gridy = 2;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(5, 5, 0, 5);
        gridbag.setConstraints(displayNameLabel, c10);
        this.add(displayNameLabel);
        this.displayNameText = new JTextField();
        c10.weightx = 0.0;
        c10.weighty = 0.0;
        c10.gridx = 0;
        c10.gridy = 3;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(0, 5, 0, 5);
        gridbag.setConstraints(this.displayNameText, c10);
        this.add(this.displayNameText);
        JLabel descriptionLabel = new JLabel(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.description", "Description:"));
        c10.weightx = 0.0;
        c10.weighty = 0.0;
        c10.gridx = 0;
        c10.gridy = 4;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(5, 5, 0, 5);
        gridbag.setConstraints(descriptionLabel, c10);
        this.add(descriptionLabel);
        this.descriptionText = new JTextArea();
        JScrollPane descriptionTextPane = new JScrollPane(this.descriptionText);
        descriptionTextPane.setPreferredSize(new Dimension(300, 200));
        c10.weightx = 0.5;
        c10.weighty = 0.2;
        c10.gridx = 0;
        c10.gridy = 5;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(0, 5, 5, 5);
        gridbag.setConstraints(descriptionTextPane, c10);
        this.add(descriptionTextPane);
        JPanel contentsPanel = new JPanel();
        contentsPanel.setBorder(new TitledBorder(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.contents", "Contents")));
        GridBagLayout gb1 = new GridBagLayout();
        contentsPanel.setLayout(gb1);
        c10.weightx = 0.3;
        c10.weighty = 0.0;
        c10.gridx = 0;
        c10.gridy = 6;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.fill = 1;
        c10.anchor = 10;
        c10.insets = new Insets(5, 5, 5, 5);
        gridbag.setConstraints(contentsPanel, c10);
        this.add(contentsPanel);
        this.contentsListModel = new DefaultListModel();
        this.contentsList = new JList(this.contentsListModel);
        JScrollPane contentsListPane = new JScrollPane(this.contentsList);
        contentsListPane.setPreferredSize(new Dimension(300, 250));
        c10.weightx = 0.5;
        c10.weighty = 0.5;
        c10.gridx = 0;
        c10.gridy = 0;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(0, 5, 5, 5);
        gb1.setConstraints(contentsListPane, c10);
        contentsPanel.add(contentsListPane);
        JPanel contentsButtonPanel = new JPanel();
        contentsButtonPanel.setLayout(new GridLayout(1, 2, 5, 5));
        c10.gridx = 0;
        c10.gridy = 1;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.weightx = 0.0;
        c10.weighty = 0.0;
        c10.insets = new Insets(5, 5, 5, 5);
        c10.fill = 0;
        c10.anchor = 13;
        gb1.setConstraints(contentsButtonPanel, c10);
        contentsPanel.add(contentsButtonPanel);
        c10.fill = 1;
        c10.anchor = 10;
        this.addPB = new JButton(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.add", "Add"));
        contentsButtonPanel.add(this.addPB);
        this.addPB.setMnemonic('A');
        this.addPB.setActionCommand("Add");
        this.addPB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                WebAppGeneralInspector.this.addContentAction();
            }
        });
        this.delPB = new JButton(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.remove", "Remove..."));
        contentsButtonPanel.add(this.delPB);
        this.delPB.setMnemonic('D');
        this.delPB.setActionCommand("Delete");
        this.delPB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                WebAppGeneralInspector.this.deleteContentAction();
            }
        });
        JLabel contentsRootDirLabel = new JLabel(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.contentsrootdirectory", "Contents root directory:"));
        c10.weightx = 0.0;
        c10.weighty = 0.0;
        c10.gridx = 1;
        c10.gridy = 0;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(5, 5, 0, 5);
        gridbag.setConstraints(contentsRootDirLabel, c10);
        this.contentsRootDirText = new JTextField();
        c10.weightx = 0.0;
        c10.weighty = 0.0;
        c10.gridx = 1;
        c10.gridy = 1;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(0, 5, 5, 5);
        gridbag.setConstraints(this.contentsRootDirText, c10);
        JPanel advancedPanel = new JPanel();
        advancedPanel.setBorder(new TitledBorder(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.advanced", "Advanced")));
        GridBagLayout gb2 = new GridBagLayout();
        advancedPanel.setLayout(gb2);
        c10.weightx = 0.3;
        c10.weighty = 0.5;
        c10.gridx = 1;
        c10.gridy = 3;
        c10.gridwidth = 1;
        c10.gridheight = 4;
        c10.fill = 2;
        c10.anchor = 13;
        c10.insets = new Insets(5, 5, 5, 5);
        gridbag.setConstraints(advancedPanel, c10);
        this.add(advancedPanel);
        c10.fill = 1;
        c10.anchor = 10;
        this.distributableCheckBox = new JCheckBox(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.distributable", "Distributable"));
        this.distributableCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                WebAppGeneralInspector.this.descriptor.setDistributable(WebAppGeneralInspector.this.distributableCheckBox.isSelected());
            }
        });
        c10.weightx = 0.0;
        c10.weighty = 0.0;
        c10.gridx = 0;
        c10.gridy = 0;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.fill = 0;
        c10.anchor = 17;
        c10.insets = new Insets(0, 5, 0, 5);
        gb2.setConstraints(this.distributableCheckBox, c10);
        advancedPanel.add(this.distributableCheckBox);
        c10.fill = 1;
        c10.anchor = 10;
        JLabel sessionTimeoutLabel = new JLabel(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.sessiontimeout", "Session timeout:"));
        c10.weightx = 0.0;
        c10.weighty = 0.0;
        c10.gridx = 0;
        c10.gridy = 1;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(5, 5, 0, 5);
        gb2.setConstraints(sessionTimeoutLabel, c10);
        advancedPanel.add(sessionTimeoutLabel);
        this.sessionTimeoutText = new JTextField();
        c10.weightx = 0.0;
        c10.weighty = 0.0;
        c10.gridx = 0;
        c10.gridy = 2;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(0, 5, 5, 5);
        gb2.setConstraints(this.sessionTimeoutText, c10);
        advancedPanel.add(this.sessionTimeoutText);
        c10.weightx = 0.5;
        c10.weighty = 0.0;
        c10.gridx = 0;
        c10.gridy = 3;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.fill = 2;
        c10.anchor = 10;
        c10.insets = new Insets(0, 5, 5, 5);
        c10.fill = 1;
        c10.anchor = 10;
        this.mimeMappingPB = new JButton(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.mimemapping", "Mime mapping..."));
        this.mimeMappingPB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                WebAppGeneralInspector.this.mimeMappingAction();
            }
        });
        c10.weightx = 0.5;
        c10.weighty = 0.0;
        c10.gridx = 0;
        c10.gridy = 4;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.fill = 2;
        c10.anchor = 10;
        c10.insets = new Insets(5, 5, 5, 5);
        gb2.setConstraints(this.mimeMappingPB, c10);
        advancedPanel.add(this.mimeMappingPB);
        c10.fill = 1;
        c10.anchor = 10;
        this.iconInspector = new IconInspector(this);
        c10.weightx = 0.3;
        c10.weighty = 0.0;
        c10.gridx = 1;
        c10.gridy = 6;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.fill = 2;
        c10.anchor = 13;
        c10.insets = new Insets(5, 5, 5, 5);
        gridbag.setConstraints(this.iconInspector, c10);
        this.add(this.iconInspector);
        c10.fill = 1;
        c10.anchor = 10;
        Frame frame = (Frame)SwingUtilities.getAncestorOfClass(class$javax$swing$JFrame != null ? class$javax$swing$JFrame : (class$javax$swing$JFrame = WebAppGeneralInspector.class$("javax.swing.JFrame")), this);
        this.mimeMappingDialog = new MimeMappingDialog(frame, true);
        this.mimeMappingDialog.pack();
    }

    void mimeMappingAction() {
        if (this.mimeMappingDialog != null) {
            this.mimeMappingDialog.setObject(this.descriptor);
            this.mimeMappingDialog.setLocationRelativeTo(this.mimeMappingDialog.getOwner());
            ((Component)this.mimeMappingDialog).setVisible(true);
        }
    }

    private void refresh() {
        block8: {
            block9: {
                ZipFile jar = null;
                this.checkMode();
                if ("DeveloperMode".equals(this.mode)) break block9;
                this.warFileText.setText(this.descriptor.getArchivist().getArchiveUri());
                try {
                    File tmpFile = File.createTempFile("scratch", "war");
                    this.descriptor.getApplication().getApplicationArchivist().extractBundleToFile(this.descriptor, tmpFile);
                    jar = new JarFile(tmpFile);
                    DefaultListModel<String> contentsListModel = new DefaultListModel<String>();
                    Enumeration<JarEntry> jarEntries = ((JarFile)jar).entries();
                    while (jarEntries.hasMoreElements()) {
                        ZipEntry entry = jarEntries.nextElement();
                        contentsListModel.addElement(entry.getName());
                    }
                    this.contentsList.setModel(contentsListModel);
                    jar.close();
                    tmpFile.delete();
                }
                catch (Throwable throwable) {
                    if (jar == null) break block8;
                    try {
                        jar.close();
                        break block8;
                    }
                    catch (IOException iOException) {}
                }
                break block8;
            }
            if (this.contentWizard != null) {
                DefaultListModel dlm = new DefaultListModel();
                Enumeration e10 = this.contentWizard.getClassDescriptor().getFiles();
                while (e10.hasMoreElements()) {
                    dlm.addElement(e10.nextElement());
                }
                Enumeration e11 = this.contentWizard.getContentsDescriptor().getFiles();
                while (e11.hasMoreElements()) {
                    dlm.addElement(e11.nextElement());
                }
                this.contentsList.setModel(dlm);
            }
        }
        this.displayNameText.setText(this.descriptor.getName());
        this.descriptionText.setText(this.descriptor.getDescription());
        this.sessionTimeoutText.setText(new Integer(this.descriptor.getSessionTimeout()).toString());
        this.distributableCheckBox.setSelected(this.descriptor.isDistributable());
        this.iconInspector.setObject(this.descriptor);
    }

    public void setContentList(Set entries) {
        DefaultListModel dlm = new DefaultListModel();
        Iterator itr = entries.iterator();
        while (itr.hasNext()) {
            dlm.addElement(itr.next());
        }
        this.contentsList.setModel(dlm);
    }

    public void setObject(Object object) {
        if (object instanceof WebBundleDescriptor) {
            this.descriptor = (WebBundleDescriptor)object;
            this.refresh();
        }
    }

    public void setWarFile(String warFilename) {
        this.warFileText.setText(warFilename);
    }
}

