/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.descriptor;

import com.sun.enterprise.deployment.AuthorizationConstraintImpl;
import com.sun.enterprise.deployment.LoginConfigurationImpl;
import com.sun.enterprise.deployment.SecurityConstraintImpl;
import com.sun.enterprise.deployment.SecurityRoleDescriptor;
import com.sun.enterprise.deployment.UserDataConstraintImpl;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebResourceCollectionImpl;
import com.sun.enterprise.security.acl.Role;
import com.sun.enterprise.tools.deployment.ui.Inspector;
import com.sun.enterprise.tools.deployment.ui.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.descriptor.RolePicker;
import com.sun.enterprise.tools.deployment.ui.descriptor.SecurityConstraintsTableModel;
import com.sun.enterprise.tools.deployment.ui.descriptor.WebResourceCollectionsDialog;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.NotificationEvent;
import com.sun.enterprise.util.NotificationListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.help.CSH;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class WebAppSecurityInspector
extends JPanel
implements Inspector {
    WebBundleDescriptor descriptor;
    GridBagConstraints c = new GridBagConstraints();
    WebResourceCollectionsDialog webResourceCollectionsDialog;
    InspectorTable secConstraintTable;
    JList webResourceCollectionsList;
    JComboBox transportGuaranteeCombo;
    JComboBox authMethodCombo;
    JList authorizationConstraintsList;
    JLabel errorPageLabel;
    JLabel loginPageLabel;
    JLabel realmNameLabel;
    JTextField errorPageText;
    JTextField loginPageText;
    JTextField realmNameText;
    JButton webResAddPB;
    private boolean isChanging = false;
    JButton authorizationConstraintAddPB;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$descriptor$WebAppSecurityInspector != null ? class$com$sun$enterprise$tools$deployment$ui$descriptor$WebAppSecurityInspector : (class$com$sun$enterprise$tools$deployment$ui$descriptor$WebAppSecurityInspector = WebAppSecurityInspector.class$("com.sun.enterprise.tools.deployment.ui.descriptor.WebAppSecurityInspector")));
    private static String NO_AUTHRORIZATION = "NONE";
    String[] authMethods = new String[]{NO_AUTHRORIZATION, "BASIC", "FORM", "CLIENT-CERT"};
    String[] transportChoices = UserDataConstraintImpl.getTransportGuaranteeChoices();
    private static String helpSetMapID = "WISecurity";
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$descriptor$WebAppSecurityInspector;
    static /* synthetic */ Class class$javax$swing$JFrame;
    static /* synthetic */ Class class$java$awt$Frame;

    public WebAppSecurityInspector() {
        CSH.setHelpIDString((Component)this, (String)helpSetMapID);
        JFrame frame = (JFrame)SwingUtilities.getAncestorOfClass(class$javax$swing$JFrame != null ? class$javax$swing$JFrame : (class$javax$swing$JFrame = WebAppSecurityInspector.class$("javax.swing.JFrame")), this);
        GridBagLayout gb1 = new GridBagLayout();
        this.setLayout(gb1);
        this.c.fill = 1;
        this.c.weightx = 0.5;
        JPanel authMethodPanel = this.createAuthMethodPanel();
        authMethodPanel.setBorder(new TitledBorder(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.authenticationmethod", "Authentication method")));
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.5;
        this.c.weighty = 0.3;
        this.c.insets = new Insets(5, 5, 5, 5);
        this.c.fill = 1;
        gb1.setConstraints(authMethodPanel, this.c);
        this.add(authMethodPanel);
        JPanel secConstraintsPanel = new JPanel();
        secConstraintsPanel.setBorder(new TitledBorder(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.securityconstraints", "Security constraints")));
        GridBagLayout secGB = new GridBagLayout();
        secConstraintsPanel.setLayout(secGB);
        this.c.gridx = 0;
        this.c.gridy = 1;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.5;
        this.c.weighty = 0.5;
        this.c.insets = new Insets(5, 5, 5, 5);
        this.c.fill = 1;
        gb1.setConstraints(secConstraintsPanel, this.c);
        this.add(secConstraintsPanel);
        SecurityConstraintsTableModel tm = new SecurityConstraintsTableModel(new Vector().elements());
        this.secConstraintTable = new InspectorTable(tm);
        this.secConstraintTable.setSelectionMode(0);
        this.secConstraintTable.setAutoResizeMode(4);
        this.secConstraintTable.addMouseListener(new SecConstraintsListMouseListener());
        JScrollPane secConstraintTablePane = new JScrollPane(this.secConstraintTable);
        secConstraintTablePane.setPreferredSize(new Dimension(150, 200));
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.5;
        this.c.weighty = 0.5;
        this.c.insets = new Insets(5, 5, 5, 5);
        this.c.fill = 1;
        secGB.setConstraints(secConstraintTablePane, this.c);
        secConstraintsPanel.add(secConstraintTablePane);
        JPanel secConstraintsButtonPanel = new JPanel();
        secConstraintsButtonPanel.setLayout(new GridLayout(1, 2, 5, 5));
        this.c.gridx = 0;
        this.c.gridy = 1;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.insets = new Insets(5, 5, 5, 5);
        this.c.fill = 0;
        this.c.anchor = 13;
        secGB.setConstraints(secConstraintsButtonPanel, this.c);
        secConstraintsPanel.add(secConstraintsButtonPanel);
        this.c.fill = 1;
        this.c.anchor = 10;
        JButton addSecConstPB = new JButton(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.add", "Add"));
        secConstraintsButtonPanel.add(addSecConstPB);
        addSecConstPB.setMnemonic('A');
        addSecConstPB.setActionCommand("Add");
        addSecConstPB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                WebAppSecurityInspector.this.addSecurityConstraint();
            }
        });
        JButton delSecConstPB = new JButton(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.delete", "Delete..."));
        secConstraintsButtonPanel.add(delSecConstPB);
        delSecConstPB.setMnemonic('D');
        delSecConstPB.setActionCommand("Delete");
        delSecConstPB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                WebAppSecurityInspector.this.deleteSecurityConstraint();
            }
        });
        JPanel resourceCollectionPanel = this.createResourceCollectionPanel();
        this.c.gridx = 1;
        this.c.gridy = 0;
        this.c.gridwidth = 1;
        this.c.gridheight = 2;
        this.c.weightx = 0.5;
        this.c.weighty = 0.5;
        this.c.insets = new Insets(5, 5, 5, 5);
        this.c.fill = 1;
        secGB.setConstraints(resourceCollectionPanel, this.c);
        secConstraintsPanel.add(resourceCollectionPanel);
    }

    private void addAuthorizationConstraint() {
        SecurityConstraintImpl sc = this.getSelectedSecurityConstraint();
        if (sc != null) {
            AuthorizationConstraintImpl aci = new AuthorizationConstraintImpl();
            Frame frame = (Frame)SwingUtilities.getAncestorOfClass(class$java$awt$Frame != null ? class$java$awt$Frame : (class$java$awt$Frame = WebAppSecurityInspector.class$("java.awt.Frame")), this);
            RolePicker rp = new RolePicker(frame, this.descriptor);
            ((Component)rp).setBounds(0, 0, 300, 200);
            rp.setLocationRelativeTo(this);
            rp.show();
            Iterator itr = rp.securityRoles.iterator();
            while (itr.hasNext()) {
                String roleName = (String)itr.next();
                aci.addSecurityRole(new SecurityRoleDescriptor(roleName, ""));
            }
            sc.setAuthorizationConstraint(aci);
            this.descriptor.changed();
        }
    }

    private void addSecurityConstraint() {
        SecurityConstraintImpl securityConstraint = new SecurityConstraintImpl();
        this.descriptor.addSecurityConstraint(securityConstraint);
    }

    private void addWebResourceCollection() {
        if (this.webResourceCollectionsDialog == null) {
            JFrame frame = (JFrame)SwingUtilities.getAncestorOfClass(class$javax$swing$JFrame != null ? class$javax$swing$JFrame : (class$javax$swing$JFrame = WebAppSecurityInspector.class$("javax.swing.JFrame")), this);
            this.webResourceCollectionsDialog = new WebResourceCollectionsDialog((Frame)frame, true);
            this.webResourceCollectionsDialog.addWindowListener(new WindowAdapter(){

                public void windowClosing() {
                    WebAppSecurityInspector.this.updateWebResourceCollections();
                }
            });
            this.webResourceCollectionsDialog.pack();
            this.webResourceCollectionsDialog.setLocationRelativeTo(this.webResourceCollectionsDialog.getOwner());
        }
        if (this.getSelectedSecurityConstraint() != null) {
            this.webResourceCollectionsDialog.setObject(new SecurityConstraintImpl(this.getSelectedSecurityConstraint()));
            this.webResourceCollectionsDialog.show();
            if (this.webResourceCollectionsDialog.isOK()) {
                this.descriptor.removeSecurityConstraint(this.getSelectedSecurityConstraint());
                this.descriptor.addSecurityConstraint(this.webResourceCollectionsDialog.getDescriptor());
                this.descriptor.changed();
            }
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private JPanel createAuthMethodPanel() {
        JPanel authMethodPanel = new JPanel();
        authMethodPanel.setBorder(new TitledBorder(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.authenticationmethod", "Authentication method")));
        GridBagLayout gbSE = new GridBagLayout();
        authMethodPanel.setLayout(gbSE);
        this.authMethodCombo = new JComboBox<String>(this.authMethods);
        this.authMethodCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                JComboBox cb2 = (JComboBox)e10.getSource();
                WebAppSecurityInspector.this.handleAuthMethodSelection();
            }
        });
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.5;
        this.c.weighty = 0.0;
        this.c.insets = new Insets(5, 5, 5, 5);
        this.c.fill = 1;
        gbSE.setConstraints(this.authMethodCombo, this.c);
        authMethodPanel.add(this.authMethodCombo);
        this.realmNameLabel = new JLabel(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.realmname", "Realm name:"));
        this.c.gridx = 0;
        this.c.gridy = 1;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.insets = new Insets(5, 5, 0, 5);
        this.c.fill = 1;
        gbSE.setConstraints(this.realmNameLabel, this.c);
        authMethodPanel.add(this.realmNameLabel);
        this.realmNameText = new JTextField();
        this.c.gridx = 0;
        this.c.gridy = 2;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.5;
        this.c.weighty = 0.0;
        this.c.insets = new Insets(5, 5, 5, 5);
        this.c.fill = 1;
        gbSE.setConstraints(this.realmNameText, this.c);
        authMethodPanel.add(this.realmNameText);
        this.realmNameText.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent fe2) {
                WebAppSecurityInspector.this.storeRealmName();
            }
        });
        this.realmNameText.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                if (ke.getKeyCode() == 10) {
                    WebAppSecurityInspector.this.storeRealmName();
                }
            }
        });
        this.loginPageLabel = new JLabel(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.loginpage", "Login page:"));
        this.c.gridx = 0;
        this.c.gridy = 1;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.insets = new Insets(5, 5, 0, 5);
        this.c.fill = 1;
        gbSE.setConstraints(this.loginPageLabel, this.c);
        this.loginPageLabel.setVisible(false);
        authMethodPanel.add(this.loginPageLabel);
        this.loginPageText = new JTextField();
        this.c.gridx = 0;
        this.c.gridy = 2;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.5;
        this.c.weighty = 0.0;
        this.c.insets = new Insets(5, 5, 5, 5);
        this.c.fill = 1;
        gbSE.setConstraints(this.loginPageText, this.c);
        this.loginPageText.setVisible(false);
        authMethodPanel.add(this.loginPageText);
        this.loginPageText.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent fe2) {
                WebAppSecurityInspector.this.storeLoginPage();
            }
        });
        this.loginPageText.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                if (ke.getKeyCode() == 10) {
                    WebAppSecurityInspector.this.storeLoginPage();
                }
            }
        });
        this.errorPageLabel = new JLabel(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.errorpage", "Error page:"));
        this.c.gridx = 0;
        this.c.gridy = 3;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.insets = new Insets(5, 5, 0, 5);
        this.c.fill = 1;
        gbSE.setConstraints(this.errorPageLabel, this.c);
        this.errorPageLabel.setVisible(false);
        authMethodPanel.add(this.errorPageLabel);
        this.errorPageText = new JTextField();
        this.c.gridx = 0;
        this.c.gridy = 4;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.5;
        this.c.weighty = 0.0;
        this.c.insets = new Insets(5, 5, 10, 5);
        this.c.fill = 1;
        gbSE.setConstraints(this.errorPageText, this.c);
        this.errorPageText.setVisible(false);
        authMethodPanel.add(this.errorPageText);
        this.errorPageText.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent fe2) {
                WebAppSecurityInspector.this.storeErrorPage();
            }
        });
        this.errorPageText.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                if (ke.getKeyCode() == 10) {
                    WebAppSecurityInspector.this.storeErrorPage();
                }
            }
        });
        return authMethodPanel;
    }

    private JPanel createResourceCollectionPanel() {
        JPanel resourceCollectionPanel = new JPanel();
        Border border = BorderFactory.createLoweredBevelBorder();
        CompoundBorder b10 = new CompoundBorder(border, new EmptyBorder(new Insets(5, 5, 5, 5)));
        resourceCollectionPanel.setBorder(b10);
        resourceCollectionPanel.setLayout(new BoxLayout(resourceCollectionPanel, 1));
        JLabel webResCollLabel = new JLabel(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.webresourcecollection", "Web resource collection:"));
        JPanel listPanel = new JPanel();
        listPanel.setLayout(new BorderLayout());
        resourceCollectionPanel.add(webResCollLabel);
        listPanel.add("North", webResCollLabel);
        this.webResourceCollectionsList = new JList();
        this.webResourceCollectionsList.setSelectionBackground(Color.white);
        JScrollPane sp = new JScrollPane(this.webResourceCollectionsList);
        listPanel.add("Center", sp);
        this.webResAddPB = new JButton(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.edit", "Edit..."));
        this.webResAddPB.setEnabled(false);
        this.webResAddPB.setActionCommand("Edit...");
        this.webResAddPB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                WebAppSecurityInspector.this.addWebResourceCollection();
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.webResAddPB);
        listPanel.add("East", buttonPanel);
        resourceCollectionPanel.add(listPanel);
        listPanel = new JPanel();
        listPanel.setLayout(new BorderLayout());
        JLabel authorizationConstraintLabel = new JLabel(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.authorizedroles", "Authorized Roles:"));
        listPanel.add("North", authorizationConstraintLabel);
        this.authorizationConstraintsList = new JList();
        this.authorizationConstraintsList.setSelectionBackground(Color.white);
        listPanel.add("Center", new JScrollPane(this.authorizationConstraintsList));
        this.authorizationConstraintAddPB = new JButton(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.edit", "Edit..."));
        this.authorizationConstraintAddPB.setEnabled(false);
        this.authorizationConstraintAddPB.setActionCommand("Add...");
        this.authorizationConstraintAddPB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                WebAppSecurityInspector.this.addAuthorizationConstraint();
            }
        });
        buttonPanel = new JPanel();
        buttonPanel.add(this.authorizationConstraintAddPB);
        listPanel.add("East", buttonPanel);
        resourceCollectionPanel.add(listPanel);
        JPanel p2 = new JPanel();
        p2.setLayout(new BorderLayout());
        JLabel transportGuaranteeLabel = new JLabel(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.transportguarantee", "Transport guarantee:"));
        p2.add("North", transportGuaranteeLabel);
        this.transportGuaranteeCombo = new JComboBox<String>(this.transportChoices);
        this.transportGuaranteeCombo.setEnabled(false);
        this.transportGuaranteeCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                JComboBox cb2 = (JComboBox)e10.getSource();
                WebAppSecurityInspector.this.handleTransportGuaranteeSelection();
            }
        });
        p2.add("Center", this.transportGuaranteeCombo);
        resourceCollectionPanel.add(p2);
        return resourceCollectionPanel;
    }

    private void deleteSecurityConstraint() {
        JFrame frame = (JFrame)SwingUtilities.getAncestorOfClass(class$javax$swing$JFrame != null ? class$javax$swing$JFrame : (class$javax$swing$JFrame = WebAppSecurityInspector.class$("javax.swing.JFrame")), this);
        SecurityConstraintsTableModel model = (SecurityConstraintsTableModel)this.secConstraintTable.getModel();
        ListSelectionModel sm = this.secConstraintTable.getSelectionModel();
        int index = sm.getMinSelectionIndex();
        if (index >= 0) {
            int n2 = JOptionPane.showConfirmDialog(frame, localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.surewanttodeleteselectedsecurityconstraint", "Are you sure you want to delete selected security constraint?"), "Delete security constraint", 0);
            if (n2 == 0) {
                SecurityConstraintImpl securityConstraint = model.getSecurityConstraintAt(index);
                if (this.descriptor != null) {
                    this.descriptor.removeSecurityConstraint(securityConstraint);
                }
            }
        } else {
            JOptionPane.showMessageDialog(frame, localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.firstselectsecurityconstraintfromlist", "You must first select a security constraint from list"));
        }
    }

    WebBundleDescriptor getDescriptor() {
        return this.descriptor;
    }

    SecurityConstraintImpl getSelectedSecurityConstraint() {
        int minIndex;
        SecurityConstraintImpl secConstraint = null;
        ListSelectionModel lsm = this.secConstraintTable.getSelectionModel();
        if (lsm.isSelectedIndex(minIndex = lsm.getMinSelectionIndex())) {
            secConstraint = ((SecurityConstraintsTableModel)this.secConstraintTable.getModel()).getSecurityConstraintAt(minIndex);
        }
        return secConstraint;
    }

    private void handleAuthMethodSelection() {
        String authenticationMethod = (String)this.authMethodCombo.getSelectedItem();
        LoginConfigurationImpl loginConfig = null;
        if (!NO_AUTHRORIZATION.equals(authenticationMethod)) {
            loginConfig = new LoginConfigurationImpl();
            loginConfig.setAuthenticationMethod(authenticationMethod);
        }
        this.realmNameLabel.setVisible(false);
        this.realmNameText.setVisible(false);
        this.loginPageLabel.setVisible(false);
        this.loginPageText.setVisible(false);
        this.errorPageLabel.setVisible(false);
        this.errorPageText.setVisible(false);
        if ("FORM".equals(authenticationMethod)) {
            this.loginPageLabel.setVisible(true);
            this.loginPageText.setVisible(true);
            this.errorPageLabel.setVisible(true);
            this.errorPageText.setVisible(true);
            this.realmNameText.setText(null);
        } else if ("BASIC".equals(authenticationMethod)) {
            this.realmNameLabel.setVisible(true);
            this.realmNameText.setVisible(true);
        } else {
            this.realmNameText.setText(null);
        }
        this.descriptor.setLoginConfiguration(loginConfig);
    }

    private void handleTransportGuaranteeSelection() {
        SecurityConstraintImpl securityConstraint = this.getSelectedSecurityConstraint();
        if (securityConstraint != null) {
            UserDataConstraintImpl userDataConstraint = (UserDataConstraintImpl)securityConstraint.getUserDataConstraint();
            if (userDataConstraint == null) {
                userDataConstraint = new UserDataConstraintImpl();
            }
            String transportType = (String)this.transportGuaranteeCombo.getSelectedItem();
            userDataConstraint.setTransportGuarantee(transportType);
            this.descriptor.changed();
        }
    }

    public static void main(String[] args) {
        WebAppSecurityInspector ei2 = new WebAppSecurityInspector();
        JFrame f2 = new JFrame();
        ((Component)f2).setBounds(10, 10, 400, 400);
        f2.getContentPane().add(ei2);
        f2.show();
        final WebBundleDescriptor wbd = new WebBundleDescriptor();
        wbd.addRole(new Role("danny"));
        wbd.addRole(new Role("matti"));
        wbd.addNotificationListener(new NotificationListener(){

            public void notification(NotificationEvent ae2) {
                WebAppSecurityInspector.this.setObject(wbd);
            }
        });
        ei2.setObject(wbd);
    }

    private void refresh() {
        if (this.descriptor == null || this.isChanging) {
            return;
        }
        LoginConfigurationImpl loginConfig = (LoginConfigurationImpl)this.descriptor.getLoginConfiguration();
        if (loginConfig != null) {
            String authenticationMethod = loginConfig.getAuthenticationMethod();
            if ("FORM".equals(authenticationMethod)) {
                this.loginPageText.setText(loginConfig.getFormLoginPage());
                this.errorPageText.setText(loginConfig.getFormErrorPage());
            } else if ("BASIC".equals(authenticationMethod)) {
                this.realmNameText.setText(loginConfig.getRealmName());
            }
            if (!this.authMethodCombo.getSelectedItem().equals(authenticationMethod)) {
                this.authMethodCombo.setSelectedItem(authenticationMethod);
            }
        } else if (!this.authMethodCombo.getSelectedItem().equals(NO_AUTHRORIZATION)) {
            this.authMethodCombo.setSelectedItem(NO_AUTHRORIZATION);
        }
        SecurityConstraintImpl oldSelectedSecurityConstraint = this.getSelectedSecurityConstraint();
        SecurityConstraintsTableModel tm = new SecurityConstraintsTableModel(this.descriptor.getSecurityConstraints());
        this.secConstraintTable.setModel(tm);
        this.secConstraintTable.sizeColumnsToFit(0);
        int i2 = -1;
        if (oldSelectedSecurityConstraint != null && (i2 = tm.getIndexOf(oldSelectedSecurityConstraint)) != -1) {
            this.secConstraintTable.setRowSelectionInterval(i2, i2);
        }
        this.showSecurityConstraint(i2);
    }

    void selectSecurityConstraint(int index) {
        int rowCount = ((SecurityConstraintsTableModel)this.secConstraintTable.getModel()).getRowCount();
        if (index >= 0 && index < rowCount) {
            ListSelectionModel sm = this.secConstraintTable.getSelectionModel();
            sm.setSelectionInterval(index, index);
        }
    }

    public void setObject(Object object) {
        block2: {
            if (!(object instanceof WebBundleDescriptor)) break block2;
            this.descriptor = (WebBundleDescriptor)object;
            try {
                this.refresh();
            }
            catch (Throwable t2) {
                System.out.println(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.errorupdatingwebsecurityinspector", "Error updating web security inspector"));
                t2.printStackTrace();
            }
        }
    }

    private void showSecurityConstraint(int index) {
        SecurityConstraintImpl securityConstraint = null;
        if (index != -1) {
            securityConstraint = ((SecurityConstraintsTableModel)this.secConstraintTable.getModel()).getSecurityConstraintAt(index);
        }
        this.webResAddPB.setEnabled(securityConstraint != null);
        this.authorizationConstraintAddPB.setEnabled(securityConstraint != null);
        this.transportGuaranteeCombo.setEnabled(securityConstraint != null);
        this.authorizationConstraintsList.setEnabled(securityConstraint != null);
        this.webResourceCollectionsList.setEnabled(securityConstraint != null);
        this.authorizationConstraintsList.setModel(new DefaultListModel());
        this.webResourceCollectionsList.setModel(new DefaultListModel());
        if (securityConstraint != null) {
            Enumeration e10;
            UserDataConstraintImpl userDataConstraint = (UserDataConstraintImpl)securityConstraint.getUserDataConstraint();
            if (userDataConstraint != null) {
                String transportType = userDataConstraint.getTransportGuarantee();
                this.transportGuaranteeCombo.setSelectedItem(transportType);
            } else {
                userDataConstraint = new UserDataConstraintImpl();
                userDataConstraint.setTransportGuarantee("NONE");
                securityConstraint.setUserDataConstraint(userDataConstraint);
                this.transportGuaranteeCombo.setSelectedItem("NONE");
            }
            AuthorizationConstraintImpl aci = (AuthorizationConstraintImpl)securityConstraint.getAuthorizationConstraint();
            DefaultListModel<String> dlm = new DefaultListModel<String>();
            if (aci != null) {
                e10 = aci.getSecurityRoles();
                while (e10.hasMoreElements()) {
                    SecurityRoleDescriptor srd = (SecurityRoleDescriptor)e10.nextElement();
                    dlm.addElement(srd.getName());
                }
            }
            this.authorizationConstraintsList.setModel(dlm);
            dlm = new DefaultListModel();
            e10 = securityConstraint.getWebResourceCollections();
            while (e10.hasMoreElements()) {
                WebResourceCollectionImpl wrc = (WebResourceCollectionImpl)e10.nextElement();
                dlm.addElement(wrc.getName());
            }
            this.webResourceCollectionsList.setModel(dlm);
        }
    }

    private void storeErrorPage() {
        LoginConfigurationImpl loginConfig = (LoginConfigurationImpl)this.descriptor.getLoginConfiguration();
        if (loginConfig == null) {
            loginConfig = new LoginConfigurationImpl();
        }
        loginConfig.setFormErrorPage(this.errorPageText.getText());
        this.descriptor.setLoginConfiguration(loginConfig);
    }

    private void storeLoginPage() {
        LoginConfigurationImpl loginConfig = (LoginConfigurationImpl)this.descriptor.getLoginConfiguration();
        if (loginConfig == null) {
            loginConfig = new LoginConfigurationImpl();
        }
        loginConfig.setFormLoginPage(this.loginPageText.getText());
        this.descriptor.setLoginConfiguration(loginConfig);
    }

    private void storeRealmName() {
        LoginConfigurationImpl loginConfig = (LoginConfigurationImpl)this.descriptor.getLoginConfiguration();
        if (loginConfig == null) {
            loginConfig = new LoginConfigurationImpl();
        }
        loginConfig.setRealmName(this.realmNameText.getText());
        this.descriptor.setLoginConfiguration(loginConfig);
    }

    private void updateWebResourceCollections() {
        this.descriptor.changed();
    }

    class SecConstraintsListMouseListener
    extends MouseAdapter {
        SecConstraintsListMouseListener() {
        }

        public void mouseClicked(MouseEvent e10) {
            int row = WebAppSecurityInspector.this.secConstraintTable.getSelectedRow();
            WebAppSecurityInspector.this.showSecurityConstraint(row);
        }
    }
}

