/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.descriptor;

import com.sun.enterprise.deployment.AuthorizationConstraintImpl;
import com.sun.enterprise.deployment.SecurityConstraintImpl;
import com.sun.enterprise.deployment.SecurityRoleDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.help.CSH;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class WebAuthConstraintsDialog
extends JDialog {
    GridBagConstraints c = new GridBagConstraints();
    WebAuthConstraintsTableModel webAuthConstraintsTableModel;
    JTable webAuthConstraintsTable;
    RolesTableModel rolesTableModel;
    JTable rolesTable;
    JTextArea descriptionText;
    JButton addRolePB;
    JButton delRolePB;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$descriptor$WebAuthConstraintsDialog != null ? class$com$sun$enterprise$tools$deployment$ui$descriptor$WebAuthConstraintsDialog : (class$com$sun$enterprise$tools$deployment$ui$descriptor$WebAuthConstraintsDialog = WebAuthConstraintsDialog.class$("com.sun.enterprise.tools.deployment.ui.descriptor.WebAuthConstraintsDialog")));
    private static String helpSetMapID = "WIAuthorization";
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$descriptor$WebAuthConstraintsDialog;

    public WebAuthConstraintsDialog(Frame frame, boolean modal) {
        super(frame, localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.wac", "Web Authorization Constraints"), modal);
        CSH.setHelpIDString((Component)this, (String)helpSetMapID);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                WebAuthConstraintsDialog.this.cancelAction();
            }
        });
        JPanel contentPane = new JPanel();
        this.setContentPane(contentPane);
        GridBagLayout gb = new GridBagLayout();
        contentPane.setLayout(gb);
        this.c.fill = 1;
        this.c.weightx = 1.0;
        this.c.gridwidth = 1;
        JPanel webAuthConstraintsPanel = this.createWebAuthConstraintsPanel();
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.c.gridwidth = 1;
        this.c.gridheight = 3;
        this.c.weightx = 0.5;
        this.c.weighty = 0.5;
        this.c.insets = new Insets(5, 5, 5, 5);
        this.c.fill = 1;
        gb.setConstraints(webAuthConstraintsPanel, this.c);
        this.getContentPane().add(webAuthConstraintsPanel);
        JPanel rolesPanel = this.createRolesPanel();
        this.c.gridx = 1;
        this.c.gridy = 0;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.5;
        this.c.weighty = 0.5;
        this.c.insets = new Insets(5, 5, 5, 5);
        this.c.fill = 1;
        gb.setConstraints(rolesPanel, this.c);
        this.getContentPane().add(rolesPanel);
        JLabel descriptionLabel = new JLabel(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.description", "Description:"));
        this.c.gridx = 1;
        this.c.gridy = 1;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.insets = new Insets(5, 5, 0, 5);
        this.c.fill = 1;
        gb.setConstraints(descriptionLabel, this.c);
        this.getContentPane().add(descriptionLabel);
        this.descriptionText = new JTextArea("", 5, 30);
        JScrollPane descriptionTextPane = new JScrollPane(this.descriptionText);
        this.descriptionText.setBorder(new EtchedBorder());
        this.c.gridx = 1;
        this.c.gridy = 2;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.5;
        this.c.weighty = 0.5;
        this.c.insets = new Insets(0, 5, 5, 5);
        this.c.fill = 1;
        gb.setConstraints(descriptionTextPane, this.c);
        this.getContentPane().add(descriptionTextPane);
        this.descriptionText.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent fe2) {
                WebAuthConstraintsDialog.this.updateDescription();
            }
        });
        this.descriptionText.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                if (ke.getKeyCode() == 10) {
                    WebAuthConstraintsDialog.this.updateDescription();
                }
            }
        });
        JPanel dialogButtonPanel = new JPanel();
        dialogButtonPanel.setLayout(new GridLayout(1, 3, 5, 5));
        JButton okPB = new JButton(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.okbutton", "OK"));
        dialogButtonPanel.add(okPB);
        okPB.setMnemonic('O');
        okPB.setActionCommand("OK");
        okPB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                WebAuthConstraintsDialog.this.okAction();
            }
        });
        JButton cancelPB = new JButton(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.cancelbutton", "Cancel"));
        dialogButtonPanel.add(cancelPB);
        cancelPB.setMnemonic('C');
        cancelPB.setActionCommand("Cancel");
        cancelPB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                WebAuthConstraintsDialog.this.cancelAction();
            }
        });
        JButton helpPB = new JButton(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.helpbutton", "Help"));
        dialogButtonPanel.add(helpPB);
        helpPB.setMnemonic('H');
        helpPB.setActionCommand("Help");
        helpPB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                WebAuthConstraintsDialog.this.helpAction();
            }
        });
        this.c.gridx = 0;
        this.c.gridy = 3;
        this.c.gridwidth = 2;
        this.c.gridheight = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.insets = new Insets(5, 5, 5, 5);
        this.c.fill = 0;
        this.c.anchor = 13;
        gb.setConstraints(dialogButtonPanel, this.c);
        this.getContentPane().add(dialogButtonPanel);
        this.c.fill = 0;
        this.c.anchor = 10;
        this.deSelectAction();
    }

    private void addRoleAction() {
        AuthorizationConstraintImpl authConstraint = this.getSelectedAuthorizationConstraint();
        if (authConstraint != null) {
            RolesTableModel model = (RolesTableModel)this.rolesTable.getModel();
            SecurityRoleDescriptor role = model.addRow();
            authConstraint.addSecurityRole(role);
        }
    }

    private void addWebAuthConstraintAction() {
        WebAuthConstraintsTableModel model = (WebAuthConstraintsTableModel)this.webAuthConstraintsTable.getModel();
        AuthorizationConstraintImpl authConstraint = model.addRow();
        ListSelectionModel sm = this.webAuthConstraintsTable.getSelectionModel();
        int selectedIndex = model.getRowCount() - 1;
        sm.setSelectionInterval(selectedIndex, selectedIndex);
    }

    private void cancelAction() {
        ((Component)this).setVisible(false);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private JPanel createRolesPanel() {
        JPanel rolesPanel = new JPanel();
        rolesPanel.setBorder(new TitledBorder(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.roles", "Roles")));
        GridBagLayout gb = new GridBagLayout();
        rolesPanel.setLayout(gb);
        this.rolesTableModel = new RolesTableModel();
        this.rolesTable = new JTable(this.rolesTableModel);
        this.rolesTable.setSelectionMode(0);
        ListSelectionModel listSelectionModel = this.rolesTable.getSelectionModel();
        JScrollPane rolesTablePane = new JScrollPane(this.rolesTable);
        this.rolesTable.setBorder(new EtchedBorder());
        rolesTablePane.setPreferredSize(new Dimension(250, 150));
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.5;
        this.c.weighty = 0.5;
        this.c.insets = new Insets(0, 5, 5, 5);
        this.c.fill = 1;
        gb.setConstraints(rolesTablePane, this.c);
        rolesPanel.add(rolesTablePane);
        JPanel roleButtonPanel = new JPanel();
        roleButtonPanel.setLayout(new GridLayout(2, 1, 5, 5));
        this.c.gridx = 1;
        this.c.gridy = 0;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.insets = new Insets(5, 5, 5, 5);
        this.c.fill = 0;
        this.c.anchor = 10;
        gb.setConstraints(roleButtonPanel, this.c);
        rolesPanel.add(roleButtonPanel);
        this.c.fill = 1;
        this.c.anchor = 10;
        this.addRolePB = new JButton(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.add", "Add"));
        roleButtonPanel.add(this.addRolePB);
        this.addRolePB.setActionCommand("Add");
        this.addRolePB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                WebAuthConstraintsDialog.this.addRoleAction();
            }
        });
        this.delRolePB = new JButton(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.delete", "Delete..."));
        roleButtonPanel.add(this.delRolePB);
        this.delRolePB.setActionCommand("Delete");
        this.delRolePB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                WebAuthConstraintsDialog.this.deleteRoleAction();
            }
        });
        return rolesPanel;
    }

    private JPanel createWebAuthConstraintsPanel() {
        JPanel webAuthConstraintsPanel = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        webAuthConstraintsPanel.setLayout(gb);
        this.webAuthConstraintsTableModel = new WebAuthConstraintsTableModel();
        this.webAuthConstraintsTable = new JTable(this.webAuthConstraintsTableModel);
        this.webAuthConstraintsTable.setSelectionMode(0);
        ListSelectionModel listSelectionModel = this.webAuthConstraintsTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new WebAuthConstraintsListSelectionListener());
        JScrollPane webAuthConstraintsTablePane = new JScrollPane(this.webAuthConstraintsTable);
        this.webAuthConstraintsTable.setBorder(new EtchedBorder());
        webAuthConstraintsTablePane.setPreferredSize(new Dimension(150, 200));
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.5;
        this.c.weighty = 0.5;
        this.c.insets = new Insets(5, 5, 5, 5);
        this.c.fill = 1;
        gb.setConstraints(webAuthConstraintsTablePane, this.c);
        webAuthConstraintsPanel.add(webAuthConstraintsTablePane);
        JPanel webAuthConstraintsButtonPanel = new JPanel();
        webAuthConstraintsButtonPanel.setLayout(new GridLayout(1, 2, 5, 5));
        this.c.gridx = 0;
        this.c.gridy = 1;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.insets = new Insets(5, 5, 5, 5);
        this.c.fill = 0;
        this.c.anchor = 13;
        gb.setConstraints(webAuthConstraintsButtonPanel, this.c);
        webAuthConstraintsPanel.add(webAuthConstraintsButtonPanel);
        this.c.fill = 1;
        this.c.anchor = 10;
        JButton addPB = new JButton(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.add", "Add"));
        webAuthConstraintsButtonPanel.add(addPB);
        addPB.setMnemonic('A');
        addPB.setActionCommand("Add");
        addPB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                WebAuthConstraintsDialog.this.addWebAuthConstraintAction();
            }
        });
        JButton delPB = new JButton(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.delete", "Delete..."));
        webAuthConstraintsButtonPanel.add(delPB);
        delPB.setMnemonic('D');
        delPB.setActionCommand("Delete");
        delPB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                WebAuthConstraintsDialog.this.deleteWebAuthConstraintAction();
            }
        });
        return webAuthConstraintsPanel;
    }

    private void deSelectAction() {
        if (this.rolesTableModel.getRowCount() > 0) {
            this.rolesTableModel.removeAllRows();
        }
        this.descriptionText.setText(null);
        this.descriptionText.setEnabled(false);
        this.addRolePB.setEnabled(false);
        this.delRolePB.setEnabled(false);
    }

    private void deleteRoleAction() {
        try {
            Class<?> cls = Class.forName("javax.swing.JFrame");
            JFrame frame = (JFrame)SwingUtilities.getAncestorOfClass(cls, this);
            RolesTableModel model = (RolesTableModel)this.rolesTable.getModel();
            ListSelectionModel sm = this.rolesTable.getSelectionModel();
            int index = sm.getMinSelectionIndex();
            if (index >= 0) {
                int n2 = JOptionPane.showConfirmDialog(frame, localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.surewanttodeleteselectedrole", "Are you sure you want to delete selected role?"), "Delete role", 0);
                if (n2 == 0) {
                    AuthorizationConstraintImpl authConstraint = this.getSelectedAuthorizationConstraint();
                    if (authConstraint != null) {
                        authConstraint.removeSecurityRole(model.getRow(index));
                    }
                    model.removeRow(index);
                }
            } else {
                JOptionPane.showMessageDialog(frame, localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.firstselectrolefromlist", "You must first select a role from list"));
            }
        }
        catch (ClassNotFoundException classNotFoundException) {}
    }

    private void deleteWebAuthConstraintAction() {
        try {
            Class<?> cls = Class.forName("javax.swing.JFrame");
            JFrame frame = (JFrame)SwingUtilities.getAncestorOfClass(cls, this);
            WebAuthConstraintsTableModel model = (WebAuthConstraintsTableModel)this.webAuthConstraintsTable.getModel();
            ListSelectionModel sm = this.webAuthConstraintsTable.getSelectionModel();
            int index = sm.getMinSelectionIndex();
            if (index >= 0) {
                int n2 = JOptionPane.showConfirmDialog(frame, localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.surewanttodeleteselectedwebauthorizationconstraint", "Are you sure you want to delete selected web authorization constraint?"), "Delete web authorization constraint", 0);
                if (n2 == 0) {
                    AuthorizationConstraintImpl authConstraint = model.getRow(index);
                    this.deSelectAction();
                    model.removeRow(index);
                }
            } else {
                JOptionPane.showMessageDialog(frame, localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.firstselectwebauthorizationconstraintfromlist", "You must first select a web authorization constraint from list"));
            }
        }
        catch (ClassNotFoundException classNotFoundException) {}
    }

    AuthorizationConstraintImpl getSelectedAuthorizationConstraint() {
        int minIndex;
        AuthorizationConstraintImpl authConstraint = null;
        ListSelectionModel lsm = this.webAuthConstraintsTable.getSelectionModel();
        if (lsm.isSelectedIndex(minIndex = lsm.getMinSelectionIndex())) {
            authConstraint = this.webAuthConstraintsTableModel.getRow(minIndex);
        }
        return authConstraint;
    }

    AuthorizationConstraintImpl getWebAuthorizationConstraint(int index) {
        System.err.println("row cnt = " + this.webAuthConstraintsTableModel.getRowCount() + "index sought=" + index);
        AuthorizationConstraintImpl authConstraint = this.webAuthConstraintsTableModel.getRow(index);
        return authConstraint;
    }

    ArrayList getWebAuthorizationConstraints() {
        return this.webAuthConstraintsTableModel.getAllRows();
    }

    private void helpAction() {
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        WebAuthConstraintsDialog myDialog = new WebAuthConstraintsDialog((Frame)frame, false);
        ((Component)frame).setVisible(true);
        ((Component)myDialog).setSize(myDialog.getPreferredSize());
        ((Component)myDialog).setVisible(true);
    }

    private void okAction() {
        ((Component)this).setVisible(false);
    }

    void refresh(WebBundleDescriptor descriptor) {
        WebAuthConstraintsTableModel model = (WebAuthConstraintsTableModel)this.webAuthConstraintsTable.getModel();
        if (model.getRowCount() > 0) {
            model.removeAllRows();
        }
        if (descriptor == null) {
            return;
        }
        Enumeration securityConstraints = descriptor.getSecurityConstraints();
        if (securityConstraints != null) {
            boolean i2 = false;
            while (securityConstraints.hasMoreElements()) {
                SecurityConstraintImpl securityConstraint = (SecurityConstraintImpl)securityConstraints.nextElement();
                AuthorizationConstraintImpl authorizationConstraint = (AuthorizationConstraintImpl)securityConstraint.getAuthorizationConstraint();
                if (authorizationConstraint == null) continue;
                model.addRow(authorizationConstraint);
            }
            if (model.getRowCount() > 0) {
                ListSelectionModel sm = this.webAuthConstraintsTable.getSelectionModel();
                sm.setSelectionInterval(0, 0);
            }
        }
    }

    private void showAuthorizationConstraint(int i2) {
        Enumeration securityRoles;
        this.addRolePB.setEnabled(true);
        this.delRolePB.setEnabled(true);
        this.descriptionText.setEnabled(true);
        AuthorizationConstraintImpl authConstraint = this.webAuthConstraintsTableModel.getRow(i2);
        if (this.rolesTableModel.getRowCount() > 0) {
            this.rolesTableModel.removeAllRows();
        }
        if ((securityRoles = authConstraint.getSecurityRoles()) != null) {
            i2 = 0;
            while (securityRoles.hasMoreElements()) {
                SecurityRoleDescriptor securityRole = (SecurityRoleDescriptor)securityRoles.nextElement();
                this.rolesTableModel.addRow(securityRole);
            }
            if (this.rolesTableModel.getRowCount() > 0) {
                ListSelectionModel sm = this.rolesTable.getSelectionModel();
                sm.setSelectionInterval(0, 0);
            }
        }
        this.descriptionText.setText(authConstraint.getDescription());
    }

    private void updateDescription() {
        AuthorizationConstraintImpl authConstraint = this.getSelectedAuthorizationConstraint();
        if (authConstraint != null) {
            authConstraint.setDescription(this.descriptionText.getText());
        }
    }

    class WebAuthConstraintsListSelectionListener
    implements ListSelectionListener {
        WebAuthConstraintsListSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e10) {
            ListSelectionModel lsm = (ListSelectionModel)e10.getSource();
            int firstIndex = e10.getFirstIndex();
            int lastIndex = e10.getLastIndex();
            boolean isAdjusting = e10.getValueIsAdjusting();
            if (isAdjusting) {
                return;
            }
            if (lsm.isSelectionEmpty()) {
                WebAuthConstraintsDialog.this.deSelectAction();
            } else {
                int minIndex = lsm.getMinSelectionIndex();
                int maxIndex = lsm.getMaxSelectionIndex();
                int i2 = minIndex;
                while (i2 <= maxIndex) {
                    if (lsm.isSelectedIndex(i2)) {
                        WebAuthConstraintsDialog.this.showAuthorizationConstraint(i2);
                    }
                    ++i2;
                }
            }
        }
    }

    class rolesTableSelectionListener
    implements ListSelectionListener {
        rolesTableSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e10) {
            ListSelectionModel lsm = (ListSelectionModel)e10.getSource();
            int firstIndex = e10.getFirstIndex();
            int lastIndex = e10.getLastIndex();
            boolean isAdjusting = e10.getValueIsAdjusting();
            if (isAdjusting) {
                return;
            }
            if (!lsm.isSelectionEmpty()) {
                int minIndex = lsm.getMinSelectionIndex();
                int maxIndex = lsm.getMaxSelectionIndex();
                int i2 = minIndex;
                while (i2 <= maxIndex) {
                    lsm.isSelectedIndex(i2);
                    ++i2;
                }
            }
        }
    }

    public class RolesTableModel
    extends AbstractTableModel {
        ArrayList roles = new ArrayList();
        String[] columnNames = new String[]{"Role name", "Description"};

        public SecurityRoleDescriptor addRow() {
            int newRow = this.getRowCount();
            String roleName = "Role" + newRow;
            String description = "";
            SecurityRoleDescriptor role = new SecurityRoleDescriptor();
            role.setName(roleName);
            role.setDescription(description);
            this.addRow(role);
            return role;
        }

        public void addRow(SecurityRoleDescriptor role) {
            this.roles.add(role);
            int index = this.roles.size() - 1;
            this.fireTableRowsInserted(index, index);
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public String getColumnName(int col) {
            return this.columnNames[col].toString();
        }

        public SecurityRoleDescriptor getRow(int index) {
            if (index < 0 || index >= this.getRowCount()) {
                return null;
            }
            return (SecurityRoleDescriptor)this.roles.get(index);
        }

        public int getRowCount() {
            return this.roles.size();
        }

        public Object getValueAt(int row, int col) {
            SecurityRoleDescriptor role = (SecurityRoleDescriptor)this.roles.get(row);
            String value = null;
            switch (col) {
                case 0: {
                    value = role.getName();
                    break;
                }
                case 1: {
                    value = role.getDescription();
                    break;
                }
            }
            return value;
        }

        public boolean isCellEditable(int row, int col) {
            return true;
        }

        public void removeAllRows() {
            int rowCount = this.roles.size();
            if (rowCount > 0) {
                this.roles.clear();
                this.fireTableRowsDeleted(0, rowCount - 1);
            }
        }

        public void removeRow(int index) {
            this.roles.remove(index);
            this.fireTableRowsDeleted(index, index);
        }

        public void setValueAt(Object value, int row, int col) {
            SecurityRoleDescriptor role = (SecurityRoleDescriptor)this.roles.get(row);
            switch (col) {
                case 0: {
                    role.setName((String)value);
                    break;
                }
                case 1: {
                    role.setDescription((String)value);
                    break;
                }
            }
        }
    }

    public class WebAuthConstraintsTableModel
    extends AbstractTableModel {
        ArrayList authConstraints = new ArrayList();
        String[] columnNames = new String[]{"Constraint"};

        public AuthorizationConstraintImpl addRow() {
            AuthorizationConstraintImpl authConstraint = new AuthorizationConstraintImpl();
            authConstraint.setName("Untitled" + this.getRowCount());
            this.addRow(authConstraint);
            return authConstraint;
        }

        public void addRow(AuthorizationConstraintImpl authConstraint) {
            this.authConstraints.add(authConstraint);
            int index = this.authConstraints.size() - 1;
            this.fireTableRowsInserted(index, index);
        }

        public ArrayList getAllRows() {
            return this.authConstraints;
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public String getColumnName(int col) {
            return this.columnNames[col].toString();
        }

        public AuthorizationConstraintImpl getRow(int index) {
            return (AuthorizationConstraintImpl)this.authConstraints.get(index);
        }

        public int getRowCount() {
            return this.authConstraints.size();
        }

        public Object getValueAt(int row, int col) {
            AuthorizationConstraintImpl authConstraint = (AuthorizationConstraintImpl)this.authConstraints.get(row);
            String value = null;
            switch (col) {
                case 0: {
                    value = authConstraint.getName();
                    break;
                }
            }
            return value;
        }

        public boolean isCellEditable(int row, int col) {
            return true;
        }

        public void removeAllRows() {
            int rowCount = this.authConstraints.size();
            if (rowCount > 0) {
                this.authConstraints.clear();
                this.fireTableRowsDeleted(0, rowCount - 1);
            }
        }

        public void removeRow(int index) {
            this.authConstraints.remove(index);
            this.fireTableRowsDeleted(index, index);
        }

        public void setValueAt(Object value, int row, int col) {
            AuthorizationConstraintImpl authConstraint = (AuthorizationConstraintImpl)this.authConstraints.get(row);
            switch (col) {
                case 0: {
                    authConstraint.setName(value.toString());
                    break;
                }
            }
        }
    }
}

