/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.descriptor;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.WebComponentDescriptorImpl;
import com.sun.enterprise.tools.deployment.ui.Inspector;
import com.sun.enterprise.tools.deployment.ui.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.descriptor.MyTableModel;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.NotificationEvent;
import com.sun.enterprise.util.NotificationListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.help.CSH;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableModel;

public class WebComponentAliasesInspector
extends JPanel
implements Inspector {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$descriptor$WebComponentAliasesInspector != null ? class$com$sun$enterprise$tools$deployment$ui$descriptor$WebComponentAliasesInspector : (class$com$sun$enterprise$tools$deployment$ui$descriptor$WebComponentAliasesInspector = WebComponentAliasesInspector.class$("com.sun.enterprise.tools.deployment.ui.descriptor.WebComponentAliasesInspector")));
    WebComponentDescriptorImpl descriptor;
    private InspectorTable urlMappingTable = new InspectorTable();
    String[] columns = new String[]{localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.urlmappings", "URL Mappings")};
    private NotificationListener tableEditListener;
    private static String helpSetMapID = "CIAlias";
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$descriptor$WebComponentAliasesInspector;

    public WebComponentAliasesInspector() {
        CSH.setHelpIDString((Component)this, (String)helpSetMapID);
        this.initializeLayout();
    }

    public void addAction() {
        Vector v2 = new Vector();
        Enumeration e10 = this.descriptor.getUrlPatterns();
        while (e10.hasMoreElements()) {
            v2.addElement(e10.nextElement());
        }
        this.descriptor.addUrlPattern(Descriptor.createUniqueNameAmongst("alias", v2));
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public void deleteAction() {
        int i2 = this.urlMappingTable.getSelectedRow();
        if (i2 != -1) {
            int n2 = JOptionPane.showConfirmDialog(this, localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.surewanttodeleteselectedalias", "Are you sure you want to delete the selected alias?"), "Delete alias", 0);
            if (n2 == 0) {
                String urlPattern = (String)((MyTableModel)this.urlMappingTable.getModel()).getValueAt(i2, 0);
                this.descriptor.removeUrlPattern(urlPattern);
            }
        } else {
            JOptionPane.showMessageDialog(this, localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.firstselectaliasfromlist", "You must first select an alias from the list"));
        }
    }

    private void initializeLayout() {
        this.setLayout(new BorderLayout());
        Object[][] data = new Object[][]{{"a"}, {"b"}};
        MyTableModel tableModel = new MyTableModel(data, this.columns, 0);
        this.urlMappingTable.setAutoResizeMode(4);
        this.urlMappingTable.setModel(tableModel);
        this.urlMappingTable.setSelectionMode(0);
        JPanel mappingPanel = new JPanel();
        mappingPanel.setLayout(new BorderLayout());
        mappingPanel.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        mappingPanel.add(new JScrollPane(this.urlMappingTable));
        this.add("Center", mappingPanel);
        JButton addButton = new JButton(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.add", "Add"));
        JButton deleteButton = new JButton(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.delete", "Delete"));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 1));
        buttonPanel.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        buttonPanel.add(addButton);
        buttonPanel.add(Box.createVerticalStrut(5));
        buttonPanel.add(deleteButton);
        buttonPanel.add(Box.createGlue());
        this.add("East", buttonPanel);
        addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                WebComponentAliasesInspector.this.addAction();
            }
        });
        deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                WebComponentAliasesInspector.this.deleteAction();
            }
        });
        this.tableEditListener = new NotificationListener(){

            public void notification(NotificationEvent ne) {
                WebComponentAliasesInspector.this.tableChanged();
            }
        };
    }

    public static void main(String[] args) {
        JFrame f2 = new JFrame();
        ((Component)f2).setBounds(0, 0, 300, 300);
        f2.getContentPane().add(new WebComponentAliasesInspector());
        f2.show();
    }

    private void refresh() {
        this.refreshTableForSelection();
    }

    public void refreshTableForSelection() {
        Object[][] tableData = new Object[this.descriptor.getUrlPatternsSet().size()][1];
        int i2 = 0;
        while (i2 < this.descriptor.getUrlPatternsSet().size()) {
            String pattern = (String)new Vector(this.descriptor.getUrlPatternsSet()).elementAt(i2);
            tableData[i2][0] = pattern;
            ++i2;
        }
        MyTableModel tableModel = new MyTableModel(tableData, this.columns, 0);
        tableModel.addNotificationListener(this.tableEditListener);
        this.urlMappingTable.setModel(tableModel);
        this.urlMappingTable.sizeColumnsToFit(0);
    }

    public void setObject(Object object) {
        if (object instanceof WebComponentDescriptorImpl) {
            this.descriptor = (WebComponentDescriptorImpl)object;
            this.refresh();
        }
    }

    public void tableChanged() {
        if (this.descriptor != null) {
            this.descriptor.getUrlPatternsSet().removeAll(this.descriptor.getUrlPatternsSet());
            TableModel tableModel = this.urlMappingTable.getModel();
            int i2 = 0;
            while (i2 < tableModel.getRowCount()) {
                String next = (String)tableModel.getValueAt(i2, 0);
                this.descriptor.getUrlPatternsSet().add(next);
                ++i2;
            }
            this.descriptor.changed();
        }
    }
}

