/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.descriptor;

import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.WebComponentDescriptorImpl;
import com.sun.enterprise.tools.deployment.ui.Inspector;
import com.sun.enterprise.tools.deployment.ui.InspectorTable;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.help.CSH;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

public class WebComponentParametersInspector
extends JPanel
implements Inspector {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$descriptor$WebComponentParametersInspector != null ? class$com$sun$enterprise$tools$deployment$ui$descriptor$WebComponentParametersInspector : (class$com$sun$enterprise$tools$deployment$ui$descriptor$WebComponentParametersInspector = WebComponentParametersInspector.class$("com.sun.enterprise.tools.deployment.ui.descriptor.WebComponentParametersInspector")));
    WebComponentDescriptorImpl descriptor;
    JPanel pnlWest = new JPanel();
    JPanel pnlDescription = new JPanel();
    DefaultTableModel tableModel;
    ParametersTableModel parametersTableModel;
    ParametersTable parametersTable;
    JScrollPane scrlTable;
    JTextArea txtDescription = new JTextArea();
    JButton btnDelete = new JButton();
    JButton btnAdd = new JButton();
    JPanel pnlButtons = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    BorderLayout borderLayout2 = new BorderLayout();
    int addCounter = 0;
    final String[] columnNames = new String[]{localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.initializationparameter", "Initialization Parameter"), localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.value", "Value")};
    private static String helpSetMapID = "CIParams";
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$descriptor$WebComponentParametersInspector;

    public WebComponentParametersInspector() {
        CSH.setHelpIDString((Component)this, (String)helpSetMapID);
        try {
            this.initializeLayout();
        }
        catch (Exception ex2) {
            ex2.printStackTrace();
        }
    }

    private void addAction() {
        String counter = new Integer(this.addCounter).toString();
        ++this.addCounter;
        String parameterKey = "parameter" + counter;
        this.descriptor.addInitializationParameter(new EnvironmentProperty(parameterKey, "value" + counter, "description for " + parameterKey));
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private void deleteAction() {
        int i2 = this.parametersTable.getSelectedRow();
        if (i2 != -1) {
            String key = (String)((ParametersTableModel)this.parametersTable.getModel()).getValueAt(i2, 0);
            EnvironmentProperty ep2 = (EnvironmentProperty)this.descriptor.getInitializationParameterByName(key);
            int n2 = JOptionPane.showConfirmDialog(this, localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.surewanttodeleteselectedparam", "Are you sure you want to delete selected parameter?"), "Delete parameter", 0);
            if (n2 == 0) {
                this.descriptor.removeInitializationParameter(ep2);
            }
        } else {
            JOptionPane.showMessageDialog(this, localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.firstselectparameterfromlist", "You must first select a parameter from list"));
        }
    }

    private void descriptionChanged() {
        int i2 = this.parametersTable.getSelectedRow();
        if (i2 != -1) {
            String key = (String)((ParametersTableModel)this.parametersTable.getModel()).getValueAt(i2, 0);
            EnvironmentProperty ep2 = (EnvironmentProperty)this.descriptor.getInitializationParameterByName(key);
            this.descriptor.setDescription(this.txtDescription.getText());
            this.descriptor.changed();
        }
    }

    private void initializeLayout() throws Exception {
        this.setLayout(this.borderLayout1);
        this.pnlWest.setLayout(this.borderLayout2);
        this.parametersTableModel = new ParametersTableModel(this);
        this.parametersTable = new ParametersTable(this.parametersTableModel);
        this.parametersTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e10) {
                ListSelectionModel lsm = (ListSelectionModel)e10.getSource();
                if (!lsm.isSelectionEmpty()) {
                    WebComponentParametersInspector.this.parametersTable.setSelectedRow(lsm.getMinSelectionIndex());
                    WebComponentParametersInspector.this.setSelectionInfo(lsm.getMinSelectionIndex());
                } else {
                    WebComponentParametersInspector.this.parametersTable.setSelectedRow(-1);
                }
            }
        });
        this.scrlTable = new JScrollPane(this.parametersTable);
        this.scrlTable.setVerticalScrollBarPolicy(22);
        this.scrlTable.setBorder(BorderFactory.createLoweredBevelBorder());
        this.scrlTable.setPreferredSize(new Dimension(300, 150));
        this.pnlDescription.setBorder(new TitledBorder(BorderFactory.createEmptyBorder(), localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.description", "Description:")));
        this.pnlDescription.setLayout(new BoxLayout(this.pnlDescription, 1));
        this.txtDescription.setBorder(BorderFactory.createLoweredBevelBorder());
        this.btnDelete.setText(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.delete", "Delete"));
        this.btnDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                WebComponentParametersInspector.this.deleteAction();
            }
        });
        this.btnAdd.setMaximumSize(new Dimension(71, 27));
        this.btnAdd.setMinimumSize(new Dimension(71, 27));
        this.btnAdd.setPreferredSize(new Dimension(71, 27));
        this.btnAdd.setText(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.add", "Add"));
        this.btnAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                WebComponentParametersInspector.this.addAction();
            }
        });
        this.add((Component)this.pnlWest, "West");
        this.pnlWest.add((Component)this.scrlTable, "North");
        this.pnlWest.add((Component)this.pnlDescription, "Center");
        this.pnlDescription.add(new JScrollPane(this.txtDescription));
        this.add((Component)this.pnlButtons, "Center");
        this.pnlButtons.add(this.btnAdd);
        this.pnlButtons.add(this.btnDelete);
        this.txtDescription.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent fe2) {
                WebComponentParametersInspector.this.descriptionChanged();
            }
        });
        this.txtDescription.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                if (ke.getKeyCode() == 10) {
                    WebComponentParametersInspector.this.descriptionChanged();
                }
            }
        });
    }

    private void refresh() {
        this.parametersTableModel = new ParametersTableModel(this);
        Enumeration initializationParameters = this.descriptor.getInitializationParameters();
        while (initializationParameters.hasMoreElements()) {
            EnvironmentProperty initializationParameter = (EnvironmentProperty)initializationParameters.nextElement();
            this.parametersTableModel.addRow(initializationParameter.getName(), initializationParameter.getValue());
        }
        this.parametersTable.setModel(this.parametersTableModel);
        if (this.parametersTable.getRowCount() > 1) {
            this.setSelectionInfo(0);
        }
        this.parametersTable.setAutoResizeMode(4);
        this.parametersTable.sizeColumnsToFit(0);
    }

    public void setObject(Object object) {
        if (object instanceof WebComponentDescriptorImpl) {
            this.descriptor = (WebComponentDescriptorImpl)object;
            this.refresh();
        }
    }

    private void setSelectionInfo(int row) {
        Enumeration initializationParameters = this.descriptor.getInitializationParameters();
        EnvironmentProperty initializationParameter = null;
        int index = 0;
        while (index <= row) {
            initializationParameter = (EnvironmentProperty)initializationParameters.nextElement();
            ++index;
        }
        if (initializationParameter != null) {
            this.txtDescription.setText(initializationParameter.getDescription());
        }
    }

    private class ParametersTable
    extends InspectorTable {
        int selectedRow = -1;

        public ParametersTable(ParametersTableModel model) {
            super(model);
            this.setToolTipText(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.tableofparams", "Table of parameters"));
            this.setSelectionMode(0);
        }

        private void setSelectedRow(int index) {
            Integer oldIndex = new Integer(this.selectedRow);
            this.selectedRow = index;
        }

        void setupColNameColumn() {
            TableColumn colNameColumn = this.getColumnModel().getColumn(1);
            JTextField colNameText = new JTextField();
            colNameColumn.setCellEditor(new DefaultCellEditor(colNameText));
            DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
            renderer.setToolTipText(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.edittext", "Click to edit text"));
            colNameColumn.setCellRenderer(renderer);
        }
    }

    public class ParametersTableModel
    extends AbstractTableModel {
        ArrayList fields = new ArrayList();
        WebComponentParametersInspector inspector;
        String[] columnNames = new String[]{WebComponentParametersInspector.access$4().getLocalString("enterprise.tools.deployment.ui.descriptor.initializationparameter", "Initialization parameter"), WebComponentParametersInspector.access$4().getLocalString("enterprise.tools.deployment.ui.descriptor.value", "Value")};

        public ParametersTableModel(WebComponentParametersInspector inspector) {
            this.inspector = inspector;
        }

        public void addRow(String initializationParameter, String value) {
            FieldInfo field = new FieldInfo();
            field.initializationParameter = initializationParameter;
            field.value = value;
            this.fields.add(field);
            this.fireTableRowsInserted(this.fields.size() - 1, this.fields.size() - 1);
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public String getColumnName(int col) {
            return this.columnNames[col].toString();
        }

        public int getRowCount() {
            return this.fields.size();
        }

        public Object getValueAt(int row, int col) {
            FieldInfo fieldInfo = (FieldInfo)this.fields.get(row);
            Object value = fieldInfo.getElement(col);
            return value;
        }

        public boolean isCellEditable(int row, int col) {
            return true;
        }

        public void setValueAt(Object value, int row, int col) {
            Enumeration initializationParameters = WebComponentParametersInspector.this.descriptor.getInitializationParameters();
            String key = (String)this.getValueAt(row, 0);
            EnvironmentProperty initializationParameter = (EnvironmentProperty)WebComponentParametersInspector.this.descriptor.getInitializationParameterByName(key);
            switch (col) {
                case 0: {
                    initializationParameter.setName((String)value);
                    WebComponentParametersInspector.this.descriptor.changed();
                    break;
                }
                case 1: {
                    initializationParameter.setValue((String)value);
                    WebComponentParametersInspector.this.descriptor.changed();
                    break;
                }
            }
        }

        private class FieldInfo {
            String initializationParameter;
            String value;

            FieldInfo() {
            }

            Object getElement(int col) {
                String elem = null;
                switch (col) {
                    case 0: {
                        elem = this.initializationParameter;
                        break;
                    }
                    case 1: {
                        elem = this.value;
                        break;
                    }
                }
                return elem;
            }

            void setElement(int col, Object elem) {
                switch (col) {
                    case 0: {
                        this.initializationParameter = elem.toString();
                        break;
                    }
                    case 1: {
                        this.value = elem.toString();
                        break;
                    }
                }
            }
        }
    }
}

