/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.descriptor;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.SecurityConstraintImpl;
import com.sun.enterprise.deployment.WebResourceCollectionImpl;
import com.sun.enterprise.tools.deployment.ui.DeployToolActions;
import com.sun.enterprise.tools.deployment.ui.Inspector;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.help.CSH;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;

public class WebResourceCollectionsDialog
extends JDialog
implements Inspector {
    private static String helpSetMapID = "WIWebResource";
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$descriptor$WebResourceCollectionsDialog != null ? class$com$sun$enterprise$tools$deployment$ui$descriptor$WebResourceCollectionsDialog : (class$com$sun$enterprise$tools$deployment$ui$descriptor$WebResourceCollectionsDialog = WebResourceCollectionsDialog.class$("com.sun.enterprise.tools.deployment.ui.descriptor.WebResourceCollectionsDialog")));
    GridBagConstraints c = new GridBagConstraints();
    JTable collectionTable;
    JTable urlPatternTable;
    JButton addUrlPB;
    JButton delUrlPB;
    JList methodList;
    JCheckBox getBox = new JCheckBox(GET_METHOD);
    JCheckBox postBox = new JCheckBox(POST_METHOD);
    boolean isOK = false;
    public static String GET_METHOD = "GET";
    public static String POST_METHOD = "POST";
    public static String URL_PATTERN_DEFAULT = "urlPattern";
    SecurityConstraintImpl descriptor;
    static SecurityConstraintImpl wbd;
    static WebResourceCollectionsDialog ei;
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$descriptor$WebResourceCollectionsDialog;
    static /* synthetic */ Class class$javax$swing$JFrame;

    public WebResourceCollectionsDialog(Frame frame, boolean modal) {
        super(frame, localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.wrc", "Web Resource Collections"), modal);
        CSH.setHelpIDString((Component)this, (String)helpSetMapID);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                WebResourceCollectionsDialog.this.cancelAction();
            }
        });
        JPanel collectionsPanel = this.createCollectionsPanel();
        this.methodList = new JList();
        this.getBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent me) {
                WebResourceCollectionsDialog.this.methodsChangedAction();
            }
        });
        this.postBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent me) {
                WebResourceCollectionsDialog.this.methodsChangedAction();
            }
        });
        JPanel methodsPanel = new JPanel();
        methodsPanel.setLayout(new GridLayout(2, 1));
        methodsPanel.setBorder(new TitledBorder(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.httpmethods", "HTTP methods")));
        methodsPanel.add(this.getBox);
        methodsPanel.add(this.postBox);
        JPanel urlPatternPanel = this.createUrlPatternPanel();
        JPanel dialogButtonPanel = new JPanel();
        dialogButtonPanel.setLayout(new BoxLayout(dialogButtonPanel, 0));
        dialogButtonPanel.add(Box.createHorizontalGlue());
        JButton okPB = new JButton(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.okbutton", "OK"));
        dialogButtonPanel.add(okPB);
        okPB.setMnemonic('O');
        okPB.setActionCommand("OK");
        okPB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                WebResourceCollectionsDialog.this.okAction();
            }
        });
        JButton cancelPB = new JButton(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.cancelbutton", "Cancel"));
        dialogButtonPanel.add(cancelPB);
        cancelPB.setMnemonic('C');
        cancelPB.setActionCommand("Cancel");
        cancelPB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                WebResourceCollectionsDialog.this.cancelAction();
            }
        });
        JButton helpPB = new JButton(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.helpbutton", "Help"));
        DeployToolActions.enableHelpOnButton(helpPB, helpSetMapID);
        dialogButtonPanel.add(helpPB);
        helpPB.setMnemonic('H');
        helpPB.setActionCommand("Help");
        helpPB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                WebResourceCollectionsDialog.this.helpAction();
            }
        });
        JPanel mainPanel = new JPanel();
        dialogButtonPanel.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        mainPanel.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        mainPanel.setLayout(new BoxLayout(mainPanel, 0));
        mainPanel.add(collectionsPanel);
        JPanel keyOffSelectionPanel = new JPanel();
        CompoundBorder cb2 = new CompoundBorder(new EmptyBorder(new Insets(5, 5, 5, 5)), new TitledBorder(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.collectionattributes", "Collection Attributes")));
        keyOffSelectionPanel.setBorder(cb2);
        keyOffSelectionPanel.setLayout(new BoxLayout(keyOffSelectionPanel, 1));
        keyOffSelectionPanel.add(methodsPanel);
        keyOffSelectionPanel.add(urlPatternPanel);
        mainPanel.add(keyOffSelectionPanel);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add("South", dialogButtonPanel);
        this.getContentPane().add("Center", mainPanel);
    }

    static /* synthetic */ LocalStringManagerImpl access$9() {
        return localStrings;
    }

    private void addUrlPatternAction() {
        WebResourceCollectionImpl collection = this.getSelectedWebResourceCollection();
        if (collection != null) {
            Vector v2 = new Vector();
            Enumeration e10 = collection.getUrlPatterns();
            while (e10.hasMoreElements()) {
                v2.addElement(e10.nextElement());
            }
            String urlPattern = Descriptor.createUniqueNameAmongst(URL_PATTERN_DEFAULT, v2);
            collection.addUrlPattern(urlPattern);
            this.refresh();
        }
    }

    private void addWebResourceCollectionAction() {
        WebResourceCollectionImpl wrc = new WebResourceCollectionImpl();
        Vector<String> v2 = new Vector<String>();
        Enumeration e10 = this.descriptor.getWebResourceCollections();
        while (e10.hasMoreElements()) {
            WebResourceCollectionImpl next = (WebResourceCollectionImpl)e10.nextElement();
            v2.addElement(next.getName());
        }
        String name = Descriptor.createUniqueNameAmongst("securityZone", v2);
        wrc.setName(name);
        wrc.addHttpMethod(GET_METHOD);
        this.descriptor.addWebResourceCollection(wrc);
        this.refresh();
    }

    private void cancelAction() {
        this.isOK = false;
        ((Component)this).setVisible(false);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private JPanel createCollectionsPanel() {
        JPanel collectionsPanel = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        collectionsPanel.setLayout(gb);
        WebResourceCollectionTableModel collectionTableModel = new WebResourceCollectionTableModel(new Vector().elements());
        this.collectionTable = new JTable(collectionTableModel);
        this.collectionTable.setSelectionMode(0);
        this.collectionTable.addMouseListener(new CollectionsTableMouseListener());
        JScrollPane collectionTablePane = new JScrollPane(this.collectionTable);
        this.collectionTable.setBorder(new EtchedBorder());
        this.collectionTable.setAutoResizeMode(4);
        collectionTablePane.setPreferredSize(new Dimension(150, 200));
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.5;
        this.c.weighty = 0.5;
        this.c.insets = new Insets(5, 5, 5, 5);
        this.c.fill = 1;
        gb.setConstraints(collectionTablePane, this.c);
        collectionsPanel.add(collectionTablePane);
        JPanel collectionsButtonPanel = new JPanel();
        collectionsButtonPanel.setLayout(new GridLayout(1, 2, 5, 5));
        this.c.gridx = 0;
        this.c.gridy = 1;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.insets = new Insets(5, 5, 5, 5);
        this.c.fill = 0;
        this.c.anchor = 13;
        gb.setConstraints(collectionsButtonPanel, this.c);
        collectionsPanel.add(collectionsButtonPanel);
        this.c.fill = 1;
        this.c.anchor = 10;
        JButton addPB = new JButton(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.add", "Add"));
        collectionsButtonPanel.add(addPB);
        addPB.setMnemonic('A');
        addPB.setActionCommand("Add");
        addPB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                WebResourceCollectionsDialog.this.addWebResourceCollectionAction();
            }
        });
        JButton delPB = new JButton(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.delete", "Delete..."));
        collectionsButtonPanel.add(delPB);
        delPB.setMnemonic('D');
        delPB.setActionCommand("Delete");
        delPB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                WebResourceCollectionsDialog.this.deleteWebResourceCollectionAction();
            }
        });
        return collectionsPanel;
    }

    private JPanel createUrlPatternPanel() {
        JPanel urlPatternPanel = new JPanel();
        urlPatternPanel.setBorder(new TitledBorder(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.urlpatterns", "URL patterns")));
        UrlPatternTableModel urlPatternTableModel = new UrlPatternTableModel(new Vector().elements());
        this.urlPatternTable = new JTable(urlPatternTableModel);
        this.urlPatternTable.setSelectionMode(0);
        this.urlPatternTable.setAutoResizeMode(4);
        JScrollPane urlPatternTablePane = new JScrollPane(this.urlPatternTable);
        urlPatternTablePane.setPreferredSize(new Dimension(250, 150));
        JPanel urlPatternButtonPanel = new JPanel();
        urlPatternButtonPanel.setLayout(new BoxLayout(urlPatternButtonPanel, 0));
        this.addUrlPB = new JButton(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.add", "Add"));
        this.addUrlPB.setMnemonic('A');
        this.addUrlPB.setActionCommand("Add");
        this.addUrlPB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                WebResourceCollectionsDialog.this.addUrlPatternAction();
            }
        });
        this.delUrlPB = new JButton(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.delete", "Delete..."));
        this.delUrlPB.setMnemonic('D');
        this.delUrlPB.setActionCommand("Delete");
        this.delUrlPB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                WebResourceCollectionsDialog.this.deleteUrlPatternAction();
            }
        });
        urlPatternButtonPanel.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        urlPatternButtonPanel.add(Box.createHorizontalGlue());
        urlPatternButtonPanel.add(this.addUrlPB);
        urlPatternButtonPanel.add(Box.createHorizontalStrut(5));
        urlPatternButtonPanel.add(this.delUrlPB);
        urlPatternButtonPanel.add(Box.createHorizontalStrut(5));
        urlPatternPanel.setLayout(new BorderLayout());
        urlPatternPanel.add("Center", urlPatternTablePane);
        urlPatternPanel.add("South", urlPatternButtonPanel);
        return urlPatternPanel;
    }

    private void deleteUrlPatternAction() {
        JFrame frame = (JFrame)SwingUtilities.getAncestorOfClass(class$javax$swing$JFrame != null ? class$javax$swing$JFrame : (class$javax$swing$JFrame = WebResourceCollectionsDialog.class$("javax.swing.JFrame")), this);
        UrlPatternTableModel model = (UrlPatternTableModel)this.urlPatternTable.getModel();
        ListSelectionModel sm = this.urlPatternTable.getSelectionModel();
        int index = sm.getMinSelectionIndex();
        WebResourceCollectionImpl collection = this.getSelectedWebResourceCollection();
        if (index >= 0 && collection != null) {
            int n2 = JOptionPane.showConfirmDialog(frame, localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.surewanttodeleteurlpattern", "Are you sure you want to delete selected URL pattern?"), "Delete URL pattern", 0);
            if (n2 == 0) {
                if (collection != null) {
                    collection.removeUrlPattern(model.getRow(index));
                }
                this.refresh();
            }
        } else {
            JOptionPane.showMessageDialog(frame, localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.firstselecturlpatternfromlist", "You must first select a URL pattern from list"));
        }
    }

    private void deleteWebResourceCollectionAction() {
        JFrame frame = (JFrame)SwingUtilities.getAncestorOfClass(class$javax$swing$JFrame != null ? class$javax$swing$JFrame : (class$javax$swing$JFrame = WebResourceCollectionsDialog.class$("javax.swing.JFrame")), this);
        WebResourceCollectionTableModel model = (WebResourceCollectionTableModel)this.collectionTable.getModel();
        ListSelectionModel sm = this.collectionTable.getSelectionModel();
        int index = sm.getMinSelectionIndex();
        if (index >= 0) {
            int n2 = JOptionPane.showConfirmDialog(frame, localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.surewanttodeleteselectedwebresourcecollection", "Are you sure you want to delete selected web resource collection?"), "Delete web resource collection", 0);
            if (n2 == 0) {
                WebResourceCollectionImpl collection = model.getRow(index);
                this.descriptor.removeWebResourceCollection(collection);
                this.refresh();
            }
        } else {
            JOptionPane.showMessageDialog(frame, localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.firstselectresourcecollectionfromlist", "You must first select a web resource collection from list"));
        }
    }

    SecurityConstraintImpl getDescriptor() {
        return this.descriptor;
    }

    WebResourceCollectionImpl getSelectedWebResourceCollection() {
        int minIndex;
        WebResourceCollectionImpl collection = null;
        ListSelectionModel lsm = this.collectionTable.getSelectionModel();
        if (lsm.isSelectedIndex(minIndex = lsm.getMinSelectionIndex())) {
            collection = this.getWRCTableModel().getRow(minIndex);
        }
        return collection;
    }

    private WebResourceCollectionTableModel getWRCTableModel() {
        return (WebResourceCollectionTableModel)this.collectionTable.getModel();
    }

    private void helpAction() {
    }

    boolean isOK() {
        return this.isOK;
    }

    public static void main(String[] args) {
        ei = new WebResourceCollectionsDialog(null, true);
        wbd = new SecurityConstraintImpl();
        ei.setObject(wbd);
        ((Component)ei).setBounds(10, 10, 500, 300);
        ei.show();
    }

    private void methodsChangedAction() {
        if (this.getSelectedWebResourceCollection() != null) {
            Enumeration e10 = this.getSelectedWebResourceCollection().getHttpMethods();
            while (e10.hasMoreElements()) {
                String next = (String)e10.nextElement();
                this.getSelectedWebResourceCollection().removeHttpMethod(next);
            }
            if (this.getBox.isSelected()) {
                this.getSelectedWebResourceCollection().addHttpMethod(GET_METHOD);
            }
            if (this.postBox.isSelected()) {
                this.getSelectedWebResourceCollection().addHttpMethod(POST_METHOD);
            }
        }
        this.refresh();
    }

    private void okAction() {
        this.isOK = true;
        ((Component)this).setVisible(false);
    }

    public void refresh() {
        if (this.descriptor == null) {
            return;
        }
        WebResourceCollectionImpl oldSelection = this.getSelectedWebResourceCollection();
        WebResourceCollectionTableModel collectionTableModel = new WebResourceCollectionTableModel(this.descriptor.getWebResourceCollections());
        this.collectionTable.setModel(collectionTableModel);
        this.collectionTable.sizeColumnsToFit(0);
        int newSelectionIndex = -1;
        if (oldSelection != null) {
            newSelectionIndex = collectionTableModel.getIndexOf(oldSelection);
        }
        if (newSelectionIndex != -1) {
            this.collectionTable.setRowSelectionInterval(newSelectionIndex, newSelectionIndex);
        }
        this.showWebResourceCollection(newSelectionIndex);
    }

    public void setObject(Object descriptor) {
        if (descriptor instanceof SecurityConstraintImpl) {
            this.descriptor = (SecurityConstraintImpl)descriptor;
            this.refresh();
        }
    }

    private void showWebResourceCollection(int i2) {
        WebResourceCollectionImpl collection = this.getWRCTableModel().getRow(i2);
        this.addUrlPB.setEnabled(true);
        this.delUrlPB.setEnabled(true);
        this.getBox.setEnabled(true);
        this.postBox.setEnabled(true);
        this.urlPatternTable.setEnabled(true);
        if (collection != null) {
            Enumeration methods = collection.getHttpMethods();
            this.getBox.setSelected(false);
            this.postBox.setSelected(false);
            while (methods.hasMoreElements()) {
                String method = (String)methods.nextElement();
                if (GET_METHOD.equals(method)) {
                    this.getBox.setSelected(true);
                }
                if (!POST_METHOD.equals(method)) continue;
                this.postBox.setSelected(true);
            }
            Enumeration patterns = collection.getUrlPatterns();
            UrlPatternTableModel tableModel = new UrlPatternTableModel(collection.getUrlPatterns());
            this.urlPatternTable.setModel(tableModel);
            this.urlPatternTable.sizeColumnsToFit(0);
        } else {
            this.addUrlPB.setEnabled(false);
            this.delUrlPB.setEnabled(false);
            this.getBox.setEnabled(false);
            this.postBox.setEnabled(false);
            this.urlPatternTable.setEnabled(false);
            this.getBox.setSelected(false);
            this.postBox.setSelected(false);
            UrlPatternTableModel urlPatternTableModel = new UrlPatternTableModel(new Vector().elements());
            this.urlPatternTable.setModel(urlPatternTableModel);
        }
    }

    class CollectionsTableMouseListener
    extends MouseAdapter {
        CollectionsTableMouseListener() {
        }

        public void mouseClicked(MouseEvent me) {
            int index = WebResourceCollectionsDialog.this.collectionTable.getSelectedRow();
            WebResourceCollectionsDialog.this.showWebResourceCollection(index);
        }
    }

    public class WebResourceCollectionTableModel
    extends AbstractTableModel {
        ArrayList collections = new ArrayList();
        String[] columnNames = new String[]{WebResourceCollectionsDialog.access$9().getLocalString("enterprise.tools.deployment.ui.descriptor.collectionname", "Collection Name"), WebResourceCollectionsDialog.access$9().getLocalString("enterprise.tools.deployment.ui.descriptor.description", "Description")};

        public WebResourceCollectionTableModel(Enumeration wrcs) {
            while (wrcs.hasMoreElements()) {
                WebResourceCollectionImpl wrc = (WebResourceCollectionImpl)wrcs.nextElement();
                this.collections.add(wrc);
            }
        }

        public ArrayList getAllRows() {
            return this.collections;
        }

        public int getColumnCount() {
            return 1;
        }

        public String getColumnName(int col) {
            return this.columnNames[col].toString();
        }

        public int getIndexOf(WebResourceCollectionImpl wrci) {
            return this.collections.indexOf(wrci);
        }

        public WebResourceCollectionImpl getRow(int index) {
            if (index < 0 || index >= this.getRowCount()) {
                return null;
            }
            return (WebResourceCollectionImpl)this.collections.get(index);
        }

        public int getRowCount() {
            return this.collections.size();
        }

        public Object getValueAt(int row, int col) {
            WebResourceCollectionImpl collection = (WebResourceCollectionImpl)this.collections.get(row);
            String value = null;
            switch (col) {
                case 0: {
                    value = collection.getName();
                    break;
                }
                case 1: {
                    value = collection.getDescription();
                    break;
                }
            }
            return value;
        }

        public boolean isCellEditable(int row, int col) {
            return true;
        }

        public void setValueAt(Object value, int row, int col) {
            WebResourceCollectionImpl collection = (WebResourceCollectionImpl)this.collections.get(row);
            switch (col) {
                case 0: {
                    collection.setName((String)value);
                    break;
                }
                case 1: {
                    collection.setDescription((String)value);
                    break;
                }
            }
        }
    }

    public class UrlPatternTableModel
    extends AbstractTableModel {
        ArrayList urlPatterns = new ArrayList();
        String[] columnNames = new String[]{""};

        public UrlPatternTableModel(Enumeration urls) {
            while (urls.hasMoreElements()) {
                this.urlPatterns.add(urls.nextElement());
            }
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public String getColumnName(int col) {
            return this.columnNames[col].toString();
        }

        public String getRow(int index) {
            return (String)this.urlPatterns.get(index);
        }

        public int getRowCount() {
            return this.urlPatterns.size();
        }

        public Object getValueAt(int row, int col) {
            String urlPattern = (String)this.urlPatterns.get(row);
            String value = null;
            switch (col) {
                case 0: {
                    value = urlPattern;
                    break;
                }
            }
            return value;
        }

        public boolean isCellEditable(int row, int col) {
            return true;
        }

        public void setValueAt(Object value, int row, int col) {
            String old = (String)this.urlPatterns.get(row);
            if (WebResourceCollectionsDialog.this.getSelectedWebResourceCollection() != null) {
                WebResourceCollectionsDialog.this.getSelectedWebResourceCollection().removeUrlPattern(old);
                WebResourceCollectionsDialog.this.getSelectedWebResourceCollection().addUrlPattern(value.toString());
                WebResourceCollectionsDialog.this.refresh();
            }
        }
    }
}

