/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.generators;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationArchivist;
import com.sun.enterprise.deployment.Archivist;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.tools.deployment.backend.DeploymentSession;
import com.sun.enterprise.tools.generators.GeneratorException;
import com.sun.enterprise.util.JarClassLoader;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.NotificationEvent;
import com.sun.enterprise.util.ORBManager;
import com.sun.enterprise.util.Utility;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import sun.tools.javac.Main;

public class Generator {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$generators$Generator != null ? class$com$sun$enterprise$tools$generators$Generator : (class$com$sun$enterprise$tools$generators$Generator = Generator.class$("com.sun.enterprise.tools.generators.Generator")));
    private static DeploymentSession session;
    private static String applicationName;
    Vector generators = new Vector();
    Vector generatedFiles = new Vector();
    private static final String fs;
    private static final char fsc;
    private static final String ps;
    private static String rmic;
    private static final File tmpDir;
    private static File appTmpDir;
    private static final boolean debug = false;
    static /* synthetic */ Class class$com$sun$enterprise$tools$generators$Generator;
    static /* synthetic */ Class class$com$sun$enterprise$tools$generators$HomeGenerator;
    static /* synthetic */ Class class$com$sun$enterprise$tools$generators$WrapperGenerator;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$EjbDescriptor;
    static /* synthetic */ Class class$com$sun$enterprise$util$JarClassLoader;

    static {
        fs = System.getProperty("file.separator");
        fsc = fs.charAt(0);
        ps = System.getProperty("path.separator");
        String eHome = System.getProperty("com.sun.enterprise.home");
        if (eHome == null) {
            eHome = "tmp";
        }
        String hostname = Utility.getLocalHost();
        String tmpDirName = String.valueOf(eHome) + File.separator + "repository" + File.separator + hostname + File.separator + "gnrtrTMP";
        tmpDir = new File(tmpDirName == null ? "tmp" : tmpDirName);
        if (!tmpDir.exists()) {
            tmpDir.mkdir();
        }
        rmic = String.valueOf(System.getProperty("java.home")) + fs + "bin" + fs + "java";
    }

    public Generator() {
        this.generators.addElement(class$com$sun$enterprise$tools$generators$HomeGenerator != null ? class$com$sun$enterprise$tools$generators$HomeGenerator : (class$com$sun$enterprise$tools$generators$HomeGenerator = Generator.class$("com.sun.enterprise.tools.generators.HomeGenerator")));
        this.generators.addElement(class$com$sun$enterprise$tools$generators$WrapperGenerator != null ? class$com$sun$enterprise$tools$generators$WrapperGenerator : (class$com$sun$enterprise$tools$generators$WrapperGenerator = Generator.class$("com.sun.enterprise.tools.generators.WrapperGenerator")));
    }

    public static void addGeneratedFiles(Vector dds, Vector allGeneratedFiles, Vector allClientFiles) {
        int ddIndex = 0;
        while (ddIndex < dds.size()) {
            String remoteStubDir;
            String homeStubDir;
            EjbDescriptor dd2 = (EjbDescriptor)dds.elementAt(ddIndex);
            String homeName = dd2.getHomeClassName().replace('.', fsc);
            String ebName = dd2.getEjbClassName().replace('.', fsc);
            String orgomgstub = "org" + fs + "omg" + fs + "stub";
            String ebTieDir = ebName;
            int idx = ebName.lastIndexOf(fsc);
            if (idx != -1) {
                String ebPackageName = ebName.substring(0, idx);
                ebTieDir = ebName.startsWith("com" + fs + "sun" + fs) ? String.valueOf(String.valueOf(Generator.getTempDirectory())) + fs + orgomgstub + fs + ebPackageName : String.valueOf(String.valueOf(Generator.getTempDirectory())) + fs + ebPackageName;
            } else {
                ebTieDir = Generator.getTempDirectory().toString();
            }
            idx = homeName.lastIndexOf(fsc);
            if (idx != -1) {
                String homePackageName = homeName.substring(0, idx);
                homeStubDir = homeName.startsWith("com" + fs + "sun" + fs) ? String.valueOf(String.valueOf(Generator.getTempDirectory())) + fs + orgomgstub + fs + homePackageName : String.valueOf(String.valueOf(Generator.getTempDirectory())) + fs + homePackageName;
            } else {
                homeStubDir = Generator.getTempDirectory().toString();
            }
            String homeClassName = homeName;
            idx = homeName.lastIndexOf(fsc);
            if (idx != -1) {
                homeClassName = homeName.substring(idx + 1, homeName.length());
            }
            String homeStub = String.valueOf(homeStubDir) + fs + "_" + homeClassName + "_Stub.class";
            allGeneratedFiles.addElement(homeStub);
            allClientFiles.addElement(homeStub);
            String tieClassName = String.valueOf(ebTieDir) + fs + "_" + homeClassName + "Impl_Tie.class";
            allGeneratedFiles.addElement(tieClassName);
            String remoteInterfaceName = dd2.getRemoteClassName().replace('.', fsc);
            idx = remoteInterfaceName.lastIndexOf(fsc);
            if (idx != -1) {
                String remotePackageName = remoteInterfaceName.substring(0, idx);
                remoteStubDir = remoteInterfaceName.startsWith("com" + fs + "sun" + fs) ? String.valueOf(String.valueOf(Generator.getTempDirectory())) + fs + orgomgstub + fs + remotePackageName : String.valueOf(String.valueOf(Generator.getTempDirectory())) + fs + remotePackageName;
            } else {
                remoteStubDir = Generator.getTempDirectory().toString();
            }
            String remoteClassName = remoteInterfaceName;
            idx = remoteInterfaceName.lastIndexOf(fsc);
            if (idx != -1) {
                remoteClassName = remoteInterfaceName.substring(idx + 1, remoteInterfaceName.length());
            }
            String remoteStub = String.valueOf(remoteStubDir) + fs + "_" + remoteClassName + "_Stub.class";
            allGeneratedFiles.addElement(remoteStub);
            allClientFiles.addElement(remoteStub);
            String ebClassName = ebName;
            idx = ebClassName.lastIndexOf(fsc);
            if (idx != -1) {
                ebClassName = ebClassName.substring(idx + 1, ebClassName.length());
            }
            String ejbObjectTie = String.valueOf(ebTieDir) + fs + "_" + ebClassName + "_EJBObjectImpl_Tie.class";
            allGeneratedFiles.addElement(ejbObjectTie);
            ++ddIndex;
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public static void compileAll(File jarFile, Vector allGeneratedFiles) throws GeneratorException, IOException {
        sun.rmi.rmic.Main comp;
        Main compiler;
        Generator.progress(localStrings.getLocalString("generator.compiling_wrapper", "Compiling wrapper code."));
        Enumeration e10 = allGeneratedFiles.elements();
        int size = allGeneratedFiles.size();
        String[] javacArgs = new String[4 + size];
        int cnt = 0;
        javacArgs[cnt++] = "-d";
        javacArgs[cnt++] = Generator.getTempDirectory().toString();
        javacArgs[cnt++] = "-classpath";
        javacArgs[cnt++] = String.valueOf(System.getProperty("java.class.path")) + ps + jarFile + ps + Generator.getTempDirectory().toString();
        while (e10.hasMoreElements()) {
            String file = (String)e10.nextElement();
            javacArgs[cnt++] = file;
            System.out.println(localStrings.getLocalString("generator.compile", "Compiling {0} ...", new Object[]{file}));
        }
        try {
            compiler = new Main((OutputStream)System.err, "javac");
        }
        catch (Throwable t2) {
            System.err.println(t2);
            System.err.println(localStrings.getLocalString("generator.compile_failed", "Compilation failed..."));
            throw new GeneratorException("Could not invoke javac.");
        }
        if (!compiler.compile(javacArgs)) {
            System.err.println(localStrings.getLocalString("generator.compile_failed", "Compilation failed..."));
            throw new GeneratorException("Compilation failed.");
        }
        if (session.isCancelled()) {
            return;
        }
        Generator.progressEvent("Ejb Compilation complete", session);
        Generator.progress(localStrings.getLocalString("generator.compiling_rmi_iiop", "Compiling RMI-IIOP code."));
        int i2 = 0;
        while (i2 < allGeneratedFiles.size()) {
            String javaFile = (String)allGeneratedFiles.elementAt(i2);
            String classFile = String.valueOf(javaFile.substring(0, javaFile.indexOf(".java"))) + ".class";
            allGeneratedFiles.setElementAt(classFile, i2);
            ++i2;
        }
        Enumeration e12 = allGeneratedFiles.elements();
        String[] rmicArgs = new String[9 + allGeneratedFiles.size() * 2];
        int rmicCnt = 0;
        rmicArgs[rmicCnt++] = "-iiop";
        rmicArgs[rmicCnt++] = "-poa";
        rmicArgs[rmicCnt++] = "-alwaysgenerate";
        rmicArgs[rmicCnt++] = "-keepgenerated";
        rmicArgs[rmicCnt++] = "-nolocalstubs";
        rmicArgs[rmicCnt++] = "-classpath";
        rmicArgs[rmicCnt++] = String.valueOf(System.getProperty("java.class.path")) + ps + jarFile + ps + Generator.getTempDirectory();
        rmicArgs[rmicCnt++] = "-d";
        rmicArgs[rmicCnt++] = Generator.getTempDirectory().toString();
        String cname = "";
        while (e12.hasMoreElements()) {
            String file = (String)e12.nextElement();
            String className = Generator.getClassName(file);
            System.out.println("rmic " + className + "...");
            rmicArgs[rmicCnt++] = "-transactional";
            rmicArgs[rmicCnt++] = className;
            cname = String.valueOf(cname) + " " + className;
        }
        try {
            comp = new sun.rmi.rmic.Main(System.err, "rmic");
        }
        catch (Throwable t3) {
            t3.printStackTrace();
            System.err.println("Could not invoke rmic..");
            throw new GeneratorException("Could not invoke rmic");
        }
        if (!comp.compile(rmicArgs)) {
            System.err.println("rmic compilation failed...");
            throw new GeneratorException("rmic compilation failed.");
        }
        if (session.isCancelled()) {
            return;
        }
        Generator.progressEvent("Ejb Compilation complete", session);
    }

    public static String cookJar(String appName, File original, File dst, File clientDst, Vector allGeneratedFiles, Vector allClientFiles) throws IOException {
        int sz = allGeneratedFiles.size();
        int clientSz = allClientFiles.size();
        boolean index = false;
        boolean clientIndex = false;
        Vector<String> genFilesUnique = new Vector<String>();
        Vector<String> clientGenFilesUnique = new Vector<String>();
        int i2 = 0;
        while (i2 < allGeneratedFiles.size()) {
            String nextFileToAdd = (String)allGeneratedFiles.elementAt(i2);
            if (!genFilesUnique.contains(nextFileToAdd)) {
                genFilesUnique.addElement(nextFileToAdd);
            } else {
                System.out.println("duplicate " + nextFileToAdd);
            }
            ++i2;
        }
        int k2 = 0;
        while (k2 < allClientFiles.size()) {
            String nextFileToAdd = (String)allClientFiles.elementAt(k2);
            if (!clientGenFilesUnique.contains(nextFileToAdd)) {
                clientGenFilesUnique.addElement(nextFileToAdd);
            } else {
                System.out.println("duplicate " + nextFileToAdd);
            }
            ++k2;
        }
        Generator.progress(localStrings.getLocalString("generator.making_client_jars", "making client JARs"));
        Generator.progressEvent("Client JARs made", session);
        Generator.makeJar(appName, original, dst, genFilesUnique);
        Generator.progress(localStrings.getLocalString("generator.making_server_jars", "making server JARs"));
        Generator.makeJar(appName, original, clientDst, clientGenFilesUnique);
        Generator.progressEvent("Server JARs made", session);
        return dst.toString();
    }

    OutputStream createOutputStream(String className) throws IOException {
        String fileName = this.getFileName(className);
        File file = new File(fileName);
        if (file.getParent() != null) {
            new File(file.getParent()).mkdirs();
        }
        this.generatedFiles.addElement(fileName);
        return new FileOutputStream(fileName);
    }

    private static boolean ddHasUniqueInterfaces(Vector deploymentDescriptors, EjbDescriptor ddToCheck) {
        boolean hasUniqueInterfaces = true;
        int i2 = 0;
        while (i2 < deploymentDescriptors.size()) {
            EjbDescriptor currentDD = (EjbDescriptor)deploymentDescriptors.elementAt(i2);
            if (currentDD.getHomeClassName().equals(ddToCheck.getHomeClassName()) && currentDD.getRemoteClassName().equals(ddToCheck.getRemoteClassName())) {
                hasUniqueInterfaces = false;
                break;
            }
            ++i2;
        }
        return hasUniqueInterfaces;
    }

    public void generate(OutputStream out) throws GeneratorException, IOException {
    }

    public void generateAll(File jarFile, JarClassLoader cl2, EjbDescriptor dd2) throws GeneratorException, IOException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        Generator.progress(String.valueOf(localStrings.getLocalString("generator.gen_wrapper_code", "Generating wrapper code for ")) + dd2.getName());
        int i2 = 0;
        while (i2 < this.generators.size()) {
            Class c10 = (Class)this.generators.elementAt(i2);
            Class[] argTypes = new Class[]{class$java$lang$String != null ? class$java$lang$String : Generator.class$("java.lang.String"), class$com$sun$enterprise$deployment$EjbDescriptor != null ? class$com$sun$enterprise$deployment$EjbDescriptor : Generator.class$("com.sun.enterprise.deployment.EjbDescriptor"), class$com$sun$enterprise$util$JarClassLoader != null ? class$com$sun$enterprise$util$JarClassLoader : Generator.class$("com.sun.enterprise.util.JarClassLoader")};
            Constructor constructor = c10.getConstructor(argTypes);
            Object[] argObjects = new Object[]{Generator.getApplicationName(), dd2, cl2};
            Generator generator = null;
            try {
                generator = (Generator)constructor.newInstance(argObjects);
            }
            catch (InvocationTargetException exc) {
                exc.getTargetException().printStackTrace();
                throw exc;
            }
            OutputStream out = this.createOutputStream(generator.generatingClass());
            generator.generate(out);
            out.close();
            ++i2;
        }
    }

    public String generatingClass() {
        return null;
    }

    public static String getApplicationName() {
        return applicationName;
    }

    static String getBaseName(String className) {
        int dot = className.lastIndexOf(46);
        if (dot == -1) {
            return className;
        }
        return className.substring(dot + 1);
    }

    static String getClassName(String fileName) {
        String className = fileName;
        if (className.startsWith(Generator.getTempDirectory().toString())) {
            className = className.substring(Generator.getTempDirectory().toString().length());
        }
        if (className.indexOf(".java") != -1) {
            className = className.substring(0, className.indexOf(".java"));
        } else if (className.indexOf(".class") != -1) {
            className = className.substring(0, className.indexOf(".class"));
        }
        className = className.replace(fsc, '.');
        if (className.charAt(0) == '.') {
            className = className.substring(1);
        }
        return className;
    }

    private static Vector getDeploymentDescriptorsIn(File file, JarClassLoader jcl) throws Exception {
        Vector deploymentDescriptors = new Vector();
        System.out.println("Parse deployment descriptor as XML");
        Application application = ApplicationArchivist.open(file);
        Enumeration e10 = application.getEjbDescriptors().elements();
        while (e10.hasMoreElements()) {
            deploymentDescriptors.addElement(e10.nextElement());
        }
        return deploymentDescriptors;
    }

    String getFileName(String className) {
        return String.valueOf(String.valueOf(Generator.getTempDirectory())) + fs + className.replace('.', fsc) + ".java";
    }

    static String getPackageName(String className) {
        int dot = className.lastIndexOf(46);
        if (dot == -1) {
            return null;
        }
        return className.substring(0, dot);
    }

    private static File getTempDirectory() {
        return appTmpDir;
    }

    public static File getTempDirectory(String appName) {
        return new File(tmpDir, appName);
    }

    public static void main(String[] args) {
        ORBManager.init(args, null);
        int i2 = 0;
        while (i2 < args.length) {
            try {
                String cookedJar = args[i2].substring(0, args[i2].lastIndexOf(46));
                String clientJar = String.valueOf(cookedJar) + "Client.jar";
                cookedJar = String.valueOf(cookedJar) + "Cooked.jar";
                File file = new File(cookedJar);
                File clientFile = new File(clientJar);
                Generator.preDeploy("main", new File(args[i2]), file, clientFile, null);
            }
            catch (GeneratorException ex2) {
                System.out.println(ex2);
            }
            catch (ClassNotFoundException ex3) {
                System.err.println(ex3);
            }
            catch (IOException ex4) {
                System.err.println(ex4);
            }
            catch (Exception ex5) {
                ex5.printStackTrace();
            }
            ++i2;
        }
        System.exit(0);
    }

    public static void makeJar(String appName, File inputJarFile, File outputJarFile, Vector files) throws IOException {
        if (outputJarFile.exists()) {
            System.out.println("Warning: " + outputJarFile + " already exists.");
        }
        FileOutputStream fos = new FileOutputStream(outputJarFile);
        ZipOutputStream zos = new ZipOutputStream(fos);
        Archivist.addJarToOutput(zos, new JarFile(inputJarFile), new Vector());
        Enumeration e10 = files.elements();
        while (e10.hasMoreElements()) {
            String longName = (String)e10.nextElement();
            File file = new File(longName);
            String entryName = "";
            if (longName.startsWith(Generator.getTempDirectory(appName).toString())) {
                entryName = longName.substring(Generator.getTempDirectory(appName).toString().length());
                if (entryName.charAt(0) == fsc) {
                    entryName = entryName.substring(1);
                }
            } else {
                throw new RuntimeException("error");
            }
            entryName = entryName.replace(fsc, '/');
            FileInputStream fis = new FileInputStream(file);
            zos.putNextEntry(new ZipEntry(entryName));
            Archivist.copy(fis, zos);
            zos.closeEntry();
            fis.close();
        }
        zos.close();
        fos.close();
    }

    public static String preDeploy(String appName, File srcJar, File dstJar, File clientDstJar, DeploymentSession session) throws GeneratorException, ClassNotFoundException, IOException, Exception {
        Generator.setSession(session, appName);
        Vector deploymentDescriptors = null;
        final JarClassLoader jcl = new JarClassLoader();
        jcl.addJar(srcJar.toString());
        File gntrDir = Generator.getTempDirectory();
        gntrDir.mkdirs();
        jcl.addDir(Generator.getTempDirectory().toURL());
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Thread.currentThread().setContextClassLoader(jcl);
                return null;
            }
        });
        try {
            deploymentDescriptors = Generator.getDeploymentDescriptorsIn(srcJar, jcl);
        }
        catch (Throwable t2) {
            t2.printStackTrace();
            System.out.println("There was an error in opening the JAR file.");
        }
        Vector<EjbDescriptor> descriptorsWithUniqueInterfaces = new Vector<EjbDescriptor>();
        int i2 = 0;
        while (i2 < deploymentDescriptors.size()) {
            EjbDescriptor dd2 = (EjbDescriptor)deploymentDescriptors.elementAt(i2);
            if (Generator.ddHasUniqueInterfaces(descriptorsWithUniqueInterfaces, dd2)) {
                descriptorsWithUniqueInterfaces.add(dd2);
            }
            ++i2;
        }
        Generator[] generators = new Generator[descriptorsWithUniqueInterfaces.size()];
        Generator.progress(localStrings.getLocalString("generator.processing_beans", "Processing beans..."));
        Vector allGeneratedFiles = new Vector();
        int i3 = 0;
        while (i3 < descriptorsWithUniqueInterfaces.size()) {
            generators[i3] = new Generator();
            generators[i3].generateAll(srcJar, jcl, (EjbDescriptor)descriptorsWithUniqueInterfaces.elementAt(i3));
            int j2 = 0;
            while (j2 < generators[i3].generatedFiles.size()) {
                allGeneratedFiles.addElement(generators[i3].generatedFiles.elementAt(j2));
                ++j2;
            }
            if (session.isCancelled()) {
                return "";
            }
            ++i3;
        }
        Generator.progressEvent("Ejb Code Generation complete", session);
        Generator.compileAll(srcJar, allGeneratedFiles);
        if (session.isCancelled()) {
            return "";
        }
        Vector allClientFiles = new Vector();
        Generator.addGeneratedFiles(descriptorsWithUniqueInterfaces, allGeneratedFiles, allClientFiles);
        if (session.isCancelled()) {
            return "";
        }
        String s2 = Generator.cookJar(appName, srcJar, dstJar, clientDstJar, allGeneratedFiles, allClientFiles);
        Generator.setSession(null, "");
        return s2;
    }

    protected String printType(Class cls) {
        if (cls.isArray()) {
            return String.valueOf(this.printType(cls.getComponentType())) + "[]";
        }
        return cls.getName();
    }

    private static void progress(String message) {
        block2: {
            if (session == null) break block2;
            try {
                session.setStatusMessage(message);
            }
            catch (Throwable t2) {
                t2.printStackTrace();
            }
        }
    }

    private static void progressEvent(String eventType, DeploymentSession session) {
        block2: {
            if (session == null) break block2;
            try {
                session.notification(new NotificationEvent("", eventType, ""));
            }
            catch (Throwable t2) {
                t2.printStackTrace();
            }
        }
    }

    public static void setSession(DeploymentSession sessionObject, String appName) {
        session = sessionObject;
        applicationName = appName;
        appTmpDir = new File(tmpDir, applicationName);
        appTmpDir.mkdirs();
    }
}

