/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.packager;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationArchivist;
import com.sun.enterprise.deployment.ApplicationClientArchivist;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.ArchiveException;
import com.sun.enterprise.deployment.Archivist;
import com.sun.enterprise.deployment.EjbBundleArchivist;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.FileContentsDescriptor;
import com.sun.enterprise.deployment.WebBundleArchivist;
import com.sun.enterprise.deployment.xml.ApplicationClientRuntimeDescriptorNode;
import com.sun.enterprise.deployment.xml.ApplicationNode;
import com.sun.enterprise.deployment.xml.ContentTransformationException;
import com.sun.enterprise.deployment.xml.ParseException;
import com.sun.enterprise.deployment.xml.RuntimeDescriptorNode;
import com.sun.enterprise.tools.packager.ApplicationAssemblyDescriptor;
import com.sun.enterprise.util.FileUtil;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ComponentPackager {
    private static final boolean debug = false;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$packager$ComponentPackager != null ? class$com$sun$enterprise$tools$packager$ComponentPackager : (class$com$sun$enterprise$tools$packager$ComponentPackager = ComponentPackager.class$("com.sun.enterprise.tools.packager.ComponentPackager")));
    static /* synthetic */ Class class$com$sun$enterprise$tools$packager$ComponentPackager;

    public void assembleApplication(ApplicationAssemblyDescriptor assemblyDescriptor, String applicationName, String destinationFile) throws Exception {
        System.out.println("Assemble application " + assemblyDescriptor + " into " + destinationFile);
        Application a = new Application(applicationName, new File(destinationFile));
        a.getApplicationArchivist().save(a.getApplicationArchivist().getApplicationFile(), true);
        Iterator itr = assemblyDescriptor.getJarFilenames().iterator();
        while (itr.hasNext()) {
            Iterator mcs;
            String nextJarFilename = (String)itr.next();
            File nextJarFile = new File(nextJarFilename);
            String nextExternalDescriptorUri = assemblyDescriptor.getExternalDDFilenameFor(nextJarFilename);
            if (EjbBundleArchivist.isEjbBundle(nextJarFile)) {
                EjbBundleDescriptor bundleDescriptor = a.getApplicationArchivist().addEjbJar(nextJarFile, new HashSet(), nextExternalDescriptorUri);
                if (!assemblyDescriptor.getLibraryJarFilenames().isEmpty()) {
                    mcs = assemblyDescriptor.getLibraryJarFilenames().iterator();
                    while (mcs.hasNext()) {
                        bundleDescriptor.getArchivist().addManfiestClasspath(ApplicationAssemblyDescriptor.getLibraryJarEntryNameFrom((String)mcs.next()));
                    }
                }
            }
            if (WebBundleArchivist.isWebBundle(nextJarFile)) {
                a.getApplicationArchivist().addWebJar(nextJarFile, nextExternalDescriptorUri);
            }
            if (ApplicationClientArchivist.isApplicationClientJar(nextJarFile)) {
                ApplicationClientDescriptor clientDescriptor = a.getApplicationArchivist().addApplicationClientJar(nextJarFile, new HashSet(), nextExternalDescriptorUri);
                if (!assemblyDescriptor.getLibraryJarFilenames().isEmpty()) {
                    mcs = assemblyDescriptor.getLibraryJarFilenames().iterator();
                    while (mcs.hasNext()) {
                        clientDescriptor.getArchivist().addManfiestClasspath(ApplicationAssemblyDescriptor.getLibraryJarEntryNameFrom((String)mcs.next()));
                    }
                }
            }
            if (!ApplicationArchivist.isApplication(nextJarFile)) continue;
            a.getApplicationArchivist().addApplicationJar(nextJarFile);
        }
        if (!assemblyDescriptor.getLibraryJarFilenames().isEmpty()) {
            a.getApplicationArchivist().addFiles(assemblyDescriptor.getLibraryJarFilenameToEntryNameMap(), a.getApplicationArchivist().getApplicationFile());
        }
        a.getApplicationArchivist().save(a.getApplicationArchivist().getApplicationFile(), false);
        System.out.println("Creation of application in " + destinationFile + " is complete");
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public static String getEjbBundleFilename(String applicationFilename) {
        return String.valueOf(applicationFilename) + ".ejbBundle.xml";
    }

    public static String getRuntimeDescriptorFilename(String applicationFilename) {
        return String.valueOf(applicationFilename) + ".runtime.xml";
    }

    public void handlePackagingException(Exception exception) {
        System.out.println("Exception during packaging: ");
        if (exception instanceof ParseException) {
            ParseException pe = (ParseException)exception;
            if (pe.getSAXException() != null) {
                System.out.println("Error parsing XML: " + pe.getSAXException().getMessage());
            } else {
                System.out.println(pe.getMessage());
            }
        } else if (exception instanceof ContentTransformationException) {
            ContentTransformationException cte = (ContentTransformationException)exception;
            System.out.println("Error interpreting XML: " + cte.getMessage());
            System.out.println(cte.getXml());
        } else if (exception instanceof IOException) {
            System.out.println(exception.getMessage());
            exception.printStackTrace();
        } else {
            System.out.println("Unknown packaging error");
            exception.printStackTrace();
        }
    }

    public void packageApplicationClient(String baseDirectory, Vector filesToAdd, String mainClassName, String descriptorFilename, String destinationFilename) throws Exception {
        FileContentsDescriptor fcd = new FileContentsDescriptor();
        File directory = new File(baseDirectory);
        Enumeration e10 = filesToAdd.elements();
        while (e10.hasMoreElements()) {
            File nextFile = new File((String)e10.nextElement());
            fcd.add(nextFile, directory);
        }
        File descriptorFile = new File(descriptorFilename);
        File destinationFile = new File(destinationFilename);
        ApplicationClientArchivist.createPackage(fcd, mainClassName, descriptorFile, destinationFile);
    }

    public void packageEjbArchive(String baseDirectory, Vector filesToAdd, String descriptorFilename, String destinationFile) throws Exception {
        FileContentsDescriptor fcd = new FileContentsDescriptor(baseDirectory, filesToAdd);
        File descriptorFile = new File(descriptorFilename);
        EjbBundleArchivist.createPackage(fcd, descriptorFile, new File(destinationFile));
    }

    public void packageEjbs(String baseDirectory, Vector filesToAdd, String descriptorFilename, String jarFile, String optionalEjbBundleFilename, String optionalRuntimeFilename) throws Exception {
        String ejbDescriptorFilename = "";
        String runtimeDescriptorFilename = "";
        ejbDescriptorFilename = "".equals(optionalEjbBundleFilename) ? ComponentPackager.getEjbBundleFilename(descriptorFilename) : optionalEjbBundleFilename;
        runtimeDescriptorFilename = "".equals(optionalRuntimeFilename) ? ComponentPackager.getRuntimeDescriptorFilename(descriptorFilename) : optionalRuntimeFilename;
        System.out.println("Package the ejbs specified in " + ejbDescriptorFilename);
        System.out.println(" using the application descriptor in " + descriptorFilename);
        System.out.println(" and the runtime descriptor in " + runtimeDescriptorFilename);
        System.out.println("All files relative to " + baseDirectory);
        File applicationDescriptorFile = new File(baseDirectory, descriptorFilename);
        FileInputStream fis = new FileInputStream(applicationDescriptorFile);
        ApplicationNode applicationNode = ApplicationNode.read(fis);
        Application application = applicationNode.getApplication(null);
        String applicationName = application.getName();
        File ejbJarFile = new File("ejb-jar-" + System.currentTimeMillis() + new File(jarFile).getName());
        Vector<String> allFiles = new Vector<String>();
        Enumeration e10 = filesToAdd.elements();
        while (e10.hasMoreElements()) {
            String nextFile = (String)e10.nextElement();
            File nextRealFileOrDir = new File(baseDirectory, nextFile);
            if (nextRealFileOrDir.isDirectory()) {
                Iterator itr = FileUtil.getAllFilesUnder(nextRealFileOrDir, null).iterator();
                while (itr.hasNext()) {
                    File next = null;
                    next = nextFile.equals(".") ? (File)itr.next() : new File(nextFile, ((File)itr.next()).toString());
                    allFiles.addElement(next.toString());
                }
                continue;
            }
            allFiles.addElement(nextFile);
        }
        FileContentsDescriptor fcd = new FileContentsDescriptor(baseDirectory, allFiles);
        File descriptorFile = new File(baseDirectory, ejbDescriptorFilename);
        EjbBundleArchivist.createPackage(fcd, descriptorFile, ejbJarFile);
        ApplicationAssemblyDescriptor ejbJars = new ApplicationAssemblyDescriptor();
        ejbJars.addJarFilename(ejbJarFile.getAbsolutePath());
        this.assembleApplication(ejbJars, applicationName, jarFile);
        Application assembledApplication = ApplicationArchivist.open(new File(jarFile));
        fis = new FileInputStream(new File(baseDirectory, runtimeDescriptorFilename));
        RuntimeDescriptorNode rdn = RuntimeDescriptorNode.read(fis);
        rdn.updateRuntimeInformation(assembledApplication);
        ejbJarFile.delete();
        ApplicationArchivist appArchivist = assembledApplication.getApplicationArchivist();
        appArchivist.save(appArchivist.getApplicationFile(), true);
    }

    public void packageWebArchive(String servletClasspath, Vector classFiles, Vector libraryFiles, String contentRoot, Vector contentFiles, String descriptorFilename, String destinationFile) throws Exception {
        System.out.println("Package Web App with its servlets under " + servletClasspath + " content in " + contentRoot + " descriptor file " + descriptorFilename + " into " + destinationFile);
        WebBundleArchivist.createPackage(servletClasspath, classFiles, libraryFiles, contentRoot, contentFiles, descriptorFilename, destinationFile);
    }

    private String relativize(String base, String longer) {
        String nBase = base.replace('\\', File.separatorChar).replace('/', File.separatorChar);
        String nLonger = longer.replace('\\', File.separatorChar).replace('/', File.separatorChar);
        if (nLonger.startsWith(nBase)) {
            return nLonger.substring(nBase.length(), nLonger.length());
        }
        return nLonger;
    }

    public void replaceApplication(String applicationFilename, String applicationXmlFilename) throws IOException, ArchiveException {
        System.out.println("Warning: this is not an externally supported option");
        File scratchFile = new File("temp.ear");
        FileOutputStream fos = new FileOutputStream(scratchFile);
        ZipOutputStream outZipStream = new ZipOutputStream(fos);
        Vector<String> entriesNotToAdd = new Vector<String>();
        entriesNotToAdd.add("META-INF/application.xml");
        entriesNotToAdd.add("META-INF/MANIFEST.MF");
        Archivist.addJarToOutput(outZipStream, new JarFile(applicationFilename), entriesNotToAdd);
        FileInputStream fis = new FileInputStream(applicationXmlFilename);
        ZipEntry ze = new ZipEntry("META-INF/application.xml");
        outZipStream.putNextEntry(ze);
        Archivist.copy(fis, outZipStream);
        outZipStream.closeEntry();
        fis.close();
        outZipStream.close();
        scratchFile.renameTo(new File(applicationFilename));
        System.out.println("Replaced descriptor in " + applicationFilename + " with " + applicationXmlFilename);
    }

    public void setClientRuntimeDeploymentInfo(Application descriptor, File runtimeDeploymentInfo, String applicationClientName) throws Exception {
        FileInputStream fis = new FileInputStream(runtimeDeploymentInfo);
        ApplicationClientRuntimeDescriptorNode node = ApplicationClientRuntimeDescriptorNode.read(fis);
        ApplicationClientDescriptor acd = descriptor.getApplicationClientByName(applicationClientName);
        node.updateRuntimeInformation(acd);
        descriptor.getApplicationArchivist().save(descriptor.getApplicationArchivist().getApplicationFile(), true);
        System.out.println("Set runtime on client within application  done");
    }

    public void setClientRuntimeDeploymentInfo(ApplicationClientDescriptor descriptor, File runtimeDeploymentInfo) throws Exception {
        FileInputStream fis = new FileInputStream(runtimeDeploymentInfo);
        ApplicationClientRuntimeDescriptorNode node = ApplicationClientRuntimeDescriptorNode.read(fis);
        node.updateRuntimeInformation(descriptor);
        ((ApplicationClientArchivist)descriptor.getArchivist()).save(new File(descriptor.getArchivist().getArchiveUri()), true);
        System.out.println("Set runtime on client done");
    }

    public void setRuntimeDeploymentInfo(Application application, File runtimeDeploymentInfo) throws Exception {
        FileInputStream fis = new FileInputStream(runtimeDeploymentInfo);
        RuntimeDescriptorNode node = RuntimeDescriptorNode.read(fis);
        node.updateRuntimeInformation(application);
        application.getApplicationArchivist().save(application.getApplicationArchivist().getApplicationFile(), true);
        System.out.println("Set runtime done");
    }

    public String toString() {
        return "ComponentPackager";
    }
}

