/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationArchivist;
import com.sun.enterprise.deployment.ApplicationClientArchivist;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.ArchiveException;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleArchivist;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.WebBundleArchivist;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.xml.ApplicationClientNode;
import com.sun.enterprise.deployment.xml.ApplicationNode;
import com.sun.enterprise.deployment.xml.ContentTransformationException;
import com.sun.enterprise.deployment.xml.EjbBundleNode;
import com.sun.enterprise.deployment.xml.WebBundleNode;
import com.sun.enterprise.tools.verifier.JarCheckImpl;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.ResultsRecord;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.app.AppCheckMgrImpl;
import com.sun.enterprise.tools.verifier.appclient.AppClientCheckMgrImpl;
import com.sun.enterprise.tools.verifier.ejb.EjbCheckMgrImpl;
import com.sun.enterprise.tools.verifier.gui.MainFrame;
import com.sun.enterprise.tools.verifier.web.WebCheckMgrImpl;
import com.sun.enterprise.util.JarClassLoader;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.xml.parser.Resolver;
import com.sun.xml.parser.ValidatingParser;
import java.awt.Component;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Verifier {
    private Descriptor application = null;
    private static String APPLICATION_CLIENT = "APPLICATION CLIENT";
    private static String APPLICATION = "APPLICATION";
    private static String WEB = "WEB";
    private static String EJB = "EJB";
    private static String EJB_DTD = "ejb-jar_1_1.dtd";
    private static String WEB_DTD = "web-app_2_2.dtd";
    private static String APP_DTD = "application_1_2.dtd";
    private static String APP_CLIENT_DTD = "application-client_1_2.dtd";
    private static String jarFileName = null;
    private static String earFileName = null;
    private static boolean alreadyWrittenInvalidParseDetails = false;
    private static boolean fileNotFoundException = false;
    private JarCheckImpl jarCheckImpl;
    private static Hashtable htJar = new Hashtable();
    private static boolean debug = false;
    public static final String TMPFILENAME = "verifier-tmp";
    public static final int PASSED = 0;
    public static final int FAILED = 1;
    static String outputFileStr = "Results.txt";
    private static String FO_Str = "Failures only";
    private static String WFO_Str = "Warning and Failures only";
    private static String AO_Str = "All";
    private String currentExceptionMessage = null;
    private static boolean using_gui = false;
    private static boolean testing = false;
    public static final int FAIL = 0;
    public static final int WARN = 1;
    public static final int ALL = 2;
    private static int reportLevel = 1;
    private LocalStringManagerImpl smh;

    public Verifier() {
        try {
            StringManagerHelper.setLocalStringsManager(Class.forName(this.getClass().getName()));
            this.smh = StringManagerHelper.getLocalStringsManager();
        }
        catch (ClassNotFoundException e10) {
            this.setExceptionMessage(e10);
            e10.printStackTrace();
        }
    }

    public Verifier(boolean usingGui) {
        this();
        using_gui = usingGui;
    }

    public static void cleanTMPFiles() {
        int i2 = 0;
        File tmpFile = new File(TMPFILENAME + i2++ + ".jar");
        while (tmpFile.exists()) {
            tmpFile.delete();
            tmpFile = new File(TMPFILENAME + i2++ + ".jar");
        }
        i2 = 0;
        tmpFile = new File(TMPFILENAME + i2++ + ".war");
        while (tmpFile.exists()) {
            tmpFile.delete();
            tmpFile = new File(TMPFILENAME + i2++ + ".war");
        }
        i2 = 0;
        tmpFile = new File("verifier-tmp-AppClient" + i2++ + ".jar");
        while (tmpFile.exists()) {
            tmpFile.delete();
            tmpFile = new File("verifier-tmp-AppClient" + i2++ + ".jar");
        }
    }

    public static void debug(Exception e10) {
        if (debug) {
            e10.printStackTrace();
        }
    }

    public static void debug(String s2) {
        if (debug) {
            Verifier.error(s2);
        }
    }

    public static void debug(Throwable t2) {
        if (debug) {
            t2.printStackTrace();
        }
    }

    public void doit() throws ClassNotFoundException, IOException {
        Verifier.debug(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug.beginStaticVerification", "*******************************BEGIN \"Static Verification\""));
        if (this.loadJar(jarFileName) == null) {
            if (!Verifier.hasAlreadyWrittenInvalidParseDetails()) {
                this.writeInvalidParseDetails(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".ErrorLoading1", "Error loading: [ {0} ]", new Object[]{jarFileName}), this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".ErrorLoading2", "Unable to perform static testing, check XML file for validity."));
            }
            if (!using_gui) {
                System.exit(1);
            }
        }
        this.jarCheckImpl = new JarCheckImpl();
        boolean ret = this.jarCheckImpl.check(this.application);
        if (this.application instanceof Application) {
            Verifier.cleanTMPFiles();
        }
        Verifier.debug(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug.endStaticVerification", "*******************************END \"Static Verification\""));
        if (ret) {
            Verifier.log(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".AllTestsPassed", "{0}: There were no failed tests.", new Object[]{this.application.getName()}));
        } else {
            Verifier.log(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".SomeTestsFailed", "{0}: Some tests failed.", new Object[]{this.application.getName()}));
        }
        this.writeDetails();
        if (!using_gui && !ret) {
            System.exit(1);
        }
    }

    public static void error(String s2) {
        System.out.println(s2);
    }

    private String getAbsoluteFilenameURLForDTD(String dtdFilename) {
        try {
            File f2 = new File(System.getProperty("com.sun.enterprise.home"));
            f2 = new File(f2, "lib");
            f2 = new File(f2, "dtds");
            f2 = new File(f2, dtdFilename);
            return f2.toURL().toString();
        }
        catch (MalformedURLException err) {
            this.setExceptionMessage(err);
            this.writeInvalidParseDetails(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".MalformedURLException", "Error in attempting to convert file [ {0} ] into URL.", new Object[]{dtdFilename}), this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".ErrMessage", "Error:    {0}", new Object[]{err.getMessage()}));
            return null;
        }
    }

    public static File getAppClientJarFile(String appClientKeyString) {
        File f2 = (File)htJar.get(appClientKeyString);
        return f2;
    }

    public static boolean getDebug() {
        return debug;
    }

    public static String getEarFile() {
        return earFileName;
    }

    public String getExceptionMessage() {
        return this.currentExceptionMessage;
    }

    public static File getJarFile(String jarKeyString) {
        File f2 = (File)htJar.get(jarKeyString);
        return f2;
    }

    public static int getReportLevel() {
        return reportLevel;
    }

    static String getReportLevelString(int rl) {
        String rls = "";
        if (rl == 0) {
            rls = FO_Str;
        } else if (rl == 1) {
            rls = WFO_Str;
        } else if (rl == 2) {
            rls = AO_Str;
        }
        return rls;
    }

    public static File getWarFile(String warKeyString) {
        File f2 = (File)htJar.get(warKeyString);
        return f2;
    }

    public static boolean hasAlreadyWrittenInvalidParseDetails() {
        return alreadyWrittenInvalidParseDetails;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Descriptor loadAppClient(File file) {
        JarFile jarFile;
        block18: {
            Descriptor descriptor;
            block20: {
                Descriptor descriptor2;
                block19: {
                    boolean validXml = false;
                    jarFile = null;
                    try {
                        try {
                            jarFile = new JarFile(file);
                            Verifier.debug(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug.retrievingJar", "Retrieving {0} file for ValidatingParser", new Object[]{"META-INF/application-client.xml"}));
                            ZipEntry deploymentEntry = jarFile.getEntry("META-INF/application-client.xml");
                            if (deploymentEntry != null) {
                                InputStream is = jarFile.getInputStream(deploymentEntry);
                                InputSource source = new InputSource(is);
                                validXml = this.validate(source, "META-INF/application-client.xml");
                                is.close();
                                if (validXml) {
                                    if (this.application == null) {
                                        this.application = ApplicationClientArchivist.open(file);
                                        Verifier.setAppClientJarFile(file.getName(), file);
                                    }
                                    JarClassLoader jcl = JarClassLoader.getInstance();
                                    try {
                                        jcl.addJar(file.getAbsolutePath());
                                    }
                                    catch (IOException e10) {
                                        this.setExceptionMessage(e10);
                                        System.out.println(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".IOException.JarCannotBeAdded", "{0} can't be added.", new Object[]{jarFile.getName()}));
                                    }
                                    jarFile.close();
                                    break block18;
                                }
                                descriptor2 = null;
                                Object var6_15 = null;
                                break block19;
                            }
                            if (debug) {
                                System.out.println(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug.MissingXMLFile", "{0} is missing XML file: {1}", new Object[]{jarFile.getName(), "META-INF/application-client.xml"}));
                            }
                            this.writeInvalidParseDetails(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".InvalidParse.MissingXMLFile1", "Error: ** Error in {0}: ", new Object[]{"LoadAppClient"}), this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".InvalidParse.MissingXMLFile2", " {0} is missing XML file: {1}", new Object[]{jarFile.getName(), "META-INF/application-client.xml"}));
                            descriptor = null;
                            break block20;
                        }
                        catch (ZipException ex2) {
                            this.setExceptionMessage(ex2);
                            Verifier.debug(ex2);
                            Verifier.log(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".ZipException", "Error: ** Error in opening jar file:  {0}", new Object[]{file.getName()}));
                            this.writeInvalidParseDetails(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".ZipException", "Error: ** Error in opening jar file:  {0}", new Object[]{file.getName()}), this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".ErrMessage", "Error:    {0}", new Object[]{ex2.getMessage()}));
                            Descriptor descriptor3 = null;
                            Object var6_17 = null;
                            try {
                                jarFile.close();
                                return descriptor3;
                            }
                            catch (IOException iOException) {}
                            return descriptor3;
                        }
                        catch (Exception ex3) {
                            this.setExceptionMessage(ex3);
                            Verifier.debug(ex3);
                            Verifier.log(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".Exception", "Error: ** Error trying to process file:  {0}", new Object[]{file.getName()}));
                            this.writeInvalidParseDetails(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".Exception", "Error: ** Error trying to process file:  {0}", new Object[]{file.getName()}), this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".Exception.ErrMessage", "Check the {0} and {1} for matching content validity: {2}", new Object[]{file.getName(), "META-INF/application-client.xml", ex3.getMessage()}));
                            Descriptor descriptor4 = null;
                            Object var6_18 = null;
                            try {}
                            catch (IOException iOException) {}
                            jarFile.close();
                            return descriptor4;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var6_20 = null;
                        try {}
                        catch (IOException iOException) {}
                        jarFile.close();
                        throw throwable;
                        throw throwable;
                    }
                }
                try {}
                catch (IOException iOException) {}
                jarFile.close();
                return descriptor2;
            }
            Object var6_16 = null;
            try {}
            catch (IOException iOException) {}
            jarFile.close();
            return descriptor;
        }
        Object var6_19 = null;
        try {}
        catch (IOException iOException) {
            return this.application;
        }
        jarFile.close();
        return this.application;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Descriptor loadAppJar(File file) {
        JarFile jarFile;
        block32: {
            Descriptor descriptor;
            block31: {
                Descriptor descriptor2;
                block30: {
                    Descriptor descriptor3;
                    block29: {
                        Descriptor descriptor4;
                        block28: {
                            Descriptor descriptor5;
                            block27: {
                                boolean validXml = false;
                                jarFile = null;
                                try {
                                    try {
                                        block36: {
                                            block33: {
                                                block34: {
                                                    block35: {
                                                        File tmpFile;
                                                        jarFile = new JarFile(file);
                                                        Verifier.setEarFile(jarFile.getName());
                                                        ZipEntry deploymentEntry = jarFile.getEntry("META-INF/application.xml");
                                                        if (deploymentEntry == null) break block33;
                                                        InputStream is = jarFile.getInputStream(deploymentEntry);
                                                        InputSource source = new InputSource(is);
                                                        validXml = this.validate(source, "META-INF/application.xml");
                                                        is.close();
                                                        if (!validXml) break block34;
                                                        this.application = ApplicationArchivist.open(file);
                                                        Set ejbBundles = ((Application)this.application).getEjbBundleDescriptors();
                                                        Iterator ejbBundlesIterator = ejbBundles.iterator();
                                                        int i2 = 0;
                                                        boolean oneFailed = false;
                                                        Descriptor descriptor6 = null;
                                                        if (ejbBundlesIterator.hasNext()) {
                                                            do {
                                                                tmpFile = new File(TMPFILENAME + i2++ + ".jar");
                                                                EjbBundleDescriptor ejbBundle = (EjbBundleDescriptor)ejbBundlesIterator.next();
                                                                ((Application)this.application).getApplicationArchivist().extractBundleToFile(ejbBundle, tmpFile);
                                                                descriptor6 = this.loadEjbJar(tmpFile);
                                                                Verifier.setJarFile(((EjbBundleArchivist)ejbBundle.getArchivist()).getEjbJarFile().getName(), tmpFile);
                                                                if (descriptor6 != null) continue;
                                                                oneFailed = true;
                                                            } while (ejbBundlesIterator.hasNext() && descriptor6 != null);
                                                        }
                                                        if (oneFailed) break block35;
                                                        Set webBundles = ((Application)this.application).getWebBundleDescriptors();
                                                        Iterator webBundlesIterator = webBundles.iterator();
                                                        i2 = 0;
                                                        if (webBundlesIterator.hasNext()) {
                                                            do {
                                                                tmpFile = new File(TMPFILENAME + i2++ + ".war");
                                                                WebBundleDescriptor webBundle = (WebBundleDescriptor)webBundlesIterator.next();
                                                                ((Application)this.application).getApplicationArchivist().extractBundleToFile(webBundle, tmpFile);
                                                                descriptor6 = this.loadWebApp(tmpFile);
                                                                Verifier.setWarFile(((WebBundleArchivist)webBundle.getArchivist()).getWebJarFile().getName(), tmpFile);
                                                                if (descriptor6 != null) continue;
                                                                oneFailed = true;
                                                            } while (webBundlesIterator.hasNext() && descriptor6 != null);
                                                        }
                                                        if (!oneFailed) {
                                                            Set appClientBundles = ((Application)this.application).getApplicationClientDescriptors();
                                                            Iterator appClientBundlesIterator = appClientBundles.iterator();
                                                            i2 = 0;
                                                            if (appClientBundlesIterator.hasNext()) {
                                                                do {
                                                                    tmpFile = new File("verifier-tmp-AppClient" + i2++ + ".jar");
                                                                    ApplicationClientDescriptor appClient = (ApplicationClientDescriptor)appClientBundlesIterator.next();
                                                                    ((Application)this.application).getApplicationArchivist().extractBundleToFile(appClient, tmpFile);
                                                                    descriptor6 = this.loadAppClient(tmpFile);
                                                                    Verifier.setAppClientJarFile(((ApplicationClientArchivist)appClient.getArchivist()).getApplicationClientJarFile().getName(), tmpFile);
                                                                    if (descriptor6 != null) continue;
                                                                    oneFailed = true;
                                                                } while (appClientBundlesIterator.hasNext() && descriptor6 != null);
                                                            }
                                                            if (oneFailed) {
                                                                descriptor5 = null;
                                                                Object var6_29 = null;
                                                                break block27;
                                                            }
                                                            break block36;
                                                        } else {
                                                            descriptor4 = null;
                                                            break block28;
                                                        }
                                                    }
                                                    descriptor3 = null;
                                                    break block29;
                                                }
                                                descriptor2 = null;
                                                break block30;
                                            }
                                            if (debug) {
                                                System.out.println(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug.MissingXMLFile", "{0} is missing XML file: {1}", new Object[]{jarFile.getName(), "META-INF/application.xml"}));
                                            }
                                            this.writeInvalidParseDetails(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".InvalidParse.MissingXMLFile1", "Error: ** Error in {0}: ", new Object[]{"LoadAppJar"}), this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".InvalidParse.MissingXMLFile2", " {0} is missing XML file: {1}", new Object[]{jarFile.getName(), "META-INF/application.xml"}));
                                            descriptor = null;
                                            break block31;
                                        }
                                        jarFile.close();
                                        break block32;
                                    }
                                    catch (ZipException ex2) {
                                        this.setExceptionMessage(ex2);
                                        Verifier.debug(ex2);
                                        Verifier.log(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".ZipException", "Error: ** Error in opening jar file: {0}", new Object[]{file.getName()}));
                                        this.writeInvalidParseDetails(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".ZipException", "Error: ** Error in opening jar file: {0}", new Object[]{file.getName()}), this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".ErrMessage", "Error:    {0}", new Object[]{ex2.getMessage()}));
                                        Descriptor descriptor7 = null;
                                        Object var6_34 = null;
                                        try {
                                            jarFile.close();
                                            return descriptor7;
                                        }
                                        catch (IOException iOException) {}
                                        return descriptor7;
                                    }
                                    catch (ContentTransformationException e10) {
                                        this.setExceptionMessage(e10);
                                        Verifier.debug(e10);
                                        Verifier.log(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".ContentTransformationException", "Error: ** ContentTransformationException processing file: {0}", new Object[]{file.getName()}));
                                        Verifier.log(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".ErrMessage", "Error:    {0}", new Object[]{e10.getMessage()}));
                                        this.writeInvalidParseDetails(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".ContentTransformationException", "Error: ** ContentTransformationException processing file: {0}", new Object[]{file.getName()}), this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".ErrMessage", "Error:    {0}", new Object[]{e10.getMessage()}));
                                        Descriptor descriptor8 = null;
                                        Object var6_35 = null;
                                        try {}
                                        catch (IOException iOException) {}
                                        jarFile.close();
                                        return descriptor8;
                                    }
                                    catch (Exception ex3) {
                                        this.setExceptionMessage(ex3);
                                        Verifier.debug(ex3);
                                        Verifier.log(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".Exception", "Error: ** Error trying to process file:  {0}", new Object[]{file.getName()}));
                                        this.writeInvalidParseDetails(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".Exception", "Error: ** Error trying to process file:  {0}", new Object[]{file.getName()}), this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".Exception.ErrMessage", "Check the {0} and {1} for matching content validity: {2}", new Object[]{file.getName(), "META-INF/application.xml", ex3.getMessage()}));
                                        Descriptor descriptor9 = null;
                                        Object var6_36 = null;
                                        try {}
                                        catch (IOException iOException) {}
                                        jarFile.close();
                                        return descriptor9;
                                    }
                                }
                                catch (Throwable throwable) {
                                    Object var6_38 = null;
                                    try {}
                                    catch (IOException iOException) {}
                                    jarFile.close();
                                    throw throwable;
                                    throw throwable;
                                }
                            }
                            try {}
                            catch (IOException iOException) {}
                            jarFile.close();
                            return descriptor5;
                        }
                        Object var6_30 = null;
                        try {}
                        catch (IOException iOException) {}
                        jarFile.close();
                        return descriptor4;
                    }
                    Object var6_31 = null;
                    try {}
                    catch (IOException iOException) {}
                    jarFile.close();
                    return descriptor3;
                }
                Object var6_32 = null;
                try {}
                catch (IOException iOException) {}
                jarFile.close();
                return descriptor2;
            }
            Object var6_33 = null;
            try {}
            catch (IOException iOException) {}
            jarFile.close();
            return descriptor;
        }
        Object var6_37 = null;
        try {}
        catch (IOException iOException) {
            return this.application;
        }
        jarFile.close();
        return this.application;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Descriptor loadEjbJar(File file) {
        JarFile jarFile;
        block22: {
            Descriptor descriptor;
            block24: {
                Descriptor descriptor2;
                block23: {
                    boolean validXml = false;
                    jarFile = null;
                    try {
                        try {
                            jarFile = new JarFile(file);
                            Verifier.debug(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug.retrievingJar", "Retrieving {0} file for ValidatingParser", new Object[]{EjbBundleArchivist.DEPLOYMENT_DESCRIPTOR_ENTRY}));
                            ZipEntry deploymentEntry = jarFile.getEntry(EjbBundleArchivist.DEPLOYMENT_DESCRIPTOR_ENTRY);
                            if (deploymentEntry != null) {
                                InputStream is = jarFile.getInputStream(deploymentEntry);
                                InputSource source = new InputSource(is);
                                validXml = this.validate(source, EjbBundleArchivist.DEPLOYMENT_DESCRIPTOR_ENTRY);
                                is.close();
                                if (validXml) {
                                    if (this.application == null) {
                                        this.application = EjbBundleArchivist.open(file);
                                        Verifier.setJarFile(file.getName(), file);
                                    }
                                    JarClassLoader jcl = JarClassLoader.getInstance();
                                    try {
                                        jcl.addJar(file.getAbsolutePath());
                                    }
                                    catch (IOException e10) {
                                        this.setExceptionMessage(e10);
                                        System.out.println(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".IOException.JarCannotBeAdded", "{0} can't be added.", new Object[]{jarFile.getName()}));
                                    }
                                    jarFile.close();
                                    break block22;
                                }
                                descriptor2 = null;
                                Object var6_19 = null;
                                break block23;
                            }
                            if (debug) {
                                System.out.println(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug.MissingXMLFile", "{0} is missing XML file: {1}", new Object[]{jarFile.getName(), EjbBundleArchivist.DEPLOYMENT_DESCRIPTOR_ENTRY}));
                            }
                            this.writeInvalidParseDetails(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".InvalidParse.MissingXMLFile1", "Error: ** Error in {0}: ", new Object[]{"LoadEjbJar"}), this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".InvalidParse.MissingXMLFile2", " {0} is missing XML file: {1}", new Object[]{jarFile.getName(), EjbBundleArchivist.DEPLOYMENT_DESCRIPTOR_ENTRY}));
                            descriptor = null;
                            break block24;
                        }
                        catch (ZipException ex2) {
                            this.setExceptionMessage(ex2);
                            Verifier.debug(ex2);
                            Verifier.log(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".ZipException", "Error: ** Error in opening jar file:  {0}", new Object[]{file.getName()}));
                            Verifier.log(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".ErrMessage", "Error:    {0}", new Object[]{ex2.getMessage()}));
                            this.writeInvalidParseDetails(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".ZipException", "Error: ** Error in opening jar file:  {0}", new Object[]{file.getName()}), this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".ErrMessage", "Error:    {0}", new Object[]{ex2.getMessage()}));
                            Descriptor descriptor3 = null;
                            Object var6_21 = null;
                            try {
                                jarFile.close();
                                return descriptor3;
                            }
                            catch (IOException iOException) {}
                            return descriptor3;
                        }
                        catch (ContentTransformationException ex3) {
                            this.setExceptionMessage(ex3);
                            Verifier.debug(ex3);
                            Verifier.log(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".ContentTransformationException", "Error: ** ContentTransformationException processing file: {0}", new Object[]{file.getName()}));
                            Verifier.log(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".ErrMessage", "Error:    {0}", new Object[]{ex3.getMessage()}));
                            this.writeInvalidParseDetails(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".ContentTransformationException", "Error: ** ContentTransformationException processing file: {0}", new Object[]{file.getName()}), this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".ErrMessage", "Error:    {0}", new Object[]{ex3.getMessage()}));
                            Descriptor descriptor4 = null;
                            Object var6_22 = null;
                            try {}
                            catch (IOException iOException) {}
                            jarFile.close();
                            return descriptor4;
                        }
                        catch (IOException ex4) {
                            this.setExceptionMessage(ex4);
                            Verifier.debug(ex4);
                            Verifier.log(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".IOException", "Error: ** Error trying to process file:  {0}", new Object[]{file.getName()}));
                            Verifier.log(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".ErrMessage", "Error:    {0}", new Object[]{ex4.getMessage()}));
                            this.writeInvalidParseDetails(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".IOException", "Error: ** Error trying to process file:  {0}", new Object[]{file.getName()}), this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".ErrMessage", "Error:    {0}", new Object[]{ex4.getMessage()}));
                            Descriptor descriptor5 = null;
                            Object var6_23 = null;
                            try {}
                            catch (IOException iOException) {}
                            jarFile.close();
                            return descriptor5;
                        }
                        catch (ArchiveException ex5) {
                            this.setExceptionMessage(ex5);
                            Verifier.debug(ex5);
                            Verifier.log(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".ArchiveException", "Error: ** Error trying to process file:  {0}", new Object[]{file.getName()}));
                            Verifier.log(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".ArchiveException.ErrMessage", "Check the {0} and {1} for matching content validity: {2}", new Object[]{file.getName(), EjbBundleArchivist.DEPLOYMENT_DESCRIPTOR_ENTRY, ex5.getMessage()}));
                            this.writeInvalidParseDetails(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".ArchiveException", "Error: ** Error trying to process file:  {0}", new Object[]{file.getName()}), this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".ArchiveException.ErrMessage", "Check the {0} and {1} for matching content validity: {2}", new Object[]{file.getName(), EjbBundleArchivist.DEPLOYMENT_DESCRIPTOR_ENTRY, ex5.getMessage()}));
                            Descriptor descriptor6 = null;
                            Object var6_24 = null;
                            try {}
                            catch (IOException iOException) {}
                            jarFile.close();
                            return descriptor6;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var6_26 = null;
                        try {}
                        catch (IOException iOException) {}
                        jarFile.close();
                        throw throwable;
                        throw throwable;
                    }
                }
                try {}
                catch (IOException iOException) {}
                jarFile.close();
                return descriptor2;
            }
            Object var6_20 = null;
            try {}
            catch (IOException iOException) {}
            jarFile.close();
            return descriptor;
        }
        Object var6_25 = null;
        try {}
        catch (IOException iOException) {
            return this.application;
        }
        jarFile.close();
        return this.application;
    }

    public Descriptor loadJar(String jarName) {
        Verifier.debug(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug.startingLoadJar", "Starting loadJar() method......"));
        Descriptor.setBoundsChecking(false);
        try {
            File file = new File(jarName);
            if (ApplicationArchivist.isApplication(file)) {
                return this.loadAppJar(file);
            }
            if (EjbBundleArchivist.isEjbBundle(file)) {
                return this.loadEjbJar(file);
            }
            if (WebBundleArchivist.isWebBundle(file)) {
                return this.loadWebApp(file);
            }
            if (ApplicationClientArchivist.isApplicationClientJar(file)) {
                return this.loadAppClient(file);
            }
        }
        catch (IOException e10) {
            this.setExceptionMessage(e10);
            Verifier.debug(e10);
            Verifier.log(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".IOException", "Error: ** Error trying to process file: {0}", new Object[]{jarName}));
            this.writeInvalidParseDetails(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".IOException", "Error: ** Error trying to process file: {0}", new Object[]{jarName}), this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".ErrMessage", "Error:    {0}", new Object[]{e10.getMessage()}));
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Descriptor loadWebApp(File file) {
        JarFile jarFile;
        block18: {
            Descriptor descriptor;
            block17: {
                Descriptor descriptor2;
                block16: {
                    boolean validXml = false;
                    jarFile = null;
                    try {
                        try {
                            block20: {
                                block19: {
                                    jarFile = new JarFile(file);
                                    Verifier.debug(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug.retrievingJar", "Retrieving {0} file for ValidatingParser", new Object[]{WebBundleArchivist.DEPLOYMENT_DESCRIPTOR_ENTRY}));
                                    ZipEntry deploymentEntry = jarFile.getEntry(WebBundleArchivist.DEPLOYMENT_DESCRIPTOR_ENTRY);
                                    if (deploymentEntry == null) break block19;
                                    InputStream is = jarFile.getInputStream(deploymentEntry);
                                    InputSource source = new InputSource(is);
                                    validXml = this.validate(source, WebBundleArchivist.DEPLOYMENT_DESCRIPTOR_ENTRY);
                                    is.close();
                                    if (validXml) {
                                        if (this.application == null) {
                                            this.application = WebBundleArchivist.open(file);
                                            Verifier.setWarFile(file.getName(), file);
                                        }
                                        break block20;
                                    } else {
                                        descriptor2 = null;
                                        Object var6_13 = null;
                                        break block16;
                                    }
                                }
                                if (debug) {
                                    System.out.println(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug.MissingXMLFile", "{0} is missing XML file: {1}", new Object[]{jarFile.getName(), WebBundleArchivist.DEPLOYMENT_DESCRIPTOR_ENTRY}));
                                }
                                this.writeInvalidParseDetails(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".InvalidParse.MissingXMLFile1", "Error: ** Error in {0}: ", new Object[]{"LoadWebApp"}), this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".InvalidParse.MissingXMLFile2", " {0} is missing XML file: {1}", new Object[]{jarFile.getName(), WebBundleArchivist.DEPLOYMENT_DESCRIPTOR_ENTRY}));
                                descriptor = null;
                                break block17;
                            }
                            jarFile.close();
                            break block18;
                        }
                        catch (ZipException ex2) {
                            this.setExceptionMessage(ex2);
                            Verifier.debug(ex2);
                            Verifier.log(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".ZipException", "Error: ** Error in opening jar file:  {0}", new Object[]{file.getName()}));
                            this.writeInvalidParseDetails(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".ZipException", "Error: ** Error in opening jar file:  {0}", new Object[]{file.getName()}), this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".ErrMessage", "Error:    {0}", new Object[]{ex2.getMessage()}));
                            Descriptor descriptor3 = null;
                            Object var6_15 = null;
                            try {
                                jarFile.close();
                                return descriptor3;
                            }
                            catch (IOException iOException) {}
                            return descriptor3;
                        }
                        catch (Exception ex3) {
                            this.setExceptionMessage(ex3);
                            Verifier.debug(ex3);
                            Verifier.log(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".Exception", "Error: ** Error trying to process file:  {0}", new Object[]{file.getName()}));
                            this.writeInvalidParseDetails(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".Exception", "Error: ** Error trying to process file:  {0}", new Object[]{file.getName()}), this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".Exception.ErrMessage", "Check the {0} and {1} for matching content validity: {2}", new Object[]{file.getName(), WebBundleArchivist.DEPLOYMENT_DESCRIPTOR_ENTRY, ex3.getMessage()}));
                            Descriptor descriptor4 = null;
                            Object var6_16 = null;
                            try {}
                            catch (IOException iOException) {}
                            jarFile.close();
                            return descriptor4;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var6_18 = null;
                        try {}
                        catch (IOException iOException) {}
                        jarFile.close();
                        throw throwable;
                        throw throwable;
                    }
                }
                try {}
                catch (IOException iOException) {}
                jarFile.close();
                return descriptor2;
            }
            Object var6_14 = null;
            try {}
            catch (IOException iOException) {}
            jarFile.close();
            return descriptor;
        }
        Object var6_17 = null;
        try {}
        catch (IOException iOException) {
            return this.application;
        }
        jarFile.close();
        return this.application;
    }

    public static void log(String s2) {
        System.out.println(s2);
    }

    public static void main(String[] args) throws ClassNotFoundException, IOException {
        Verifier v2 = new Verifier();
        v2.parseArgs(args);
        if (!using_gui) {
            v2.doit();
            System.exit(0);
        }
    }

    void parseArgs(String[] args) {
        boolean setWarningLevelOnce = false;
        if (args.length < 1) {
            this.usage();
        } else {
            int i2 = 0;
            while (i2 < args.length) {
                String arg = args[i2];
                Verifier.debug(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug.argIs", "arg {0} is: {1}", new Object[]{new Integer(i2), arg}));
                if (arg.startsWith("-")) {
                    try {
                        switch (arg.charAt(1)) {
                            case 'v': {
                                debug = true;
                                Verifier.debug(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug.verboseFlag", "Setting verbose flag to TRUE."));
                                break;
                            }
                            case 'h': {
                                Verifier.debug(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug.helpMessage", "Displaying help message."));
                                this.usage();
                                break;
                            }
                            case 'o': {
                                Verifier.debug(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug.outputFilename", "Retrieving results output filename."));
                                char[] vhstr = new char[arg.length() - 2];
                                arg.getChars(2, arg.length(), vhstr, 0);
                                outputFileStr = new String(vhstr);
                                Verifier.debug("Using this output file = " + outputFileStr);
                                break;
                            }
                            case 'w': {
                                if (!setWarningLevelOnce) {
                                    Verifier.debug(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug.displayWarningFailures", "Setting output report level to display only warning and failure results."));
                                    Verifier.setReportLevel(1);
                                    setWarningLevelOnce = true;
                                    break;
                                }
                                Verifier.debug(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug.reportLevel", "Already set output display report level to [ {0} ] ", new Object[]{Verifier.getReportLevelString(Verifier.getReportLevel())}));
                                break;
                            }
                            case 'f': {
                                if (!setWarningLevelOnce) {
                                    Verifier.debug(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug.displayFailures", "Setting output report level to display only failure results."));
                                    Verifier.setReportLevel(0);
                                    setWarningLevelOnce = true;
                                    break;
                                }
                                Verifier.debug(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug.reportLevel", "Already set output display report level to [ {0} ] ", new Object[]{Verifier.getReportLevelString(Verifier.getReportLevel())}));
                                break;
                            }
                            case 'a': {
                                if (!setWarningLevelOnce) {
                                    Verifier.debug(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug.displayAll", "Setting output report level to display all results."));
                                    Verifier.setReportLevel(2);
                                    setWarningLevelOnce = true;
                                    break;
                                }
                                Verifier.debug(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug.reportLevel", "Already set output display report level to [ {0} ] ", new Object[]{Verifier.getReportLevelString(Verifier.getReportLevel())}));
                                break;
                            }
                            case 'u': {
                                Verifier.debug(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug.startGUI", "Starting Verifier GUI."));
                                using_gui = true;
                                break;
                            }
                            case 't': {
                                testing = true;
                                Verifier.debug(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug.testingMode", "Testing mode is on."));
                                break;
                            }
                            default: {
                                Verifier.log(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".log.unknownArg", "unknown option \"{0}\"", new Object[]{arg}));
                                this.usage();
                                break;
                            }
                        }
                    }
                    catch (StringIndexOutOfBoundsException e10) {
                        this.setExceptionMessage(e10);
                        Verifier.debug(e10);
                        this.usage();
                    }
                } else if (jarFileName == null) {
                    jarFileName = new File(arg).getAbsolutePath();
                    Verifier.debug(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug.jarFileName", "Jar filename: {0}", new Object[]{jarFileName}));
                } else {
                    Verifier.debug(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug.invalidArg", "invalid argument \"{0}\"", new Object[]{arg}));
                    this.usage();
                    return;
                }
                ++i2;
            }
            if (jarFileName == null && !using_gui) {
                this.usage();
            }
            if (using_gui) {
                MainFrame mf = new MainFrame(jarFileName, true);
                ((Component)mf).setSize(800, 600);
                ((Component)mf).setVisible(true);
            }
            Verifier.debug(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug.endParseArgs", "*******************************END \"Parse Args\""));
        }
    }

    public void printAllFailedTestResults(Vector allEjbResults, BufferedWriter buf_writer, String whoAmI) throws IOException {
        boolean someFailed = false;
        buf_writer.write("                  -------------------------------");
        buf_writer.newLine();
        buf_writer.write(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".bufWriter.failedTestTitle", "                    FAILED TEST - {0}", new Object[]{whoAmI}));
        buf_writer.newLine();
        buf_writer.write("                  -------------------------------");
        buf_writer.newLine();
        int a = 0;
        while (a < allEjbResults.size()) {
            ResultsRecord ejbTestResults = (ResultsRecord)allEjbResults.elementAt(a);
            Hashtable failedEJBResults = ejbTestResults.getFailedResults();
            Enumeration results = failedEJBResults.elements();
            while (results.hasMoreElements()) {
                Result rez;
                if (!someFailed) {
                    someFailed = true;
                }
                if ((rez = (Result)results.nextElement()) == null) continue;
                buf_writer.write("***********************************************************");
                buf_writer.newLine();
                buf_writer.write(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".bufWriter.testName", "Test Name: "));
                buf_writer.write(rez.getTestName());
                buf_writer.newLine();
                buf_writer.write(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".bufWriter.testAssertion", "Test Assertion: "));
                buf_writer.write(rez.getAssertion());
                buf_writer.newLine();
                buf_writer.write(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".bufWriter.testDetailedMessages", "Detailed Messages:"));
                buf_writer.write("\n");
                Enumeration ven = rez.getErrorDetails().elements();
                while (ven.hasMoreElements()) {
                    String string = (String)ven.nextElement();
                    if (testing) {
                        buf_writer.write("[-->" + rez.getTestName() + "<--] ");
                    } else {
                        buf_writer.write("   ");
                    }
                    buf_writer.write(string);
                    buf_writer.newLine();
                }
                buf_writer.write("***********************************************************");
                buf_writer.newLine();
                buf_writer.newLine();
            }
            ++a;
        }
        if (!someFailed) {
            buf_writer.newLine();
            buf_writer.write(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".bufWriter.noFailedTest", " There are no {0} failed tests.", new Object[]{whoAmI}));
            buf_writer.newLine();
            buf_writer.newLine();
            buf_writer.newLine();
        }
    }

    public void printAllNaTestResults(Vector allEjbResults, BufferedWriter buf_writer, String whoAmI) throws IOException {
        boolean someNA = false;
        buf_writer.newLine();
        buf_writer.newLine();
        buf_writer.write("                  -----------------------------------");
        buf_writer.newLine();
        buf_writer.write(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".bufWriter.notApplicableTestTitle", "                    NOT APPLICABLE TEST - {0}", new Object[]{whoAmI}));
        buf_writer.newLine();
        buf_writer.write("                  -----------------------------------");
        buf_writer.newLine();
        int a = 0;
        while (a < allEjbResults.size()) {
            ResultsRecord ejbTestResults = (ResultsRecord)allEjbResults.elementAt(a);
            Hashtable naEJBResults = ejbTestResults.getNaResults();
            Enumeration results = naEJBResults.elements();
            while (results.hasMoreElements()) {
                Result rez;
                if (!someNA) {
                    someNA = true;
                }
                if ((rez = (Result)results.nextElement()) == null) continue;
                buf_writer.write("***********************************************************");
                buf_writer.newLine();
                buf_writer.write(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".bufWriter.testName", "Test Name: "));
                buf_writer.write(rez.getTestName());
                buf_writer.newLine();
                buf_writer.write(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".bufWriter.testAssertion", "Test Assertion: "));
                buf_writer.write(rez.getAssertion());
                buf_writer.newLine();
                buf_writer.write(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".bufWriter.testDetailedMessages", "Detailed Messages:"));
                buf_writer.write("\n");
                Enumeration ven = rez.getNaDetails().elements();
                while (ven.hasMoreElements()) {
                    String string = (String)ven.nextElement();
                    if (testing) {
                        buf_writer.write("[-->" + rez.getTestName() + "<--] ");
                    } else {
                        buf_writer.write("   ");
                    }
                    buf_writer.write(string);
                    buf_writer.newLine();
                }
                buf_writer.write("***********************************************************");
                buf_writer.newLine();
                buf_writer.newLine();
            }
            ++a;
        }
        if (!someNA) {
            buf_writer.newLine();
            buf_writer.write(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".bufWriter.noNotApplicableTest", " There are no {0} tests with status of not applicable.", new Object[]{whoAmI}));
            buf_writer.newLine();
            buf_writer.newLine();
            buf_writer.newLine();
        }
    }

    public void printAllPassedTestResults(Vector allEjbResults, BufferedWriter buf_writer, String whoAmI) throws IOException {
        boolean somePassed = false;
        buf_writer.newLine();
        buf_writer.newLine();
        buf_writer.write("                  -------------------------------");
        buf_writer.newLine();
        buf_writer.write(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".bufWriter.passedTestTitle", "                    PASSED TEST - {0}", new Object[]{whoAmI}));
        buf_writer.newLine();
        buf_writer.write("                  -------------------------------");
        buf_writer.newLine();
        int a = 0;
        while (a < allEjbResults.size()) {
            ResultsRecord ejbTestResults = (ResultsRecord)allEjbResults.elementAt(a);
            Hashtable passedEJBResults = ejbTestResults.getPassedResults();
            Enumeration results = passedEJBResults.elements();
            while (results.hasMoreElements()) {
                Result rez;
                if (!somePassed) {
                    somePassed = true;
                }
                if ((rez = (Result)results.nextElement()) == null) continue;
                buf_writer.write("***********************************************************");
                buf_writer.newLine();
                buf_writer.write(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".bufWriter.testName", "Test Name: "));
                buf_writer.write(rez.getTestName());
                buf_writer.newLine();
                buf_writer.write(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".bufWriter.testAssertion", "Test Assertion: "));
                buf_writer.write(rez.getAssertion());
                buf_writer.newLine();
                buf_writer.write(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".bufWriter.testDetailedMessages", "Detailed Messages:"));
                buf_writer.write("\n");
                Enumeration ven = rez.getGoodDetails().elements();
                while (ven.hasMoreElements()) {
                    String string = (String)ven.nextElement();
                    if (testing) {
                        buf_writer.write("[-->" + rez.getTestName() + "<--] ");
                    } else {
                        buf_writer.write("   ");
                    }
                    buf_writer.write(string);
                    buf_writer.newLine();
                }
                buf_writer.write("***********************************************************");
                buf_writer.newLine();
                buf_writer.newLine();
            }
            ++a;
        }
        if (!somePassed) {
            buf_writer.newLine();
            buf_writer.write(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".bufWriter.noPassedTest", " There are no {0} passed tests.", new Object[]{whoAmI}));
            buf_writer.newLine();
            buf_writer.newLine();
            buf_writer.newLine();
        }
    }

    public void printAllWarningTestResults(Vector allEjbResults, BufferedWriter buf_writer, String whoAmI) throws IOException {
        boolean someWarning = false;
        buf_writer.write("                  -------------------------------");
        buf_writer.newLine();
        buf_writer.write(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".bufWriter.warningTestTitle", "                    WARNING TEST - {0}", new Object[]{whoAmI}));
        buf_writer.newLine();
        buf_writer.write("                  -------------------------------");
        buf_writer.newLine();
        int a = 0;
        while (a < allEjbResults.size()) {
            ResultsRecord ejbTestResults = (ResultsRecord)allEjbResults.elementAt(a);
            Hashtable warningEJBResults = ejbTestResults.getWarningResults();
            Enumeration results = warningEJBResults.elements();
            while (results.hasMoreElements()) {
                Result rez;
                if (!someWarning) {
                    someWarning = true;
                }
                if ((rez = (Result)results.nextElement()) == null) continue;
                buf_writer.write("***********************************************************");
                buf_writer.newLine();
                buf_writer.write(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".bufWriter.testName", "Test Name: "));
                buf_writer.write(rez.getTestName());
                buf_writer.newLine();
                buf_writer.write(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".bufWriter.testAssertion", "Test Assertion: "));
                buf_writer.write(rez.getAssertion());
                buf_writer.newLine();
                buf_writer.write(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".bufWriter.testDetailedMessages", "Detailed Messages:"));
                buf_writer.write("\n");
                Enumeration ven = rez.getWarningDetails().elements();
                while (ven.hasMoreElements()) {
                    String string = (String)ven.nextElement();
                    if (testing) {
                        buf_writer.write("[-->" + rez.getTestName() + "<--] ");
                    } else {
                        buf_writer.write("   ");
                    }
                    buf_writer.write(string);
                    buf_writer.newLine();
                }
                buf_writer.write("***********************************************************");
                buf_writer.newLine();
                buf_writer.newLine();
            }
            ++a;
        }
        if (!someWarning) {
            buf_writer.newLine();
            buf_writer.write(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".bufWriter.noWarningTest", " There are no {0} tests with status of warning.", new Object[]{whoAmI}));
            buf_writer.newLine();
            buf_writer.newLine();
            buf_writer.newLine();
        }
    }

    static void setAppClientJarFile(String key, File name) {
        htJar.put(key, name);
    }

    public void setDebug(boolean b10) {
        debug = b10;
    }

    static void setEarFile(String name) {
        earFileName = name;
    }

    void setExceptionMessage(Exception e10) {
        this.currentExceptionMessage = e10.getMessage();
    }

    static void setJarFile(String key, File name) {
        htJar.put(key, name);
    }

    public static void setReportLevel(int rl) {
        reportLevel = rl;
    }

    static void setWarFile(String key, File name) {
        htJar.put(key, name);
    }

    static void setWriteInvalidParseDetails(boolean alreadyWritten) {
        alreadyWrittenInvalidParseDetails = alreadyWritten;
    }

    public void usage() {
        System.err.println("\n" + this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".usageLine1", "usage: verifier [optional_params] <jarFile>") + "\n\n" + this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".usageLine2", "where :") + "\n\n" + this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".usageLine3", "  [optional_params]: Must be: ") + "\n\n" + this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".usageLine4", "     -v : verbose debug turned on ") + "\n\n" + this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".usageLine5", "    -o<output file> : test results written to this file") + "\n" + this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".usageLine6", "                      (Overrides default file - Results.txt)") + "\n\n" + this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".usageLine7", "    -u : use Verifier GUI") + "\n" + this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".usageLine8", "          (Note: Overrides default behavior, ") + "\n" + this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".usageLine9", "                 required jarFile not needed)") + "\n\n" + this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".usageLine10", "    -<Report Level> : where report level is defined by one of: ") + "\n" + this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".usageLine11", "       -a : set output report level to display all results") + "\n" + this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".usageLine12", "       -w : set output report level to display only warning and") + "\n" + this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".usageLine13", "            failure results") + "\n" + this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".usageLine14", "       -f : set output report level to display only failure") + "\n" + this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".usageLine15", "            results") + "\n" + this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".usageLine16", "    Note: default is set to display only warnings and failures") + "\n\n" + this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".usageLine17", "<jarFile>: Jar file to perform static verification on ") + "\n\n" + this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".usageLine18", "Below is an example which runs verifier in verbose mode") + "\n" + this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".usageLine19", "and writes all the results of static verification of ") + "\n" + this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".usageLine20", "file ejb.jar to output file MyResults.out") + "\n\n" + this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".usageLine21", " verifier -v -a -oMyResults.out ejb.jar") + "\n\n");
        if (!using_gui) {
            System.exit(0);
        }
    }

    public boolean validate(InputSource source, String xmlFile) {
        ValidatingParser p2 = new ValidatingParser(true);
        Resolver resolver = new Resolver();
        resolver.registerCatalogEntry(ApplicationNode.PUBLIC_DTD_ID, this.getAbsoluteFilenameURLForDTD(APP_DTD));
        resolver.registerCatalogEntry(ApplicationClientNode.PUBLIC_DTD_ID, this.getAbsoluteFilenameURLForDTD(APP_CLIENT_DTD));
        resolver.registerCatalogEntry(EjbBundleNode.PUBLIC_DTD_ID, this.getAbsoluteFilenameURLForDTD(EJB_DTD));
        resolver.registerCatalogEntry(WebBundleNode.PUBLIC_DTD_ID, this.getAbsoluteFilenameURLForDTD(WEB_DTD));
        try {
            Verifier.debug(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug.validateParse", "About to ValidateParse {0} file.", new Object[]{xmlFile}));
            p2.setEntityResolver(resolver);
            p2.parse(source);
            Verifier.debug(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug.xmlIsValid", "{0} file is Valid.", new Object[]{xmlFile}));
            return true;
        }
        catch (SAXParseException err) {
            this.setExceptionMessage(err);
            this.writeInvalidParseDetails(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".SAXParseException", "Error in file [ {0} ] ** Parsing error, line {1}, uri {2}", new Object[]{xmlFile, new Integer(err.getLineNumber()), err.getSystemId()}), this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".ErrMessage", "Error:    {0}", new Object[]{err.getMessage()}));
            return false;
        }
        catch (SAXException e10) {
            this.setExceptionMessage(e10);
            Exception x2 = e10;
            if (e10.getException() != null) {
                x2 = e10.getException();
            }
            this.writeInvalidParseDetails(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".SAXException", "Error in file [ {0} ] ** Parsing error, SAXException.", new Object[]{xmlFile}), this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".ErrMessage", "Error:    {0}", new Object[]{x2.getMessage()}));
            return false;
        }
        catch (Throwable t2) {
            this.writeInvalidParseDetails(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".Throwable", "Error in file [ {0} ] ** Parsing error, Throwable.", new Object[]{xmlFile}), this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".ErrMessage", "Error:    {0}", new Object[]{t2.getMessage()}));
            return false;
        }
    }

    public boolean writeDetails() {
        File outputFile = null;
        FileWriter out = null;
        BufferedWriter buf_writer = null;
        outputFile = new File(outputFileStr);
        Vector allEjbResults = EjbCheckMgrImpl.getAllEJBResults();
        Vector allWebResults = WebCheckMgrImpl.getAllWebResults();
        Vector allAppClientResults = AppClientCheckMgrImpl.getAllAppClientResults();
        Vector allAppResults = AppCheckMgrImpl.getAllAppResults();
        try {
            out = new FileWriter(outputFile);
            buf_writer = new BufferedWriter(out);
            if (Verifier.getReportLevel() == 1) {
                this.printAllFailedTestResults(allAppResults, buf_writer, APPLICATION);
                this.printAllFailedTestResults(allEjbResults, buf_writer, EJB);
                this.printAllFailedTestResults(allWebResults, buf_writer, WEB);
                this.printAllFailedTestResults(allAppClientResults, buf_writer, APPLICATION_CLIENT);
                this.printAllWarningTestResults(allAppResults, buf_writer, APPLICATION);
                this.printAllWarningTestResults(allEjbResults, buf_writer, EJB);
                this.printAllWarningTestResults(allWebResults, buf_writer, WEB);
                this.printAllWarningTestResults(allAppClientResults, buf_writer, APPLICATION_CLIENT);
            } else if (Verifier.getReportLevel() == 0) {
                this.printAllFailedTestResults(allAppResults, buf_writer, APPLICATION);
                this.printAllFailedTestResults(allEjbResults, buf_writer, EJB);
                this.printAllFailedTestResults(allWebResults, buf_writer, WEB);
                this.printAllFailedTestResults(allAppClientResults, buf_writer, APPLICATION_CLIENT);
            } else if (Verifier.getReportLevel() == 2) {
                this.printAllFailedTestResults(allAppResults, buf_writer, APPLICATION);
                this.printAllFailedTestResults(allEjbResults, buf_writer, EJB);
                this.printAllFailedTestResults(allWebResults, buf_writer, WEB);
                this.printAllFailedTestResults(allAppClientResults, buf_writer, APPLICATION_CLIENT);
                this.printAllWarningTestResults(allAppResults, buf_writer, APPLICATION);
                this.printAllWarningTestResults(allEjbResults, buf_writer, EJB);
                this.printAllWarningTestResults(allWebResults, buf_writer, WEB);
                this.printAllWarningTestResults(allAppClientResults, buf_writer, APPLICATION_CLIENT);
                this.printAllPassedTestResults(allAppResults, buf_writer, APPLICATION);
                this.printAllPassedTestResults(allEjbResults, buf_writer, EJB);
                this.printAllPassedTestResults(allWebResults, buf_writer, WEB);
                this.printAllPassedTestResults(allAppClientResults, buf_writer, APPLICATION_CLIENT);
                this.printAllNaTestResults(allAppResults, buf_writer, APPLICATION);
                this.printAllNaTestResults(allEjbResults, buf_writer, EJB);
                this.printAllNaTestResults(allWebResults, buf_writer, WEB);
                this.printAllNaTestResults(allAppClientResults, buf_writer, APPLICATION_CLIENT);
            }
            buf_writer.close();
            out.close();
        }
        catch (FileNotFoundException e10) {
            this.setExceptionMessage(e10);
            Verifier.debug(e10);
            this.writeInvalidParseDetails(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".FileNotFoundException", "Cannot find output file, no such file or directory: {0} - {1}", new Object[]{outputFile.toString(), e10.getMessage()}), this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".FileNotFoundException.ErrMessage", "Unable to complete writing of output file:  {0}", new Object[]{outputFile.toString()}));
            Verifier.log(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".FileNotFoundException", "Cannot find output file, no such file or directory: {0} - {1}", new Object[]{outputFile.toString(), e10.getMessage()}));
            Verifier.log(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".FileNotFoundException.ErrMessage", "Unable to complete writing of output file:  {0}", new Object[]{outputFile.toString()}));
            fileNotFoundException = true;
            return false;
        }
        catch (IOException e11) {
            this.setExceptionMessage(e11);
            Verifier.debug(e11);
            this.writeInvalidParseDetails(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".WriteDetails.IOException", "IO exception trying to access output file: {0}", new Object[]{outputFile.toString()}), this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".WriteDetails.IOException.ErrMessage", "Unable to complete writing of output file:  {0}", new Object[]{outputFile.toString()}));
            Verifier.log(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".WriteDetails.IOException", "IO exception trying to access output file: {0}", new Object[]{outputFile.toString()}));
            Verifier.log(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".WriteDetails.IOException.ErrMessage", "Unable to complete writing of output file:  {0}", new Object[]{outputFile.toString()}));
            return false;
        }
        catch (Exception e12) {
            this.setExceptionMessage(e12);
            Verifier.debug(e12);
            this.writeInvalidParseDetails(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".WriteDetails.Exception", "{0} trying to access output file: {1}", new Object[]{e12.getMessage(), outputFile.toString()}), this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".WriteDetails.Exception.ErrMessage", "Unable to complete writing of output file:  {0}", new Object[]{outputFile.toString()}));
            Verifier.log(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".WriteDetails.Exception", "{0} trying to access output file: {1}", new Object[]{e12.getMessage(), outputFile.toString()}));
            Verifier.log(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".WriteDetails.Exception.ErrMessage", "Unable to complete writing of output file:  {0}", new Object[]{outputFile.toString()}));
            return false;
        }
        if (!Verifier.hasAlreadyWrittenInvalidParseDetails()) {
            Verifier.log(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".LookInResults", "Look in file \"{0}\" for detailed results on {1}", new Object[]{outputFile.toString(), "test assertions."}));
        }
        return true;
    }

    public void writeInvalidParseDetails(String s2, String t2) {
        File outputFile;
        block7: {
            outputFile = null;
            FileWriter out = null;
            BufferedWriter buf_writer = null;
            Verifier.setWriteInvalidParseDetails(true);
            outputFile = new File(outputFileStr);
            try {
                out = new FileWriter(outputFile);
                buf_writer = new BufferedWriter(out);
                buf_writer.write("                  -----------------");
                buf_writer.newLine();
                buf_writer.write(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".bufWriter.error", "                        ERROR   "));
                buf_writer.newLine();
                buf_writer.write("                  -----------------");
                buf_writer.newLine();
                buf_writer.write("***********************************************************");
                buf_writer.newLine();
                buf_writer.write(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".bufWriter.noTestRun", "No Test Run. Fix error before continuing."));
                buf_writer.newLine();
                buf_writer.newLine();
                buf_writer.write(s2);
                buf_writer.newLine();
                buf_writer.newLine();
                buf_writer.write(t2);
                buf_writer.newLine();
                buf_writer.write("***********************************************************");
                buf_writer.newLine();
                buf_writer.newLine();
                buf_writer.close();
                out.close();
            }
            catch (FileNotFoundException e10) {
                this.setExceptionMessage(e10);
                Verifier.debug(e10);
                Verifier.log(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".FileNotFoundException", "Can not find output file, no such file or directory:  {0} - {1}", new Object[]{outputFile.toString(), e10.getMessage()}));
                Verifier.log(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".FileNotFoundException.ErrMessage", "Unable to complete writing of output file:  {0}", new Object[]{outputFile.toString()}));
                if (!using_gui) {
                    System.exit(0);
                }
                fileNotFoundException = true;
            }
            catch (IOException e11) {
                this.setExceptionMessage(e11);
                Verifier.debug(e11);
                Verifier.log(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".WriteDetails.IOException", "IO exception trying to access output file: {0}", new Object[]{outputFile.toString()}));
                Verifier.log(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".WriteDetails.IOException.ErrMessage", "Unable to complete writing of output file:  {0}", new Object[]{outputFile.toString()}));
                if (!using_gui) {
                    System.exit(0);
                }
            }
            catch (Exception e12) {
                this.setExceptionMessage(e12);
                Verifier.debug(e12);
                Verifier.log(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".WriteDetails.Exception", "{0} trying to access output file: {1}", new Object[]{e12.getMessage(), outputFile.toString()}));
                Verifier.log(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".WriteDetails.Exception.ErrMessage", "Unable to complete writing of output file:  {0}", new Object[]{outputFile.toString()}));
                if (using_gui) break block7;
                System.exit(0);
            }
        }
        if (!fileNotFoundException) {
            Verifier.log(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".LookInResults", "Look in file \"{0}\" for detailed results on {1}", new Object[]{outputFile.toString(), "errors."}));
        }
    }
}

