/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.ejb;

import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.tools.verifier.CheckMgr;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.ResultsRecord;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.ejb.EjbCheckMgr;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class EjbCheckMgrImpl
extends CheckMgr
implements EjbCheckMgr {
    static Vector test = new Vector();
    private static Vector allEJBResults = new Vector();
    LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();

    boolean AllTestNamesFromPropsFile() {
        test = new Vector();
        boolean allIsWell = true;
        if (this.debug) {
            System.out.println(this.smh.getLocalString("com.sun.enterprise.tools.verifier.ejb.EjbCheckMgrImpl.TestnamesPropsFile", "About to get all test names from props file."));
        }
        File inputFile = EjbCheckMgrImpl.getEjbTestsFileFor("TestNamesEjb.conf");
        try {
            FileReader in = new FileReader(inputFile);
            BufferedReader buf_reader = new BufferedReader(in);
            String ln = null;
            while ((ln = buf_reader.readLine()) != null) {
                test.addElement(ln);
            }
            buf_reader.close();
            in.close();
        }
        catch (FileNotFoundException e10) {
            Verifier.debug(e10);
            allIsWell = false;
        }
        catch (IOException e11) {
            Verifier.debug(e11);
            allIsWell = false;
        }
        return allIsWell;
    }

    public boolean check(EjbBundleDescriptor bundleDescriptor) {
        boolean allIsWell;
        if (this.debug) {
            System.out.println(this.smh.getLocalString("com.sun.enterprise.tools.verifier.ejb.EjbCheckMgrImpl.EjbCheckMgr.check", "inside EjbCheckMgr.check for [ {0} ]", new Object[]{bundleDescriptor.getName()}));
            System.out.println("[ " + bundleDescriptor + " ]");
        }
        if (allIsWell = this.AllTestNamesFromPropsFile()) {
            Iterator itr = bundleDescriptor.getEjbs().iterator();
            while (itr.hasNext()) {
                EjbDescriptor descriptor = (EjbDescriptor)itr.next();
                Hashtable<String, Result> warningResults = new Hashtable<String, Result>();
                Hashtable<String, Result> failedResults = new Hashtable<String, Result>();
                Hashtable<String, Result> okayResults = new Hashtable<String, Result>();
                Hashtable<String, Result> naResults = new Hashtable<String, Result>();
                if (this.debug) {
                    System.out.println(this.smh.getLocalString("com.sun.enterprise.tools.verifier.ejb.EjbCheckMgrImpl.RunAllTests", "Now run all tests against ejb [ {0} ]", new Object[]{descriptor.getName()}));
                }
                int i2 = 0;
                while (i2 < test.size()) {
                    try {
                        Class<?> c10 = Class.forName((String)test.elementAt(i2));
                        try {
                            EjbCheck t2 = (EjbCheck)c10.newInstance();
                            Result r2 = new Result();
                            try {
                                r2 = t2.check(descriptor);
                                r2.setComponentName(descriptor.getName());
                            }
                            catch (Throwable tt) {
                                if (this.debug) {
                                    System.out.println(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".unexpectedError", "Unexpected error in verifier, check for problems related to: [ {0} ]", new Object[]{tt.toString()}));
                                }
                                Verifier.debug(tt);
                                r2.init(c10);
                                r2.failed(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".unexpectedError", "Unexpected error in verifier, check for problems related to: [ {0} ]", new Object[]{tt.toString()}));
                                r2.setComponentName(descriptor.getName());
                            }
                            this.fireStateChanged(r2);
                            if (r2.getStatus() == 1) {
                                if (this.debug) {
                                    System.out.println(this.smh.getLocalString("com.sun.enterprise.tools.verifier.ejb.EjbCheckMgrImpl.status.FAILED", " {0}  [ FAILED ]", new Object[]{r2.getTestName()}));
                                }
                                failedResults.put(r2.getTestName(), r2);
                                if (allIsWell) {
                                    allIsWell = false;
                                }
                            } else if (r2.getStatus() == 0) {
                                if (this.debug) {
                                    System.out.println(this.smh.getLocalString("com.sun.enterprise.tools.verifier.ejb.EjbCheckMgrImpl.status.PASSED", " {0}  [ PASSED ]", new Object[]{r2.getTestName()}));
                                }
                                okayResults.put(r2.getTestName(), r2);
                            } else if (r2.getStatus() == 2) {
                                if (this.debug) {
                                    System.out.println(this.smh.getLocalString("com.sun.enterprise.tools.verifier.ejb.EjbCheckMgrImpl.status.WARNING", " {0}  [ WARNING ]", new Object[]{r2.getTestName()}));
                                }
                                warningResults.put(r2.getTestName(), r2);
                            } else if (r2.getStatus() == 3 || r2.getStatus() == 4 || r2.getStatus() == 5) {
                                if (this.debug) {
                                    System.out.println(this.smh.getLocalString("com.sun.enterprise.tools.verifier.ejb.EjbCheckMgrImpl.status.NOT_APPLICABLE", " {0}  [ NOT_APPLICABLE ]", new Object[]{r2.getTestName()}));
                                }
                                naResults.put(r2.getTestName(), r2);
                            }
                        }
                        catch (InstantiationException e10) {
                            Verifier.debug(e10);
                            allIsWell = false;
                        }
                        catch (IllegalAccessException e11) {
                            Verifier.debug(e11);
                            allIsWell = false;
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        Verifier.debug("EJB test class [ " + (String)test.elementAt(i2) + " ] not found.");
                    }
                    ++i2;
                }
                ResultsRecord hashTableResults = new ResultsRecord();
                hashTableResults.setPassedResults(okayResults);
                hashTableResults.setFailedResults(failedResults);
                hashTableResults.setWarningResults(warningResults);
                hashTableResults.setNaResults(naResults);
                allEJBResults.addElement(hashTableResults);
            }
        }
        return allIsWell;
    }

    public static Vector getAllEJBResults() {
        return allEJBResults;
    }

    public static File getEjbTestsFileFor(String filename) {
        File f2 = new File(System.getProperty("com.sun.enterprise.home"));
        f2 = new File(f2, "config");
        f2 = new File(f2, "verifier");
        f2 = new File(f2, filename);
        if (Verifier.getDebug()) {
            System.out.println(StringManagerHelper.getLocalStringsManager().getLocalString("com.sun.enterprise.tools.verifier.ejb.EjbCheckMgrImpl.RetrievingTestnames", "Retrieving Test names from [ {0} ]", new Object[]{f2.toString()}));
        }
        return new File(f2.toString());
    }

    public static Vector getTests() {
        return test;
    }

    void setAllEJBResults(Vector v2) {
        allEJBResults = v2;
    }
}

