/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.app;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.app.AppCheck;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.Iterator;

public class WebURI
implements AppCheck {
    boolean debug = Verifier.getDebug();

    public Result check(Application descriptor) {
        LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
        if (this.debug) {
            System.out.println("\n********************************************************** \n " + smh.getLocalString("which.class.called.string", String.valueOf(String.valueOf(this.getClass())) + " called \n", new Object[]{this.getClass()}) + "\n**********************************************************");
        }
        Result result = new Result();
        result.init(this.getClass());
        if (this.debug) {
            System.out.println(smh.getLocalString("test.string.assertion", "Assertion from resource file is: [ {0} ]", new Object[]{result.getAssertion()}));
        }
        if (descriptor.getWebBundleDescriptors().size() > 0) {
            boolean oneFailed = false;
            Iterator itr = descriptor.getWebBundleDescriptors().iterator();
            while (itr.hasNext()) {
                WebBundleDescriptor wbd = (WebBundleDescriptor)itr.next();
                if (wbd.getArchivist().getArchiveUri().endsWith(".war")) {
                    result.addGoodDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".passed", "[ {0} ] specifies the URI [ {1} ] of web application file, relative to the top level of the application package [ {2} ].", new Object[]{wbd.getName(), wbd.getArchivist().getArchiveUri(), descriptor.getName()}));
                    continue;
                }
                if (!oneFailed) {
                    oneFailed = true;
                }
                result.addErrorDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failed", "Error: [ {0} ] does not specify the URI [ {1} ] of web application file, relative to the top level of the application package [ {2} ]", new Object[]{wbd.getName(), wbd.getArchivist().getArchiveUri(), descriptor.getName()}));
            }
            if (oneFailed) {
                result.setStatus(1);
            } else {
                result.setStatus(0);
            }
        } else {
            result.notApplicable(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable", "There are no web components in application [ {0} ]", new Object[]{descriptor.getName()}));
        }
        return result;
    }
}

