/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.appclient.elements;

import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.appclient.AppClientCheck;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.Iterator;

public class AppClientEjbRefTypeElement
implements AppClientCheck {
    boolean debug = Verifier.getDebug();

    public Result check(ApplicationClientDescriptor descriptor) {
        LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
        if (this.debug) {
            System.out.println("\n********************************************************** \n " + smh.getLocalString("which.class.called.string", String.valueOf(String.valueOf(this.getClass())) + " called \n", new Object[]{this.getClass()}) + "\n**********************************************************");
        }
        Result result = new Result();
        result.init(this.getClass());
        if (this.debug) {
            System.out.println(smh.getLocalString("test.string.assertion", "Assertion from resource file is: [ {0} ]", new Object[]{result.getAssertion()}));
        }
        boolean failed = false;
        if (!descriptor.getEjbReferenceDescriptors().isEmpty()) {
            Iterator itr = descriptor.getEjbReferenceDescriptors().iterator();
            while (itr.hasNext()) {
                EjbReferenceDescriptor nextEjbReference = (EjbReferenceDescriptor)itr.next();
                String ejbRefTypeStr = nextEjbReference.getEjbDescriptor().getType();
                if (ejbRefTypeStr.equals(EjbSessionDescriptor.TYPE) || ejbRefTypeStr.equals(EjbEntityDescriptor.TYPE)) continue;
                result.failed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failed", "Error: ejb-ref-type [ {0} ] within \n application client [ {1} ] is not valid.  \n Must be [ {2} ] or [ {3} ]", new Object[]{ejbRefTypeStr, descriptor.getName(), EjbEntityDescriptor.TYPE, EjbSessionDescriptor.TYPE}));
                failed = true;
            }
        } else {
            result.notApplicable(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable", "There are no ejb references to other beans within this application client [ {0} ]", new Object[]{descriptor.getName()}));
            return result;
        }
        if (failed) {
            result.setStatus(1);
        } else {
            result.passed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".passed", "All ejb-ref-type elements are valid.  They are all [ {0} ] or [ {1} ] within this application client [ {2} ]", new Object[]{EjbEntityDescriptor.TYPE, EjbSessionDescriptor.TYPE, descriptor.getName()}));
        }
        return result;
    }
}

