/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb;

import com.sun.enterprise.deployment.EjbBundleArchivist;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.util.JarClassLoader;
import com.sun.enterprise.util.LocalStringManagerImpl;

public class JarFileContainsProperEJBClasses
implements EjbCheck {
    boolean debug = Verifier.getDebug();

    public Result check(EjbDescriptor descriptor) {
        LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
        if (this.debug) {
            System.out.println("\n********************************************************** \n " + smh.getLocalString("which.class.called.string", String.valueOf(String.valueOf(this.getClass())) + " called \n", new Object[]{this.getClass()}) + "\n**********************************************************");
        }
        Result result = new Result();
        result.init(this.getClass());
        if (this.debug) {
            System.out.println(smh.getLocalString("test.string.assertion", "Assertion from resource file is: [ {0} ]", new Object[]{result.getAssertion()}));
        }
        try {
            JarClassLoader jcl = JarClassLoader.getInstance();
            Class<?> c10 = jcl.loadClass(descriptor.getEjbClassName());
            try {
                c10.newInstance();
                result.passed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".passed", "Bean class [ {0} ] exists and it's supporting classes exist.", new Object[]{descriptor.getEjbClassName()}));
            }
            catch (InstantiationException e10) {
                Verifier.debug(e10);
                result.failed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failedException", "Error: Could not instantiate [ {0} ] within bean [ {1} ]", new Object[]{descriptor.getEjbClassName(), descriptor.getName()}));
            }
            catch (IllegalAccessException e11) {
                Verifier.debug(e11);
                result.failed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failedException1", "Error: Illegal Access while trying to instantiate [ {0} ] within bean [ {1} ]", new Object[]{descriptor.getEjbClassName(), descriptor.getName()}));
            }
        }
        catch (ClassNotFoundException e12) {
            Verifier.debug(e12);
            result.failed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failedException2", "Error: Can't find class [ {0} ] within bean [ {1} ]", new Object[]{descriptor.getEjbClassName(), descriptor.getName()}));
        }
        catch (Throwable t2) {
            Verifier.debug(t2);
            result.notApplicable(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable", "Not Applicable: [ {0} ] class encountered [ {1} ]. Cannot create instance of class [ {2} ] becuase [ {3} ] is not accessible within [ {4} ].", new Object[]{descriptor.getEjbClassName(), t2.toString(), descriptor.getEjbClassName(), t2.getMessage(), Verifier.getJarFile(((EjbBundleArchivist)descriptor.getEjbBundleDescriptor().getArchivist()).getEjbJarFile().getName()).getName()}));
        }
        return result;
    }
}

