/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb;

import com.sun.enterprise.deployment.ContainerTransaction;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.Arrays;
import java.util.Enumeration;

public class TransactionDemarcationType
implements EjbCheck {
    boolean debug = Verifier.getDebug();
    static String[] EJBObjectMethods = new String[]{"getHomeHandle", "getEJBMetaData", "create", "getEJBHome", "getHandle", "getPrimaryKey", "isIdentical", "remove"};

    public Result check(EjbDescriptor descriptor) {
        LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
        if (this.debug) {
            System.out.println("\n********************************************************** \n " + smh.getLocalString("which.class.called.string", String.valueOf(String.valueOf(this.getClass())) + " called \n", new Object[]{this.getClass()}) + "\n**********************************************************");
        }
        Result result = new Result();
        result.init(this.getClass());
        if (this.debug) {
            System.out.println(smh.getLocalString("test.string.assertion", "Assertion from resource file is: [ {0} ]", new Object[]{result.getAssertion()}));
        }
        try {
            if (descriptor instanceof EjbSessionDescriptor || descriptor instanceof EjbEntityDescriptor) {
                boolean oneFailed = false;
                String transactionType = descriptor.getTransactionType();
                if (EjbDescriptor.CONTAINER_TRANSACTION_TYPE.equals(transactionType)) {
                    try {
                        Arrays.sort(EJBObjectMethods);
                        ContainerTransaction containerTransaction = null;
                        if (!descriptor.getMethodContainerTransactions().isEmpty()) {
                            Enumeration ee2 = descriptor.getMethodContainerTransactions().keys();
                            while (ee2.hasMoreElements()) {
                                MethodDescriptor methodDescriptor = (MethodDescriptor)ee2.nextElement();
                                if (Arrays.binarySearch(EJBObjectMethods, methodDescriptor.getName()) >= 0) continue;
                                containerTransaction = (ContainerTransaction)descriptor.getMethodContainerTransactions().get(methodDescriptor);
                                try {
                                    if (containerTransaction != null) {
                                        String transactionAttribute = containerTransaction.getTransactionAttribute();
                                        if (ContainerTransaction.NOT_SUPPORTED.equals(transactionAttribute) || ContainerTransaction.SUPPORTS.equals(transactionAttribute) || ContainerTransaction.REQUIRED.equals(transactionAttribute) || ContainerTransaction.REQUIRES_NEW.equals(transactionAttribute) || ContainerTransaction.MANDATORY.equals(transactionAttribute) || ContainerTransaction.NEVER.equals(transactionAttribute)) {
                                            result.addGoodDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".passed", "TransactionAttribute [ {0} ] for method [ {1} ] is valid.", new Object[]{transactionAttribute, methodDescriptor.getName()}));
                                            continue;
                                        }
                                        oneFailed = true;
                                        result.addErrorDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failed", "Error: TransactionAttribute [ {0} ] for method [ {1} ] is not valid.", new Object[]{transactionAttribute, methodDescriptor.getName()}));
                                        continue;
                                    }
                                    oneFailed = true;
                                    result.addErrorDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failedException", "Error: TransactionAttribute is null for method [ {0} ]", new Object[]{methodDescriptor.getName()}));
                                }
                                catch (NullPointerException nullPointerException) {
                                    oneFailed = true;
                                    result.addErrorDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failedException", "Error: TransactionAttribute is null for method [ {0} ]", new Object[]{methodDescriptor.getName()}));
                                }
                            }
                        } else {
                            result.notApplicable(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable1", "There are no method permissions within this bean [ {0} ]", new Object[]{descriptor.getName()}));
                        }
                    }
                    catch (Exception e10) {
                        result.failed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failedException2", "Error: [ {0} ] does not contain class [ {1} ] within bean [ {2} ]", new Object[]{descriptor.getName(), e10.getMessage(), descriptor.getName()}));
                        return result;
                    }
                    if (oneFailed) {
                        result.setStatus(1);
                    } else {
                        result.setStatus(0);
                    }
                    return result;
                }
                result.notApplicable(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable2", "Bean [ {0} ] is not {1} managed, it is [ {2} ] managed.", new Object[]{descriptor.getName(), EjbDescriptor.CONTAINER_TRANSACTION_TYPE, transactionType}));
                return result;
            }
            result.notApplicable(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable", "[ {0} ] not called \n with a Session or Entity bean.", new Object[]{this.getClass()}));
            return result;
        }
        catch (Throwable t2) {
            result.failed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failedException2", "Error: [ {0} ] does not contain class [ {1} ] within bean [ {2} ]", new Object[]{descriptor.getName(), t2.getMessage(), descriptor.getName()}));
            return result;
        }
    }
}

