/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.businessmethod;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.RmiIIOPUtils;
import com.sun.enterprise.util.JarClassLoader;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.reflect.Method;

public class BusinessMethodRmiIIOP
implements EjbCheck {
    boolean debug = Verifier.getDebug();

    public Result check(EjbDescriptor descriptor) {
        LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
        if (this.debug) {
            System.out.println("\n********************************************************** \n " + smh.getLocalString("which.class.called.string", String.valueOf(String.valueOf(this.getClass())) + " called \n", new Object[]{this.getClass()}) + "\n**********************************************************");
        }
        Result result = new Result();
        result.init(this.getClass());
        if (this.debug) {
            System.out.println(smh.getLocalString("test.string.assertion", "Assertion from resource file is: [ {0} ]", new Object[]{result.getAssertion()}));
        }
        if (descriptor instanceof EjbSessionDescriptor || descriptor instanceof EjbEntityDescriptor) {
            boolean oneFailed = false;
            try {
                JarClassLoader jcl = JarClassLoader.getInstance();
                Class<?> c10 = jcl.loadClass(descriptor.getEjbClassName());
                Class<?> rc = jcl.loadClass(descriptor.getRemoteClassName());
                int foundAtLeastOne = 0;
                boolean businessFound = false;
                boolean isLegalRMIIIOP = false;
                Method[] methods = c10.getDeclaredMethods();
                Method[] remoteMethods = rc.getDeclaredMethods();
                int h2 = 0;
                while (h2 < remoteMethods.length) {
                    businessFound = false;
                    isLegalRMIIIOP = false;
                    int i2 = 0;
                    while (i2 < methods.length) {
                        if (methods[i2].getName().equals(remoteMethods[h2].getName())) {
                            ++foundAtLeastOne;
                            businessFound = true;
                            Class[] businessMethodParameterTypes = methods[i2].getParameterTypes();
                            if (RmiIIOPUtils.isValidRmiIIOPParameters(businessMethodParameterTypes)) {
                                isLegalRMIIIOP = true;
                            }
                            if (businessFound && isLegalRMIIIOP) {
                                result.addGoodDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug1", "For EJB Class [ {0} ] business method [ {1} ]", new Object[]{descriptor.getEjbClassName(), methods[i2].getName()}));
                                result.addGoodDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".passed", "[ {0} ] properly declares business method [ {1} ] with valid RMI-IIOP parameter and return types.", new Object[]{descriptor.getEjbClassName(), methods[i2].getName()}));
                                result.addGoodDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug2", "=============================="));
                            } else if (businessFound && !isLegalRMIIIOP) {
                                oneFailed = true;
                                result.addErrorDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug1", "For EJB Class [ {0} ] business method [ {1} ]", new Object[]{descriptor.getEjbClassName(), methods[i2].getName()}));
                                result.addErrorDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failed", "Error: business method [ {0} ] was found, but business method has illegal parameter values.   Business methods arguments types must be legal types for RMI-IIOP.", new Object[]{methods[i2].getName()}));
                                result.addErrorDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug2", "=============================="));
                            }
                        }
                        ++i2;
                    }
                    ++h2;
                }
                if (foundAtLeastOne <= 0) {
                    result.failed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable1", " [ {0} ] does not declare any business methods. ", new Object[]{descriptor.getEjbClassName()}));
                }
            }
            catch (ClassNotFoundException e10) {
                Verifier.debug(e10);
                result.failed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failedException", "Error: Remote interface [ {0} ] or bean class [ {1} ] does not exist or is not loadable within bean [ {2} ].", new Object[]{descriptor.getRemoteClassName(), descriptor.getEjbClassName(), descriptor.getName()}));
            }
            if (oneFailed) {
                result.setStatus(1);
            } else {
                result.setStatus(0);
            }
            return result;
        }
        result.notApplicable(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable", "{0} expected {1} bean or {2} bean, but called with {3}.", new Object[]{this.getClass(), "Session", "Entity", descriptor.getName()}));
        return result;
    }
}

