/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.elements;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.security.acl.Role;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.Enumeration;
import java.util.Hashtable;

public class MethodPermissionSecurityRoleExists
implements EjbCheck {
    boolean debug = Verifier.getDebug();

    public Result check(EjbDescriptor descriptor) {
        LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
        if (this.debug) {
            System.out.println("\n********************************************************** \n " + smh.getLocalString("which.class.called.string", String.valueOf(String.valueOf(this.getClass())) + " called \n", new Object[]{this.getClass()}) + "\n**********************************************************");
        }
        Result result = new Result();
        result.init(this.getClass());
        if (this.debug) {
            System.out.println(smh.getLocalString("test.string.assertion", "Assertion from resource file is: [ {0} ]", new Object[]{result.getAssertion()}));
        }
        Hashtable permissionedMethods = descriptor.getPermissionedMethodsByRole();
        boolean oneFailed = false;
        if (permissionedMethods.size() > 0) {
            Enumeration e10 = permissionedMethods.keys();
            while (e10.hasMoreElements()) {
                Role nextRole = (Role)e10.nextElement();
                if (!descriptor.getEjbBundleDescriptor().getRoles().contains(nextRole)) {
                    oneFailed = true;
                    result.addErrorDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failed", "Error: Method permissions role [ {0} ] must be one of the roles defined in bean [ {1} ]", new Object[]{nextRole.getName(), descriptor.getName()}));
                    continue;
                }
                result.addGoodDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".passed", "Valid: Method permissions role [ {0} ] is defined as one of the roles defined in bean [ {1} ]", new Object[]{nextRole.getName(), descriptor.getName()}));
            }
            if (oneFailed) {
                result.setStatus(1);
            } else {
                result.setStatus(0);
            }
        } else {
            result.notApplicable(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable", "There are no <method-permission> elements within this bean [ {0} ]", new Object[]{descriptor.getName()}));
        }
        return result;
    }
}

