/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.entity;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.util.JarClassLoader;
import com.sun.enterprise.util.LocalStringManagerImpl;

public class EjbClassImplementsRemoteInterface
implements EjbCheck {
    boolean debug = Verifier.getDebug();

    public Result check(EjbDescriptor descriptor) {
        LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
        if (this.debug) {
            System.out.println("\n********************************************************** \n " + smh.getLocalString("which.class.called.string", String.valueOf(String.valueOf(this.getClass())) + " called \n", new Object[]{this.getClass()}) + "\n**********************************************************");
        }
        Result result = new Result();
        result.init(this.getClass());
        if (this.debug) {
            System.out.println(smh.getLocalString("test.string.assertion", "Assertion from resource file is: [ {0} ]", new Object[]{result.getAssertion()}));
        }
        if (descriptor instanceof EjbEntityDescriptor) {
            try {
                JarClassLoader jcl = JarClassLoader.getInstance();
                Class<?> c10 = jcl.loadClass(descriptor.getEjbClassName());
                Class<?> rc = jcl.loadClass(descriptor.getRemoteClassName());
                boolean foundOne = false;
                block2: do {
                    Class<?>[] interfaces = c10.getInterfaces();
                    int i2 = 0;
                    while (i2 < interfaces.length) {
                        if (this.debug) {
                            System.out.println(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug1", "Interface [ {0} ]", new Object[]{interfaces[i2].getName()}));
                        }
                        if (interfaces[i2].getName().equals(rc.getName()) && descriptor instanceof EjbEntityDescriptor) {
                            result.warning(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".warning", "Warning: [ {0} ] class implments the enterprise Bean's remote interface [ {1} ].  It is recommended that the enterprise bean class not implement the remote interface to prevent inadvertent passing of this as a method argument or result.  The class must provide no-op implementations of the methods defined in the javax.ejb.EJBObject interface.", new Object[]{descriptor.getEjbClassName(), rc.getName()}));
                            foundOne = true;
                            continue block2;
                        }
                        ++i2;
                    }
                } while ((c10 = c10.getSuperclass()) != null);
                if (!foundOne) {
                    result.notApplicable(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable2", "[ {0} ] does not optionally implement bean class remote interface  [ {1} ]", new Object[]{descriptor.getEjbClassName(), rc.getName()}));
                }
            }
            catch (ClassNotFoundException e10) {
                Verifier.debug(e10);
                result.failed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failedException", "Error: [ {0} ] class not found.", new Object[]{descriptor.getEjbClassName()}));
            }
            return result;
        }
        result.notApplicable(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable", "[ {0} ] expected {1} bean, but called with {2} bean.", new Object[]{this.getClass(), "Entity", "Session"}));
        return result;
    }
}

