/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.entity.cmp;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.RmiIIOPUtils;
import com.sun.enterprise.util.JarClassLoader;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.Set;

public class CmpFields
implements EjbCheck {
    boolean debug = Verifier.getDebug();

    public Result check(EjbDescriptor descriptor) {
        LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
        if (this.debug) {
            System.out.println("\n********************************************************** \n " + smh.getLocalString("which.class.called.string", String.valueOf(String.valueOf(this.getClass())) + " called \n", new Object[]{this.getClass()}) + "\n**********************************************************");
        }
        Result result = new Result();
        result.init(this.getClass());
        if (this.debug) {
            System.out.println(smh.getLocalString("test.string.assertion", "Assertion from resource file is: [ {0} ]", new Object[]{result.getAssertion()}));
        }
        if (descriptor instanceof EjbEntityDescriptor) {
            block12: {
                String persistentType = ((EjbEntityDescriptor)descriptor).getPersistenceType();
                if (EjbEntityDescriptor.CONTAINER_PERSISTENCE.equals(persistentType)) {
                    try {
                        JarClassLoader jcl = JarClassLoader.getInstance();
                        Class<?> c10 = jcl.loadClass(descriptor.getEjbClassName());
                        Set persistentFields = ((EjbEntityDescriptor)descriptor).getPersistentFields();
                        Iterator iterator = persistentFields.iterator();
                        boolean oneFailed = false;
                        while (iterator.hasNext()) {
                            Descriptor persistentField = (Descriptor)iterator.next();
                            try {
                                Field f2 = c10.getDeclaredField(persistentField.getName());
                                Class<?> persistentFieldClassType = f2.getType();
                                if (RmiIIOPUtils.isPersistentFieldTypeValid(persistentFieldClassType, descriptor.getHomeClassName(), descriptor.getRemoteClassName())) {
                                    result.addGoodDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".passed", "Valid type assigned to container managed field [ {0} ] found in bean [ {1} ]", new Object[]{persistentField.getName(), descriptor.getEjbClassName()}));
                                    continue;
                                }
                                oneFailed = true;
                                result.addErrorDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failed", "Error: Invalid type assigned to container managed field [ {0} ] found in bean [ {1} ]", new Object[]{persistentField.getName(), descriptor.getEjbClassName()}));
                            }
                            catch (NoSuchFieldException e10) {
                                Verifier.debug(e10);
                                oneFailed = true;
                                result.addErrorDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failedException1", "Error: field [ {0} ] not found in class [ {1} ]", new Object[]{persistentField.getName(), descriptor.getEjbClassName()}));
                            }
                        }
                        if (oneFailed) {
                            result.setStatus(1);
                            break block12;
                        }
                        result.setStatus(0);
                    }
                    catch (ClassNotFoundException e11) {
                        Verifier.debug(e11);
                        result.failed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failedException", "Error: [ {0} ] class not found.", new Object[]{descriptor.getEjbClassName()}));
                    }
                } else {
                    result.notApplicable(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable1", "Expected persistence type [ {0} ], but [ {1} ] bean has persistence type [ {2} ]", new Object[]{EjbEntityDescriptor.CONTAINER_PERSISTENCE, descriptor.getName(), persistentType}));
                }
            }
            return result;
        }
        result.notApplicable(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable", "[ {0} ] expected {1} bean, but called with {2} bean.", new Object[]{this.getClass(), "Entity", "Session"}));
        return result;
    }
}

