/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.entity.cmp;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.FieldDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbUtils;
import com.sun.enterprise.tools.verifier.tests.ejb.RmiIIOPUtils;
import com.sun.enterprise.util.JarClassLoader;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.reflect.Field;
import java.util.Iterator;

public class CmpFieldsJavaTypesAssigned
implements EjbCheck {
    boolean debug = Verifier.getDebug();

    public Result check(EjbDescriptor descriptor) {
        LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
        if (this.debug) {
            System.out.println("\n********************************************************** \n " + smh.getLocalString("which.class.called.string", String.valueOf(String.valueOf(this.getClass())) + " called \n", new Object[]{this.getClass()}) + "\n**********************************************************");
        }
        Result result = new Result();
        result.init(this.getClass());
        if (this.debug) {
            System.out.println(smh.getLocalString("test.string.assertion", "Assertion from resource file is: [ {0} ]", new Object[]{result.getAssertion()}));
        }
        if (descriptor instanceof EjbEntityDescriptor) {
            String persistence = ((EjbEntityDescriptor)descriptor).getPersistenceType();
            if (EjbEntityDescriptor.CONTAINER_PERSISTENCE.equals(persistence)) {
                try {
                    JarClassLoader jcl = JarClassLoader.getInstance();
                    Class<?> c10 = jcl.loadClass(((EjbEntityDescriptor)descriptor).getEjbClassName());
                    boolean oneFailed = false;
                    boolean badField = false;
                    Iterator itr = ((EjbEntityDescriptor)descriptor).getPersistentFields().iterator();
                    while (itr.hasNext()) {
                        FieldDescriptor nextPersistentField = (FieldDescriptor)itr.next();
                        badField = false;
                        try {
                            Field f2 = c10.getDeclaredField(nextPersistentField.getName());
                            Class<?> fc2 = f2.getType();
                            if (RmiIIOPUtils.isValidRmiIDLPrimitiveType(fc2) || descriptor.getRemoteClassName().equals(fc2.getName()) || descriptor.getHomeClassName().equals(fc2.getName()) || EjbUtils.isValidSerializableType(fc2)) continue;
                            if (!oneFailed) {
                                oneFailed = true;
                            }
                            if (!(badField = true)) continue;
                            result.failed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failed", "Error: Field [ {0} ] defined within entity bean class [ {1} ] was assigned an invalid type.  Container managed field must be assigned in the entity bean class with Java types restricted to the following: Java primitive types, Java serializable types, and references of enterprise beans' remote or home interfaces.", new Object[]{nextPersistentField.getName(), ((EjbEntityDescriptor)descriptor).getEjbClassName()}));
                        }
                        catch (NoSuchFieldException e10) {
                            Verifier.debug(e10);
                            if (!oneFailed) {
                                oneFailed = true;
                            }
                            result.failed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failedException1", "Error: [ {0} ] field not found within class [ {1} ]", new Object[]{nextPersistentField.getName(), ((EjbEntityDescriptor)descriptor).getEjbClassName()}));
                        }
                    }
                    if (!oneFailed) {
                        result.passed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".passed", "This entity bean class [ {0} ] has assigned all container managed fields with valid Java types.", new Object[]{((EjbEntityDescriptor)descriptor).getEjbClassName()}));
                    }
                }
                catch (ClassNotFoundException e11) {
                    Verifier.debug(e11);
                    result.failed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failedException", "Error: [ {0} ] class not found.", new Object[]{((EjbEntityDescriptor)descriptor).getEjbClassName()}));
                }
                return result;
            }
            result.notApplicable(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable1", "Expected [ {0} ] managed persistence, but [ {1} ] bean has [ {2} ] managed persistence.", new Object[]{EjbEntityDescriptor.CONTAINER_PERSISTENCE, descriptor.getName(), persistence}));
            return result;
        }
        result.notApplicable(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable", "{0} expected {1} bean, but called with {2}.", new Object[]{this.getClass(), "Entity", "Session"}));
        return result;
    }
}

