/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.entity.ejbfindbyprimarykey;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.util.JarClassLoader;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class EjbFindByPrimaryKeyFinal
implements EjbCheck {
    boolean debug = Verifier.getDebug();

    public Result check(EjbDescriptor descriptor) {
        LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
        if (this.debug) {
            System.out.println("\n********************************************************** \n " + smh.getLocalString("which.class.called.string", String.valueOf(String.valueOf(this.getClass())) + " called \n", new Object[]{this.getClass()}) + "\n**********************************************************");
        }
        Result result = new Result();
        result.init(this.getClass());
        if (this.debug) {
            System.out.println(smh.getLocalString("test.string.assertion", "Assertion from resource file is: [ {0} ]", new Object[]{result.getAssertion()}));
        }
        if (descriptor instanceof EjbEntityDescriptor) {
            String persistentType = ((EjbEntityDescriptor)descriptor).getPersistenceType();
            if (EjbEntityDescriptor.BEAN_PERSISTENCE.equals(persistentType)) {
                boolean ejbFindByPrimaryKeyMethodFound = false;
                boolean isFinal = false;
                boolean oneFailed = false;
                int findMethodModifiers = 0;
                try {
                    JarClassLoader jcl = JarClassLoader.getInstance();
                    Class<?> EJBClass = jcl.loadClass(descriptor.getEjbClassName());
                    Method[] ejbFinderMethods = EJBClass.getDeclaredMethods();
                    int j2 = 0;
                    while (j2 < ejbFinderMethods.length) {
                        if (ejbFinderMethods[j2].getName().equals("ejbFindByPrimaryKey")) {
                            ejbFindByPrimaryKeyMethodFound = true;
                            findMethodModifiers = ejbFinderMethods[j2].getModifiers();
                            if (Modifier.isFinal(findMethodModifiers)) {
                                isFinal = true;
                            }
                            if (ejbFindByPrimaryKeyMethodFound && !isFinal) {
                                result.addGoodDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug1", "For EJB Class [ {0} ] Finder method [ {1} ]", new Object[]{EJBClass.getName(), ejbFinderMethods[j2].getName()}));
                                result.addGoodDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".passed", "A non-final [ {0} ] method was found.", new Object[]{ejbFinderMethods[j2].getName()}));
                                result.addGoodDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug2", "=============================="));
                                break;
                            }
                            if (!ejbFindByPrimaryKeyMethodFound || !isFinal) break;
                            oneFailed = true;
                            result.addErrorDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug1", "For EJB Class [ {0} ] Finder method [ {1} ]", new Object[]{EJBClass.getName(), ejbFinderMethods[j2].getName()}));
                            result.addErrorDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failed", "Error: A final [ {0} ] method was found, but [ {1} ] cannot be declared as final.", new Object[]{ejbFinderMethods[j2].getName(), ejbFinderMethods[j2].getName()}));
                            result.addErrorDetails("==============================");
                            break;
                        }
                        ++j2;
                    }
                    if (!ejbFindByPrimaryKeyMethodFound) {
                        oneFailed = true;
                        result.addErrorDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug3", "For EJB Class [ {0} ]", new Object[]{EJBClass.getName()}));
                        result.addErrorDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failed1", "Error: No ejbFindByPrimaryKey method was found in bean class."));
                        result.addErrorDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug2", "=============================="));
                    }
                }
                catch (ClassNotFoundException e10) {
                    Verifier.debug(e10);
                    result.failed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failedException", "Error: EJB Class [ {0} ] does not exist or is not loadable.", new Object[]{descriptor.getEjbClassName()}));
                    oneFailed = true;
                }
                if (oneFailed) {
                    result.setStatus(1);
                } else {
                    result.setStatus(0);
                }
            } else {
                result.notApplicable(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable2", "Expected persistence type [ {0} ], but bean [ {1} ] has persistence type [ {2} ]", new Object[]{EjbEntityDescriptor.BEAN_PERSISTENCE, descriptor.getName(), persistentType}));
            }
            return result;
        }
        result.notApplicable(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable", "[ {0} ] expected {1} bean, but called with {2} bean.", new Object[]{this.getClass(), "Entity", "Session"}));
        return result;
    }
}

