/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.remoteintf;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.util.JarClassLoader;
import com.sun.enterprise.util.LocalStringManagerImpl;

public class EjbRemoteInterfaceExtendsEJBObject
implements EjbCheck {
    boolean debug = Verifier.getDebug();

    public Result check(EjbDescriptor descriptor) {
        LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
        if (this.debug) {
            System.out.println("\n********************************************************** \n " + smh.getLocalString("which.class.called.string", String.valueOf(String.valueOf(this.getClass())) + " called \n", new Object[]{this.getClass()}) + "\n**********************************************************");
        }
        Result result = new Result();
        result.init(this.getClass());
        if (this.debug) {
            System.out.println(smh.getLocalString("test.string.assertion", "Assertion from resource file is: [ {0} ]", new Object[]{result.getAssertion()}));
        }
        if (descriptor instanceof EjbSessionDescriptor || descriptor instanceof EjbEntityDescriptor) {
            try {
                JarClassLoader jcl = JarClassLoader.getInstance();
                Class<?> c10 = jcl.loadClass(descriptor.getRemoteClassName());
                boolean validRemoteInterface = false;
                block2: do {
                    Class<?>[] interfaces = c10.getInterfaces();
                    int i2 = 0;
                    while (i2 < interfaces.length) {
                        if (this.debug) {
                            System.out.println(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug1", "Interface [ {0} ]", new Object[]{interfaces[i2].getName()}));
                        }
                        if (interfaces[i2].getName().equals("javax.ejb.EJBObject") && (descriptor instanceof EjbSessionDescriptor || descriptor instanceof EjbEntityDescriptor)) {
                            validRemoteInterface = true;
                            continue block2;
                        }
                        ++i2;
                    }
                } while ((c10 = c10.getSuperclass()) != null && !validRemoteInterface);
                if (!validRemoteInterface) {
                    result.failed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failed", "Error: [ {0} ] does not properly extend the EJBObject interface.  All enterprise bean remote interfaces must extend the EJBObject interface.  [ {1} ] is not a valid remote interface within bean [ {2} ]", new Object[]{descriptor.getRemoteClassName(), descriptor.getRemoteClassName(), descriptor.getName()}));
                } else {
                    result.passed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".passed", "[ {0} ] remote interface properly extends the EJBObject interface.", new Object[]{descriptor.getRemoteClassName()}));
                }
            }
            catch (ClassNotFoundException e10) {
                Verifier.debug(e10);
                result.failed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failedException", "Error: [ {0} ] class not found.", new Object[]{descriptor.getRemoteClassName()}));
            }
            return result;
        }
        result.notApplicable(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable", "[ {0} ] expected {1} bean or {2} bean, but called with {3}", new Object[]{this.getClass(), "Session", "Entity", descriptor.getName()}));
        return result;
    }
}

