/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.remoteintf;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.RmiIIOPUtils;
import com.sun.enterprise.util.JarClassLoader;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.reflect.Method;
import java.util.Arrays;

public class RemoteInterfaceRmiIIOPException
implements EjbCheck {
    static String[] EJBObjectMethods = new String[]{"getEJBHome", "getHandle", "getPrimaryKey", "isIdentical", "remove"};
    boolean debug = Verifier.getDebug();

    public Result check(EjbDescriptor descriptor) {
        LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
        if (this.debug) {
            System.out.println("\n********************************************************** \n " + smh.getLocalString("which.class.called.string", String.valueOf(String.valueOf(this.getClass())) + " called \n", new Object[]{this.getClass()}) + "\n**********************************************************");
        }
        Result result = new Result();
        result.init(this.getClass());
        if (this.debug) {
            System.out.println(smh.getLocalString("test.string.assertion", "Assertion from resource file is: [ {0} ]", new Object[]{result.getAssertion()}));
        }
        boolean throwsRemoteException = false;
        boolean oneFailed = false;
        try {
            Arrays.sort(EJBObjectMethods);
            JarClassLoader jcl = JarClassLoader.getInstance();
            Class<?> remoteInterfaceClass = jcl.loadClass(descriptor.getRemoteClassName());
            Method[] remoteInterfaceMethods = remoteInterfaceClass.getDeclaredMethods();
            int i2 = 0;
            while (i2 < remoteInterfaceMethods.length) {
                if (Arrays.binarySearch(EJBObjectMethods, remoteInterfaceMethods[i2].getName()) < 0) {
                    Class[] methodExceptionTypes = remoteInterfaceMethods[i2].getExceptionTypes();
                    throwsRemoteException = false;
                    if (RmiIIOPUtils.isValidRmiIIOPException(methodExceptionTypes)) {
                        throwsRemoteException = true;
                    }
                    if (throwsRemoteException) {
                        result.addGoodDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug1", "For Remote Interface [ {0} ] Method [ {1} ]", new Object[]{remoteInterfaceClass.getName(), remoteInterfaceMethods[i2].getName()}));
                        result.addGoodDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".passed", "[ {0} ] method properly throws java.rmi.RemoteException.", new Object[]{remoteInterfaceMethods[i2].getName()}));
                        result.addGoodDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug2", "=============================="));
                    } else if (!throwsRemoteException) {
                        oneFailed = true;
                        result.addErrorDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug1", "For Remote Interface [ {0} ] Method [ {1} ]", new Object[]{remoteInterfaceClass.getName(), remoteInterfaceMethods[i2].getName()}));
                        result.addErrorDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failed", "Error: [ {0} ] method was found, but does not properly throw java.rmi.RemoteException.", new Object[]{remoteInterfaceMethods[i2].getName()}));
                        result.addErrorDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug2", "=============================="));
                    }
                }
                ++i2;
            }
        }
        catch (ClassNotFoundException e10) {
            Verifier.debug(e10);
            result.failed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failedException", "Error: Remote interface [ {0} ] does not exist or is not loadable within bean [ {1} ]", new Object[]{descriptor.getRemoteClassName(), descriptor.getName()}));
        }
        if (oneFailed) {
            result.setStatus(1);
        } else {
            result.setStatus(0);
        }
        return result;
    }
}

