/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.session;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.util.JarClassLoader;
import com.sun.enterprise.util.LocalStringManagerImpl;

public class SessionSynchronizationInterface
implements EjbCheck {
    boolean debug = Verifier.getDebug();

    public Result check(EjbDescriptor descriptor) {
        LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
        if (this.debug) {
            System.out.println("\n********************************************************** \n " + smh.getLocalString("which.class.called.string", String.valueOf(String.valueOf(this.getClass())) + " called \n", new Object[]{this.getClass()}) + "\n**********************************************************");
        }
        Result result = new Result();
        result.init(this.getClass());
        if (this.debug) {
            System.out.println(smh.getLocalString("test.string.assertion", "Assertion from resource file is: [ {0} ]", new Object[]{result.getAssertion()}));
        }
        if (descriptor instanceof EjbSessionDescriptor) {
            String stateType = ((EjbSessionDescriptor)descriptor).getSessionTypeString();
            try {
                JarClassLoader jcl = JarClassLoader.getInstance();
                Class<?> c10 = jcl.loadClass(descriptor.getEjbClassName());
                boolean oneFound = false;
                block2: do {
                    Class<?>[] interfaces = c10.getInterfaces();
                    int i2 = 0;
                    while (i2 < interfaces.length) {
                        if (this.debug) {
                            System.out.println(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug1", "Interface [ {0} ]", new Object[]{interfaces[i2].getName()}));
                        }
                        if (interfaces[i2].getName().equals("javax.ejb.SessionSynchronization")) {
                            oneFound = true;
                            if (EjbSessionDescriptor.STATELESS.equals(stateType)) {
                                result.failed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failed", "Error: [ {0} ] does not properly implement the SessionSynchronization interface.  SessionSynchronization interface must not be implemented by a stateless Session Bean. [ {1} ] is not a valid bean.", new Object[]{descriptor.getEjbClassName(), descriptor.getEjbClassName()}));
                                continue block2;
                            }
                            if (EjbSessionDescriptor.STATEFUL.equals(stateType)) {
                                String transactionType = descriptor.getTransactionType();
                                if (EjbDescriptor.CONTAINER_TRANSACTION_TYPE.equals(transactionType)) {
                                    result.passed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".passed", "[ {0} ] properly implements the SessionSynchronization interface.", new Object[]{descriptor.getEjbClassName()}));
                                    continue block2;
                                }
                                if (EjbDescriptor.BEAN_TRANSACTION_TYPE.equals(transactionType)) {
                                    result.failed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failed2", "Error: [ {0} ] does not properly implement the SessionSynchronization interface.  SessionSynchronization interface may be implemented only by a stateful Session Bean using container-managed transactions. [ {1} ] is not a valid bean.", new Object[]{descriptor.getEjbClassName(), descriptor.getEjbClassName()}));
                                    continue block2;
                                }
                            }
                        }
                        ++i2;
                    }
                } while ((c10 = c10.getSuperclass()) != null);
                if (!oneFound) {
                    result.notApplicable(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable1", "Optional interface SessionSynchronization is not implemented by bean [ {0} ]", new Object[]{descriptor.getEjbClassName()}));
                }
            }
            catch (ClassNotFoundException e10) {
                Verifier.debug(e10);
                result.failed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failedException", "Error: [ {0} ] class not found.", new Object[]{descriptor.getEjbClassName()}));
            }
            return result;
        }
        result.notApplicable(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable", "[ {0} ] expected {1} bean, but called with {2} bean.", new Object[]{this.getClass(), "Session", "Entity"}));
        return result;
    }
}

