/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.session;

import com.sun.enterprise.deployment.ContainerTransaction;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.util.LocalStringManagerImpl;

public class TransactionTypeNullForContainerTX
implements EjbCheck {
    boolean debug = Verifier.getDebug();

    public Result check(EjbDescriptor descriptor) {
        LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
        if (this.debug) {
            System.out.println("\n********************************************************** \n " + smh.getLocalString("which.class.called.string", String.valueOf(String.valueOf(this.getClass())) + " called \n", new Object[]{this.getClass()}) + "\n**********************************************************");
        }
        Result result = new Result();
        result.init(this.getClass());
        if (this.debug) {
            System.out.println(smh.getLocalString("test.string.assertion", "Assertion from resource file is: [ {0} ]", new Object[]{result.getAssertion()}));
        }
        if (descriptor instanceof EjbSessionDescriptor) {
            String transactionType = descriptor.getTransactionType();
            if (EjbDescriptor.BEAN_TRANSACTION_TYPE.equals(transactionType)) {
                try {
                    ContainerTransaction containerTransaction = descriptor.getContainerTransaction();
                    if (containerTransaction != null) {
                        result.failed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failed", "Error: Session Beans [ {0} ] with [ {1} ] managed \ntransaction demarcation should not have container \ntransactions defined.", new Object[]{descriptor.getName(), transactionType}));
                    } else {
                        result.passed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".passed", "This session bean [ {0} ] is [ {1} ] managed and correctly declares no container transactions.", new Object[]{descriptor.getName(), transactionType}));
                    }
                    return result;
                }
                catch (NullPointerException nullPointerException) {
                    result.passed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".passed", "This session bean [ {0} ] is [ {1} ] managed and correctly declares no container transactions.", new Object[]{descriptor.getName(), transactionType}));
                    return result;
                }
            }
            result.notApplicable(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable1", "Session bean [ {0} ], expected [ {1} ] managed, but called with [ {2} ] managed.", new Object[]{descriptor.getName(), EjbDescriptor.BEAN_TRANSACTION_TYPE, EjbDescriptor.CONTAINER_TRANSACTION_TYPE}));
            return result;
        }
        result.notApplicable(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable", "[ {0} ] expected {1} \n bean, but called with {2} bean.", new Object[]{this.getClass(), "Session", "Entity"}));
        return result;
    }
}

