/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.session.stateless;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.util.JarClassLoader;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.reflect.Method;

public class StatelessCreateReturn
implements EjbCheck {
    boolean debug = Verifier.getDebug();

    public Result check(EjbDescriptor descriptor) {
        LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
        if (this.debug) {
            System.out.println("\n********************************************************** \n " + smh.getLocalString("which.class.called.string", String.valueOf(String.valueOf(this.getClass())) + " called \n", new Object[]{this.getClass()}) + "\n**********************************************************");
        }
        Result result = new Result();
        result.init(this.getClass());
        if (this.debug) {
            System.out.println(smh.getLocalString("test.string.assertion", "Assertion from resource file is: [ {0} ]", new Object[]{result.getAssertion()}));
        }
        if (descriptor instanceof EjbSessionDescriptor) {
            String stateType = ((EjbSessionDescriptor)descriptor).getSessionTypeString();
            if (EjbSessionDescriptor.STATELESS.equals(stateType)) {
                try {
                    JarClassLoader jcl = JarClassLoader.getInstance();
                    Class<?> c10 = jcl.loadClass(descriptor.getHomeClassName());
                    Class<?> rc = jcl.loadClass(descriptor.getRemoteClassName());
                    Method[] methods = c10.getDeclaredMethods();
                    Method m2 = null;
                    int i2 = 0;
                    while (i2 < methods.length) {
                        if (methods[i2].getName().equals("create")) {
                            m2 = methods[i2];
                            break;
                        }
                        ++i2;
                    }
                    if (m2 != null) {
                        Class<?> rt = m2.getReturnType();
                        if (!rc.getName().equals(rt.getName())) {
                            result.failed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failed", "Error: The create methods return type [ {0} ] is not \n equal to remote interface [ {1} ]", new Object[]{rt.getName(), rc.getName()}));
                        } else {
                            result.passed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".passed", "Valid: The create methods return type [ {0} ] is \n equal to remote interface [ {1} ]", new Object[]{rt.getName(), rc.getName()}));
                        }
                    } else {
                        result.failed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failed1", "Error: No Create method exists within bean [ {0} ]", new Object[]{descriptor.getHomeClassName()}));
                    }
                }
                catch (ClassNotFoundException e10) {
                    Verifier.debug(e10);
                    result.failed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failedException", "Error: Class [ {0} ] not found within bean [ {1} ]", new Object[]{descriptor.getHomeClassName(), descriptor.getName()}));
                }
                return result;
            }
            if (EjbSessionDescriptor.STATEFUL.equals(stateType)) {
                result.notApplicable(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable1", "[ {0} ] expected {1} Session bean, but called with {2} Session bean.", new Object[]{this.getClass(), EjbSessionDescriptor.STATELESS, stateType}));
                return result;
            }
            result.failed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failed2", "Error: [ {0} ] is not valid stateType within bean [ {1} ].", new Object[]{stateType, descriptor.getName()}));
            return result;
        }
        result.notApplicable(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable", "[ {0} ] expected {1} bean, but called with {2} bean.", new Object[]{this.getClass(), "Session", "Entity"}));
        return result;
    }
}

