/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.deployment.WebBundleArchivist;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class FormErrorPage
implements WebCheck {
    boolean debug = Verifier.getDebug();
    LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();

    public Result check(WebBundleDescriptor descriptor) {
        if (this.debug) {
            System.out.println("\n********************************************************** \n " + this.smh.getLocalString("which.class.called.string", String.valueOf(String.valueOf(this.getClass())) + " called \n", new Object[]{this.getClass()}) + "\n**********************************************************");
        }
        Result result = new Result();
        result.init(this.getClass());
        if (this.debug) {
            System.out.println(this.smh.getLocalString("test.string.assertion", "Assertion from resource file is: [ {0} ]", new Object[]{result.getAssertion()}));
        }
        if (descriptor.getLoginConfiguration() != null) {
            boolean foundIt = false;
            String formErrorPage = descriptor.getLoginConfiguration().getFormErrorPage();
            if (formErrorPage.length() > 0) {
                try {
                    JarFile jar = new JarFile(Verifier.getWarFile(((WebBundleArchivist)descriptor.getArchivist()).getWebJarFile().getName()));
                    ZipEntry ze = jar.getEntry(formErrorPage);
                    foundIt = ze != null;
                    jar.close();
                }
                catch (Exception exception) {
                    foundIt = false;
                }
                if (foundIt) {
                    result.passed(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".passed", "The form-error-page [ {0} ] value defines the location in the web application where the error page that is displayed when login is not successful can be found within web application [ {1} ]", new Object[]{formErrorPage, descriptor.getName()}));
                } else {
                    result.failed(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failed", "Error: The form-error-page [ {0} ] value does not define the location in the web application where the error page that is displayed when login is not successful can be found within web application [ {1} ]", new Object[]{formErrorPage, descriptor.getName()}));
                }
            } else {
                result.notApplicable(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable", "There are no form-error-page elements within this web archive [ {0} ]", new Object[]{descriptor.getName()}));
            }
        } else {
            result.notApplicable(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable", "There are no form-error-page elements within this web archive [ {0} ]", new Object[]{descriptor.getName()}));
        }
        return result;
    }
}

