/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.deployment.JspDescriptorImpl;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.Iterator;

public class JspLoadOnStartup
implements WebCheck {
    boolean debug = Verifier.getDebug();
    LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();

    public Result check(WebBundleDescriptor descriptor) {
        LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
        if (this.debug) {
            System.out.println("\n********************************************************** \n " + smh.getLocalString("which.class.called.string", String.valueOf(String.valueOf(this.getClass())) + " called \n", new Object[]{this.getClass()}) + "\n**********************************************************");
        }
        Result result = new Result();
        result.init(this.getClass());
        if (this.debug) {
            System.out.println(smh.getLocalString("test.string.assertion", "Assertion from resource file is: [ {0} ]", new Object[]{result.getAssertion()}));
        }
        boolean oneFailed = false;
        if (!descriptor.getJspDescriptors().isEmpty()) {
            Iterator itr = descriptor.getJspDescriptors().iterator();
            while (itr.hasNext()) {
                JspDescriptorImpl nextJspDescriptor = (JspDescriptorImpl)itr.next();
                Integer loadOnStartUp = new Integer(nextJspDescriptor.getLoadOnStartUp());
                if (loadOnStartUp >= 0) {
                    result.addGoodDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".passed", "load-on-startup [ {0} ] value found in [ {1} ]", new Object[]{loadOnStartUp, nextJspDescriptor.getName()}));
                    continue;
                }
                if (!oneFailed) {
                    oneFailed = true;
                }
                result.addErrorDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failed", "Error: load-on-startup [ {0} ] invalid value found in [ {1} ]", new Object[]{loadOnStartUp, nextJspDescriptor.getName()}));
            }
            if (oneFailed) {
                result.setStatus(1);
            } else {
                result.setStatus(0);
            }
        } else {
            result.notApplicable(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable", "There are no JSP's within this web archive [ {0} ]", new Object[]{descriptor.getName()}));
        }
        return result;
    }
}

