/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.deployment.ErrorPageDescriptorImpl;
import com.sun.enterprise.deployment.WebBundleArchivist;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.Enumeration;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class Location
implements WebCheck {
    boolean debug = Verifier.getDebug();
    LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();

    public Result check(WebBundleDescriptor descriptor) {
        if (this.debug) {
            System.out.println("\n********************************************************** \n " + this.smh.getLocalString("which.class.called.string", String.valueOf(String.valueOf(this.getClass())) + " called \n", new Object[]{this.getClass()}) + "\n**********************************************************");
        }
        Result result = new Result();
        result.init(this.getClass());
        if (this.debug) {
            System.out.println(this.smh.getLocalString("test.string.assertion", "Assertion from resource file is: [ {0} ]", new Object[]{result.getAssertion()}));
        }
        if (descriptor.getErrorPageDescriptors().hasMoreElements()) {
            boolean oneFailed = false;
            boolean foundIt = false;
            Enumeration e10 = descriptor.getErrorPageDescriptors();
            while (e10.hasMoreElements()) {
                String location;
                block11: {
                    foundIt = false;
                    ErrorPageDescriptorImpl errorpage = (ErrorPageDescriptorImpl)e10.nextElement();
                    location = errorpage.getLocation();
                    try {
                        JarFile jar = new JarFile(Verifier.getWarFile(((WebBundleArchivist)descriptor.getArchivist()).getWebJarFile().getName()));
                        ZipEntry ze = jar.getEntry(location);
                        foundIt = ze != null;
                        jar.close();
                    }
                    catch (Exception exception) {
                        if (oneFailed) break block11;
                        oneFailed = true;
                    }
                }
                if (foundIt) {
                    result.addGoodDetails(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".passed", "Location [ {0} ] contains the location of the resource within web application [ {1} ]", new Object[]{location, descriptor.getName()}));
                    continue;
                }
                if (!oneFailed) {
                    oneFailed = true;
                }
                result.addErrorDetails(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failed", "Error: Location [ {0} ] is not found within [ {1} ] or does not contain the location of the resource within web application [ {2} ]", new Object[]{location, Verifier.getWarFile(((WebBundleArchivist)descriptor.getArchivist()).getWebJarFile().getName()), descriptor.getName()}));
            }
            if (oneFailed) {
                result.setStatus(1);
            } else {
                result.setStatus(0);
            }
        } else {
            result.notApplicable(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable", "There are no location elements within the web archive [ {0} ]", new Object[]{descriptor.getName()}));
        }
        return result;
    }
}

