/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.deployment.RoleReference;
import com.sun.enterprise.deployment.SecurityRoleDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptorImpl;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.Enumeration;

public class RoleLink
implements WebCheck {
    boolean debug = Verifier.getDebug();
    LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();

    public Result check(WebBundleDescriptor descriptor) {
        if (this.debug) {
            System.out.println("\n********************************************************** \n " + this.smh.getLocalString("which.class.called.string", String.valueOf(String.valueOf(this.getClass())) + " called \n", new Object[]{this.getClass()}) + "\n**********************************************************");
        }
        Result result = new Result();
        result.init(this.getClass());
        if (this.debug) {
            System.out.println(this.smh.getLocalString("test.string.assertion", "Assertion from resource file is: [ {0} ]", new Object[]{result.getAssertion()}));
        }
        if (descriptor.getWebComponentDescriptors().hasMoreElements()) {
            boolean oneFailed = false;
            int na = 0;
            int noWd = 0;
            Enumeration e10 = descriptor.getWebComponentDescriptors();
            while (e10.hasMoreElements()) {
                ++noWd;
                WebComponentDescriptorImpl next = (WebComponentDescriptorImpl)e10.nextElement();
                boolean foundIt = false;
                if (next.getSecurityRoleReferences().hasMoreElements()) {
                    Enumeration ee2 = next.getSecurityRoleReferences();
                    while (ee2.hasMoreElements()) {
                        RoleReference rr = (RoleReference)ee2.nextElement();
                        foundIt = false;
                        String linkName = rr.getValue();
                        Verifier.debug("servlet linkName: " + linkName);
                        if (descriptor.getSecurityRoles().hasMoreElements()) {
                            Enumeration eee = descriptor.getSecurityRoles();
                            while (eee.hasMoreElements()) {
                                SecurityRoleDescriptor srdNext = (SecurityRoleDescriptor)eee.nextElement();
                                if (!linkName.equals(srdNext.getName())) continue;
                                foundIt = true;
                                break;
                            }
                        } else {
                            foundIt = false;
                        }
                        if (foundIt) {
                            result.addGoodDetails(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".passed", "role-link [ {0} ] links security role reference to a defined security role within web application [ {1} ]", new Object[]{linkName, descriptor.getName()}));
                            continue;
                        }
                        if (!oneFailed) {
                            oneFailed = true;
                        }
                        result.addErrorDetails(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failed", "Error: role-link [ {0} ] does not link security role reference to a defined security role within web application [ {1} ]", new Object[]{linkName, descriptor.getName()}));
                    }
                    continue;
                }
                result.addNaDetails(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable1", "[ {0} ] has no role-link element defined within the web archive [ {1} ]", new Object[]{next.getName(), descriptor.getName()}));
                ++na;
            }
            if (oneFailed) {
                result.setStatus(1);
            } else if (na == noWd) {
                result.setStatus(3);
            } else {
                result.setStatus(0);
            }
        } else {
            result.notApplicable(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable", "There are no location elements within the web archive [ {0} ]", new Object[]{descriptor.getName()}));
        }
        return result;
    }
}

