/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.deployment.WebBundleArchivist;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.Enumeration;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class WelcomeFile
implements WebCheck {
    boolean debug = Verifier.getDebug();
    LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();

    public Result check(WebBundleDescriptor descriptor) {
        if (this.debug) {
            System.out.println("\n********************************************************** \n " + this.smh.getLocalString("which.class.called.string", String.valueOf(String.valueOf(this.getClass())) + " called \n", new Object[]{this.getClass()}) + "\n**********************************************************");
        }
        Result result = new Result();
        result.init(this.getClass());
        if (this.debug) {
            System.out.println(this.smh.getLocalString("test.string.assertion", "Assertion from resource file is: [ {0} ]", new Object[]{result.getAssertion()}));
        }
        if (descriptor.getWelcomeFiles().hasMoreElements()) {
            boolean oneFailed = false;
            boolean foundIt = false;
            Enumeration e10 = descriptor.getWelcomeFiles();
            while (e10.hasMoreElements()) {
                String welcomefile;
                block11: {
                    foundIt = false;
                    welcomefile = (String)e10.nextElement();
                    try {
                        JarFile jar = new JarFile(Verifier.getWarFile(((WebBundleArchivist)descriptor.getArchivist()).getWebJarFile().getName()));
                        ZipEntry ze = jar.getEntry(welcomefile);
                        foundIt = ze != null;
                        jar.close();
                    }
                    catch (Exception exception) {
                        if (oneFailed) break block11;
                        oneFailed = true;
                    }
                }
                if (foundIt) {
                    result.addGoodDetails(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".passed", "Welcome file [ {0} ] contains the file name to use as a default welcome file within web application [ {1} ]", new Object[]{welcomefile, descriptor.getName()}));
                    continue;
                }
                if (!oneFailed) {
                    oneFailed = true;
                }
                result.addErrorDetails(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failed", "Error: Welcome file [ {0} ] is not found within [ {1} ] or does not contain the file name to use as a default welcome file within web application [ {2} ]", new Object[]{welcomefile, Verifier.getWarFile(((WebBundleArchivist)descriptor.getArchivist()).getWebJarFile().getName()), descriptor.getName()}));
            }
            if (oneFailed) {
                result.setStatus(1);
            } else {
                result.setStatus(0);
            }
        } else {
            result.notApplicable(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable", "There are no welcome files within the web archive [ {0} ]", new Object[]{descriptor.getName()}));
        }
        return result;
    }
}

