/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.AuthorizationConstraintImpl;
import com.sun.enterprise.deployment.ContainerTransaction;
import com.sun.enterprise.deployment.EjbBundleArchivist;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbExternalDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.ErrorPageDescriptorImpl;
import com.sun.enterprise.deployment.FieldDescriptor;
import com.sun.enterprise.deployment.JspDescriptorImpl;
import com.sun.enterprise.deployment.LoginConfigurationImpl;
import com.sun.enterprise.deployment.MailConfiguration;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.MimeMappingDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.RoleReference;
import com.sun.enterprise.deployment.SecurityConstraintImpl;
import com.sun.enterprise.deployment.SecurityRoleDescriptor;
import com.sun.enterprise.deployment.ServletDescriptorImpl;
import com.sun.enterprise.deployment.TagLibConfigurationDescriptor;
import com.sun.enterprise.deployment.UserDataConstraintImpl;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebResourceCollectionImpl;
import com.sun.enterprise.resource.ResourcePrincipal;
import com.sun.enterprise.security.PrincipalImpl;
import com.sun.enterprise.security.acl.Group;
import com.sun.enterprise.security.acl.Role;
import com.sun.enterprise.security.acl.RoleMapper;
import java.io.File;
import java.util.HashSet;
import java.util.Vector;

public class DescriptorGenerator {
    public static Application getDefaultApplication() {
        Application a = new Application("myApp", new File("myApp.jar"));
        a.setServerName("egmont.eng");
        WebBundleDescriptor wbd = DescriptorGenerator.getDefaultWebBundleDescriptor();
        wbd.addWebComponentDescriptor(DescriptorGenerator.getDefaultServletDescriptor());
        wbd.addWebComponentDescriptor(DescriptorGenerator.getDefaultJspDescriptor());
        wbd.getArchivist().setArchiveUri("webstuff.jar");
        a.addWebBundleDescriptor(wbd);
        EjbBundleDescriptor ejbd = DescriptorGenerator.getDefaultEjbBundleDescriptor();
        ejbd.getArchivist().setArchiveUri("ejbstuff.jar");
        a.addEjbBundleDescriptor(ejbd);
        a.addApplicationClientDescriptor(DescriptorGenerator.getDefaultApplicationClientDescriptor());
        RoleMapper rm = RoleMapper.getRoleMapper("testing only");
        Role manager = new Role("Manager");
        Role employee = new Role("employee");
        Role administrator = new Role("administrator");
        rm.assignRole(new PrincipalImpl("Danny"), administrator);
        rm.assignRole(new PrincipalImpl("Harish"), administrator);
        rm.assignRole(new Group("TheAdministrators"), administrator);
        rm.assignRole(new PrincipalImpl("Connie"), manager);
        rm.assignRole(new PrincipalImpl("David"), manager);
        rm.assignRole(new Group("Staff"), employee);
        rm.assignRole(new Group("Green"), employee);
        return a;
    }

    public static ApplicationClientDescriptor getDefaultApplicationClientDescriptor() {
        ApplicationClientDescriptor descriptor = new ApplicationClientDescriptor();
        descriptor.setName("AppClient");
        descriptor.setDescription("This is an application client");
        descriptor.setLargeIconUri("images/icon.gif");
        descriptor.addEnvironmentProperty(new EnvironmentProperty("key1", "value1", "description1"));
        descriptor.addEnvironmentProperty(new EnvironmentProperty("key2", "value2", "description2"));
        ResourceReferenceDescriptor rrd = new ResourceReferenceDescriptor("EmployeeDB", "The employee database", "javax.sql.DataSource");
        rrd.setValue("dbs/employee");
        rrd.setResourcePrincipal(new ResourcePrincipal("danny", "password"));
        descriptor.addResourceReferenceDescriptor(rrd);
        EjbExternalDescriptor externalReference = new EjbExternalDescriptor("AuditBean", "foo.AuditHome", "foo.AuditRemote", EjbEntityDescriptor.TYPE);
        EjbReferenceDescriptor unresolvedReference = new EjbReferenceDescriptor("Hallo", "ejb reference description", externalReference);
        unresolvedReference.setJndiName("ejbs/jndi/name");
        descriptor.addEjbReferenceDescriptor(unresolvedReference);
        descriptor.getArchivist().setArchiveUri("overHere.jar");
        return descriptor;
    }

    public static EjbBundleDescriptor getDefaultEjbBundleDescriptor() {
        EjbBundleDescriptor bundleDescriptor = new EjbBundleDescriptor();
        EjbEntityDescriptor entity = DescriptorGenerator.getDefaultEjbEntityDescriptor();
        EjbSessionDescriptor session = DescriptorGenerator.getDefaultEjbSessionDescriptor();
        bundleDescriptor.addEjb(session);
        Role managerRole = new Role("manager");
        managerRole.setDescription("This is the manager role");
        Role employeeRole = new Role("employee");
        employeeRole.setDescription("This is the employee role");
        Role administratorRole = new Role("administrator");
        administratorRole.setDescription("This is the administrator role");
        String[] createParameters = new String[]{"java.lang.Object", "int"};
        MethodDescriptor createMethod = new MethodDescriptor("create", "", createParameters, MethodDescriptor.EJB_REMOTE);
        String[] getSalaryParameters = new String[]{"java.lang.String"};
        MethodDescriptor getSalaryMethod = new MethodDescriptor("getSalary", "", getSalaryParameters, MethodDescriptor.EJB_HOME);
        HashSet<MethodDescriptor> methodsForEmployee = new HashSet<MethodDescriptor>();
        methodsForEmployee.add(createMethod);
        methodsForEmployee.add(getSalaryMethod);
        HashSet<MethodDescriptor> methodsForManager = new HashSet<MethodDescriptor>();
        methodsForManager.add(createMethod);
        EjbReferenceDescriptor intraJarEjbReference = new EjbReferenceDescriptor("UseTheEntityBean", "ejb reference description", entity);
        EjbExternalDescriptor externalReference = new EjbExternalDescriptor("AuditBean", "foo.AuditHome", "foo.AuditRemote", EjbEntityDescriptor.TYPE);
        EjbReferenceDescriptor unresolvedReference = new EjbReferenceDescriptor("UseAuditBean", "ejb reference description", externalReference);
        ((EjbBundleArchivist)bundleDescriptor.getArchivist()).setExternalDescriptorArchiveUri("this/uri/ejb.xml");
        bundleDescriptor.setEjbClientJarUri("Hellodanny.jar");
        return bundleDescriptor;
    }

    public static EjbEntityDescriptor getDefaultEjbEntityDescriptor() {
        EjbEntityDescriptor ejbDescriptor = new EjbEntityDescriptor("EmployeeRecord", "com.EmployeeRecordHome", "com.EmployeeRecordRemote", "com.EmployeeRecordBean", "com.EmployeeID");
        ejbDescriptor.setDescription("The employee record entity bean is the...");
        ejbDescriptor.addRoleReference(new RoleReference("MGR", ""));
        ejbDescriptor.addRoleReference(new RoleReference("EMPL", ""));
        ejbDescriptor.addRoleReference(new RoleReference("ADMIN", ""));
        ejbDescriptor.setPersistenceType(EjbEntityDescriptor.CONTAINER_PERSISTENCE);
        HashSet<FieldDescriptor> persistentFields = new HashSet<FieldDescriptor>();
        persistentFields.add(new FieldDescriptor("employeeID", "the employee ID"));
        persistentFields.add(new FieldDescriptor("firstName", "the first name of the employee"));
        persistentFields.add(new FieldDescriptor("lastName", "the last name of the employee"));
        persistentFields.add(new FieldDescriptor("address1", "the first line of the street address"));
        persistentFields.add(new FieldDescriptor("address2", "the second line of the street address"));
        ejbDescriptor.setPersistentFields(persistentFields);
        ResourceReferenceDescriptor rrd = new ResourceReferenceDescriptor("CMPDB", "no description", "javax.sql.DataSource");
        rrd.setResourcePrincipal(new ResourcePrincipal("danny", "dannyspassword"));
        rrd.setJndiName("CMP/Database");
        ejbDescriptor.setResourceReference(rrd);
        String[] parameters = new String[]{"java.lang.String"};
        MethodDescriptor sqlMd = new MethodDescriptor("find", "", parameters, MethodDescriptor.EJB_BEAN);
        String sql = "SELECT * FROM HERE";
        ejbDescriptor.setSqlStatementFor(sqlMd, sql);
        ejbDescriptor.setTableCreateSqlStatement("CREATE THIS USING THIS");
        ejbDescriptor.setTableRemoveSqlStatement("DELETE THAT");
        ejbDescriptor.setPrimaryKeyField(new FieldDescriptor("employeeID", ""));
        ejbDescriptor.setReentrant(true);
        ejbDescriptor.setJndiName("Entity/jndi/name");
        ejbDescriptor.setPersistenceType("Container");
        ResourcePrincipal defaultResourcePrincipal = new ResourcePrincipal("defaultUser", "defaultPassword");
        ResourceReferenceDescriptor rr = new ResourceReferenceDescriptor("AccountsDatabase", "The database", "javax.sql.DataSource");
        rr.setResourcePrincipal(defaultResourcePrincipal);
        rr.setValue("myServer/databases/accounts");
        ejbDescriptor.addResourceReferenceDescriptor(rr);
        rr = new ResourceReferenceDescriptor("MailReference", "My mila thingy", "javax.mail.Session");
        rr.setJndiName("mail/thing");
        rr.setMailConfiguration(new MailConfiguration("danny", "danny.coward@sun.com", "My host"));
        ejbDescriptor.addResourceReferenceDescriptor(rr);
        return ejbDescriptor;
    }

    public static EjbSessionDescriptor getDefaultEjbSessionDescriptor() {
        EjbSessionDescriptor ejbDescriptor = new EjbSessionDescriptor("EmployeeService", "com.EmployeeServiceHome", "com.EmployeeServiceRemote", "com.EmployeeServiceEJB");
        ejbDescriptor.setDescription("This is the employee service bean...");
        ejbDescriptor.setTransactionType("Container");
        String[] serviceParameters = new String[]{"foo.bar.ServiceObject"};
        MethodDescriptor serviceRequestMethod = new MethodDescriptor("serviceRequest", "", serviceParameters, MethodDescriptor.EJB_HOME);
        ContainerTransaction serviceRequestContainerTransaction = new ContainerTransaction(ContainerTransaction.NEVER, "some description or other");
        String[] killParameters = new String[]{"foo.bar.ServiceObject", "long"};
        MethodDescriptor killRequestMethod = new MethodDescriptor("killService", "", killParameters, MethodDescriptor.EJB_REMOTE);
        ContainerTransaction killRequestContainerTransaction = new ContainerTransaction(ContainerTransaction.MANDATORY, "some other description or other");
        MethodDescriptor ms1a = new MethodDescriptor(MethodDescriptor.ALL_EJB_METHODS, "", null);
        ejbDescriptor.setContainerTransactionFor(ms1a, new ContainerTransaction(ContainerTransaction.MANDATORY, ""));
        MethodDescriptor ms1b = new MethodDescriptor(MethodDescriptor.ALL_EJB_METHODS, "", MethodDescriptor.EJB_REMOTE);
        ejbDescriptor.setContainerTransactionFor(ms1b, new ContainerTransaction(ContainerTransaction.MANDATORY, ""));
        MethodDescriptor ms2a = new MethodDescriptor("create", "", null);
        ejbDescriptor.setContainerTransactionFor(ms2a, new ContainerTransaction(ContainerTransaction.MANDATORY, ""));
        MethodDescriptor ms2b = new MethodDescriptor("create", "", MethodDescriptor.EJB_REMOTE);
        ejbDescriptor.setContainerTransactionFor(ms2b, new ContainerTransaction(ContainerTransaction.MANDATORY, ""));
        String[] params = new String[]{"java.lang.String"};
        MethodDescriptor ms3a = new MethodDescriptor("foo", "", params, null);
        ejbDescriptor.setContainerTransactionFor(ms3a, new ContainerTransaction(ContainerTransaction.MANDATORY, ""));
        String[] moreParams = new String[]{};
        MethodDescriptor ms3b = new MethodDescriptor("foo", "", moreParams, null);
        ejbDescriptor.setContainerTransactionFor(ms3b, new ContainerTransaction(ContainerTransaction.MANDATORY, ""));
        MethodDescriptor ms3c = new MethodDescriptor("foo", "", moreParams, MethodDescriptor.EJB_REMOTE);
        ejbDescriptor.setContainerTransactionFor(ms3c, new ContainerTransaction(ContainerTransaction.MANDATORY, ""));
        ejbDescriptor.setJndiName("Session/jndi/name");
        System.out.println(ejbDescriptor);
        return ejbDescriptor;
    }

    public static JspDescriptorImpl getDefaultJspDescriptor() {
        JspDescriptorImpl jspDescriptor = new JspDescriptorImpl();
        jspDescriptor.setName("MyJspDescriptionName");
        jspDescriptor.setCanonicalName("MyJspLogicalName");
        jspDescriptor.setLargeIconUri("icons/myLargeIcon.gif");
        jspDescriptor.setSmallIconUri("icons/mySmallIcon.gif");
        jspDescriptor.setDescription("A jsp description");
        jspDescriptor.addInitializationParameter(new EnvironmentProperty("username", "danny", ""));
        jspDescriptor.addInitializationParameter(new EnvironmentProperty("password", "xxxx", ""));
        jspDescriptor.setLoadOnStartUp(67);
        jspDescriptor.addUrlPattern("/catalog/*");
        jspDescriptor.addUrlPattern("/anthing/index.html");
        jspDescriptor.setJspFileName("myJsp.jsp");
        RoleReference rr = new RoleReference("MGR", "");
        rr.setValue("manager");
        jspDescriptor.addSecurityRoleReference(rr);
        return jspDescriptor;
    }

    public Vector getDefaultMethodDescriptors() {
        Vector<MethodDescriptor> v2 = new Vector<MethodDescriptor>();
        v2.addElement(new MethodDescriptor(MethodDescriptor.ALL_EJB_METHODS, "", null));
        v2.addElement(new MethodDescriptor(MethodDescriptor.ALL_EJB_METHODS, "", MethodDescriptor.EJB_REMOTE));
        v2.addElement(new MethodDescriptor("create", "", null));
        v2.addElement(new MethodDescriptor("create", "", MethodDescriptor.EJB_REMOTE));
        String[] params = new String[]{"java.lang.String"};
        v2.addElement(new MethodDescriptor("foo", "", params, null));
        String[] moreParams = new String[]{};
        v2.addElement(new MethodDescriptor("foo", "", moreParams, null));
        v2.addElement(new MethodDescriptor("foo", "", moreParams, MethodDescriptor.EJB_REMOTE));
        return v2;
    }

    public static SecurityConstraintImpl getDefaultSecurityConstraint() {
        SecurityConstraintImpl constraint = new SecurityConstraintImpl();
        WebResourceCollectionImpl wrc = new WebResourceCollectionImpl();
        wrc.setName("MySecureBits");
        wrc.setDescription("Prefer not to show this to just anyone");
        wrc.addUrlPattern("/security/zone/*");
        wrc.addUrlPattern("/customers/*");
        wrc.addHttpMethod("GET");
        constraint.addWebResourceCollection(wrc);
        UserDataConstraintImpl udc = new UserDataConstraintImpl();
        udc.setDescription("This is a description");
        AuthorizationConstraintImpl ac2 = new AuthorizationConstraintImpl();
        ac2.setDescription("There is no descption !");
        ac2.setName("dos this get used ?");
        ac2.addSecurityRole(new SecurityRoleDescriptor("manager", " the manager's role"));
        constraint.setAuthorizationConstraint(ac2);
        return constraint;
    }

    public static ServletDescriptorImpl getDefaultServletDescriptor() {
        ServletDescriptorImpl servletDescriptor = new ServletDescriptorImpl();
        servletDescriptor.setName("MyServletDisplayName");
        servletDescriptor.setCanonicalName("MyServletLogicalName");
        servletDescriptor.setLargeIconUri("icons/myLargeIcon.gif");
        servletDescriptor.setSmallIconUri("icons/mySmallIcon.gif");
        servletDescriptor.setDescription("A servlet description");
        servletDescriptor.addInitializationParameter(new EnvironmentProperty("username", "danny", ""));
        servletDescriptor.addInitializationParameter(new EnvironmentProperty("password", "xxxx", ""));
        servletDescriptor.setClassName("com.danny.this.MyServlet");
        servletDescriptor.addUrlPattern("/catalog/*");
        servletDescriptor.addUrlPattern("/anthing/index.html");
        return servletDescriptor;
    }

    public static WebBundleDescriptor getDefaultWebBundleDescriptor() {
        WebBundleDescriptor webBundleDescriptor = new WebBundleDescriptor();
        webBundleDescriptor.setSmallIconUri("mySmallIcon.gif");
        webBundleDescriptor.setLargeIconUri("myLargeIcon.gif");
        webBundleDescriptor.setName("MyWebApplicationDisplayName");
        webBundleDescriptor.setDescription("A description");
        webBundleDescriptor.setDistributable(true);
        webBundleDescriptor.addContextParameter(new EnvironmentProperty("key1", "value1", "description1"));
        webBundleDescriptor.addContextParameter(new EnvironmentProperty("key2", "value2", "description1"));
        ServletDescriptorImpl servletDescriptor = DescriptorGenerator.getDefaultServletDescriptor();
        JspDescriptorImpl jspDescriptor = DescriptorGenerator.getDefaultJspDescriptor();
        webBundleDescriptor.addWebComponentDescriptor(servletDescriptor);
        webBundleDescriptor.addWebComponentDescriptor(jspDescriptor);
        webBundleDescriptor.setSessionTimeout(24);
        webBundleDescriptor.addMimeMapping(new MimeMappingDescriptor("txt", "text"));
        webBundleDescriptor.addMimeMapping(new MimeMappingDescriptor("html", "hyper-text"));
        webBundleDescriptor.addErrorPageDescriptor(new ErrorPageDescriptorImpl(404, "error.jsp"));
        webBundleDescriptor.addErrorPageDescriptor(new ErrorPageDescriptorImpl("java.lang.Exception", "error.jsp"));
        webBundleDescriptor.addTagLibConfig(new TagLibConfigurationDescriptor("danny", "coward"));
        webBundleDescriptor.addTagLibConfig(new TagLibConfigurationDescriptor("ertert", "ertyh"));
        ResourceReferenceDescriptor rrd = new ResourceReferenceDescriptor("EmployeeDB", "The employee database", "javax.sql.DataSource");
        rrd.setValue("dbs/employee");
        rrd.setAuthorization("CONTAINER");
        webBundleDescriptor.addResourceReferenceDescriptor(rrd);
        SecurityConstraintImpl securityConstraint = DescriptorGenerator.getDefaultSecurityConstraint();
        webBundleDescriptor.addSecurityConstraint(securityConstraint);
        LoginConfigurationImpl lc = new LoginConfigurationImpl();
        lc.setAuthenticationMethod("FORM");
        lc.setRealmName("DEFAULT");
        lc.setFormLoginPage("login.jsp");
        lc.setFormErrorPage("error.jsp");
        webBundleDescriptor.setLoginConfiguration(lc);
        webBundleDescriptor.addSecurityRole(new SecurityRoleDescriptor("manager", " the manager's role"));
        webBundleDescriptor.addSecurityRole(new SecurityRoleDescriptor("employee", " the employee's role"));
        webBundleDescriptor.addEnvironmentEntry(new EnvironmentProperty("MYINT", "23", "the int", "java.lang.Integer"));
        EjbReferenceDescriptor refD = new EjbReferenceDescriptor("myAuditingBean", "reference description", new EjbExternalDescriptor("AuditBean", "foo.AuditHome", "foo.AuditRemote", EjbEntityDescriptor.TYPE));
        webBundleDescriptor.addEjbReferenceDescriptor(refD);
        webBundleDescriptor.addWelcomeFile("index.html");
        webBundleDescriptor.addWelcomeFile("default.html");
        webBundleDescriptor.setContextRoot("MyContextRoot");
        return webBundleDescriptor;
    }

    public static void main(String[] args) {
        EjbEntityDescriptor session = DescriptorGenerator.getDefaultEjbEntityDescriptor();
        System.out.println(session);
        System.out.println("");
        System.out.println(new EjbEntityDescriptor(session));
    }
}

