/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

class EJBClassLoader
extends ClassLoader {
    private HashMap classCache;
    private Set urlSet = new HashSet();
    private static final boolean debug = false;

    protected EJBClassLoader() {
        this.classCache = new HashMap(1024);
    }

    public synchronized void addURL(URL url) throws IOException {
        this.urlSet.add(url);
    }

    protected void finalize() {
        this.print("ClassLoader: " + this + " is getting garbage collected");
    }

    protected URL findResource(String name) {
        this.print("findResource : " + name);
        URL resource = null;
        Iterator itr = this.urlSet.iterator();
        while (itr.hasNext()) {
            URL classpathURL = (URL)itr.next();
            File thisFile = new File(classpathURL.getFile());
            if (thisFile.isFile()) {
                try {
                    URL resourceURL = new URL("jar:" + classpathURL + "!/" + name);
                    JarURLConnection jarConnection = (JarURLConnection)resourceURL.openConnection();
                    JarEntry jarEntry = jarConnection.getJarEntry();
                    this.print("Found resource : " + resourceURL);
                    resource = resourceURL;
                    break;
                }
                catch (IOException iOException) {
                    this.print("Couldn't find " + name + " in " + classpathURL);
                    continue;
                }
            }
            File resourceFile = new File(String.valueOf(thisFile.toString()) + File.separator + name);
            if (resourceFile.exists()) {
                try {
                    resource = resourceFile.toURL();
                    break;
                }
                catch (IOException e10) {
                    this.print(e10.toString());
                    continue;
                }
            }
            this.print("Couldn't find " + resourceFile);
        }
        return resource;
    }

    private byte[] getClassData(InputStream istream) throws IOException {
        byte[] buf = new byte[1024];
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        int num = 0;
        while ((num = istream.read(buf)) != -1) {
            bout.write(buf, 0, num);
        }
        return bout.toByteArray();
    }

    public URL[] getURLs() {
        return this.urlSet.toArray(new URL[0]);
    }

    public synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c10 = null;
        try {
            try {
                c10 = super.loadClass(name, resolve);
            }
            catch (ClassNotFoundException classNotFoundException) {
                c10 = null;
            }
            Object var5_4 = null;
            if (c10 != null) {
                return c10;
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (c10 != null) {
                return c10;
            }
            throw throwable;
        }
        this.print("Loading class " + name + " using the classLoader " + this);
        c10 = (Class<?>)this.classCache.get(name);
        if (c10 == null) {
            byte[] data = this.loadClassData(name);
            if (data != null) {
                this.print("Read the class data ");
                c10 = this.defineClass(null, data, 0, data.length);
                this.classCache.put(name, c10);
                if (resolve) {
                    this.resolveClass(c10);
                }
            } else {
                this.print("Looking for the class in the system class loader.");
                c10 = this.findSystemClass(name);
            }
        } else {
            this.print("Found the class " + c10 + " in the cache");
        }
        if (c10 == null) {
            this.print("JarClassLoader: could not find " + name + " in  " + this.urlSet);
        }
        return c10;
    }

    private byte[] loadClassData(String name) {
        this.print("JCL: load " + name);
        InputStream classStream = null;
        String entryName = String.valueOf(name.replace('.', '/')) + ".class";
        Iterator itr = this.urlSet.iterator();
        while (itr.hasNext()) {
            URL thisURL = (URL)itr.next();
            File thisFile = new File(thisURL.getFile());
            try {
                if (!thisFile.exists()) {
                    throw new FileNotFoundException(thisFile.toString());
                }
                if (thisFile.isFile()) {
                    this.print("JCL: opening " + thisFile);
                    ZipFile zip = new ZipFile(thisFile);
                    ZipEntry entry = zip.getEntry(entryName);
                    if (entry != null) {
                        this.print("JCL: yes !");
                        classStream = zip.getInputStream(entry);
                        byte[] classData = this.getClassData(classStream);
                        zip.close();
                        return classData;
                    }
                    this.print("JCL: no - closing");
                    zip.close();
                    continue;
                }
                File classFile = new File(thisFile, entryName.replace('/', File.separatorChar));
                if (!classFile.exists()) continue;
                classStream = new FileInputStream(classFile);
                byte[] classData = this.getClassData(classStream);
                ((InputStream)classStream).close();
                return classData;
            }
            catch (IOException ioe) {
                this.print("JCL: Class Could not be loaded");
            }
        }
        return null;
    }

    private void print(Object o2) {
    }

    public String toString() {
        return "JCL: \n " + this.urlSet + " \n " + this.classCache;
    }
}

