/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import com.sun.enterprise.util.FileClassLoader;
import com.sun.enterprise.util.SimpleFilenameFilter;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;

public class FileUtil {
    private static final String JAR_FILE_NAME = "j2ee.jar";
    private static final String HOME_DIR_PROP = "com.sun.enterprise.home";
    private static final String DEFAULT_HOME_DIR = System.getProperty("user.dir");
    private static String basedir = null;

    public static void countWords() {
        try {
            String[] filter = new String[]{".java"};
            File f2 = new File("/home/dannyc/workspace/j2ee/src/share/com/sun/enterprise/deployment");
            Set s2 = FileUtil.getAllFilesUnder(f2, new SimpleFilenameFilter(filter));
            int i2 = 0;
            System.out.println(s2);
            Iterator itr = s2.iterator();
            while (itr.hasNext()) {
                File next = (File)itr.next();
                File absoluteFile = new File(f2, next.toString());
                System.out.println();
                System.out.println(absoluteFile);
                FileReader fr = new FileReader(absoluteFile);
                int nextChar = 0;
                boolean start = false;
                while (nextChar != -1) {
                    if (nextChar == 34) {
                        if (!(start ^= true)) {
                            System.out.println("\"");
                            ++i2;
                        } else {
                            System.out.print(String.valueOf(String.valueOf(next)) + " \t word = ");
                        }
                    }
                    if (start) {
                        System.out.print((char)nextChar);
                    }
                    nextChar = fr.read();
                }
            }
            System.out.println(String.valueOf(i2) + " words in " + s2.size() + " files.");
        }
        catch (Throwable ioe) {
            ioe.printStackTrace();
        }
    }

    public static String getAbsolutePath(String relativePath) {
        if (FileUtil.isAbsolute(relativePath)) {
            return relativePath;
        }
        String rpath = relativePath.replace('/', File.separatorChar);
        if (basedir == null) {
            FileUtil.setBaseDir();
        }
        String path = String.valueOf(basedir) + File.separator + relativePath;
        return new File(path).getAbsolutePath();
    }

    public static Set getAllFilesAndDirectoriesUnder(File directory) throws IOException {
        if (!directory.exists() || !directory.isDirectory()) {
            throw new IOException("Problem with: " + directory + ". You must supply a directory that exists");
        }
        TreeSet allFiles = new TreeSet();
        FileUtil.recursiveGetFilesUnder(directory, directory, null, allFiles, true);
        return allFiles;
    }

    public static Set getAllFilesUnder(File directory, FilenameFilter filenameFilter) throws IOException {
        if (!directory.exists() || !directory.isDirectory()) {
            throw new IOException("Problem with: " + directory + ". You must supply a directory that exists");
        }
        TreeSet allFiles = new TreeSet();
        FileUtil.recursiveGetFilesUnder(directory, directory, filenameFilter, allFiles, false);
        return allFiles;
    }

    public static String getClassNameFromFile(File f2) throws IOException, ClassFormatError {
        FileClassLoader fcl = new FileClassLoader(f2.toString());
        return fcl.getClassName(f2);
    }

    public static File getTempDirectory() {
        String home;
        String temp = System.getProperty("java.io.tmpdir");
        if (temp == null) {
            temp = "/tmp";
        }
        if ((home = System.getProperty("user.home")) == null) {
            home = "";
        }
        File tmp = new File(home, "tmp");
        tmp.mkdirs();
        return tmp;
    }

    private static boolean isAbsolute(String fpath) {
        return new File(fpath).isAbsolute();
    }

    public static void main(String[] args) {
        try {
            File f2 = new File("/home/dannyc/workspace/j2ee/build/unix/lib/classes/com/sun/enterprise/deployment");
            String[] filter = new String[]{".jsp", ".html", ".class", ".gif"};
            int i2 = 0;
            Set s2 = FileUtil.getAllFilesUnder(f2, new SimpleFilenameFilter(filter));
            Iterator itr = s2.iterator();
            while (itr.hasNext()) {
                File next = (File)itr.next();
                File absoluteFile = new File(f2, next.toString());
                String className = FileUtil.getClassNameFromFile(absoluteFile);
                System.out.println(String.valueOf(next.getName()) + " - > " + className);
                if (!"".equals(className)) continue;
                ++i2;
            }
            System.out.println(String.valueOf(i2) + " failed out of " + s2.size());
        }
        catch (Throwable ioe) {
            ioe.printStackTrace();
        }
    }

    public static String[] parseFileList(String files) {
        Vector<String> fileNames = new Vector<String>();
        boolean checkDriveLetter = File.pathSeparator.equals(":") ^ true;
        StringTokenizer st = new StringTokenizer(files, ":");
        while (st.hasMoreTokens()) {
            String name = st.nextToken();
            if (checkDriveLetter && name.length() == 1 && st.hasMoreTokens()) {
                name = String.valueOf(name) + ":" + st.nextToken();
            }
            fileNames.addElement(name);
        }
        int size = fileNames.size();
        String[] result = new String[size];
        int i2 = 0;
        while (i2 < size) {
            result[i2] = (String)fileNames.elementAt(i2);
            ++i2;
        }
        return result;
    }

    private static void recursiveGetFilesUnder(File relativizingRoot, File directory, FilenameFilter filenameFilter, Set set, boolean returnDirectories) {
        File[] files = directory.listFiles(filenameFilter);
        int i2 = 0;
        while (i2 < files.length) {
            if (files[i2].isDirectory()) {
                FileUtil.recursiveGetFilesUnder(relativizingRoot, files[i2], filenameFilter, set, returnDirectories);
                if (returnDirectories) {
                    set.add(FileUtil.relativize(relativizingRoot, files[i2]));
                }
            } else {
                set.add(FileUtil.relativize(relativizingRoot, files[i2]));
            }
            ++i2;
        }
    }

    public static File relativize(File parent, File child) {
        String s2 = parent.getAbsolutePath();
        String t2 = child.getAbsolutePath();
        String u2 = t2.substring(s2.length() + 1, t2.length());
        return new File(u2);
    }

    private static void setBaseDir() {
        basedir = System.getProperty(HOME_DIR_PROP);
        if (basedir != null) {
            return;
        }
        basedir = DEFAULT_HOME_DIR;
        String classPath = System.getProperty("java.class.path");
        if (classPath == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(classPath, File.pathSeparator);
        while (st.hasMoreTokens()) {
            String filename = st.nextToken();
            if (!filename.endsWith(JAR_FILE_NAME)) continue;
            try {
                String parent = new File(filename).getAbsoluteFile().getParentFile().getParent();
                if (parent != null) {
                    basedir = parent;
                }
                return;
            }
            catch (NullPointerException nullPointerException) {
                return;
            }
        }
    }
}

