/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.AuthorizationConstraintImpl;
import com.sun.enterprise.deployment.EjbExternalDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.ErrorPageDescriptorImpl;
import com.sun.enterprise.deployment.JspDescriptorImpl;
import com.sun.enterprise.deployment.LoginConfigurationImpl;
import com.sun.enterprise.deployment.MailConfiguration;
import com.sun.enterprise.deployment.MimeMappingDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.RoleReference;
import com.sun.enterprise.deployment.SecurityConstraintImpl;
import com.sun.enterprise.deployment.SecurityRoleDescriptor;
import com.sun.enterprise.deployment.ServletDescriptorImpl;
import com.sun.enterprise.deployment.TagLibConfigurationDescriptor;
import com.sun.enterprise.deployment.UserDataConstraintImpl;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptorImpl;
import com.sun.enterprise.deployment.WebResourceCollectionImpl;
import com.sun.enterprise.deployment.xml.RuntimeDescriptorNode;
import com.sun.enterprise.deployment.xml.WebBundleNode;
import com.sun.enterprise.deployment.xml.XMLUtils;
import com.sun.enterprise.resource.ResourcePrincipal;
import com.sun.enterprise.security.PrincipalImpl;
import com.sun.enterprise.security.acl.Group;
import com.sun.enterprise.security.acl.Role;
import com.sun.enterprise.security.acl.RoleMapper;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.NiceProperties;
import com.sun.xml.tree.XmlDocument;
import java.io.File;
import java.io.FileInputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class WebPropertiesFileConverter {
    private static String WEB_APPLICATION = "webApplication";
    private static String NAME = ".name";
    private static String CONTEXT_ROOT = ".contextRoot";
    private static String DESCRIPTION = ".description";
    private static String SMALL_ICON = ".smallIcon";
    private static String LARGE_ICON = ".largeIcon";
    private static String DISTRIBUTABLE = ".distributable";
    private static String CONTEXT_PARAMETER_COUNT = ".#contextParameters";
    private static String CONTEXT_PARAMETER = "contextParameter";
    private static String ENVIRONMENT_PROPERTIES = ".#environmentProperties";
    private static String ENVIRONMENT_PROPERTY = "environmentProperty";
    private static String IS_RESOURCE_REFERENCE = ".isResourceReference";
    private static String AUTHORIZATION = ".authorization";
    private static String DEFAULT_DB_ACCOUNT = ".defaultDBAccount";
    private static String MAIL_CONFIGURATION = ".mailConfiguration";
    private static String IS_EJB_REFERENCE = ".isEjbReference";
    private static String EJB_HOME = ".homeInterface";
    private static String EJB_REMOTE = ".remoteInterface";
    private static String EJB_NAME = ".ejbName";
    private static String VALUE = ".value";
    private static String WEB_COMPONENT_COUNT = ".#webComponents";
    private static String WEB_COMPONENT = "webComponent";
    private static String JSP_TYPE = "jsp";
    private static String SERVLET_TYPE = "servlet";
    private static String CANONICAL_NAME = ".logicalName";
    private static String INITIALIZATION_PARAMETER_COUNT = ".#initializationParameters";
    private static String INITIALIZATION_PARAMETER = ".initializationParameter";
    private static String URL_ALIAS_COUNT = ".#urlAliases";
    private static String URL_ALIAS = ".urlAlias";
    private static String JSP_FILENAME = ".filename";
    private static String LOAD_ON_START_UP = ".loadOnStartUp";
    private static String SERVLET_CLASSNAME = ".classname";
    private static String SESSION_TIMEOUT = ".sessionTimeout";
    private static String LOCALIZED_CONTENT_COUNT = ".#localizedContentDescriptors";
    private static String LOCALIZED_CONTENT = "localizedContentDescriptor";
    private static String LOCALE = ".locale";
    private static String URL = ".url";
    private static String MIME_MAPPING_COUNT = ".#mimeMappings";
    private static String MIME_MAPPING = "mimeMapping";
    private static String EXTENSION = ".extension";
    private static String TYPE = ".type";
    private static String WELCOME_FILE_COUNT = ".#welcomeFiles";
    private static String WELCOME_FILE = "welcomeFile";
    private static String ERROR_PAGE_COUNT = ".#errorPages";
    private static String ERROR_PAGE = "errorPage";
    private static String EXCEPTION_TYPE = ".exceptionType";
    private static String ERROR_CODE = ".errorCode";
    private static String SECURITY_ROLE_COUNT = ".#securityRoles";
    private static String SECURITY_ROLE = "securityRole";
    private static String USERS = ".users";
    private static String GROUPS = ".groups";
    private static String SECURITY_ROLE_REFS = ".#securityRoleReferences";
    private static String SECURITY_ROLE_REF = ".securityRoleReference";
    private static String SECURITY_CONSTRAINT_COUNT = ".#securityConstraints";
    private static String SECURITY_CONSTRAINT = "securityConstraint";
    private static String WEB_RESOURCE_COLLECTION_COUNT = ".#webResourceCollections";
    private static String WEB_RESOURCE_COLLECTION = ".webResourceCollection";
    private static String URL_PATTERNS = ".urlPatterns";
    private static String HTTP_METHODS = ".httpMethods";
    private static String ROLE_NAMES = ".roleNames";
    private static String TRANSPORT_TYPE = ".transportType";
    private static String LOGIN_METHOD = ".loginMethod";
    private static String REALM = ".realm";
    private static String FORM_LOGIN_PAGE = ".formLoginPage";
    private static String FORM_ERROR_PAGE = ".formErrorPage";
    private static String TAG_LIB_CONFIG_COUNT = ".#tagLibConfigurations";
    private static String TAG_LIB_CONFIG = "tagLibConfiguration";
    private static String LOCATION = ".location";
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$util$WebPropertiesFileConverter != null ? class$com$sun$enterprise$util$WebPropertiesFileConverter : (class$com$sun$enterprise$util$WebPropertiesFileConverter = WebPropertiesFileConverter.class$("com.sun.enterprise.util.WebPropertiesFileConverter")));
    static /* synthetic */ Class class$com$sun$enterprise$util$WebPropertiesFileConverter;

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public void convert(Properties webProperties, File xmlFile, File runtimeXmlFile) throws Exception {
        WebBundleDescriptor descriptor = new WebBundleDescriptor();
        Application application = new Application("never used", new File(""));
        application.addWebBundleDescriptor(descriptor);
        XmlDocument document = null;
        Object out = null;
        descriptor.setName(webProperties.getProperty(String.valueOf(WEB_APPLICATION) + NAME));
        descriptor.setDescription(webProperties.getProperty(String.valueOf(WEB_APPLICATION) + DESCRIPTION));
        descriptor.setSmallIconUri(webProperties.getProperty(String.valueOf(WEB_APPLICATION) + SMALL_ICON));
        descriptor.setLargeIconUri(webProperties.getProperty(String.valueOf(WEB_APPLICATION) + LARGE_ICON));
        descriptor.setContextRoot(webProperties.getProperty(String.valueOf(WEB_APPLICATION) + CONTEXT_ROOT));
        descriptor.setDistributable(new Boolean(webProperties.getProperty(String.valueOf(WEB_APPLICATION) + DISTRIBUTABLE)));
        int contextParameterCount = Integer.parseInt(webProperties.getProperty(String.valueOf(WEB_APPLICATION) + CONTEXT_PARAMETER_COUNT));
        int i2 = 0;
        while (i2 < contextParameterCount) {
            EnvironmentProperty ep2 = new EnvironmentProperty();
            String epName = webProperties.getProperty(String.valueOf(CONTEXT_PARAMETER) + i2 + NAME);
            String epValue = webProperties.getProperty(String.valueOf(CONTEXT_PARAMETER) + i2 + VALUE);
            ep2.setName(epName);
            ep2.setValue(epValue);
            descriptor.addContextParameter(ep2);
            ++i2;
        }
        int epCount = Integer.parseInt(webProperties.getProperty(String.valueOf(WEB_APPLICATION) + ENVIRONMENT_PROPERTIES));
        int i3 = 0;
        while (i3 < epCount) {
            String epName = webProperties.getProperty(String.valueOf(ENVIRONMENT_PROPERTY) + i3 + NAME);
            String epValue = webProperties.getProperty(String.valueOf(ENVIRONMENT_PROPERTY) + i3 + VALUE);
            if ("true".equals(webProperties.getProperty(String.valueOf(ENVIRONMENT_PROPERTY) + i3 + IS_RESOURCE_REFERENCE))) {
                StringTokenizer st;
                ResourceReferenceDescriptor rr = new ResourceReferenceDescriptor(epName, "", webProperties.getProperty(String.valueOf(ENVIRONMENT_PROPERTY) + i3 + TYPE));
                rr.setJndiName(epValue);
                String authorizartion = webProperties.getProperty(String.valueOf(ENVIRONMENT_PROPERTY) + i3 + AUTHORIZATION);
                rr.setAuthorization(authorizartion);
                if (ResourceReferenceDescriptor.CONTAINER_AUTHORIZATION.equals(authorizartion) && webProperties.getProperty(String.valueOf(ENVIRONMENT_PROPERTY) + i3 + DEFAULT_DB_ACCOUNT) != null) {
                    st = new StringTokenizer(webProperties.getProperty(String.valueOf(ENVIRONMENT_PROPERTY) + i3 + DEFAULT_DB_ACCOUNT), ",");
                    ResourcePrincipal rp = new ResourcePrincipal(st.nextToken(), st.nextToken());
                    rr.setResourcePrincipal(rp);
                }
                if (webProperties.getProperty(String.valueOf(ENVIRONMENT_PROPERTY) + i3 + MAIL_CONFIGURATION) != null) {
                    System.out.println(webProperties.getProperty(String.valueOf(ENVIRONMENT_PROPERTY) + i3 + MAIL_CONFIGURATION));
                    st = new StringTokenizer(webProperties.getProperty(String.valueOf(ENVIRONMENT_PROPERTY) + i3 + MAIL_CONFIGURATION), ",");
                    MailConfiguration mc = new MailConfiguration(st.nextToken(), st.nextToken(), st.nextToken());
                    rr.setMailConfiguration(mc);
                }
                descriptor.addResourceReferenceDescriptor(rr);
            } else if ("true".equals(webProperties.getProperty(String.valueOf(ENVIRONMENT_PROPERTY) + i3 + IS_EJB_REFERENCE))) {
                EjbExternalDescriptor ejb = new EjbExternalDescriptor(webProperties.getProperty(String.valueOf(ENVIRONMENT_PROPERTY) + i3 + EJB_NAME), webProperties.getProperty(String.valueOf(ENVIRONMENT_PROPERTY) + i3 + EJB_HOME), webProperties.getProperty(String.valueOf(ENVIRONMENT_PROPERTY) + i3 + EJB_REMOTE), webProperties.getProperty(String.valueOf(ENVIRONMENT_PROPERTY) + i3 + TYPE));
                EjbReferenceDescriptor erd = new EjbReferenceDescriptor(epName, "", ejb);
                erd.setJndiName(epValue);
                descriptor.addEjbReferenceDescriptor(erd);
            } else {
                EnvironmentProperty ep3 = new EnvironmentProperty(epName, epValue, "", webProperties.getProperty(String.valueOf(ENVIRONMENT_PROPERTY) + i3 + TYPE));
                descriptor.addEnvironmentEntry(ep3);
            }
            ++i3;
        }
        int webComponentCount = Integer.parseInt(webProperties.getProperty(String.valueOf(WEB_APPLICATION) + WEB_COMPONENT_COUNT));
        int webComponentIndex = 0;
        while (webComponentIndex < webComponentCount) {
            descriptor.addWebComponentDescriptor(this.convertWebComponentDescriptor(webProperties, webComponentIndex));
            ++webComponentIndex;
        }
        descriptor.setSessionTimeout(Integer.parseInt(webProperties.getProperty(String.valueOf(WEB_APPLICATION) + SESSION_TIMEOUT)));
        int mimeMappingCount = Integer.parseInt(webProperties.getProperty(String.valueOf(WEB_APPLICATION) + MIME_MAPPING_COUNT));
        int i4 = 0;
        while (i4 < mimeMappingCount) {
            MimeMappingDescriptor mmd = new MimeMappingDescriptor(webProperties.getProperty(String.valueOf(MIME_MAPPING) + i4 + EXTENSION), webProperties.getProperty(String.valueOf(MIME_MAPPING) + i4 + TYPE));
            descriptor.addMimeMapping(mmd);
            ++i4;
        }
        int welcomeFileCount = Integer.parseInt(webProperties.getProperty(String.valueOf(WEB_APPLICATION) + WELCOME_FILE_COUNT));
        int i5 = 0;
        while (i5 < welcomeFileCount) {
            descriptor.addWelcomeFile(webProperties.getProperty(String.valueOf(WELCOME_FILE) + i5 + NAME));
            ++i5;
        }
        int errorPageCount = Integer.parseInt(webProperties.getProperty(String.valueOf(WEB_APPLICATION) + ERROR_PAGE_COUNT));
        int i6 = 0;
        while (i6 < errorPageCount) {
            ErrorPageDescriptorImpl epd = new ErrorPageDescriptorImpl();
            epd.setLocation(webProperties.getProperty(String.valueOf(ERROR_PAGE) + i6 + NAME));
            String exceptionType = webProperties.getProperty(String.valueOf(ERROR_PAGE) + i6 + EXCEPTION_TYPE);
            if (exceptionType != null) {
                epd.setExceptionType(exceptionType);
            } else {
                epd.setErrorCode(Integer.parseInt(webProperties.getProperty(String.valueOf(ERROR_PAGE) + i6 + ERROR_CODE)));
            }
            descriptor.addErrorPageDescriptor(epd);
            ++i6;
        }
        RoleMapper roleMapper = application.getRoleMapper();
        int securityRoleCount = Integer.parseInt(webProperties.getProperty(String.valueOf(WEB_APPLICATION) + SECURITY_ROLE_COUNT));
        int i7 = 0;
        while (i7 < securityRoleCount) {
            SecurityRoleDescriptor srd = new SecurityRoleDescriptor(webProperties.getProperty(String.valueOf(SECURITY_ROLE) + i7 + NAME), webProperties.getProperty(String.valueOf(SECURITY_ROLE) + i7 + DESCRIPTION));
            Enumeration e10 = this.getVectorFromString(webProperties.getProperty(String.valueOf(SECURITY_ROLE) + i7 + USERS)).elements();
            while (e10.hasMoreElements()) {
                String username = (String)e10.nextElement();
                roleMapper.assignRole(new PrincipalImpl(username), new Role(srd.getName()));
            }
            Enumeration e11 = this.getVectorFromString(webProperties.getProperty(String.valueOf(SECURITY_ROLE) + i7 + GROUPS)).elements();
            while (e11.hasMoreElements()) {
                String username = (String)e11.nextElement();
                roleMapper.assignRole(new Group(username), new Role(srd.getName()));
            }
            descriptor.addSecurityRole(srd);
            ++i7;
        }
        if (webProperties.getProperty(String.valueOf(WEB_APPLICATION) + LOGIN_METHOD) != null) {
            LoginConfigurationImpl lc = new LoginConfigurationImpl();
            lc.setAuthenticationMethod(webProperties.getProperty(String.valueOf(WEB_APPLICATION) + LOGIN_METHOD));
            lc.setRealmName(webProperties.getProperty(String.valueOf(WEB_APPLICATION) + REALM));
            lc.setFormLoginPage(webProperties.getProperty(String.valueOf(WEB_APPLICATION) + FORM_LOGIN_PAGE));
            lc.setFormErrorPage(webProperties.getProperty(String.valueOf(WEB_APPLICATION) + FORM_ERROR_PAGE));
            descriptor.setLoginConfiguration(lc);
        }
        if (webProperties.getProperty(String.valueOf(WEB_APPLICATION) + SECURITY_CONSTRAINT_COUNT) != null) {
            int scCount = Integer.parseInt(webProperties.getProperty(String.valueOf(WEB_APPLICATION) + SECURITY_CONSTRAINT_COUNT));
            int i8 = 0;
            while (i8 < scCount) {
                StringTokenizer st;
                SecurityConstraintImpl sc = new SecurityConstraintImpl();
                int wrcCount = Integer.parseInt(webProperties.getProperty(String.valueOf(SECURITY_CONSTRAINT) + i8 + WEB_RESOURCE_COLLECTION_COUNT));
                int j2 = 0;
                while (j2 < wrcCount) {
                    WebResourceCollectionImpl wrc = new WebResourceCollectionImpl();
                    wrc.setName(webProperties.getProperty(String.valueOf(SECURITY_CONSTRAINT) + i8 + WEB_RESOURCE_COLLECTION + j2 + NAME));
                    st = new StringTokenizer(webProperties.getProperty(String.valueOf(SECURITY_CONSTRAINT) + i8 + WEB_RESOURCE_COLLECTION + j2 + URL_PATTERNS), ",");
                    while (st.hasMoreTokens()) {
                        wrc.addUrlPattern(st.nextToken());
                    }
                    st = new StringTokenizer(webProperties.getProperty(String.valueOf(SECURITY_CONSTRAINT) + i8 + WEB_RESOURCE_COLLECTION + j2 + HTTP_METHODS), ",");
                    while (st.hasMoreTokens()) {
                        wrc.addHttpMethod(st.nextToken());
                    }
                    sc.addWebResourceCollection(wrc);
                    ++j2;
                }
                AuthorizationConstraintImpl ac2 = new AuthorizationConstraintImpl();
                st = new StringTokenizer(webProperties.getProperty(String.valueOf(SECURITY_CONSTRAINT) + i8 + ROLE_NAMES), ",");
                while (st.hasMoreTokens()) {
                    SecurityRoleDescriptor srd = new SecurityRoleDescriptor();
                    srd.setName(st.nextToken());
                    ac2.addSecurityRole(srd);
                }
                if (ac2.getSecurityRoles().hasMoreElements()) {
                    sc.setAuthorizationConstraint(ac2);
                }
                UserDataConstraintImpl udc = new UserDataConstraintImpl();
                udc.setTransportGuarantee(webProperties.getProperty(String.valueOf(SECURITY_CONSTRAINT) + i8 + TRANSPORT_TYPE));
                sc.setUserDataConstraint(udc);
                descriptor.addSecurityConstraint(sc);
                ++i8;
            }
        }
        if (webProperties.getProperty(String.valueOf(WEB_APPLICATION) + TAG_LIB_CONFIG_COUNT) != null) {
            int tagLibConfigCount = Integer.parseInt(webProperties.getProperty(String.valueOf(WEB_APPLICATION) + TAG_LIB_CONFIG_COUNT));
            int i9 = 0;
            while (i9 < tagLibConfigCount) {
                TagLibConfigurationDescriptor tlcd = new TagLibConfigurationDescriptor(webProperties.getProperty(String.valueOf(TAG_LIB_CONFIG) + i9 + URL), webProperties.getProperty(String.valueOf(TAG_LIB_CONFIG) + i9 + LOCATION));
                descriptor.addTagLibConfig(tlcd);
                ++i9;
            }
        }
        document = WebBundleNode.getDocument(descriptor);
        XMLUtils.writeDocumentToFile(document, xmlFile);
        document = RuntimeDescriptorNode.getDocument(application);
        XMLUtils.writeDocumentToFile(document, runtimeXmlFile);
    }

    private WebComponentDescriptorImpl convertWebComponentDescriptor(Properties webProperties, int webComponentIndex) {
        WebComponentDescriptorImpl descriptor = null;
        String webComponentKey = String.valueOf(WEB_COMPONENT) + webComponentIndex;
        if (JSP_TYPE.equals(webProperties.getProperty(String.valueOf(webComponentKey) + TYPE))) {
            descriptor = new JspDescriptorImpl();
            ((JspDescriptorImpl)descriptor).setJspFileName(webProperties.getProperty(String.valueOf(webComponentKey) + JSP_FILENAME));
        } else if (SERVLET_TYPE.equals(webProperties.getProperty(String.valueOf(webComponentKey) + TYPE))) {
            descriptor = new ServletDescriptorImpl();
            ((ServletDescriptorImpl)descriptor).setClassName(webProperties.getProperty(String.valueOf(webComponentKey) + SERVLET_CLASSNAME));
        }
        descriptor.setName(webProperties.getProperty(String.valueOf(webComponentKey) + NAME));
        descriptor.setDescription(webProperties.getProperty(String.valueOf(webComponentKey) + DESCRIPTION));
        descriptor.setSmallIconUri(webProperties.getProperty(String.valueOf(webComponentKey) + SMALL_ICON));
        descriptor.setLargeIconUri(webProperties.getProperty(String.valueOf(webComponentKey) + LARGE_ICON));
        descriptor.setCanonicalName(webProperties.getProperty(String.valueOf(webComponentKey) + CANONICAL_NAME));
        if (webProperties.getProperty(String.valueOf(webComponentKey) + LOAD_ON_START_UP) != null) {
            descriptor.setLoadOnStartUp(Integer.parseInt(webProperties.getProperty(String.valueOf(webComponentKey) + LOAD_ON_START_UP)));
        }
        int initializationParameterCount = Integer.parseInt(webProperties.getProperty(String.valueOf(webComponentKey) + INITIALIZATION_PARAMETER_COUNT));
        int i2 = 0;
        while (i2 < initializationParameterCount) {
            EnvironmentProperty ep2 = new EnvironmentProperty(webProperties.getProperty(String.valueOf(webComponentKey) + INITIALIZATION_PARAMETER + i2 + NAME), webProperties.getProperty(String.valueOf(webComponentKey) + INITIALIZATION_PARAMETER + i2 + VALUE), "");
            descriptor.addInitializationParameter(ep2);
            ++i2;
        }
        int urlAliasCount = Integer.parseInt(webProperties.getProperty(String.valueOf(webComponentKey) + URL_ALIAS_COUNT));
        int i3 = 0;
        while (i3 < urlAliasCount) {
            descriptor.addUrlPattern(webProperties.getProperty(String.valueOf(webComponentKey) + URL_ALIAS + i3 + NAME));
            ++i3;
        }
        if (webProperties.getProperty(String.valueOf(webComponentKey) + SECURITY_ROLE_REFS) != null) {
            int secRoleRefsCount = Integer.parseInt(webProperties.getProperty(String.valueOf(webComponentKey) + SECURITY_ROLE_REFS));
            int i4 = 0;
            while (i4 < secRoleRefsCount) {
                RoleReference rr = new RoleReference();
                rr.setName(webProperties.getProperty(String.valueOf(webComponentKey) + SECURITY_ROLE_REF + i4 + NAME));
                rr.setValue(webProperties.getProperty(String.valueOf(webComponentKey) + SECURITY_ROLE_REF + i4 + VALUE));
                descriptor.addSecurityRoleReference(rr);
                ++i4;
            }
        }
        return descriptor;
    }

    private Vector getVectorFromString(String s2) {
        Vector<String> v2 = new Vector<String>();
        if (s2 == null) {
            return v2;
        }
        StringTokenizer st = new StringTokenizer(s2, ",");
        while (st.hasMoreElements()) {
            v2.addElement(st.nextToken());
        }
        return v2;
    }

    public static void main(String[] args) {
        if (args.length < 3) {
            System.out.println(localStrings.getLocalString("webprops.converter.usage", ""));
            System.exit(1);
        }
        File propertiesFile = new File(args[0]);
        File xmlFile = new File(args[1]);
        File runtimeXmlFile = new File(args[2]);
        try {
            FileInputStream is = new FileInputStream(propertiesFile);
            NiceProperties webProperties = new NiceProperties();
            webProperties.load(is);
            WebPropertiesFileConverter converter = new WebPropertiesFileConverter();
            converter.convert(webProperties, xmlFile, runtimeXmlFile);
        }
        catch (Exception ex2) {
            ex2.printStackTrace();
            System.exit(1);
        }
    }
}

