/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.cosnaming;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.naming.CompositeName;
import javax.naming.CompoundName;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingException;
import org.omg.CosNaming.NameComponent;

public final class CNNameParser
implements NameParser {
    private static final Properties mySyntax = new Properties();
    private static final char kindSeparator = '.';
    private static final char compSeparator = '/';
    private static final char escapeChar = '\\';

    static {
        ((Hashtable)mySyntax).put("jndi.syntax.direction", "left_to_right");
        ((Hashtable)mySyntax).put("jndi.syntax.separator", "/");
        ((Hashtable)mySyntax).put("jndi.syntax.escape", "\\");
    }

    static String cosNameToInsString(NameComponent[] nameComponentArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < nameComponentArray.length) {
            if (n2 > 0) {
                stringBuffer.append('/');
            }
            stringBuffer.append(CNNameParser.stringifyComponent(nameComponentArray[n2]));
            ++n2;
        }
        return stringBuffer.toString();
    }

    static Name cosNameToName(NameComponent[] nameComponentArray) {
        CompositeName compositeName = new CompositeName();
        int n2 = 0;
        while (nameComponentArray != null && n2 < nameComponentArray.length) {
            try {
                compositeName.add(CNNameParser.stringifyComponent(nameComponentArray[n2]));
            }
            catch (InvalidNameException invalidNameException) {}
            ++n2;
        }
        return compositeName;
    }

    private static String escape(String string) {
        if (string.indexOf(46) < 0 && string.indexOf(47) < 0 && string.indexOf(92) < 0) {
            return string;
        }
        int n2 = string.length();
        int n3 = 0;
        char[] cArray = new char[n2 + n2];
        int n4 = 0;
        while (n4 < n2) {
            if (CNNameParser.isMeta(string.charAt(n4))) {
                cArray[n3++] = 92;
            }
            cArray[n3++] = string.charAt(n4);
            ++n4;
        }
        return new String(cArray, 0, n3);
    }

    private static Vector insStringToStringifiedComps(String string) throws InvalidNameException {
        int n2 = string.length();
        Vector<String> vector = new Vector<String>(10);
        char[] cArray = new char[n2];
        char[] cArray2 = new char[n2];
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0;
            int n5 = 0;
            boolean bl2 = true;
            while (n3 < n2) {
                if (string.charAt(n3) == '/') break;
                if (string.charAt(n3) == '\\') {
                    if (n3 + 1 >= n2) {
                        throw new InvalidNameException(String.valueOf(string) + ": unescaped \\ at end of component");
                    }
                    if (CNNameParser.isMeta(string.charAt(n3 + 1))) {
                        ++n3;
                        if (bl2) {
                            cArray[n5++] = string.charAt(n3++);
                            continue;
                        }
                        cArray2[n4++] = string.charAt(n3++);
                        continue;
                    }
                    throw new InvalidNameException(String.valueOf(string) + ": invalid character being escaped");
                }
                if (bl2 && string.charAt(n3) == '.') {
                    ++n3;
                    bl2 = false;
                    continue;
                }
                if (bl2) {
                    cArray[n5++] = string.charAt(n3++);
                    continue;
                }
                cArray2[n4++] = string.charAt(n3++);
            }
            vector.addElement(CNNameParser.stringifyComponent(new NameComponent(new String(cArray, 0, n5), new String(cArray2, 0, n4))));
            if (n3 >= n2) continue;
            ++n3;
        }
        return vector;
    }

    private static boolean isMeta(char c10) {
        switch (c10) {
            case '.': 
            case '/': 
            case '\\': {
                return true;
            }
        }
        return false;
    }

    static NameComponent[] nameToCosName(Name name) throws InvalidNameException {
        int n2 = name.size();
        if (n2 == 0) {
            return new NameComponent[0];
        }
        NameComponent[] nameComponentArray = new NameComponent[n2];
        int n3 = 0;
        while (n3 < n2) {
            nameComponentArray[n3] = CNNameParser.parseComponent(name.get(n3));
            ++n3;
        }
        return nameComponentArray;
    }

    public Name parse(String string) throws NamingException {
        Vector vector = CNNameParser.insStringToStringifiedComps(string);
        return new CNCompoundName(vector.elements());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static NameComponent parseComponent(String string) throws InvalidNameException {
        NameComponent nameComponent = new NameComponent();
        int n2 = -1;
        int n3 = string.length();
        int n4 = 0;
        char[] cArray = new char[n3];
        boolean bl2 = false;
        int n5 = 0;
        while (n5 < n3 && n2 < 0) {
            if (bl2) {
                cArray[n4++] = string.charAt(n5);
                bl2 = false;
            } else if (string.charAt(n5) == '\\') {
                if (n5 + 1 >= n3) {
                    throw new InvalidNameException(String.valueOf(string) + ": unescaped \\ at end of component");
                }
                if (!CNNameParser.isMeta(string.charAt(n5 + 1))) throw new InvalidNameException(String.valueOf(string) + ": invalid character being escaped");
                bl2 = true;
            } else if (string.charAt(n5) == '.') {
                n2 = n5;
            } else {
                cArray[n4++] = string.charAt(n5);
            }
            ++n5;
        }
        nameComponent.id = new String(cArray, 0, n4);
        if (n2 < 0) {
            nameComponent.kind = "";
            return nameComponent;
        } else {
            n4 = 0;
            bl2 = false;
            int n6 = n2 + 1;
            while (n6 < n3) {
                if (bl2) {
                    cArray[n4++] = string.charAt(n6);
                    bl2 = false;
                } else if (string.charAt(n6) == '\\') {
                    if (n6 + 1 >= n3) {
                        throw new InvalidNameException(String.valueOf(string) + ": unescaped \\ at end of component");
                    }
                    if (!CNNameParser.isMeta(string.charAt(n6 + 1))) throw new InvalidNameException(String.valueOf(string) + ": invalid character being escaped");
                    bl2 = true;
                } else {
                    cArray[n4++] = string.charAt(n6);
                }
                ++n6;
            }
            nameComponent.kind = new String(cArray, 0, n4);
        }
        return nameComponent;
    }

    private static String stringifyComponent(NameComponent nameComponent) {
        StringBuffer stringBuffer = new StringBuffer(CNNameParser.escape(nameComponent.id));
        if (nameComponent.kind != null && !nameComponent.kind.equals("")) {
            stringBuffer.append(String.valueOf('.') + CNNameParser.escape(nameComponent.kind));
        }
        if (stringBuffer.length() == 0) {
            return ".";
        }
        return stringBuffer.toString();
    }

    static final class CNCompoundName
    extends CompoundName {
        CNCompoundName(Enumeration enumeration) {
            super(enumeration, mySyntax);
        }

        public Object clone() {
            return new CNCompoundName(this.getAll());
        }

        public Name getPrefix(int n2) {
            Enumeration enumeration = super.getPrefix(n2).getAll();
            return new CNCompoundName(enumeration);
        }

        public Name getSuffix(int n2) {
            Enumeration enumeration = super.getSuffix(n2).getAll();
            return new CNCompoundName(enumeration);
        }

        public String toString() {
            try {
                return CNNameParser.cosNameToInsString(CNNameParser.nameToCosName(this));
            }
            catch (InvalidNameException invalidNameException) {
                return super.toString();
            }
        }
    }
}

