/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.internal.net.DNS;

import com.sun.jndi.internal.net.DNS.DnsRequest;
import com.sun.jndi.internal.net.DNS.Packet;
import com.sun.jndi.internal.net.DNS.ResourceRecord;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;

public class DnsClient {
    private static final int IDENT_OFFSET = 0;
    private static final int FLAGS_OFFSET = 2;
    private static final int NUMQ_OFFSET = 4;
    private static final int NUMANS_OFFSET = 6;
    private static final int NUMAUTH_OFFSET = 8;
    private static final int NUMADD_OFFSET = 10;
    private static final int Q_OFFSET = 12;
    private static final int TYPE_OFFSET = 12;
    private static final int CLASS_OFFSET = 14;
    private static final int TYPE_A = 1;
    private static final int TYPE_NS = 2;
    private static final int TYPE_CNAME = 5;
    private static final int TYPE_PTR = 12;
    private static final int TYPE_TXT = 16;
    private static final int CLASS_INTERNET = 1;
    private static final int LocalDomainParts = 2;
    private static final int MaxSearchDomains = 4;
    private static final int defaultPort = 53;
    private static String[] searchDomains;
    private String domain_name;
    private int[] nameServers;
    private int nameServerPort;
    private int local_port;
    private boolean initialized;
    private DatagramSocket ds = new DatagramSocket();
    private Hashtable requests;
    private static final int QR_BIT = 32768;
    private static final int OPCODE_MASK = 30720;
    private static final int AA_BIT = 1024;
    private static final int TC_BIT = 512;
    private static final int RD_BIT = 256;
    private static final int RA_BIT = 128;
    private static final int RCODE_MASK = 15;
    private static final int QUERY_FLAGS = 256;
    private static final int DNS_HDR_SIZE = 12;
    private static final int MAX_TIMEOUTS = 4;
    private int ident;
    private static final int LOOKUP_TIMEOUT = 1000;
    private static final int LOOKUP_FLAGS = 0;
    private static boolean debug;

    static {
        debug = false;
    }

    public DnsClient(String string, String string2) throws IOException {
        InetAddress inetAddress = InetAddress.getByName(string);
        byte[] byArray = inetAddress.getAddress();
        int[] nArray = new int[]{(byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF};
        this.init(nArray, 53, string2);
    }

    private String addrToPtrName(int n2) {
        return String.valueOf(n2 & 0xFF) + "." + (n2 >>> 8 & 0xFF) + "." + (n2 >>> 16 & 0xFF) + "." + (n2 >>> 24 & 0xFF) + ".in-addr.arpa";
    }

    private void doQuery(DnsRequest dnsRequest, byte[] byArray, int n2, int n3) {
        Packet packet = null;
        int n4 = 12 + n2 + 4;
        DnsClient.dprint("doQuery");
        try {
            packet = new Packet(new byte[n4], n4);
            dnsRequest.xid = new Integer(++this.ident);
            dnsRequest.have_reply = false;
            dnsRequest.answers = null;
            packet.putShort(dnsRequest.xid, 0);
            packet.putShort(256, 2);
            packet.putShort(1, 4);
            packet.putShort(0, 6);
            packet.putInt(0, 8);
            packet.putBytes(byArray, 0, 12, n2);
            packet.putShort(n3, 12 + n2);
            packet.putShort(1, 14 + n2);
            int n5 = 0;
            while (n5 < 4) {
                int n6 = 0;
                while (n6 < this.nameServers.length) {
                    int n7;
                    block14: {
                        block13: {
                            DnsClient.dprint("sending query length:" + n4);
                            n7 = packet.getHeaderOffset();
                            int n8 = this.nameServers[n6];
                            try {
                                InetAddress inetAddress = InetAddress.getByName(String.valueOf(n8 >> 24 & 0xFF) + "." + (n8 >> 16 & 0xFF) + "." + (n8 >> 8 & 0xFF) + "." + (n8 & 0xFF));
                                DatagramPacket datagramPacket = new DatagramPacket(packet.buf, n4, inetAddress, this.nameServerPort);
                                this.ds.send(datagramPacket);
                                this.ds.setSoTimeout(1000 * (1 << n5));
                                DatagramPacket datagramPacket2 = new DatagramPacket(new byte[8000], 8000);
                                this.ds.receive(datagramPacket2);
                                this.input(new Packet(datagramPacket2.getData(), datagramPacket2.getLength()), dnsRequest);
                            }
                            catch (IOException iOException) {}
                            if (dnsRequest.have_reply) break block13;
                            if (this.initialized) break block14;
                        }
                        Object var8_14 = null;
                        if (packet != null) {
                            packet.recycle();
                        }
                        return;
                    }
                    packet.setHeaderOffset(n7);
                    ++n6;
                }
                ++n5;
            }
        }
        catch (Throwable throwable) {
            Object var8_16 = null;
            if (packet != null) {
                packet.recycle();
            }
            throw throwable;
        }
        Object var8_15 = null;
        if (packet != null) {
            packet.recycle();
        }
    }

    static void dprint(String string) {
        if (debug) {
            DnsClient.err(string);
        }
    }

    private static void err(String string) {
        System.err.println("DNS: " + string);
    }

    private void init(int[] nArray, int n2, String string) {
        this.nameServers = nArray;
        this.nameServerPort = n2;
        string = "." + string;
        int n3 = 0;
        int n4 = 0;
        while ((n3 = string.indexOf(46, n3 + 1)) != -1) {
            ++n4;
        }
        int n5 = n4 + 3 - 2;
        searchDomains = new String[n5];
        DnsClient.searchDomains[0] = string;
        n3 = 0;
        int n6 = 1;
        while (n6 < n5) {
            if ((n3 = searchDomains[n6 - 1].indexOf(46, n3 + 1)) == -1) break;
            DnsClient.searchDomains[n6] = searchDomains[n6 - 1].substring(n3);
            ++n6;
        }
        DnsClient.searchDomains[n5 - 1] = "";
        this.initialized = true;
    }

    public void input(Packet packet, DnsRequest dnsRequest) {
        if (!this.initialized) {
            return;
        }
        int n2 = packet.getHeaderOffset();
        Integer n3 = new Integer(packet.getShort(0));
        DnsClient.dprint("got ident:" + n3);
        if (dnsRequest == null) {
            return;
        }
        int n4 = packet.getShort(2);
        if ((n4 & 0x8000) == 0) {
            DnsClient.dprint("reply not a response, flags: 0x");
            return;
        }
        dnsRequest.rcode = n4 & 0xF;
        DnsClient.dprint("got rcode: " + dnsRequest.rcode);
        if (dnsRequest.rcode == 0) {
            int n5 = packet.getShort(4);
            int n6 = packet.getShort(6);
            DnsClient.dprint("questions: " + n5 + " answers: " + n6);
            packet.shiftHeader(12);
            while (n5 > 0) {
                DnsClient.dprint("skipping question");
                this.skipQuery(packet);
                --n5;
            }
            if (n6 > 0) {
                dnsRequest.answers = new ResourceRecord[n6];
                int n7 = 0;
                while (n7 < n6) {
                    dnsRequest.answers[n7] = new ResourceRecord(packet, n2);
                    ++n7;
                }
            } else {
                DnsClient.dprint("no answer RR's");
                dnsRequest.rcode = 3;
                dnsRequest.answers = null;
            }
        }
        dnsRequest.have_reply = true;
    }

    public String lookup(int n2) {
        byte[] byArray;
        if (!this.initialized) {
            return null;
        }
        String string = this.addrToPtrName(n2);
        int n3 = this.makeQueryName(string, byArray = new byte[string.length() + 2]);
        if (n3 == 0) {
            DnsClient.err("error making pointer query name");
            return null;
        }
        DnsRequest dnsRequest = new DnsRequest();
        this.doQuery(dnsRequest, byArray, n3, 12);
        if (!dnsRequest.have_reply) {
            return null;
        }
        if (dnsRequest.answers == null) {
            return null;
        }
        return (String)dnsRequest.answers[0].answer;
    }

    public InetAddress[] lookup(String string) {
        byte[][] byArray = this.lookup(string, 1);
        if (byArray == null) {
            return null;
        }
        InetAddress[] inetAddressArray = new InetAddress[byArray.length];
        int n2 = 0;
        while (n2 < byArray.length) {
            byte[] byArray2 = byArray[n2];
            try {
                inetAddressArray[n2] = InetAddress.getByName(String.valueOf(byArray2[0] & 0xFF) + "." + (byArray2[1] & 0xFF) + "." + (byArray2[2] & 0xFF) + "." + (byArray2[3] & 0xFF));
            }
            catch (UnknownHostException unknownHostException) {
                return null;
            }
            ++n2;
        }
        return inetAddressArray;
    }

    private byte[][] lookup(String string, int n2) {
        int n3;
        int n4;
        int n5;
        if (!this.initialized) {
            DnsClient.dprint("not initialized");
            return null;
        }
        byte[] byArray = new byte[string.length() + searchDomains[0].length() + 2];
        Object var4_4 = null;
        DnsRequest dnsRequest = new DnsRequest();
        if (string.indexOf(46) >= 0) {
            n5 = searchDomains.length - 1;
            n4 = -1;
        } else {
            n5 = 0;
            n4 = 1;
        }
        int n6 = 0;
        while (n6 < searchDomains.length) {
            n3 = this.makeQueryName(String.valueOf(string) + searchDomains[n5], byArray);
            if (n3 == 0) {
                DnsClient.err("error making query name");
                return null;
            }
            this.doQuery(dnsRequest, byArray, n3, n2);
            if (!dnsRequest.have_reply) {
                DnsClient.dprint("have_reply is false");
                return null;
            }
            if (dnsRequest.rcode == 0) break;
            ++n6;
            n5 += n4;
        }
        if (dnsRequest.answers == null) {
            DnsClient.dprint("answers is null");
            return null;
        }
        n3 = 0;
        int n7 = 0;
        while (n7 < dnsRequest.answers.length) {
            if (dnsRequest.answers[n7].type == n2) {
                ++n3;
            }
            ++n7;
        }
        byte[][] byArray2 = new byte[n3][];
        int n8 = 0;
        int n9 = 0;
        while (n8 < dnsRequest.answers.length) {
            if (dnsRequest.answers[n8].type == n2) {
                byArray2[n9++] = (byte[])dnsRequest.answers[n8].answer;
            }
            ++n8;
        }
        if (byArray2 == null) {
            DnsClient.dprint("result is null");
        }
        return byArray2;
    }

    public String[] lookup_txt(String string) {
        byte[][] byArray = this.lookup(string, 16);
        if (byArray == null) {
            return null;
        }
        String[] stringArray = new String[byArray.length];
        int n2 = 0;
        while (n2 < byArray.length) {
            stringArray[n2] = new String(byArray[n2]);
            ++n2;
        }
        return stringArray;
    }

    private int makeQueryName(String string, byte[] byArray) {
        byte[] byArray2;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        try {
            byArray2 = string.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return 0;
        }
        boolean bl2 = false;
        while (!bl2) {
            if ((n2 = string.indexOf(46, n2)) == -1) {
                n2 = string.length();
                bl2 = true;
            }
            int n5 = n2 - n3;
            byArray[n4] = (byte)n5;
            System.arraycopy(byArray2, n3, byArray, ++n4, n2 - n3);
            n4 += n5;
            if (n2 == -1) break;
            n3 = ++n2;
        }
        byArray[n4++] = 0;
        return n4;
    }

    public static void setDebug(boolean bl2) {
        debug = bl2;
    }

    private void skipQuery(Packet packet) {
        int n2;
        int n3 = 0;
        while ((n2 = packet.getByte(n3++)) != 0) {
            n3 += n2;
        }
        packet.shiftHeader(n3 += 4);
    }
}

