/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.internal.net.DNS;

import com.sun.jndi.internal.net.DNS.DnsClient;

class Packet {
    byte[] buf;
    int index;

    Packet(byte[] byArray, int n2) {
        this.buf = new byte[n2];
        System.arraycopy(byArray, 0, this.buf, 0, n2);
        this.index = 0;
    }

    int getByte(int n2) {
        if (this.index + n2 >= this.buf.length) {
            DnsClient.dprint("index " + this.index + ", offset " + n2 + ", >= length " + this.buf.length);
        }
        return this.buf[this.index + n2] & 0xFF;
    }

    int getHeaderOffset() {
        return this.index;
    }

    int getInt(int n2) {
        return this.getShort(n2) << 16 | this.getShort(n2 + 2);
    }

    int getShort(int n2) {
        return (this.buf[this.index + n2] & 0xFF) << 8 | this.buf[this.index + n2 + 1] & 0xFF;
    }

    void putByte(int n2, int n3) {
        this.buf[this.index + n3] = (byte)n2;
    }

    void putBytes(byte[] byArray, int n2, int n3, int n4) {
        System.arraycopy(byArray, n2, this.buf, this.index + n3, n4);
    }

    void putInt(int n2, int n3) {
        this.buf[this.index + n3] = (byte)(n2 >> 24);
        this.buf[this.index + n3 + 1] = (byte)(n2 >> 16);
        this.buf[this.index + n3 + 2] = (byte)(n2 >> 8);
        this.buf[this.index + n3 + 3] = (byte)n2;
    }

    void putShort(int n2, int n3) {
        this.buf[this.index + n3] = (byte)(n2 >> 8);
        this.buf[this.index + n3 + 1] = (byte)n2;
    }

    void recycle() {
    }

    void setHeaderOffset(int n2) {
        this.index = n2;
    }

    void shiftHeader(int n2) {
        this.index += n2;
    }
}

