/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.CosTransactions;

import com.sun.jts.CosTransactions.CompletionHandler;
import com.sun.jts.CosTransactions.Configuration;
import com.sun.jts.CosTransactions.ControlImpl;
import com.sun.jts.CosTransactions.CoordinatorImpl;
import com.sun.jts.CosTransactions.CurrentTransaction;
import com.sun.jts.CosTransactions.ErrorLog;
import com.sun.jts.CosTransactions.GlobalTID;
import com.sun.jts.CosTransactions.LogicErrorException;
import com.sun.jts.CosTransactions.TopCoordinator;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.INVALID_TRANSACTION;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.NotPrepared;
import org.omg.CosTransactions.Status;
import org.omg.CosTransactions.Unavailable;
import org.omg.CosTransactions.Vote;

class CoordinatorTerm
implements CompletionHandler {
    private CoordinatorImpl coordinator = null;
    private boolean subtransaction = false;
    private boolean aborted = false;
    private boolean heuristicDamage = false;
    private boolean completed = false;
    private boolean completing = false;

    CoordinatorTerm() {
    }

    CoordinatorTerm(CoordinatorImpl coord, boolean subtran) {
        this.coordinator = coord;
        this.subtransaction = subtran;
        if (this.coordinator != null) {
            this.coordinator.setTerminator(this);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void commit(boolean promptReturn) throws HeuristicMixed, HeuristicHazard, TRANSACTION_ROLLEDBACK, SystemException, LogicErrorException {
        Throwable heuristicExc;
        Status status;
        boolean sameCoordinator;
        ControlImpl current;
        block50: {
            boolean commit_one_phase_worked_ok;
            block48: {
                block47: {
                    commit_one_phase_worked_ok = true;
                    if (this.aborted) {
                        throw new TRANSACTION_ROLLEDBACK(0, CompletionStatus.COMPLETED_NO);
                    }
                    if (this.coordinator == null) {
                        LogicErrorException exc = new LogicErrorException(ErrorLog.getMessage(57));
                        throw exc;
                    }
                    this.completing = true;
                    current = CurrentTransaction.getCurrent();
                    ControlImpl establishedControl = null;
                    Coordinator currentCoord = null;
                    sameCoordinator = false;
                    if (current != null) {
                        try {
                            currentCoord = Configuration.isLocalFactory() ? current.get_localCoordinator() : current.get_coordinator();
                            sameCoordinator = this.coordinator.is_same_transaction(currentCoord);
                        }
                        catch (Unavailable unavailable) {}
                    }
                    if (!this.subtransaction) {
                        try {
                            if (current == null || !sameCoordinator) {
                                establishedControl = new ControlImpl(null, this.coordinator, new GlobalTID(this.coordinator.getGlobalTID()), new Long(this.coordinator.getLocalTID()));
                                CurrentTransaction.setCurrent(establishedControl, true);
                            }
                        }
                        catch (Throwable throwable) {}
                        try {
                            try {
                                ((TopCoordinator)this.coordinator).beforeCompletion();
                            }
                            catch (SystemException exc) {
                                this.completing = false;
                                throw exc;
                            }
                            Object var8_11 = null;
                            if (establishedControl == null) break block47;
                        }
                        catch (Throwable throwable) {
                            Object var8_12 = null;
                            if (establishedControl != null) {
                                CurrentTransaction.endCurrent(true);
                                establishedControl.finalize();
                            }
                            throw throwable;
                        }
                        CurrentTransaction.endCurrent(true);
                        establishedControl.finalize();
                    }
                }
                status = Status.StatusCommitted;
                if (sameCoordinator) {
                    CurrentTransaction.endCurrent(true);
                }
                heuristicExc = null;
                try {
                    commit_one_phase_worked_ok = this.coordinator.commitOnePhase();
                }
                catch (Throwable exc) {
                    if (exc instanceof HeuristicHazard || exc instanceof HeuristicMixed) {
                        heuristicExc = exc;
                    } else if (exc instanceof TRANSACTION_ROLLEDBACK) {
                        status = Status.StatusRolledBack;
                    } else if (exc instanceof INVALID_TRANSACTION) {
                        throw (INVALID_TRANSACTION)exc;
                    }
                    if (!(exc instanceof INTERNAL)) break block48;
                    throw (INTERNAL)exc;
                }
            }
            if (commit_one_phase_worked_ok) {
                status = Status.StatusCommitted;
            } else {
                Vote prepareResult = Vote.VoteRollback;
                try {
                    prepareResult = this.coordinator.prepare();
                }
                catch (HeuristicHazard exc) {
                    heuristicExc = exc;
                }
                catch (HeuristicMixed exc) {
                    heuristicExc = exc;
                }
                catch (INVALID_TRANSACTION exc) {
                    throw exc;
                }
                catch (Throwable throwable) {}
                if (this.subtransaction) {
                    if (prepareResult == Vote.VoteCommit) {
                        try {
                            this.coordinator.commit();
                        }
                        catch (NotPrepared notPrepared) {
                            prepareResult = Vote.VoteRollback;
                        }
                    }
                    if (prepareResult == Vote.VoteRollback) {
                        this.coordinator.rollback(true);
                        status = Status.StatusRolledBack;
                    }
                } else {
                    try {
                        if (prepareResult == Vote.VoteCommit) {
                            try {
                                this.coordinator.commit();
                            }
                            catch (NotPrepared notPrepared) {
                                prepareResult = Vote.VoteRollback;
                            }
                        }
                        if (prepareResult == Vote.VoteRollback && heuristicExc == null) {
                            status = Status.StatusRolledBack;
                            this.coordinator.rollback(true);
                        }
                    }
                    catch (Throwable exc) {
                        if (exc instanceof HeuristicHazard || exc instanceof HeuristicMixed) {
                            heuristicExc = exc;
                        }
                        if (!(exc instanceof INTERNAL)) break block50;
                        throw (INTERNAL)exc;
                    }
                }
            }
        }
        if (!this.subtransaction) {
            ((TopCoordinator)this.coordinator).afterCompletion(status);
        }
        this.completed = true;
        if (current != null && sameCoordinator) {
            current.setTranState(status);
        }
        if (heuristicExc != null) {
            if (heuristicExc instanceof HeuristicMixed) {
                throw (HeuristicMixed)heuristicExc;
            }
            throw (HeuristicHazard)heuristicExc;
        }
        if (status == Status.StatusRolledBack) {
            TRANSACTION_ROLLEDBACK exc = new TRANSACTION_ROLLEDBACK(0, CompletionStatus.COMPLETED_YES);
            throw exc;
        }
    }

    void dump() {
    }

    public void finalize() {
        if (!this.completed) {
            this.completing = true;
            try {
                this.coordinator.rollback(true);
            }
            catch (Throwable throwable) {}
            if (!this.subtransaction) {
                ((TopCoordinator)this.coordinator).afterCompletion(Status.StatusRolledBack);
            }
        }
        this.coordinator = null;
    }

    void rollback() throws HeuristicMixed, HeuristicHazard, SystemException, LogicErrorException {
        if (this.aborted) {
            TRANSACTION_ROLLEDBACK exc = new TRANSACTION_ROLLEDBACK(0, CompletionStatus.COMPLETED_NO);
            throw exc;
        }
        if (this.coordinator == null) {
            LogicErrorException exc = new LogicErrorException(ErrorLog.getMessage(57));
            throw exc;
        }
        Coordinator currentCoord = null;
        ControlImpl current = null;
        this.completing = true;
        try {
            current = CurrentTransaction.getCurrent();
        }
        catch (Throwable throwable) {}
        if (current != null) {
            try {
                currentCoord = Configuration.isLocalFactory() ? current.get_localCoordinator() : current.get_coordinator();
                if (this.coordinator.is_same_transaction(currentCoord)) {
                    CurrentTransaction.endCurrent(true);
                }
            }
            catch (Throwable throwable) {
                CurrentTransaction.endCurrent(true);
            }
        }
        Throwable heuristicExc = null;
        try {
            block18: {
                try {
                    this.coordinator.rollback(true);
                }
                catch (Throwable exc) {
                    if (exc instanceof HeuristicHazard || exc instanceof HeuristicMixed) {
                        heuristicExc = exc;
                    }
                    if (!(exc instanceof INTERNAL)) break block18;
                    throw (INTERNAL)exc;
                }
            }
            Object var5_7 = null;
            if (!this.subtransaction) {
                ((TopCoordinator)this.coordinator).afterCompletion(Status.StatusRolledBack);
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            if (!this.subtransaction) {
                ((TopCoordinator)this.coordinator).afterCompletion(Status.StatusRolledBack);
            }
            throw throwable;
        }
        this.completed = true;
        if (current != null) {
            current.setTranState(Status.StatusRolledBack);
        }
        if (heuristicExc != null) {
            if (heuristicExc instanceof HeuristicMixed) {
                throw (HeuristicMixed)heuristicExc;
            }
            throw (HeuristicHazard)heuristicExc;
        }
    }

    public void setCompleted(boolean aborted, boolean heuristicDamage) {
        if (!this.completing) {
            this.completed = true;
            this.aborted = aborted;
            this.heuristicDamage = heuristicDamage;
            if (this.coordinator != null && !this.subtransaction) {
                ((TopCoordinator)this.coordinator).afterCompletion(Status.StatusRolledBack);
            }
        }
    }
}

