/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.utils.RecoveryHooks;

import com.sun.jts.CosTransactions.GlobalTID;
import com.sun.jts.jtsxa.Utility;
import com.sun.jts.otsidl.JCoordinator;
import com.sun.jts.otsidl.JCoordinatorHelper;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.ResourceBundle;
import org.omg.CosTransactions.Coordinator;

public class FailureInducer {
    public static final Integer ACTIVE = new Integer(0);
    public static final Integer PREPARING = new Integer(1);
    public static final Integer PREPARED = new Integer(2);
    public static final Integer COMPLETING = new Integer(3);
    public static final Integer COMPLETED = new Integer(4);
    private static boolean failureInducerIsActive = false;
    private static boolean crash = false;
    private static int waitPeriod = 0;
    private static int waitCount = 0;
    private static Hashtable crashList = new Hashtable();
    private static Hashtable waitList = new Hashtable();
    private static Hashtable waitTime = new Hashtable();
    private static ResourceBundle messages = ResourceBundle.getBundle("com.sun.jts.utils.RecoveryHooks.Messages");

    public static void activateFailureInducer() {
        failureInducerIsActive = true;
    }

    public static void crash() {
        crash = true;
    }

    public static void deactivateFailureInducer() {
        failureInducerIsActive = false;
    }

    private static String getMessage(String key) {
        return FailureInducer.getMessage(key, null);
    }

    private static String getMessage(String key, Object[] inserts) {
        if (messages == null || key == null) {
            return null;
        }
        String msg = messages.getString(key);
        if (msg == null) {
            return null;
        }
        if (inserts == null) {
            return msg;
        }
        return MessageFormat.format(msg, inserts);
    }

    public static int getWaitCount() {
        return waitCount;
    }

    private static void incrementWaitCount() {
        ++waitCount;
    }

    public static boolean isFailureInducerActive() {
        return failureInducerIsActive;
    }

    public static void setCrashPoint(Integer crashPoint) {
        if (crashPoint == null) {
            System.err.println(FailureInducer.getMessage("invalid_crash_point"));
            return;
        }
        Coordinator coord = Utility.getCoordinator(Utility.getControl());
        JCoordinator jcoord = JCoordinatorHelper.narrow(coord);
        if (jcoord != null) {
            GlobalTID gtid = new GlobalTID(jcoord.getGlobalTID());
            crashList.put(gtid, crashPoint);
        }
    }

    public static void setWaitPoint(Integer waitPoint, int waitDuration) {
        if (waitPoint == null) {
            System.err.println(FailureInducer.getMessage("invalid_wait_point"));
            return;
        }
        Coordinator coord = Utility.getCoordinator(Utility.getControl());
        JCoordinator jcoord = JCoordinatorHelper.narrow(coord);
        if (jcoord != null) {
            GlobalTID gtid = new GlobalTID(jcoord.getGlobalTID());
            waitList.put(gtid, waitPoint);
            waitTime.put(gtid, new Integer(waitDuration));
        }
    }

    public static void waitForFailure(GlobalTID gtid, Integer failPoint) {
        block9: {
            if (gtid == null) {
                return;
            }
            Integer crashPoint = (Integer)crashList.get(gtid);
            Integer waitPoint = (Integer)waitList.get(gtid);
            if (crashPoint == null && waitPoint == null) {
                return;
            }
            System.out.println(FailureInducer.getMessage("tx_progress", new Object[]{failPoint}));
            if (crashPoint != null && crashPoint.equals(failPoint)) {
                FailureInducer.incrementWaitCount();
                while (!crash) {
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (Exception exception) {}
                }
                System.exit(0);
            }
            if (waitPoint == null || !waitPoint.equals(failPoint)) break block9;
            Integer waitDuration = (Integer)waitTime.get(gtid);
            if (waitDuration == null || waitDuration < 0) {
                return;
            }
            try {
                Thread.sleep(waitDuration * 1000);
            }
            catch (Exception exception) {}
        }
    }
}

