/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap;

import com.sun.mail.iap.BadCommandException;
import com.sun.mail.iap.CommandFailedException;
import com.sun.mail.iap.ConnectionException;
import com.sun.mail.iap.ProtocolException;
import com.sun.mail.iap.Response;
import com.sun.mail.iap.ResponseHandler;
import com.sun.mail.imap.DefaultFolder;
import com.sun.mail.imap.IMAPMessage;
import com.sun.mail.imap.IMAPStore;
import com.sun.mail.imap.Utility;
import com.sun.mail.imap.protocol.FetchResponse;
import com.sun.mail.imap.protocol.IMAPProtocol;
import com.sun.mail.imap.protocol.IMAPResponse;
import com.sun.mail.imap.protocol.ListInfo;
import com.sun.mail.imap.protocol.MailboxInfo;
import com.sun.mail.imap.protocol.Status;
import com.sun.mail.imap.protocol.UID;
import com.sun.mail.util.CRLFOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.mail.FetchProfile;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.FolderClosedException;
import javax.mail.FolderNotFoundException;
import javax.mail.Message;
import javax.mail.MessageRemovedException;
import javax.mail.MessagingException;
import javax.mail.StoreClosedException;
import javax.mail.UIDFolder;
import javax.mail.search.FlagTerm;
import javax.mail.search.SearchException;
import javax.mail.search.SearchTerm;

public class IMAPFolder
extends Folder
implements UIDFolder,
ResponseHandler {
    protected String fullName;
    protected String name;
    protected int type;
    protected char separator;
    protected Flags availableFlags;
    protected Flags permanentFlags;
    protected boolean exists = false;
    protected IMAPProtocol protocol;
    protected Vector messageCache;
    protected Object messageCacheLock;
    protected Hashtable uidTable;
    protected static final char UNKNOWN_SEPARATOR = '\uffff';
    private boolean opened = false;
    private boolean reallyClosed = true;
    private int total = -1;
    private int recent = -1;
    private int realTotal = -1;
    private int uidvalidity = -1;
    private boolean doExpungeNotification = true;
    static /* synthetic */ Class class$javax$mail$Flags;

    protected IMAPFolder(ListInfo listInfo, IMAPStore iMAPStore) {
        this(listInfo.name, listInfo.separator, iMAPStore);
        if (listInfo.hasInferiors) {
            this.type |= 2;
        }
        if (listInfo.canOpen) {
            this.type |= 1;
        }
        this.exists = true;
    }

    protected IMAPFolder(String string, char c10, IMAPStore iMAPStore) {
        super(iMAPStore);
        this.fullName = string;
        this.separator = c10;
        this.messageCacheLock = new Object();
    }

    public void appendMessages(Message[] messageArray) throws MessagingException {
        this.checkExists();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        CRLFOutputStream cRLFOutputStream = new CRLFOutputStream(byteArrayOutputStream);
        IMAPProtocol iMAPProtocol = this.storeProtocol();
        int n2 = 0;
        while (n2 < messageArray.length) {
            block11: {
                Message message = messageArray[n2];
                try {
                    message.writeTo(cRLFOutputStream);
                }
                catch (IOException iOException) {
                    throw new MessagingException("IOException while appending messages", iOException);
                }
                catch (MessageRemovedException messageRemovedException) {
                    break block11;
                }
                Object object = this.messageCacheLock;
                synchronized (object) {
                    try {
                        Date date = message.getReceivedDate();
                        if (date == null) {
                            date = message.getSentDate();
                        }
                        iMAPProtocol.append(this.fullName, date, byteArrayOutputStream);
                    }
                    catch (ConnectionException connectionException) {
                        throw new StoreClosedException(this.store, connectionException.getMessage());
                    }
                    catch (ProtocolException protocolException) {
                        throw new MessagingException(protocolException.getMessage(), protocolException);
                    }
                }
                byteArrayOutputStream.reset();
            }
            ++n2;
        }
    }

    private void checkClosed() {
        if (this.opened) {
            throw new IllegalStateException("This operation is not allowed on an open folder");
        }
    }

    private void checkExists() throws MessagingException {
        if (!this.exists && !this.exists()) {
            throw new FolderNotFoundException(String.valueOf(this.fullName) + " not found", this);
        }
    }

    private void checkFlags(Flags flags) throws MessagingException {
        if (this.mode != 2) {
            throw new IllegalStateException("Cannot change flags on READ_ONLY folder: " + this.fullName);
        }
        if (!this.availableFlags.contains(flags)) {
            throw new MessagingException("These flags are not supported by this implementation");
        }
    }

    private void checkOpened() throws FolderClosedException {
        if (!this.opened) {
            if (this.reallyClosed) {
                throw new IllegalStateException("This operation is not allowed on a closed folder");
            }
            throw new FolderClosedException(this, "Lost folder connection to server");
        }
    }

    private void checkRange(int n2) throws MessagingException {
        if (n2 < 1) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 <= this.total) {
            return;
        }
        Object object = this.messageCacheLock;
        synchronized (object) {
            try {
                this.protocol.noop();
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException(this, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
        if (n2 > this.total) {
            throw new IndexOutOfBoundsException();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private void cleanup() {
        this.protocol = null;
        this.messageCache = null;
        this.exists = false;
        this.opened = false;
        this.notifyConnectionListeners(3);
    }

    public void close(boolean bl2) throws MessagingException {
        Object object = this.messageCacheLock;
        synchronized (object) {
            this.reallyClosed = true;
            if (!this.opened) {
                Object var3_3 = null;
                return;
            }
            try {
                try {
                    if (bl2) {
                        this.protocol.close();
                    }
                    this.protocol.logout();
                }
                catch (ProtocolException protocolException) {
                    throw new MessagingException(protocolException.getMessage(), protocolException);
                }
                Object var5_5 = null;
                this.cleanup();
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.cleanup();
                throw throwable;
            }
        }
    }

    public void copyMessages(Message[] messageArray, Folder folder) throws MessagingException {
        this.checkOpened();
        if (messageArray.length == 0) {
            return;
        }
        if (folder.getStore() == this.store) {
            Object object = this.messageCacheLock;
            synchronized (object) {
                try {
                    this.protocol.copy(Utility.toMessageSet(messageArray, null), folder.getFullName());
                }
                catch (CommandFailedException commandFailedException) {
                    if (commandFailedException.getMessage().indexOf("TRYCREATE") != -1) {
                        throw new FolderNotFoundException(String.valueOf(folder.getFullName()) + " does not exist", folder);
                    }
                    throw new MessagingException(commandFailedException.getMessage(), commandFailedException);
                }
                catch (ConnectionException connectionException) {
                    throw new FolderClosedException(this, connectionException.getMessage());
                }
                catch (ProtocolException protocolException) {
                    throw new MessagingException(protocolException.getMessage(), protocolException);
                }
            }
        }
        super.copyMessages(messageArray, folder);
    }

    public synchronized boolean create(int n2) throws MessagingException {
        try {
            if ((n2 & 1) == 0) {
                this.storeProtocol().create(String.valueOf(this.fullName) + this.getSeparator());
            } else {
                ListInfo[] listInfoArray;
                this.storeProtocol().create(this.fullName);
                if ((n2 & 2) != 0 && (listInfoArray = this.storeProtocol().list("", this.fullName)) != null && !listInfoArray[0].hasInferiors) {
                    this.storeProtocol().delete(this.fullName);
                    throw new MessagingException("Unsupported type");
                }
            }
        }
        catch (CommandFailedException commandFailedException) {
            return false;
        }
        catch (ConnectionException connectionException) {
            throw new StoreClosedException(this.store, connectionException.getMessage());
        }
        catch (ProtocolException protocolException) {
            throw new MessagingException(protocolException.getMessage(), protocolException);
        }
        this.exists = true;
        this.type = n2;
        this.notifyFolderListeners(1);
        return true;
    }

    public synchronized boolean delete(boolean bl2) throws MessagingException {
        this.checkClosed();
        if (bl2) {
            Folder[] folderArray = this.list();
            int n2 = 0;
            while (n2 < folderArray.length) {
                folderArray[n2].delete(bl2);
                ++n2;
            }
        }
        try {
            this.storeProtocol().delete(this.fullName);
            this.exists = false;
            this.notifyFolderListeners(2);
            return true;
        }
        catch (CommandFailedException commandFailedException) {
            return false;
        }
        catch (ConnectionException connectionException) {
            throw new StoreClosedException(this.store, connectionException.getMessage());
        }
        catch (ProtocolException protocolException) {
            throw new MessagingException(protocolException.getMessage(), protocolException);
        }
    }

    private Folder[] doList(String string, boolean bl2) throws MessagingException {
        this.checkExists();
        if (!this.isDirectory()) {
            return new Folder[0];
        }
        ListInfo[] listInfoArray = null;
        char c10 = this.getSeparator();
        try {
            listInfoArray = bl2 ? this.storeProtocol().lsub("", String.valueOf(this.fullName) + c10 + string) : this.storeProtocol().list("", String.valueOf(this.fullName) + c10 + string);
        }
        catch (CommandFailedException commandFailedException) {
        }
        catch (ConnectionException connectionException) {
            throw new StoreClosedException(this.store, connectionException.getMessage());
        }
        catch (ProtocolException protocolException) {
            throw new MessagingException(protocolException.getMessage(), protocolException);
        }
        if (listInfoArray == null) {
            return new Folder[0];
        }
        int n2 = 0;
        if (listInfoArray[0].name.equals(String.valueOf(this.fullName) + c10)) {
            n2 = 1;
        }
        Folder[] folderArray = new IMAPFolder[listInfoArray.length - n2];
        int n3 = n2;
        while (n3 < listInfoArray.length) {
            folderArray[n3 - n2] = new IMAPFolder(listInfoArray[n3], (IMAPStore)this.store);
            ++n3;
        }
        return folderArray;
    }

    public boolean exists() throws MessagingException {
        ListInfo[] listInfoArray = null;
        try {
            listInfoArray = this.storeProtocol().list("", this.fullName);
        }
        catch (ConnectionException connectionException) {
            throw new StoreClosedException(this.store, connectionException.getMessage());
        }
        catch (ProtocolException protocolException) {
            throw new MessagingException(protocolException.getMessage(), protocolException);
        }
        if (listInfoArray != null) {
            this.fullName = listInfoArray[0].name;
            this.separator = listInfoArray[0].separator;
            if (listInfoArray[0].hasInferiors) {
                this.type |= 2;
            }
            if (listInfoArray[0].canOpen) {
                this.type |= 1;
            }
            this.exists = true;
        } else {
            this.exists = false;
        }
        return this.exists;
    }

    public synchronized Message[] expunge() throws MessagingException {
        this.checkOpened();
        Vector<IMAPMessage> vector = new Vector<IMAPMessage>();
        Object[] objectArray = this.messageCacheLock;
        synchronized (objectArray) {
            IMAPMessage iMAPMessage;
            this.doExpungeNotification = false;
            try {
                try {
                    this.protocol.expunge();
                }
                catch (CommandFailedException commandFailedException) {
                }
                catch (ConnectionException connectionException) {
                    throw new FolderClosedException(this, connectionException.getMessage());
                }
                catch (ProtocolException protocolException) {
                    throw new MessagingException(protocolException.getMessage(), protocolException);
                }
                iMAPMessage = null;
                this.doExpungeNotification = true;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                this.doExpungeNotification = true;
                throw throwable;
            }
            int n2 = 0;
            while (n2 < this.messageCache.size()) {
                iMAPMessage = (IMAPMessage)this.messageCache.elementAt(n2);
                if (iMAPMessage.isExpunged()) {
                    long l2;
                    vector.addElement(iMAPMessage);
                    this.messageCache.removeElementAt(n2);
                    if (this.uidTable == null || (l2 = iMAPMessage.getUID()) == -1L) continue;
                    this.uidTable.remove(new Long(l2));
                    continue;
                }
                iMAPMessage.setMessageNumber(iMAPMessage.getSequenceNumber());
                ++n2;
            }
        }
        this.total = this.messageCache.size();
        objectArray = new Message[vector.size()];
        vector.copyInto(objectArray);
        if (objectArray.length > 0) {
            this.notifyMessageRemovedListeners(true, (Message[])objectArray);
        }
        return objectArray;
    }

    public void fetch(Message[] messageArray, FetchProfile fetchProfile) throws MessagingException {
        this.checkOpened();
        IMAPMessage.fetch(this, messageArray, fetchProfile);
    }

    public Folder getFolder(String string) throws MessagingException {
        if (this.exists && !this.isDirectory()) {
            throw new MessagingException("Cannot contain subfolders");
        }
        char c10 = this.getSeparator();
        return new IMAPFolder(String.valueOf(this.fullName) + c10 + string, c10, (IMAPStore)this.store);
    }

    public String getFullName() {
        return this.fullName;
    }

    public synchronized Message getMessage(int n2) throws MessagingException {
        this.checkOpened();
        this.checkRange(n2);
        return (Message)this.messageCache.elementAt(n2 - 1);
    }

    IMAPMessage getMessageBySeqNumber(int n2) {
        int n3 = n2 - 1;
        while (n3 < this.total) {
            IMAPMessage iMAPMessage = (IMAPMessage)this.messageCache.elementAt(n3);
            if (iMAPMessage.getSequenceNumber() == n2) {
                return iMAPMessage;
            }
            ++n3;
        }
        return null;
    }

    public synchronized Message getMessageByUID(long l2) throws MessagingException {
        this.checkOpened();
        Long l3 = new Long(l2);
        IMAPMessage iMAPMessage = null;
        if (this.uidTable != null) {
            iMAPMessage = (IMAPMessage)this.uidTable.get(l3);
            if (iMAPMessage != null) {
                return iMAPMessage;
            }
        } else {
            this.uidTable = new Hashtable();
        }
        try {
            Object object = this.messageCacheLock;
            synchronized (object) {
                UID uID = this.protocol.fetchSequenceNumber(l2);
                if (uID != null) {
                    iMAPMessage = (IMAPMessage)this.messageCache.elementAt(uID.msgno - 1);
                    iMAPMessage.setUID(uID.uid);
                    this.uidTable.put(l3, iMAPMessage);
                }
            }
        }
        catch (ConnectionException connectionException) {
            throw new FolderClosedException(this, connectionException.getMessage());
        }
        catch (ProtocolException protocolException) {
            throw new MessagingException(protocolException.getMessage(), protocolException);
        }
        return iMAPMessage;
    }

    public int getMessageCount() throws MessagingException {
        this.checkExists();
        if (!this.opened) {
            try {
                Status status = this.storeProtocol().status(this.fullName, null);
                return status.total;
            }
            catch (BadCommandException badCommandException) {
                try {
                    MailboxInfo mailboxInfo = this.storeProtocol().examine(this.fullName);
                    this.storeProtocol().close();
                    return mailboxInfo.total;
                }
                catch (ProtocolException protocolException) {
                    throw new MessagingException(protocolException.getMessage(), protocolException);
                }
            }
            catch (ConnectionException connectionException) {
                throw new StoreClosedException(this.store, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
        Object object = this.messageCacheLock;
        synchronized (object) {
            try {
                this.protocol.noop();
                this.storeProtocol().noop();
                int n2 = this.total;
                Object var3_8 = null;
                return n2;
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException(this, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
    }

    public synchronized Message[] getMessagesByUID(long l2, long l3) throws MessagingException {
        Message[] messageArray;
        this.checkOpened();
        if (this.uidTable == null) {
            this.uidTable = new Hashtable();
        }
        try {
            Object object = this.messageCacheLock;
            synchronized (object) {
                UID[] uIDArray = this.protocol.fetchSequenceNumbers(l2, l3);
                messageArray = new Message[uIDArray.length];
                int n2 = 0;
                while (n2 < uIDArray.length) {
                    IMAPMessage iMAPMessage = (IMAPMessage)this.messageCache.elementAt(uIDArray[n2].msgno - 1);
                    iMAPMessage.setUID(uIDArray[n2].uid);
                    messageArray[n2] = iMAPMessage;
                    this.uidTable.put(new Long(uIDArray[n2].uid), iMAPMessage);
                    ++n2;
                }
            }
        }
        catch (ConnectionException connectionException) {
            throw new FolderClosedException(this, connectionException.getMessage());
        }
        catch (ProtocolException protocolException) {
            throw new MessagingException(protocolException.getMessage(), protocolException);
        }
        return messageArray;
    }

    public synchronized Message[] getMessagesByUID(long[] lArray) throws MessagingException {
        int n2;
        Message[] messageArray;
        this.checkOpened();
        long[] lArray2 = lArray;
        if (this.uidTable != null) {
            messageArray = new Vector();
            int n3 = 0;
            while (n3 < lArray.length) {
                Long l2 = new Long(lArray[n3]);
                if (!this.uidTable.containsKey(l2)) {
                    messageArray.addElement(l2);
                }
                ++n3;
            }
            int n4 = messageArray.size();
            lArray2 = new long[n4];
            n2 = 0;
            while (n2 < n4) {
                lArray2[n2] = (Long)messageArray.elementAt(n2);
                ++n2;
            }
        } else {
            this.uidTable = new Hashtable();
        }
        if (lArray2.length > 0) {
            try {
                messageArray = this.messageCacheLock;
                synchronized (messageArray) {
                    UID[] uIDArray = this.protocol.fetchSequenceNumbers(lArray2);
                    n2 = 0;
                    while (n2 < uIDArray.length) {
                        IMAPMessage iMAPMessage = (IMAPMessage)this.messageCache.elementAt(uIDArray[n2].msgno - 1);
                        iMAPMessage.setUID(uIDArray[n2].uid);
                        this.uidTable.put(new Long(uIDArray[n2].uid), iMAPMessage);
                        ++n2;
                    }
                }
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException(this, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
        messageArray = new Message[lArray.length];
        int n5 = 0;
        while (n5 < lArray.length) {
            messageArray[n5] = (Message)this.uidTable.get(new Long(lArray[n5]));
            ++n5;
        }
        return messageArray;
    }

    public String getName() {
        block2: {
            if (this.name != null) break block2;
            try {
                this.name = this.fullName.substring(this.fullName.lastIndexOf(this.getSeparator()) + 1);
            }
            catch (MessagingException messagingException) {}
        }
        return this.name;
    }

    public synchronized int getNewMessageCount() throws MessagingException {
        this.checkExists();
        if (!this.opened) {
            try {
                Status status = this.storeProtocol().status(this.fullName, null);
                return status.recent;
            }
            catch (BadCommandException badCommandException) {
                try {
                    MailboxInfo mailboxInfo = this.storeProtocol().examine(this.fullName);
                    this.storeProtocol().close();
                    return mailboxInfo.recent;
                }
                catch (ProtocolException protocolException) {
                    throw new MessagingException(protocolException.getMessage(), protocolException);
                }
            }
            catch (ConnectionException connectionException) {
                throw new StoreClosedException(this.store, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
        Object object = this.messageCacheLock;
        synchronized (object) {
            try {
                this.protocol.noop();
                this.storeProtocol().noop();
                int n2 = this.recent;
                Object var3_8 = null;
                return n2;
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException(this, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
    }

    public Folder getParent() throws MessagingException {
        char c10 = this.getSeparator();
        int n2 = this.fullName.lastIndexOf(c10);
        if (n2 != -1) {
            return new IMAPFolder(this.fullName.substring(0, n2), c10, (IMAPStore)this.store);
        }
        return new DefaultFolder((IMAPStore)this.store);
    }

    public Flags getPermanentFlags() {
        return this.permanentFlags;
    }

    public synchronized char getSeparator() throws MessagingException {
        if (this.separator == '\uffff') {
            ListInfo[] listInfoArray = null;
            try {
                IMAPProtocol iMAPProtocol = this.storeProtocol();
                listInfoArray = iMAPProtocol.isREV1() ? iMAPProtocol.list(this.fullName, "") : iMAPProtocol.list("", this.fullName);
            }
            catch (ConnectionException connectionException) {
                throw new StoreClosedException(this.store, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
            this.separator = listInfoArray != null ? listInfoArray[0].separator : (char)47;
        }
        return this.separator;
    }

    public int getType() throws MessagingException {
        this.checkExists();
        return this.type;
    }

    public synchronized long getUID(Message message) throws MessagingException {
        if (message.getFolder() != this) {
            throw new NoSuchElementException("Message does not belong to this folder");
        }
        this.checkOpened();
        IMAPMessage iMAPMessage = (IMAPMessage)message;
        long l2 = iMAPMessage.getUID();
        if (l2 != -1L) {
            return l2;
        }
        UID uID = null;
        Object object = this.messageCacheLock;
        synchronized (object) {
            iMAPMessage.checkExpunged();
            try {
                uID = this.protocol.fetchUID(iMAPMessage.getSequenceNumber());
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException(this, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
        if (uID != null) {
            l2 = uID.uid;
            iMAPMessage.setUID(l2);
            if (this.uidTable == null) {
                this.uidTable = new Hashtable();
            }
            this.uidTable.put(new Long(l2), iMAPMessage);
        }
        return l2;
    }

    public long getUIDValidity() throws MessagingException {
        if (this.opened) {
            return this.uidvalidity;
        }
        try {
            String[] stringArray = new String[]{"UIDVALIDITY"};
            Status status = this.storeProtocol().status(this.fullName, stringArray);
            return status.uidvalidity;
        }
        catch (BadCommandException badCommandException) {
            throw new MessagingException("Cannot obtain UIDValidity", badCommandException);
        }
        catch (ConnectionException connectionException) {
            throw new StoreClosedException(this.store, connectionException.getMessage());
        }
        catch (ProtocolException protocolException) {
            throw new MessagingException(protocolException.getMessage(), protocolException);
        }
    }

    public synchronized int getUnreadMessageCount() throws MessagingException {
        this.checkExists();
        if (!this.opened) {
            try {
                Status status = this.storeProtocol().status(this.fullName, null);
                return status.unseen;
            }
            catch (BadCommandException badCommandException) {
                return -1;
            }
            catch (ConnectionException connectionException) {
                throw new StoreClosedException(this.store, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
        Flags flags = new Flags();
        flags.add(Flags.Flag.SEEN);
        try {
            Object object = this.messageCacheLock;
            synchronized (object) {
                int[] nArray = this.protocol.search(new FlagTerm(flags, false));
                int n2 = nArray.length;
                Object var4_10 = null;
                return n2;
            }
        }
        catch (ConnectionException connectionException) {
            throw new FolderClosedException(this, connectionException.getMessage());
        }
        catch (ProtocolException protocolException) {
            throw new MessagingException(protocolException.getMessage(), protocolException);
        }
    }

    public void handleResponse(Response response) {
        if (response.isBYE()) {
            if (this.opened) {
                this.cleanup();
            }
            return;
        }
        if (response.isOK()) {
            ((IMAPStore)this.store).handleResponse(response);
            return;
        }
        if (!(response instanceof IMAPResponse)) {
            System.out.println("UNEXPECTED RESPONSE : " + response.toString());
            System.out.println("CONTACT javamail@sun.com");
            return;
        }
        IMAPResponse iMAPResponse = (IMAPResponse)response;
        if (iMAPResponse.keyEquals("EXISTS")) {
            int n2 = iMAPResponse.getNumber();
            if (n2 <= this.realTotal) {
                return;
            }
            int n3 = n2 - this.realTotal;
            Message[] messageArray = new Message[n3];
            int n4 = 0;
            while (n4 < n3) {
                IMAPMessage iMAPMessage = new IMAPMessage(this, ++this.total, ++this.realTotal);
                messageArray[n4] = iMAPMessage;
                this.messageCache.addElement(iMAPMessage);
                ++n4;
            }
            this.notifyMessageAddedListeners(messageArray);
        } else if (iMAPResponse.keyEquals("EXPUNGE")) {
            Message[] messageArray;
            IMAPMessage iMAPMessage = this.getMessageBySeqNumber(iMAPResponse.getNumber());
            iMAPMessage.setExpunged(true);
            int n5 = iMAPMessage.getMessageNumber();
            while (n5 < this.total) {
                messageArray = (Message[])this.messageCache.elementAt(n5);
                if (!messageArray.isExpunged()) {
                    messageArray.setSequenceNumber(messageArray.getSequenceNumber() - 1);
                }
                ++n5;
            }
            --this.realTotal;
            if (this.doExpungeNotification) {
                messageArray = new Message[]{iMAPMessage};
                this.notifyMessageRemovedListeners(false, messageArray);
            }
        } else if (iMAPResponse.keyEquals("FETCH")) {
            FetchResponse fetchResponse = (FetchResponse)iMAPResponse;
            Flags flags = (Flags)((Object)fetchResponse.getItem(class$javax$mail$Flags != null ? class$javax$mail$Flags : (class$javax$mail$Flags = IMAPFolder.class$("javax.mail.Flags"))));
            if (flags != null) {
                IMAPMessage iMAPMessage = this.getMessageBySeqNumber(fetchResponse.getNumber());
                iMAPMessage._setFlags(flags);
                this.notifyMessageChangedListeners(1, iMAPMessage);
            }
        } else if (iMAPResponse.keyEquals("RECENT")) {
            this.recent = iMAPResponse.getNumber();
        }
    }

    void handleResponses(Response[] responseArray) {
        int n2 = 0;
        while (n2 < responseArray.length) {
            if (responseArray[n2] != null) {
                this.handleResponse(responseArray[n2]);
            }
            ++n2;
        }
    }

    public boolean hasNewMessages() throws MessagingException {
        this.checkExists();
        if (this.opened) {
            return this.recent > 0;
        }
        try {
            ListInfo[] listInfoArray = this.storeProtocol().list("", this.fullName);
            if (listInfoArray != null) {
                if (listInfoArray[0].changeState == 1) {
                    return true;
                }
                if (listInfoArray[0].changeState == 2) {
                    return false;
                }
            }
            Status status = this.storeProtocol().status(this.fullName, null);
            return status.recent > 0;
        }
        catch (BadCommandException badCommandException) {
            return false;
        }
        catch (ConnectionException connectionException) {
            throw new StoreClosedException(this.store, connectionException.getMessage());
        }
        catch (ProtocolException protocolException) {
            throw new MessagingException(protocolException.getMessage(), protocolException);
        }
    }

    private boolean isDirectory() {
        return (this.type & 2) != 0;
    }

    public boolean isOpen() {
        if (this.opened) {
            Object object = this.messageCacheLock;
            synchronized (object) {
                if (!this.opened) {
                    boolean bl2 = false;
                    Object var3_3 = null;
                    return bl2;
                }
                try {
                    this.protocol.noop();
                }
                catch (ProtocolException protocolException) {}
            }
        }
        return this.opened;
    }

    public boolean isSubscribed() {
        ListInfo[] listInfoArray = null;
        try {
            listInfoArray = this.storeProtocol().lsub("", this.fullName);
        }
        catch (ProtocolException protocolException) {}
        return listInfoArray != null;
    }

    public Folder[] list(String string) throws MessagingException {
        return this.doList(string, false);
    }

    public Folder[] listSubscribed(String string) throws MessagingException {
        return this.doList(string, true);
    }

    public synchronized void open(int n2) throws MessagingException {
        this.checkExists();
        this.checkClosed();
        if ((this.type & 1) == 0) {
            throw new MessagingException("folder cannot contain messages");
        }
        MailboxInfo mailboxInfo = null;
        this.protocol = ((IMAPStore)this.store).getProtocol(this);
        Object object = this.messageCacheLock;
        synchronized (object) {
            try {
                mailboxInfo = n2 == 1 ? this.protocol.examine(this.fullName) : this.protocol.select(this.fullName);
            }
            catch (ProtocolException protocolException) {
                this.openFailure(protocolException.getMessage(), protocolException);
            }
            if (mailboxInfo.mode != n2) {
                this.openFailure("Cannot open in desired mode", null);
            }
            this.opened = true;
            this.reallyClosed = false;
            this.mode = mailboxInfo.mode;
            this.availableFlags = mailboxInfo.availableFlags;
            this.permanentFlags = mailboxInfo.permanentFlags;
            this.total = this.realTotal = mailboxInfo.total;
            this.recent = mailboxInfo.recent;
            this.uidvalidity = mailboxInfo.uidvalidity;
            this.protocol.addResponseHandler(this);
            this.messageCache = new Vector(this.total);
            int n3 = 0;
            while (n3 < this.total) {
                this.messageCache.addElement(new IMAPMessage(this, n3 + 1, n3 + 1));
                ++n3;
            }
        }
        this.notifyConnectionListeners(1);
    }

    private void openFailure(String string, Exception exception) throws MessagingException {
        Object object = this.messageCacheLock;
        synchronized (object) {
            try {
                this.protocol.logout();
            }
            catch (ProtocolException protocolException) {}
        }
        this.protocol = null;
        if (exception != null) {
            throw new MessagingException(string, exception);
        }
        throw new MessagingException(string);
    }

    public boolean renameTo(Folder folder) throws MessagingException {
        this.checkClosed();
        if (folder.getStore() != this.store) {
            throw new MessagingException("Can't rename across Stores");
        }
        try {
            this.storeProtocol().rename(this.fullName, folder.getFullName());
        }
        catch (CommandFailedException commandFailedException) {
            return false;
        }
        catch (ConnectionException connectionException) {
            throw new StoreClosedException(this.store, connectionException.getMessage());
        }
        catch (ProtocolException protocolException) {
            throw new MessagingException(protocolException.getMessage(), protocolException);
        }
        this.notifyFolderRenamedListeners(folder);
        return true;
    }

    public Message[] search(SearchTerm searchTerm) throws MessagingException {
        this.checkOpened();
        try {
            Message[] messageArray = null;
            Object object = this.messageCacheLock;
            synchronized (object) {
                int[] nArray = this.protocol.search(searchTerm);
                if (nArray != null) {
                    messageArray = new IMAPMessage[nArray.length];
                    int n2 = 0;
                    while (n2 < nArray.length) {
                        messageArray[n2] = this.getMessageBySeqNumber(nArray[n2]);
                        ++n2;
                    }
                }
            }
            return messageArray;
        }
        catch (CommandFailedException commandFailedException) {
            return super.search(searchTerm);
        }
        catch (SearchException searchException) {
            return super.search(searchTerm);
        }
        catch (ConnectionException connectionException) {
            throw new FolderClosedException(this, connectionException.getMessage());
        }
        catch (ProtocolException protocolException) {
            throw new MessagingException(protocolException.getMessage(), protocolException);
        }
    }

    public Message[] search(SearchTerm searchTerm, Message[] messageArray) throws MessagingException {
        this.checkOpened();
        if (messageArray.length == 0) {
            return messageArray;
        }
        try {
            Message[] messageArray2 = null;
            Object object = this.messageCacheLock;
            synchronized (object) {
                int[] nArray = this.protocol.search(Utility.toMessageSet(messageArray, null), searchTerm);
                if (nArray != null) {
                    messageArray2 = new IMAPMessage[nArray.length];
                    int n2 = 0;
                    while (n2 < nArray.length) {
                        messageArray2[n2] = this.getMessageBySeqNumber(nArray[n2]);
                        ++n2;
                    }
                }
            }
            return messageArray2;
        }
        catch (CommandFailedException commandFailedException) {
            return super.search(searchTerm, messageArray);
        }
        catch (SearchException searchException) {
            return super.search(searchTerm, messageArray);
        }
        catch (ConnectionException connectionException) {
            throw new FolderClosedException(this, connectionException.getMessage());
        }
        catch (ProtocolException protocolException) {
            throw new MessagingException(protocolException.getMessage(), protocolException);
        }
    }

    public void setFlags(Message[] messageArray, Flags flags, boolean bl2) throws MessagingException {
        this.checkOpened();
        this.checkFlags(flags);
        if (messageArray.length == 0) {
            return;
        }
        Object object = this.messageCacheLock;
        synchronized (object) {
            try {
                this.protocol.storeFlags(Utility.toMessageSet(messageArray, null), flags, bl2);
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException(this, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
    }

    public void setSubscribed(boolean bl2) throws MessagingException {
        this.checkExists();
        try {
            if (bl2) {
                this.storeProtocol().subscribe(this.fullName);
            } else {
                this.storeProtocol().unsubscribe(this.fullName);
            }
        }
        catch (CommandFailedException commandFailedException) {
        }
        catch (ConnectionException connectionException) {
            throw new StoreClosedException(this.store, connectionException.getMessage());
        }
        catch (ProtocolException protocolException) {
            throw new MessagingException(protocolException.getMessage(), protocolException);
        }
    }

    IMAPProtocol storeProtocol() {
        return ((IMAPStore)this.store).getProtocol();
    }
}

