/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap;

import com.sun.mail.iap.ByteArray;
import com.sun.mail.iap.ProtocolException;
import com.sun.mail.imap.IMAPMessage;
import com.sun.mail.imap.protocol.BODY;
import java.io.IOException;
import java.io.InputStream;
import javax.mail.FolderClosedException;

public class IMAPInputStream
extends InputStream {
    private IMAPMessage msg;
    private String section;
    private int pos;
    private int blksize;
    private int max;
    private byte[] buf;
    private int bufcount;
    private int bufpos;

    public IMAPInputStream(IMAPMessage iMAPMessage, String string, int n2) {
        this.msg = iMAPMessage;
        this.section = string;
        this.max = n2;
        this.pos = 0;
        this.blksize = iMAPMessage.getFetchBlockSize();
    }

    public synchronized int available() throws IOException {
        return this.bufcount - this.bufpos;
    }

    private void fill() throws IOException {
        if (this.max != -1 && this.pos >= this.max) {
            return;
        }
        BODY bODY = null;
        Object object = this.msg.getMessageCacheLock();
        synchronized (object) {
            if (this.msg.isExpunged()) {
                throw new IOException("No content for expunged message");
            }
            int n2 = this.msg.getSequenceNumber();
            try {
                bODY = this.msg.getProtocol().fetchBody(n2, this.section, this.pos, this.blksize);
            }
            catch (ProtocolException protocolException) {
                throw new IOException(protocolException.getMessage());
            }
            catch (FolderClosedException folderClosedException) {
                throw new IOException(folderClosedException.getMessage());
            }
        }
        if (bODY == null || (object = bODY.getByteArray()) == null) {
            throw new IOException("No content");
        }
        this.buf = ((ByteArray)object).getBytes();
        this.bufpos = ((ByteArray)object).getStart();
        int n3 = ((ByteArray)object).getCount();
        this.bufcount = this.bufpos + n3;
        this.pos += n3;
    }

    public synchronized int read() throws IOException {
        if (this.bufpos >= this.bufcount) {
            this.fill();
            if (this.bufpos >= this.bufcount) {
                return -1;
            }
        }
        return this.buf[this.bufpos++] & 0xFF;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public synchronized int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = this.bufcount - this.bufpos;
        if (n4 <= 0) {
            this.fill();
            n4 = this.bufcount - this.bufpos;
            if (n4 <= 0) {
                return -1;
            }
        }
        int n5 = n4 < n3 ? n4 : n3;
        System.arraycopy(this.buf, this.bufpos, byArray, n2, n5);
        this.bufpos += n5;
        return n5;
    }
}

