/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap;

import com.sun.mail.iap.CommandFailedException;
import com.sun.mail.iap.ConnectionException;
import com.sun.mail.iap.ProtocolException;
import com.sun.mail.iap.Response;
import com.sun.mail.imap.IMAPFolder;
import com.sun.mail.imap.IMAPInputStream;
import com.sun.mail.imap.IMAPMessage;
import com.sun.mail.imap.IMAPMultipartDataSource;
import com.sun.mail.imap.IMAPNestedMessage;
import com.sun.mail.imap.IMAPStore;
import com.sun.mail.imap.Utility;
import com.sun.mail.imap.protocol.BODY;
import com.sun.mail.imap.protocol.BODYSTRUCTURE;
import com.sun.mail.imap.protocol.ENVELOPE;
import com.sun.mail.imap.protocol.FetchResponse;
import com.sun.mail.imap.protocol.IMAPProtocol;
import com.sun.mail.imap.protocol.INTERNALDATE;
import com.sun.mail.imap.protocol.Item;
import com.sun.mail.imap.protocol.MessageSet;
import com.sun.mail.imap.protocol.RFC822DATA;
import com.sun.mail.imap.protocol.RFC822SIZE;
import com.sun.mail.imap.protocol.UID;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.mail.Address;
import javax.mail.FetchProfile;
import javax.mail.Flags;
import javax.mail.FolderClosedException;
import javax.mail.IllegalWriteException;
import javax.mail.Message;
import javax.mail.MessageRemovedException;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.UIDFolder;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;

public class IMAPMessage
extends MimeMessage {
    protected BODYSTRUCTURE bs;
    protected ENVELOPE envelope;
    private Date receivedDate;
    private int size = -1;
    private int seqnum;
    private long uid = -1L;
    protected String sectionId;
    private String type;
    private String subject;
    private String description;
    private boolean headersLoaded = false;
    private Hashtable loadedHeaders;
    private static String EnvelopeCmd = "ENVELOPE INTERNALDATE RFC822.SIZE";

    protected IMAPMessage(IMAPFolder iMAPFolder, int n2, int n3) {
        super(iMAPFolder, n2);
        this.seqnum = n3;
        this.flags = null;
    }

    protected IMAPMessage(Session session) {
        super(session);
    }

    BODYSTRUCTURE _getBodyStructure() {
        return this.bs;
    }

    ENVELOPE _getEnvelope() {
        return this.envelope;
    }

    Flags _getFlags() {
        return this.flags;
    }

    Session _getSession() {
        return this.session;
    }

    void _setFlags(Flags flags) {
        this.flags = flags;
    }

    static /* synthetic */ boolean access$0(IMAPMessage iMAPMessage, String string) {
        return iMAPMessage.isHeaderLoaded(string);
    }

    public void addFrom(Address[] addressArray) throws MessagingException {
        throw new IllegalWriteException("IMAPMessage is read-only");
    }

    public void addHeader(String string, String string2) throws MessagingException {
        throw new IllegalWriteException("IMAPMessage is read-only");
    }

    public void addHeaderLine(String string) throws MessagingException {
        throw new IllegalWriteException("IMAPMessage is read-only");
    }

    public void addRecipients(Message.RecipientType recipientType, Address[] addressArray) throws MessagingException {
        throw new IllegalWriteException("IMAPMessage is read-only");
    }

    protected void checkExpunged() throws MessageRemovedException {
        if (this.expunged) {
            throw new MessageRemovedException();
        }
    }

    private static String craftHeaderCmd(IMAPProtocol iMAPProtocol, String[] stringArray) {
        StringBuffer stringBuffer = iMAPProtocol.isREV1() ? new StringBuffer("BODY.PEEK[HEADER.FIELDS (") : new StringBuffer("RFC822.HEADER.LINES (");
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (n2 > 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(stringArray[n2]);
            ++n2;
        }
        if (iMAPProtocol.isREV1()) {
            stringBuffer.append(")]");
        } else {
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void fetch(IMAPFolder iMAPFolder, Message[] messageArray, FetchProfile fetchProfile) throws MessagingException {
        String[] stringArray;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = true;
        if (fetchProfile.contains(FetchProfile.Item.ENVELOPE)) {
            stringBuffer.append(EnvelopeCmd);
            bl2 = false;
        }
        if (fetchProfile.contains(FetchProfile.Item.FLAGS)) {
            stringBuffer.append(bl2 ? "FLAGS" : " FLAGS");
            bl2 = false;
        }
        if (fetchProfile.contains(FetchProfile.Item.CONTENT_INFO)) {
            stringBuffer.append(bl2 ? "BODYSTRUCTURE" : " BODYSTRUCTURE");
            bl2 = false;
        }
        if (fetchProfile.contains(UIDFolder.FetchProfileItem.UID)) {
            stringBuffer.append(bl2 ? "UID" : " UID");
            bl2 = false;
        }
        if ((stringArray = fetchProfile.getHeaderNames()).length > 0) {
            if (!bl2) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(IMAPMessage.craftHeaderCmd(iMAPFolder.protocol, stringArray));
        }
        class FetchProfileCondition
        implements Utility.Condition {
            private boolean needEnvelope;
            private boolean needFlags;
            private boolean needBodyStructure;
            private boolean needUID;
            private String[] hdrs;

            public FetchProfileCondition(FetchProfile fetchProfile) {
                this.needEnvelope = false;
                this.needFlags = false;
                this.needBodyStructure = false;
                this.needUID = false;
                this.hdrs = null;
                if (fetchProfile.contains(FetchProfile.Item.ENVELOPE)) {
                    this.needEnvelope = true;
                }
                if (fetchProfile.contains(FetchProfile.Item.FLAGS)) {
                    this.needFlags = true;
                }
                if (fetchProfile.contains(FetchProfile.Item.CONTENT_INFO)) {
                    this.needBodyStructure = true;
                }
                if (fetchProfile.contains(UIDFolder.FetchProfileItem.UID)) {
                    this.needUID = true;
                }
                this.hdrs = fetchProfile.getHeaderNames();
            }

            public boolean test(IMAPMessage iMAPMessage) {
                if (this.needEnvelope && iMAPMessage._getEnvelope() == null) {
                    return true;
                }
                if (this.needFlags && iMAPMessage._getFlags() == null) {
                    return true;
                }
                if (this.needBodyStructure && iMAPMessage._getBodyStructure() == null) {
                    return true;
                }
                if (this.needUID && iMAPMessage.getUID() == -1L) {
                    return true;
                }
                int n2 = 0;
                while (n2 < this.hdrs.length) {
                    if (!IMAPMessage.access$0(iMAPMessage, this.hdrs[n2])) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
        }
        FetchProfileCondition fetchProfileCondition = new FetchProfileCondition(fetchProfile);
        Object object = iMAPFolder.messageCacheLock;
        synchronized (object) {
            MessageSet[] messageSetArray = Utility.toMessageSet(messageArray, fetchProfileCondition);
            if (messageSetArray == null) {
                return;
            }
            Response[] responseArray = null;
            Vector<Response> vector = new Vector<Response>();
            try {
                responseArray = iMAPFolder.protocol.fetch(messageSetArray, stringBuffer.toString());
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException(iMAPFolder, connectionException.getMessage());
            }
            catch (CommandFailedException commandFailedException) {
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
            if (responseArray == null) {
                return;
            }
            int n2 = 0;
            while (true) {
                Object object2;
                if (n2 >= responseArray.length) {
                    int n3 = vector.size();
                    if (n3 == 0) return;
                    object2 = new Response[n3];
                    vector.copyInto((Object[])object2);
                    iMAPFolder.handleResponses((Response[])object2);
                    return;
                }
                if (responseArray[n2] != null) {
                    if (!(responseArray[n2] instanceof FetchResponse)) {
                        vector.addElement(responseArray[n2]);
                    } else {
                        FetchResponse fetchResponse = (FetchResponse)responseArray[n2];
                        object2 = iMAPFolder.getMessageBySeqNumber(fetchResponse.getNumber());
                        int n4 = fetchResponse.getItemCount();
                        boolean bl3 = false;
                        int n5 = 0;
                        while (true) {
                            Object object3;
                            if (n5 >= n4) {
                                if (!bl3) break;
                                vector.addElement(fetchResponse);
                                break;
                            }
                            Item item = fetchResponse.getItem(n5);
                            if (item instanceof Flags) {
                                if (!fetchProfile.contains(FetchProfile.Item.FLAGS) || object2 == null) {
                                    bl3 = true;
                                } else {
                                    ((MimeMessage)object2).flags = (Flags)((Object)item);
                                }
                            } else if (item instanceof ENVELOPE) {
                                ((IMAPMessage)object2).envelope = (ENVELOPE)item;
                            } else if (item instanceof INTERNALDATE) {
                                ((IMAPMessage)object2).receivedDate = ((INTERNALDATE)item).getDate();
                            } else if (item instanceof RFC822SIZE) {
                                ((IMAPMessage)object2).size = ((RFC822SIZE)item).size;
                            } else if (item instanceof BODYSTRUCTURE) {
                                ((IMAPMessage)object2).bs = (BODYSTRUCTURE)item;
                            } else if (item instanceof UID) {
                                object3 = (UID)item;
                                ((IMAPMessage)object2).uid = ((UID)object3).uid;
                                if (iMAPFolder.uidTable == null) {
                                    iMAPFolder.uidTable = new Hashtable();
                                }
                                iMAPFolder.uidTable.put(new Long(((UID)object3).uid), object2);
                            } else if (item instanceof RFC822DATA || item instanceof BODY) {
                                object3 = item instanceof RFC822DATA ? ((RFC822DATA)item).getByteArrayInputStream() : ((BODY)item).getByteArrayInputStream();
                                if (((MimeMessage)object2).headers == null) {
                                    ((MimeMessage)object2).headers = new InternetHeaders();
                                }
                                ((MimeMessage)object2).headers.load((InputStream)object3);
                                int n6 = 0;
                                while (n6 < stringArray.length) {
                                    super.setHeaderLoaded(stringArray[n6]);
                                    ++n6;
                                }
                            }
                            ++n5;
                        }
                    }
                }
                ++n2;
            }
        }
    }

    public Enumeration getAllHeaderLines() throws MessagingException {
        this.checkExpunged();
        this.loadHeaders();
        return super.getAllHeaderLines();
    }

    public Enumeration getAllHeaders() throws MessagingException {
        this.checkExpunged();
        this.loadHeaders();
        return super.getAllHeaders();
    }

    public String getContentID() throws MessagingException {
        this.checkExpunged();
        this.loadBODYSTRUCTURE();
        return this.bs.id;
    }

    public String getContentMD5() throws MessagingException {
        this.checkExpunged();
        this.loadBODYSTRUCTURE();
        return this.bs.md5;
    }

    protected InputStream getContentStream() throws MessagingException {
        IMAPProtocol iMAPProtocol = this.getProtocol();
        if (iMAPProtocol.isREV1() && this.getFetchBlockSize() != -1) {
            return new IMAPInputStream(this, this.toSection("TEXT"), this.bs != null ? this.bs.size : -1);
        }
        ByteArrayInputStream byteArrayInputStream = null;
        Object object = this.getMessageCacheLock();
        synchronized (object) {
            this.checkExpunged();
            try {
                RFC822DATA rFC822DATA = iMAPProtocol.fetchRFC822(this.getSequenceNumber(), "TEXT");
                if (rFC822DATA != null) {
                    byteArrayInputStream = rFC822DATA.getByteArrayInputStream();
                }
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException(this.folder, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
        if (byteArrayInputStream == null) {
            throw new MessagingException("No content");
        }
        return byteArrayInputStream;
    }

    public String getContentType() throws MessagingException {
        this.checkExpunged();
        if (this.type == null) {
            this.loadBODYSTRUCTURE();
            ContentType contentType = new ContentType(this.bs.type, this.bs.subtype, this.bs.cParams);
            this.type = contentType.toString();
        }
        return this.type;
    }

    public synchronized DataHandler getDataHandler() throws MessagingException {
        this.checkExpunged();
        if (this.dh == null) {
            this.loadBODYSTRUCTURE();
            if (this.type == null) {
                ContentType contentType = new ContentType(this.bs.type, this.bs.subtype, this.bs.cParams);
                this.type = contentType.toString();
            }
            if (this.bs.isMulti()) {
                this.dh = new DataHandler(new IMAPMultipartDataSource(this, this.bs.bodies, this.sectionId, this));
            } else if (this.bs.isNested() && this.getProtocol().isREV1()) {
                this.dh = new DataHandler(new IMAPNestedMessage(this, this.bs.bodies[0], this.bs.envelope, this.sectionId == null ? "1" : String.valueOf(this.sectionId) + ".1"), this.type);
            }
        }
        return super.getDataHandler();
    }

    public String getDescription() throws MessagingException {
        this.checkExpunged();
        if (this.description != null) {
            return this.description;
        }
        this.loadBODYSTRUCTURE();
        if (this.bs.description == null) {
            return null;
        }
        try {
            this.description = MimeUtility.decodeText(this.bs.description);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.description = this.bs.description;
        }
        return this.description;
    }

    public String getDisposition() throws MessagingException {
        this.checkExpunged();
        this.loadBODYSTRUCTURE();
        return this.bs.disposition;
    }

    public String getEncoding() throws MessagingException {
        this.checkExpunged();
        this.loadBODYSTRUCTURE();
        return this.bs.encoding;
    }

    protected int getFetchBlockSize() {
        return ((IMAPStore)this.folder.getStore()).getFetchBlockSize();
    }

    public String getFileName() throws MessagingException {
        this.checkExpunged();
        String string = null;
        this.loadBODYSTRUCTURE();
        if (this.bs.dParams != null) {
            string = this.bs.dParams.get("filename");
        }
        if (string == null && this.bs.cParams != null) {
            string = this.bs.cParams.get("name");
        }
        return string;
    }

    public synchronized Flags getFlags() throws MessagingException {
        this.checkExpunged();
        this.loadFlags();
        return super.getFlags();
    }

    public Address[] getFrom() throws MessagingException {
        this.checkExpunged();
        this.loadEnvelope();
        return this.envelope.from;
    }

    public String[] getHeader(String string) throws MessagingException {
        this.checkExpunged();
        if (this.isHeaderLoaded(string)) {
            return this.headers.getHeader(string);
        }
        IMAPProtocol iMAPProtocol = this.getProtocol();
        ByteArrayInputStream byteArrayInputStream = null;
        Object object = this.getMessageCacheLock();
        synchronized (object) {
            this.checkExpunged();
            try {
                if (iMAPProtocol.isREV1()) {
                    BODY bODY = iMAPProtocol.peekBody(this.getSequenceNumber(), this.toSection("HEADER.FIELDS (" + string + ")"));
                    if (bODY != null) {
                        byteArrayInputStream = bODY.getByteArrayInputStream();
                    }
                } else {
                    RFC822DATA rFC822DATA = iMAPProtocol.fetchRFC822(this.getSequenceNumber(), "HEADER.LINES (" + string + ")");
                    if (rFC822DATA != null) {
                        byteArrayInputStream = rFC822DATA.getByteArrayInputStream();
                    }
                }
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException(this.folder, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
        if (this.headers == null) {
            this.headers = new InternetHeaders();
        }
        this.headers.load(byteArrayInputStream);
        this.setHeaderLoaded(string);
        return this.headers.getHeader(string);
    }

    public String getHeader(String string, String string2) throws MessagingException {
        this.checkExpunged();
        if (this.getHeader(string) == null) {
            return null;
        }
        return this.headers.getHeader(string, string2);
    }

    public int getLineCount() throws MessagingException {
        this.checkExpunged();
        this.loadBODYSTRUCTURE();
        return this.bs.lines;
    }

    public Enumeration getMatchingHeaderLines(String[] stringArray) throws MessagingException {
        this.checkExpunged();
        this.loadHeaders();
        return super.getMatchingHeaderLines(stringArray);
    }

    public Enumeration getMatchingHeaders(String[] stringArray) throws MessagingException {
        this.checkExpunged();
        this.loadHeaders();
        return super.getMatchingHeaders(stringArray);
    }

    protected Object getMessageCacheLock() {
        return ((IMAPFolder)this.folder).messageCacheLock;
    }

    public String getMessageID() throws MessagingException {
        this.checkExpunged();
        this.loadEnvelope();
        return this.envelope.messageId;
    }

    public Enumeration getNonMatchingHeaderLines(String[] stringArray) throws MessagingException {
        this.checkExpunged();
        this.loadHeaders();
        return super.getNonMatchingHeaderLines(stringArray);
    }

    public Enumeration getNonMatchingHeaders(String[] stringArray) throws MessagingException {
        this.checkExpunged();
        this.loadHeaders();
        return super.getNonMatchingHeaders(stringArray);
    }

    protected IMAPProtocol getProtocol() throws FolderClosedException {
        IMAPProtocol iMAPProtocol = ((IMAPFolder)this.folder).protocol;
        if (iMAPProtocol == null) {
            throw new FolderClosedException(this.folder);
        }
        return iMAPProtocol;
    }

    public Date getReceivedDate() throws MessagingException {
        this.checkExpunged();
        this.loadEnvelope();
        return this.receivedDate;
    }

    public Address[] getRecipients(Message.RecipientType recipientType) throws MessagingException {
        this.checkExpunged();
        this.loadEnvelope();
        if (recipientType == Message.RecipientType.TO) {
            return this.envelope.to;
        }
        if (recipientType == Message.RecipientType.CC) {
            return this.envelope.cc;
        }
        if (recipientType == Message.RecipientType.BCC) {
            return this.envelope.bcc;
        }
        return super.getRecipients(recipientType);
    }

    public Address[] getReplyTo() throws MessagingException {
        this.checkExpunged();
        this.loadEnvelope();
        return this.envelope.replyTo;
    }

    public Date getSentDate() throws MessagingException {
        this.checkExpunged();
        this.loadEnvelope();
        return this.envelope.date;
    }

    protected int getSequenceNumber() {
        return this.seqnum;
    }

    public int getSize() throws MessagingException {
        this.checkExpunged();
        this.loadEnvelope();
        return this.size;
    }

    public String getSubject() throws MessagingException {
        this.checkExpunged();
        if (this.subject != null) {
            return this.subject;
        }
        this.loadEnvelope();
        if (this.envelope.subject == null) {
            return null;
        }
        try {
            this.subject = MimeUtility.decodeText(this.envelope.subject);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.subject = this.envelope.subject;
        }
        return this.subject;
    }

    protected long getUID() {
        return this.uid;
    }

    private boolean isHeaderLoaded(String string) {
        if (this.headersLoaded) {
            return true;
        }
        return this.loadedHeaders != null ? this.loadedHeaders.containsKey(string.toUpperCase()) : false;
    }

    public synchronized boolean isSet(Flags.Flag flag) throws MessagingException {
        this.checkExpunged();
        this.loadFlags();
        return super.isSet(flag);
    }

    private synchronized void loadBODYSTRUCTURE() throws MessagingException {
        if (this.bs != null) {
            return;
        }
        Object object = this.getMessageCacheLock();
        synchronized (object) {
            this.checkExpunged();
            try {
                this.bs = this.getProtocol().fetchBodyStructure(this.getSequenceNumber());
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException(this.folder, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
    }

    private synchronized void loadEnvelope() throws MessagingException {
        if (this.envelope != null) {
            return;
        }
        IMAPProtocol iMAPProtocol = this.getProtocol();
        Response[] responseArray = null;
        Object object = this.getMessageCacheLock();
        synchronized (object) {
            this.checkExpunged();
            int n2 = this.getSequenceNumber();
            try {
                responseArray = iMAPProtocol.fetch(n2, EnvelopeCmd);
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException(this.folder, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
            if (responseArray == null) {
                Object var4_8 = null;
                return;
            }
            int n3 = 0;
            while (n3 < responseArray.length) {
                if (responseArray[n3] != null && responseArray[n3] instanceof FetchResponse && ((FetchResponse)responseArray[n3]).getNumber() == n2) {
                    FetchResponse fetchResponse = (FetchResponse)responseArray[n3];
                    int n4 = fetchResponse.getItemCount();
                    int n5 = 0;
                    while (n5 < n4) {
                        Item item = fetchResponse.getItem(n5);
                        if (item instanceof ENVELOPE) {
                            this.envelope = (ENVELOPE)item;
                        } else if (item instanceof INTERNALDATE) {
                            this.receivedDate = ((INTERNALDATE)item).getDate();
                        } else if (item instanceof RFC822SIZE) {
                            this.size = ((RFC822SIZE)item).size;
                        }
                        ++n5;
                    }
                }
                ++n3;
            }
            ((IMAPFolder)this.folder).handleResponses(responseArray);
        }
    }

    private synchronized void loadFlags() throws MessagingException {
        if (this.flags != null) {
            return;
        }
        Object object = this.getMessageCacheLock();
        synchronized (object) {
            this.checkExpunged();
            try {
                this.flags = this.getProtocol().fetchFlags(this.getSequenceNumber());
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException(this.folder, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
    }

    private synchronized void loadHeaders() throws MessagingException {
        if (this.headersLoaded) {
            return;
        }
        IMAPProtocol iMAPProtocol = this.getProtocol();
        ByteArrayInputStream byteArrayInputStream = null;
        Object object = this.getMessageCacheLock();
        synchronized (object) {
            this.checkExpunged();
            try {
                if (iMAPProtocol.isREV1()) {
                    BODY bODY = iMAPProtocol.peekBody(this.getSequenceNumber(), this.toSection("HEADER"));
                    if (bODY != null) {
                        byteArrayInputStream = bODY.getByteArrayInputStream();
                    }
                } else {
                    RFC822DATA rFC822DATA = iMAPProtocol.fetchRFC822(this.getSequenceNumber(), "HEADER");
                    if (rFC822DATA != null) {
                        byteArrayInputStream = rFC822DATA.getByteArrayInputStream();
                    }
                }
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException(this.folder, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
        if (byteArrayInputStream == null) {
            throw new MessagingException("Cannot load header");
        }
        this.headers = new InternetHeaders(byteArrayInputStream);
        this.headersLoaded = true;
    }

    public void removeHeader(String string) throws MessagingException {
        throw new IllegalWriteException("IMAPMessage is read-only");
    }

    public void setContentID(String string) throws MessagingException {
        throw new IllegalWriteException("IMAPMessage is read-only");
    }

    public void setContentMD5(String string) throws MessagingException {
        throw new IllegalWriteException("IMAPMessage is read-only");
    }

    public void setDataHandler(DataHandler dataHandler) throws MessagingException {
        throw new IllegalWriteException("IMAPMessage is read-only");
    }

    public void setDescription(String string, String string2) throws MessagingException {
        throw new IllegalWriteException("IMAPMessage is read-only");
    }

    public void setDisposition(String string) throws MessagingException {
        throw new IllegalWriteException("IMAPMessage is read-only");
    }

    protected void setExpunged(boolean bl2) {
        super.setExpunged(bl2);
        this.seqnum = -1;
    }

    public void setFileName(String string) throws MessagingException {
        throw new IllegalWriteException("IMAPMessage is read-only");
    }

    public synchronized void setFlags(Flags flags, boolean bl2) throws MessagingException {
        Object object = this.getMessageCacheLock();
        synchronized (object) {
            this.checkExpunged();
            try {
                this.getProtocol().storeFlags(this.getSequenceNumber(), flags, bl2);
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException(this.folder, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
    }

    public void setFrom(Address address) throws MessagingException {
        throw new IllegalWriteException("IMAPMessage is read-only");
    }

    public void setHeader(String string, String string2) throws MessagingException {
        throw new IllegalWriteException("IMAPMessage is read-only");
    }

    private void setHeaderLoaded(String string) {
        if (this.loadedHeaders == null) {
            this.loadedHeaders = new Hashtable(1);
        }
        this.loadedHeaders.put(string.toUpperCase(), string);
    }

    protected void setMessageNumber(int n2) {
        super.setMessageNumber(n2);
    }

    public void setRecipients(Message.RecipientType recipientType, Address[] addressArray) throws MessagingException {
        throw new IllegalWriteException("IMAPMessage is read-only");
    }

    public void setReplyTo(Address[] addressArray) throws MessagingException {
        throw new IllegalWriteException("IMAPMessage is read-only");
    }

    public void setSentDate(Date date) throws MessagingException {
        throw new IllegalWriteException("IMAPMessage is read-only");
    }

    protected void setSequenceNumber(int n2) {
        this.seqnum = n2;
    }

    public void setSubject(String string, String string2) throws MessagingException {
        throw new IllegalWriteException("IMAPMessage is read-only");
    }

    protected void setUID(long l2) {
        this.uid = l2;
    }

    private String toSection(String string) {
        if (this.sectionId == null) {
            return string;
        }
        return String.valueOf(this.sectionId) + "." + string;
    }

    public void writeTo(OutputStream outputStream) throws IOException, MessagingException {
        int n2;
        IMAPProtocol iMAPProtocol = this.getProtocol();
        ByteArrayInputStream byteArrayInputStream = null;
        Object object = this.getMessageCacheLock();
        synchronized (object) {
            this.checkExpunged();
            try {
                Item item;
                if (iMAPProtocol.isREV1()) {
                    item = iMAPProtocol.fetchBody(this.getSequenceNumber(), this.sectionId);
                    if (item != null) {
                        byteArrayInputStream = ((BODY)item).getByteArrayInputStream();
                    }
                } else {
                    item = iMAPProtocol.fetchRFC822(this.getSequenceNumber(), null);
                    if (item != null) {
                        byteArrayInputStream = ((RFC822DATA)item).getByteArrayInputStream();
                    }
                }
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException(this.folder, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
        if (byteArrayInputStream == null) {
            throw new MessagingException("No content");
        }
        object = new byte[1024];
        while ((n2 = byteArrayInputStream.read((byte[])object)) != -1) {
            outputStream.write((byte[])object, 0, n2);
        }
    }
}

