/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap.protocol;

import com.sun.mail.iap.ParsingException;
import com.sun.mail.iap.Protocol;
import com.sun.mail.iap.ProtocolException;
import com.sun.mail.iap.Response;
import com.sun.mail.imap.protocol.BODY;
import com.sun.mail.imap.protocol.BODYSTRUCTURE;
import com.sun.mail.imap.protocol.ENVELOPE;
import com.sun.mail.imap.protocol.FLAGS;
import com.sun.mail.imap.protocol.IMAPResponse;
import com.sun.mail.imap.protocol.INTERNALDATE;
import com.sun.mail.imap.protocol.Item;
import com.sun.mail.imap.protocol.RFC822DATA;
import com.sun.mail.imap.protocol.RFC822SIZE;
import com.sun.mail.imap.protocol.UID;
import java.io.IOException;
import java.util.Vector;

public class FetchResponse
extends IMAPResponse {
    private Item[] items;
    private static final char[] HEADER = new char[]{'.', 'H', 'E', 'A', 'D', 'E', 'R'};
    private static final char[] TEXT = new char[]{'.', 'T', 'E', 'X', 'T'};

    public FetchResponse(Protocol protocol) throws IOException, ProtocolException {
        super(protocol);
        this.parse();
    }

    public FetchResponse(IMAPResponse iMAPResponse) throws IOException, ProtocolException {
        super(iMAPResponse);
        this.parse();
    }

    public Item getItem(int n2) {
        return this.items[n2];
    }

    public Item getItem(Class clazz) {
        int n2 = 0;
        while (n2 < this.items.length) {
            if (clazz.isInstance(this.items[n2])) {
                return this.items[n2];
            }
            ++n2;
        }
        return null;
    }

    public static Item getItem(Response[] responseArray, int n2, Class clazz) {
        if (responseArray == null) {
            return null;
        }
        int n3 = 0;
        while (n3 < responseArray.length) {
            if (responseArray[n3] != null && responseArray[n3] instanceof FetchResponse && ((FetchResponse)responseArray[n3]).getNumber() == n2) {
                FetchResponse fetchResponse = (FetchResponse)responseArray[n3];
                int n4 = 0;
                while (n4 < fetchResponse.items.length) {
                    if (clazz.isInstance(fetchResponse.items[n4])) {
                        return fetchResponse.items[n4];
                    }
                    ++n4;
                }
            }
            ++n3;
        }
        return null;
    }

    public int getItemCount() {
        return this.items.length;
    }

    private boolean match(char[] cArray) {
        int n2 = cArray.length;
        int n3 = 0;
        int n4 = this.index;
        while (n3 < n2) {
            if (Character.toUpperCase((char)this.buffer[n4++]) == cArray[n3++]) continue;
            return false;
        }
        return true;
    }

    private void parse() throws ParsingException {
        this.skipSpaces();
        if (this.buffer[this.index] != 40) {
            throw new ParsingException("error in FETCH parsing");
        }
        Vector<ENVELOPE> vector = new Vector<ENVELOPE>();
        Item item = null;
        do {
            ++this.index;
            switch (this.buffer[this.index]) {
                case 69: {
                    if (!this.match(ENVELOPE.name)) break;
                    this.index += ENVELOPE.name.length;
                    item = new ENVELOPE(this);
                    break;
                }
                case 70: {
                    if (!this.match(FLAGS.name)) break;
                    this.index += FLAGS.name.length;
                    item = new FLAGS(this);
                    break;
                }
                case 73: {
                    if (!this.match(INTERNALDATE.name)) break;
                    this.index += INTERNALDATE.name.length;
                    item = new INTERNALDATE(this);
                    break;
                }
                case 66: {
                    if (!this.match(BODY.name)) break;
                    if (this.buffer[this.index + 4] == 91) {
                        this.index += BODY.name.length;
                        item = new BODY(this);
                        break;
                    }
                    this.index = this.match(BODYSTRUCTURE.name) ? (this.index += BODYSTRUCTURE.name.length) : (this.index += BODY.name.length);
                    item = new BODYSTRUCTURE(this);
                    break;
                }
                case 82: {
                    if (this.match(RFC822SIZE.name)) {
                        this.index += RFC822SIZE.name.length;
                        item = new RFC822SIZE(this);
                        break;
                    }
                    if (!this.match(RFC822DATA.name)) break;
                    this.index += RFC822DATA.name.length;
                    if (this.match(HEADER)) {
                        this.index += HEADER.length;
                    } else if (this.match(TEXT)) {
                        this.index += TEXT.length;
                    }
                    item = new RFC822DATA(this);
                    break;
                }
                case 85: {
                    if (!this.match(UID.name)) break;
                    this.index += UID.name.length;
                    item = new UID(this);
                    break;
                }
            }
            if (item == null) continue;
            vector.addElement((ENVELOPE)item);
        } while (this.buffer[this.index] != 41);
        ++this.index;
        this.items = new Item[vector.size()];
        vector.copyInto(this.items);
    }
}

