/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.util;

import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;

public class UUDecoderStream
extends FilterInputStream {
    private String name;
    private int mode;
    private byte[] buffer;
    private int bufsize = 0;
    private int index = 0;
    private boolean gotPrefix = false;
    private byte[] decode_buffer = new byte[60];

    public UUDecoderStream(InputStream inputStream) {
        super(inputStream);
        if (!(inputStream instanceof PushbackInputStream)) {
            inputStream = new PushbackInputStream(inputStream);
        }
        this.buffer = new byte[45];
    }

    public int available() throws IOException {
        return this.in.available() * 3 / 4 + (this.bufsize - this.index);
    }

    private void decode() throws IOException {
        int n2;
        this.bufsize = 0;
        int n3 = this.in.read();
        if (n3 == -1) {
            throw new IOException("Short buffer error");
        }
        n3 = n3 - 32 & 0x3F;
        int n4 = (n3 * 8 + 5) / 6;
        int n5 = 0;
        while ((n2 = this.in.read(this.decode_buffer, n5, n4)) != n4) {
            if (n2 == -1) {
                throw new IOException("Error in encoded stream");
            }
            n4 -= n2;
            n5 += n2;
        }
        int n6 = 0;
        while (this.bufsize < n3) {
            byte by2 = (byte)(this.decode_buffer[n6++] - 32 & 0x3F);
            byte by3 = (byte)(this.decode_buffer[n6++] - 32 & 0x3F);
            this.buffer[this.bufsize++] = (byte)(by2 << 2 & 0xFC | by3 >>> 4 & 3);
            by2 = by3;
            by3 = (byte)(this.decode_buffer[n6++] - 32 & 0x3F);
            this.buffer[this.bufsize++] = (byte)(by2 << 4 & 0xF0 | by3 >>> 2 & 0xF);
            by2 = by3;
            by3 = (byte)(this.decode_buffer[n6++] - 32 & 0x3F);
            this.buffer[this.bufsize++] = (byte)(by2 << 6 & 0xC0 | by3 & 0x3F);
        }
        this.bufsize = n3;
        while ((n6 = this.in.read()) != 10 && n6 != 13) {
        }
        if (n6 == 13 && (n6 = this.in.read()) != 10) {
            ((PushbackInputStream)this.in).unread(n6);
        }
    }

    public int getMode() throws IOException {
        this.readPrefix();
        return this.mode;
    }

    public String getName() throws IOException {
        this.readPrefix();
        return this.name;
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        if (this.index >= this.bufsize) {
            this.readPrefix();
            this.decode();
            if (this.bufsize == 0) {
                this.readSuffix();
                return -1;
            }
            this.index = 0;
        }
        return this.buffer[this.index++] & 0xFF;
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        try {
            n4 = 0;
            while (n4 < n3) {
                int n5 = this.read();
                if (n5 == -1) {
                    if (n4 == 0) {
                        n4 = -1;
                    }
                    break;
                }
                byArray[n2 + n4] = (byte)n5;
                ++n4;
            }
        }
        catch (IOException iOException) {
            n4 = -1;
        }
        return n4;
    }

    private void readPrefix() throws IOException {
        String string;
        if (this.gotPrefix) {
            return;
        }
        DataInputStream dataInputStream = new DataInputStream(this.in);
        do {
            if ((string = dataInputStream.readLine()) != null) continue;
            throw new IOException("UUDecoder error: No Begin");
        } while (!string.regionMatches(true, 0, "begin", 0, 5));
        this.mode = Integer.parseInt(string.substring(6, 9));
        this.name = string.substring(10);
        this.gotPrefix = true;
    }

    private void readSuffix() throws IOException {
        DataInputStream dataInputStream = new DataInputStream(this.in);
        String string = dataInputStream.readLine();
        if (string == null || !string.regionMatches(true, 0, "end", 0, 3)) {
            throw new IOException("Missing End");
        }
    }
}

