/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import COM.rsa.jsafe.a5;
import COM.rsa.jsafe.au;
import COM.rsa.jsafe.bt;
import COM.rsa.jsafe.bz;
import com.sun.net.ssl.internal.ssl.ContentInfo;
import com.sun.net.ssl.internal.ssl.DerInputStream;
import com.sun.net.ssl.internal.ssl.DerValue;
import com.sun.net.ssl.internal.ssl.MacData;
import com.sun.net.ssl.internal.ssl.ObjectIdentifier;
import com.sun.net.ssl.internal.ssl.b2;
import com.sun.net.ssl.internal.ssl.by;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;

public final class PKCS12KeyStore
extends KeyStoreSpi {
    public static final int VERSION_3 = 3;
    private static final ObjectIdentifier a = new ObjectIdentifier("1.2.840.113549.1.12.10.1.2");
    private static final ObjectIdentifier b = new ObjectIdentifier("1.2.840.113549.1.12.10.1.3");
    private static final ObjectIdentifier c = new ObjectIdentifier("1.2.840.113549.1.9.20");
    private static final ObjectIdentifier d = new ObjectIdentifier("1.2.840.113549.1.9.21");
    private static final int e = 20;
    private Hashtable f = new Hashtable();
    private ArrayList g = new ArrayList();
    private HashMap h = new HashMap();
    private int i = 1;

    private static void a(byte[] byArray, byte[] byArray2, int n2, int n3) {
        int n4 = n3 / byArray.length;
        int n5 = 0;
        int n6 = 0;
        while (n5 < n4) {
            System.arraycopy(byArray, 0, byArray2, n6 + n2, byArray.length);
            ++n5;
            n6 += byArray.length;
        }
        System.arraycopy(byArray, 0, byArray2, n6 + n2, n3 - n6);
    }

    private static byte[] a(char[] cArray, byte[] byArray, int n2, int n3, int n4) {
        int n5 = cArray.length;
        if ((n5 *= 2) > 0) {
            n5 += 2;
        }
        byte[] byArray2 = new byte[n5];
        int n6 = 0;
        int n7 = 0;
        while (n6 < cArray.length) {
            byArray2[n7] = (byte)(cArray[n6] >>> 8 & 0xFF);
            byArray2[n7 + 1] = (byte)(cArray[n6] & 0xFF);
            ++n6;
            n7 += 2;
        }
        int n8 = 64;
        int n9 = 20;
        int n10 = PKCS12KeyStore.a(n3, n9) / n9;
        byte[] byArray3 = new byte[n8];
        int n11 = PKCS12KeyStore.a(byArray.length, n8);
        int n12 = PKCS12KeyStore.a(byArray2.length, n8);
        byte[] byArray4 = new byte[n11 + n12];
        byte[] byArray5 = new byte[n3];
        Arrays.fill(byArray3, (byte)n4);
        PKCS12KeyStore.a(byArray, byArray4, 0, n11);
        PKCS12KeyStore.a(byArray2, byArray4, n11, n12);
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
            byte[] byArray6 = new byte[n8];
            byte[] byArray7 = new byte[n8];
            int n13 = 0;
            while (true) {
                messageDigest.update(byArray3);
                messageDigest.update(byArray4);
                byte[] byArray8 = messageDigest.digest();
                int n14 = 1;
                while (n14 < n2) {
                    byArray8 = messageDigest.digest(byArray8);
                    ++n14;
                }
                System.arraycopy(byArray8, 0, byArray5, n9 * n13, Math.min(n3, n9));
                if (n13 + 1 != n10) {
                    PKCS12KeyStore.a(byArray8, byArray6, 0, byArray6.length);
                    BigInteger bigInteger = new BigInteger(1, byArray6).add(BigInteger.ONE);
                    int n15 = 0;
                    while (n15 < byArray4.length) {
                        if (byArray7.length != n8) {
                            byArray7 = new byte[n8];
                        }
                        System.arraycopy(byArray4, n15, byArray7, 0, n8);
                        BigInteger bigInteger2 = new BigInteger(1, byArray7);
                        bigInteger2 = bigInteger2.add(bigInteger);
                        byArray7 = bigInteger2.toByteArray();
                        int n16 = byArray7.length - n8;
                        if (n16 >= 0) {
                            System.arraycopy(byArray7, n16, byArray4, n15, n8);
                        } else if (n16 < 0) {
                            Arrays.fill(byArray4, n15, n15 + -n16, (byte)0);
                            System.arraycopy(byArray7, 0, byArray4, n15 + -n16, byArray7.length);
                        }
                        n15 += n8;
                    }
                    ++n13;
                    n3 -= n9;
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            System.out.println("Caught " + exception);
            exception.printStackTrace();
        }
        return byArray5;
    }

    static byte[] a(char[] cArray, byte[] byArray, int n2, int n3) {
        return PKCS12KeyStore.a(cArray, byArray, n2, n3, 2);
    }

    static byte[] b(char[] cArray, byte[] byArray, int n2, int n3) {
        return PKCS12KeyStore.a(cArray, byArray, n2, n3, 1);
    }

    static byte[] c(char[] cArray, byte[] byArray, int n2, int n3) {
        return PKCS12KeyStore.a(cArray, byArray, n2, n3, 3);
    }

    private static byte[] a(a5 a52, byte[] byArray) throws Exception {
        byte[] byArray2;
        int n2 = a52.a(byArray.length);
        byte[] byArray3 = new byte[n2];
        int n3 = 0;
        n3 = a52.a(byArray, 0, byArray.length, byArray3, 0);
        if ((n3 += a52.a(byArray3, n3)) < byArray3.length) {
            byArray2 = new byte[n3];
            System.arraycopy(byArray3, 0, byArray2, 0, byArray2.length);
        } else {
            byArray2 = byArray3;
        }
        return byArray2;
    }

    public Enumeration engineAliases() {
        return this.f.keys();
    }

    public boolean engineContainsAlias(String string) {
        return this.f.containsKey(string.toLowerCase());
    }

    public void engineDeleteEntry(String string) throws KeyStoreException {
        Hashtable hashtable = this.f;
        synchronized (hashtable) {
            this.f.remove(string.toLowerCase());
        }
    }

    public Certificate engineGetCertificate(String string) {
        Object v2 = this.f.get(string.toLowerCase());
        if (v2 != null) {
            if (v2 instanceof b2) {
                return ((b2)v2).c;
            }
            if (((by)v2).d == null) {
                return null;
            }
            return ((by)v2).d[0];
        }
        return null;
    }

    public String engineGetCertificateAlias(Certificate certificate) {
        Enumeration enumeration = this.f.keys();
        while (enumeration.hasMoreElements()) {
            Certificate certificate2;
            String string = (String)enumeration.nextElement();
            Object v2 = this.f.get(string);
            if (v2 instanceof b2) {
                certificate2 = ((b2)v2).c;
            } else {
                if (((by)v2).d == null) continue;
                certificate2 = ((by)v2).d[0];
            }
            if (!certificate2.equals(certificate)) continue;
            return string;
        }
        return null;
    }

    public Certificate[] engineGetCertificateChain(String string) {
        Object v2 = this.f.get(string.toLowerCase());
        if (v2 != null && v2 instanceof by) {
            if (((by)v2).d == null) {
                return null;
            }
            return (Certificate[])((by)v2).d.clone();
        }
        return null;
    }

    public Date engineGetCreationDate(String string) {
        Object v2 = this.f.get(string.toLowerCase());
        if (v2 != null) {
            if (v2 instanceof b2) {
                return new Date(((b2)v2).b.getTime());
            }
            return new Date(((by)v2).b.getTime());
        }
        return null;
    }

    public Key engineGetKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        Object v2 = this.f.get(string.toLowerCase());
        PrivateKey privateKey = null;
        if (v2 == null || !(v2 instanceof by)) {
            return null;
        }
        byte[] byArray = ((by)v2).c;
        try {
            DerValue derValue = new DerValue(byArray);
            DerValue[] derValueArray = new DerValue[]{derValue.data.getDerValue(), derValue.data.getDerValue()};
            if (derValue.data.available() != 0) {
                throw new IOException("overrun, bytes = " + derValue.data.available());
            }
            byte[] byArray2 = derValueArray[1].getOctetString();
            a5 a52 = a5.a(byArray, 0, "Java");
            bt bt2 = a52.g();
            bt2.a(cArray, 0, cArray.length);
            a52.a(bt2);
            if (!"3DES_EDE".equals(a52.m())) {
                throw new NoSuchAlgorithmException("3DES_EDE only for shrouded keys");
            }
            byte[] byArray3 = PKCS12KeyStore.b(cArray, a52.u(), a52.q()[0], a52.q()[1] * a52.h());
            byte[] byArray4 = PKCS12KeyStore.a(cArray, a52.u(), a52.q()[0], a52.h());
            String string2 = String.valueOf(a52.m()) + "/" + a52.n() + "/" + a52.s();
            a52 = a5.a(string2, "Java");
            a52.c(byArray4, 0, byArray4.length);
            bt2 = a52.g();
            bt2.a(byArray3, 0, byArray3.length);
            a52.a(bt2);
            byte[] byArray5 = PKCS12KeyStore.a(a52, byArray2);
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray5);
            au au2 = au.a(byArray5, 0, "Java");
            KeyFactory keyFactory = KeyFactory.getInstance(au2.b());
            privateKey = keyFactory.generatePrivate(pKCS8EncodedKeySpec);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new UnrecoverableKeyException(exception.getMessage());
        }
        return privateKey;
    }

    public boolean engineIsCertificateEntry(String string) {
        Object v2 = this.f.get(string.toLowerCase());
        return v2 != null && v2 instanceof b2;
    }

    public boolean engineIsKeyEntry(String string) {
        Object v2 = this.f.get(string.toLowerCase());
        return v2 != null && v2 instanceof by;
    }

    public void engineLoad(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        Hashtable hashtable = this.f;
        synchronized (hashtable) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object var6_4 = null;
            Object var7_5 = null;
            Hashtable hashtable2 = null;
            Object var9_7 = null;
            Object var10_8 = null;
            if (inputStream == null) {
                Object var4_9 = null;
                return;
            }
            DerValue derValue = new DerValue(inputStream);
            DerInputStream derInputStream = derValue.toDerInputStream();
            int n2 = derInputStream.getInteger().toInt();
            if (n2 != 3) {
                throw new IOException("PKCS12 keystore not in version 3 format");
            }
            hashtable2 = new Hashtable(3);
            this.f.clear();
            ContentInfo contentInfo = new ContentInfo(derInputStream);
            ObjectIdentifier objectIdentifier = contentInfo.getContentType();
            if (!objectIdentifier.equals(ContentInfo.DATA_OID)) {
                throw new IOException("public key protected PKCS12 not supported");
            }
            byte[] byArray = contentInfo.getData();
            DerInputStream derInputStream2 = new DerInputStream(byArray);
            DerValue[] derValueArray = derInputStream2.getSequence(2);
            int n3 = derValueArray.length;
            int n4 = 0;
            while (n4 < n3) {
                object5 = null;
                object4 = new DerInputStream(derValueArray[n4].toByteArray());
                object3 = new ContentInfo((DerInputStream)object4);
                objectIdentifier = ((ContentInfo)object3).getContentType();
                object2 = null;
                if (objectIdentifier.equals(ContentInfo.DATA_OID)) {
                    object2 = ((ContentInfo)object3).getData();
                } else if (objectIdentifier.equals(ContentInfo.ENCRYPTED_DATA_OID)) {
                    object = ((ContentInfo)object3).getContent().toDerInputStream();
                    int n5 = ((DerInputStream)object).getInteger().toInt();
                    DerValue[] derValueArray2 = ((DerInputStream)object).getSequence(2);
                    ObjectIdentifier objectIdentifier2 = derValueArray2[0].getOID();
                    object5 = derValueArray2[1].toByteArray();
                    if (!derValueArray2[2].isContextSpecific((byte)0)) {
                        throw new IOException("encrypted content not present!");
                    }
                    byte by2 = 4;
                    if (derValueArray2[2].isConstructed()) {
                        by2 = (byte)(by2 | 0x20);
                    }
                    derValueArray2[2].resetTag(by2);
                    object2 = derValueArray2[2].getOctetString();
                    try {
                        a5 a52 = a5.a((byte[])object5, 0, "Java");
                        bt bt2 = a52.g();
                        bt2.a(cArray, 0, cArray.length);
                        a52.a(bt2);
                        if (!"RC2".equals(a52.m())) {
                            throw new NoSuchAlgorithmException("RC2 Only for safeContents");
                        }
                        byte[] byArray2 = bt2.n();
                        byte[] byArray3 = a52.p();
                        int[] nArray = a52.q();
                        String string = "RC2-" + nArray[1] + "/CBC/PKCS5Padding";
                        a52 = a5.a(string, "Java");
                        a52.c(byArray3, 0, byArray3.length);
                        bt2 = a52.g();
                        bt2.a(byArray2, 0, byArray2.length);
                        a52.a(bt2);
                        object2 = PKCS12KeyStore.a(a52, (byte[])object2);
                    }
                    catch (Exception exception) {
                        System.out.println("Caught: " + exception);
                        exception.printStackTrace();
                    }
                } else {
                    throw new IOException("public key protected PKCS12 not supported");
                }
                object = new DerInputStream((byte[])object2);
                this.a((DerInputStream)object, cArray);
                ++n4;
            }
            if (derInputStream.available() > 0) {
                object2 = new MacData(derInputStream);
                try {
                    object3 = object2.getDigestAlgName().toUpperCase();
                    object4 = bz.a("HMAC/" + (String)object3, "Java");
                    object5 = PKCS12KeyStore.c(cArray, object2.getSalt(), object2.getIterations(), 20);
                    object = ((bz)object4).c();
                    ((bt)object).a((byte[])object5, 0, ((Object)object5).length);
                    ((bz)object4).a((bt)object, new SecureRandom());
                    ((bz)object4).a(byArray, 0, byArray.length);
                    byte[] byArray4 = ((bz)object4).i();
                    if (!Arrays.equals(object2.getDigest(), byArray4)) {
                        throw new SecurityException("Failed PKCS12 integrity checking");
                    }
                }
                catch (Exception exception) {
                    System.out.println("Caught: " + exception);
                    exception.printStackTrace();
                }
            }
            object2 = this.g.toArray();
            int n6 = 0;
            while (n6 < ((Object)object2).length) {
                object4 = (by)object2[n6];
                if (((by)object4).e != null) {
                    object5 = new ArrayList();
                    object = (X509Certificate)this.h.get(new KeyId(((by)object4).e));
                    while (object != null) {
                        ((ArrayList)object5).add(object);
                        if (((X509Certificate)object).getIssuerDN().equals(((X509Certificate)object).getSubjectDN())) break;
                        object = (X509Certificate)this.h.get(((X509Certificate)object).getIssuerDN());
                    }
                    if (((ArrayList)object5).size() > 0) {
                        ((by)object4).d = ((ArrayList)object5).toArray(new Certificate[((ArrayList)object5).size()]);
                    }
                }
                ++n6;
            }
            this.h.clear();
            this.g.clear();
        }
    }

    public void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        Hashtable hashtable = this.f;
        synchronized (hashtable) {
            Object v2 = this.f.get(string.toLowerCase());
            if (v2 != null && v2 instanceof by) {
                throw new KeyStoreException("Cannot overwrite own certificate");
            }
            b2 b22 = new b2(this);
            b22.c = certificate;
            b22.b = new Date();
            this.f.put(string.toLowerCase(), b22);
        }
    }

    public void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        try {
            Hashtable hashtable = this.f;
            synchronized (hashtable) {
                by by2 = new by(this);
                by2.b = new Date();
                if (certificateArray != null) {
                    by2.d = (Certificate[])certificateArray.clone();
                }
                this.f.put(string.toLowerCase(), by2);
            }
        }
        catch (Exception exception) {
            throw new KeyStoreException("Key protection algorithm not found");
        }
    }

    public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        Hashtable hashtable = this.f;
        synchronized (hashtable) {
            by by2 = new by(this);
            by2.b = new Date();
            by2.c = (byte[])byArray.clone();
            if (certificateArray != null) {
                by2.d = (Certificate[])certificateArray.clone();
            }
            this.f.put(string.toLowerCase(), by2);
        }
    }

    public int engineSize() {
        return this.f.size();
    }

    public void engineStore(OutputStream outputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        Hashtable hashtable = this.f;
        synchronized (hashtable) {
            throw new IOException("PKCS 12 storing not implemented");
        }
    }

    private void a(DerInputStream derInputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        DerValue[] derValueArray = derInputStream.getSequence(2);
        int n2 = derValueArray.length;
        int n3 = 0;
        while (n3 < n2) {
            DerValue[] derValueArray2;
            Object object;
            Object object2;
            Object object3;
            DerValue[] derValueArray3;
            DerValue[] derValueArray4 = null;
            DerInputStream derInputStream2 = derValueArray[n3].toDerInputStream();
            ObjectIdentifier objectIdentifier = derInputStream2.getOID();
            DerValue derValue = derInputStream2.getDerValue();
            if (!derValue.isContextSpecific((byte)0)) {
                throw new IOException("unsupported PKCS12 bag value type " + derValue.tag);
            }
            derValue = derValue.data.getDerValue();
            if (objectIdentifier.equals(a)) {
                derValueArray3 = new by(this);
                derValueArray3.c = derValue.toByteArray();
                derValueArray3.b = new Date();
                derValueArray4 = derValueArray3;
            } else if (objectIdentifier.equals(b)) {
                derValueArray3 = new DerInputStream(derValue.toByteArray());
                object3 = derValueArray3.getSequence(2);
                object2 = object3[0].getOID();
                if (!object3[1].isContextSpecific((byte)0)) {
                    throw new IOException("unsupported PKCS12 cert value type " + object3[1].tag);
                }
                DerValue derValue2 = object3[1].data.getDerValue();
                object = CertificateFactory.getInstance("X509");
                derValueArray2 = (DerValue[])((CertificateFactory)object).generateCertificate(new ByteArrayInputStream(derValue2.getOctetString()));
                derValueArray4 = derValueArray2;
            } else {
                throw new IOException("unsupported PKCS12 bag type " + objectIdentifier);
            }
            derValueArray3 = derInputStream2.getSet(2);
            object3 = null;
            object2 = null;
            int n4 = 0;
            while (n4 < derValueArray3.length) {
                object = new DerInputStream(derValueArray3[n4].toByteArray());
                derValueArray2 = ((DerInputStream)object).getSequence(2);
                ObjectIdentifier objectIdentifier2 = derValueArray2[0].getOID();
                DerInputStream derInputStream3 = new DerInputStream(derValueArray2[1].toByteArray());
                DerValue[] derValueArray5 = derInputStream3.getSet(2);
                if (objectIdentifier2.equals(c)) {
                    object3 = derValueArray5[0].getBMPString();
                } else if (objectIdentifier2.equals(d)) {
                    object2 = derValueArray5[0].getOctetString();
                } else {
                    System.out.println("unknown attr" + objectIdentifier2);
                }
                ++n4;
            }
            if (derValueArray4 instanceof by) {
                object = (by)derValueArray4;
                ((by)object).e = (byte[])object2;
                ((by)object).f = object3;
                this.g.add(object);
                this.f.put(object3.toLowerCase(), object);
            } else if (derValueArray4 instanceof X509Certificate) {
                object = (X509Certificate)derValueArray4;
                if (object2 != null) {
                    this.h.put(new KeyId((byte[])object2), derValueArray4);
                }
                if (object3 != null) {
                    this.h.put(object3, derValueArray4);
                }
                if (((X509Certificate)object).getSubjectDN() != null) {
                    this.h.put(((X509Certificate)object).getSubjectDN(), derValueArray4);
                }
            }
            ++n3;
        }
    }

    private static int a(int n2, int n3) {
        return (n2 + (n3 - 1)) / n3 * n3;
    }

    class KeyId {
        byte[] b;

        KeyId(byte[] byArray) {
            this.b = byArray;
        }

        public boolean equals(Object object) {
            if (!(object instanceof KeyId)) {
                return false;
            }
            KeyId keyId = (KeyId)object;
            if (this.b == keyId.b) {
                return true;
            }
            if (this.b.length != keyId.b.length) {
                return false;
            }
            int n2 = 0;
            while (n2 < this.b.length) {
                if (this.b[n2] != keyId.b[n2]) {
                    return false;
                }
                ++n2;
            }
            return true;
        }

        public int hashCode() {
            int n2 = 0;
            int n3 = 0;
            while (n3 < this.b.length) {
                n2 += this.b[n3];
                ++n3;
            }
            return n2;
        }
    }
}

