/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.www.https;

import com.sun.net.ssl.internal.www.HeaderParser;
import com.sun.net.ssl.internal.www.MessageHeader;
import com.sun.net.ssl.internal.www.MeteredStream;
import com.sun.net.ssl.internal.www.NetworkClient;
import com.sun.net.ssl.internal.www.ProgressData;
import com.sun.net.ssl.internal.www.ProgressEntry;
import com.sun.net.ssl.internal.www.https.ChunkedInputStream;
import com.sun.net.ssl.internal.www.https.KeepAliveCache;
import com.sun.net.ssl.internal.www.https.KeepAliveStream;
import com.sun.net.ssl.internal.www.https.RegexpPool;
import com.sun.net.ssl.internal.www.https.b4;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PushbackInputStream;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.StringTokenizer;
import javax.net.ssl.SSLSocketFactory;
import sun.security.action.GetPropertyAction;

public class HttpClient
extends NetworkClient {
    MessageHeader a;
    boolean b = false;
    KeepAliveStream c;
    private static RegexpPool d = new RegexpPool();
    private static String e = null;
    private static final int f = 100;
    static final int g = 80;
    public static String proxyHost = null;
    public static int proxyPort = 80;
    private String h = null;
    private int i = -1;
    protected boolean proxyDisabled;
    public boolean usingProxy = false;
    private String j;
    private int k;
    protected static KeepAliveCache kac = new KeepAliveCache();
    boolean l = false;
    int m = -1;
    int n = 0;
    protected URL url;

    private HttpClient(URL uRL) throws IOException {
        this(uRL, null, -1, false);
    }

    public HttpClient(URL uRL, String string, int n2) throws IOException {
        this(uRL, string, n2, false);
    }

    private HttpClient(URL uRL, String string, int n2, boolean bl2) throws IOException {
        this.proxyDisabled = bl2;
        if (!bl2) {
            this.h = string;
            this.i = n2 < 0 ? this.getDefaultPort() : n2;
        }
        try {
            InetAddress inetAddress = InetAddress.getByName(uRL.getHost());
            this.j = inetAddress.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            this.j = uRL.getHost();
        }
        this.url = uRL;
        this.k = uRL.getPort();
        if (this.k == -1) {
            this.k = this.getDefaultPort();
        }
        this.d();
    }

    protected HttpClient(URL uRL, boolean bl2) throws IOException {
        this(uRL, null, -1, bl2);
    }

    protected HttpClient(SSLSocketFactory sSLSocketFactory, URL uRL, boolean bl2) throws IOException {
        Object var4_4 = null;
        int n2 = -1;
        this.a(sSLSocketFactory);
        this.proxyDisabled = bl2;
        if (!bl2) {
            this.h = var4_4;
            this.i = n2 < 0 ? this.getDefaultPort() : n2;
        }
        try {
            InetAddress inetAddress = InetAddress.getByName(uRL.getHost());
            this.j = inetAddress.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            this.j = uRL.getHost();
        }
        this.url = uRL;
        this.k = uRL.getPort();
        if (this.k == -1) {
            this.k = this.getDefaultPort();
        }
        this.d();
    }

    public void closeServer() {
        try {
            this.l = false;
            this.serverSocket.close();
        }
        catch (Exception exception) {}
    }

    protected void finalize() throws Throwable {
    }

    public static void finished(HttpClient httpClient) {
        --httpClient.m;
        if (httpClient.m > 0 && httpClient.l && !httpClient.serverOutput.checkError()) {
            kac.register(httpClient);
        } else {
            httpClient.closeServer();
        }
    }

    protected int getDefaultPort() {
        return 80;
    }

    private static RegexpPool a() {
        RegexpPool regexpPool = d;
        synchronized (regexpPool) {
            String string = AccessController.doPrivileged(new GetPropertyAction("http.nonProxyHosts"));
            if (string == e) {
                RegexpPool regexpPool2 = d;
                Object var2_3 = null;
                return regexpPool2;
            }
            RegexpPool regexpPool3 = new RegexpPool();
            if (string != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "|", false);
                try {
                    while (stringTokenizer.hasMoreTokens()) {
                        regexpPool3.add(stringTokenizer.nextToken().toLowerCase(), Boolean.TRUE);
                    }
                }
                catch (b4 b42) {
                    System.err.println("Error in http.nonProxyHosts system property:  " + b42);
                }
            }
            e = string;
            d = regexpPool3;
        }
        return d;
    }

    public boolean getHttpKeepAliveSet() {
        boolean bl2 = true;
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("http.keepAlive");
            }
        });
        if (string != null) {
            bl2 = Boolean.valueOf(string);
        }
        return bl2;
    }

    public synchronized InputStream getInputStream() {
        return this.serverInput;
    }

    public OutputStream getOutputStream() {
        return this.serverOutput;
    }

    private String b() {
        String string = AccessController.doPrivileged(new GetPropertyAction("http.proxyHost"));
        if (string == null) {
            string = AccessController.doPrivileged(new GetPropertyAction("proxyHost"));
        }
        if (string != null && string.length() == 0) {
            string = null;
        }
        return string;
    }

    public String getProxyHostUsed() {
        if (!this.usingProxy) {
            return null;
        }
        return this.h;
    }

    private int c() {
        final int[] nArray = new int[1];
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                nArray[0] = System.getProperty("http.proxyHost") != null ? Integer.getInteger("http.proxyPort", 80).intValue() : Integer.getInteger("proxyPort", 80).intValue();
                return null;
            }
        });
        return nArray[0];
    }

    public int getProxyPortUsed() {
        return this.i;
    }

    public String getURLFile() {
        String string = this.url.getFile();
        if (string == null || string.length() == 0) {
            string = "/";
        }
        if (this.usingProxy) {
            String string2 = String.valueOf(this.url.getProtocol()) + "://" + this.url.getHost();
            if (this.url.getPort() != -1) {
                string2 = String.valueOf(string2) + ":" + this.url.getPort();
            }
            return String.valueOf(string2) + string;
        }
        return string;
    }

    public final boolean isKeepingAlive() {
        return this.getHttpKeepAliveSet() && this.l;
    }

    private boolean a(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        if (string.equalsIgnoreCase("localhost")) {
            return true;
        }
        if (!Character.isDigit(string.charAt(0))) {
            return false;
        }
        boolean bl2 = true;
        int n2 = 0;
        char[] cArray = string.toCharArray();
        int n3 = 0;
        while (n3 < cArray.length) {
            char c10 = cArray[n3];
            if (c10 < '0' || c10 > '9') {
                return false;
            }
            int n4 = 0;
            while (c10 != '.') {
                if (c10 < '0' || c10 > '9') {
                    return false;
                }
                n4 = n4 * 10 + c10 - 48;
                if (++n3 >= cArray.length) break;
                c10 = cArray[n3];
            }
            if (n4 > 255) {
                return false;
            }
            if (bl2) {
                bl2 = false;
                if (n4 != 127) {
                    return false;
                }
            }
            ++n2;
            ++n3;
        }
        return n2 == 4 && !string.endsWith(".");
    }

    private synchronized void d() throws IOException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkConnect(this.j, this.k);
        }
        if (this.l) {
            return;
        }
        RegexpPool regexpPool = HttpClient.a();
        String string = this.url.getHost().toLowerCase();
        boolean bl2 = this.a(string);
        if (this.url.getProtocol().equals("http")) {
            if (this.h != null && !bl2) {
                this.a(this.h, this.i);
                this.usingProxy = true;
                return;
            }
            String string2 = this.b();
            if (string2 != null && !this.proxyDisabled && !bl2 && regexpPool.match(string) == null && regexpPool.match(this.j) == null) {
                try {
                    int n2 = this.c();
                    this.a(string2, n2);
                    this.h = string2;
                    this.i = n2;
                    this.usingProxy = true;
                    return;
                }
                catch (IOException iOException) {}
            }
            this.openServer(this.j, this.k);
            this.usingProxy = false;
            return;
        }
        if (this.h != null && !bl2) {
            this.b(this.h, this.i);
            this.usingProxy = true;
            return;
        }
        String string3 = this.b();
        if (string3 != null && !this.proxyDisabled && !bl2 && regexpPool.match(string) == null && regexpPool.match(this.j) == null) {
            try {
                int n3 = this.c();
                this.b(string3, n3);
                this.h = string3;
                this.i = n3;
                this.usingProxy = true;
                return;
            }
            catch (IOException iOException) {}
        }
        super.openServer(this.j, this.k);
        this.usingProxy = false;
    }

    public void openServer(String string, int n2) throws IOException {
        this.serverSocket = this.doConnect(string, n2);
        this.serverOutput = new PrintStream(new BufferedOutputStream(this.serverSocket.getOutputStream()));
        this.serverSocket.setTcpNoDelay(true);
    }

    public boolean parseHTTP(MessageHeader messageHeader, ProgressEntry progressEntry) throws IOException {
        try {
            this.serverInput = this.serverSocket.getInputStream();
            this.serverInput = new BufferedInputStream(this.serverInput);
            this.serverInput = new PushbackInputStream(this.serverInput, 8);
            return this.a(messageHeader, progressEntry);
        }
        catch (IOException iOException) {
            this.closeServer();
            if (!this.b && this.a != null) {
                this.b = true;
                this.d();
                this.writeRequests(this.a);
                return this.parseHTTP(messageHeader, progressEntry);
            }
            throw iOException;
        }
    }

    private boolean a(MessageHeader messageHeader, ProgressEntry progressEntry) throws IOException {
        this.m = -1;
        this.n = 0;
        boolean bl2 = false;
        byte[] byArray = new byte[8];
        int n2 = 0;
        while (n2 < 8) {
            int n3 = this.serverInput.read(byArray, n2, 8 - n2);
            if (n3 < 0) break;
            n2 += n3;
        }
        String string = null;
        bl2 = byArray[0] == 72 && byArray[1] == 84 && byArray[2] == 84 && byArray[3] == 80 && byArray[4] == 47 && byArray[5] == 49 && byArray[6] == 46;
        ((PushbackInputStream)this.serverInput).unread(byArray);
        if (bl2) {
            messageHeader.parseHeader(this.serverInput);
            if (this.usingProxy) {
                string = messageHeader.findValue("Proxy-Connection");
            }
            if (string == null) {
                string = messageHeader.findValue("Connection");
            }
            if (string != null && string.toLowerCase().equals("keep-alive")) {
                HeaderParser headerParser = new HeaderParser(messageHeader.findValue("Keep-Alive"));
                if (headerParser != null) {
                    this.m = headerParser.findInt("max", 5);
                    this.n = headerParser.findInt("timeout", 5);
                }
            } else if (byArray[7] != 48) {
                this.m = string != null ? 1 : 2;
            }
        } else {
            if (n2 != 8) {
                if (!this.b && this.a != null) {
                    this.b = true;
                    this.closeServer();
                    this.d();
                    this.writeRequests(this.a);
                    return this.parseHTTP(messageHeader, progressEntry);
                }
                throw new SocketException("Unexpected end of file from server");
            }
            messageHeader.set("Content-type", "unknown/unknown");
        }
        n2 = -1;
        try {
            string = messageHeader.getValue(0);
            int n4 = string.indexOf(32);
            while (string.charAt(n4) == ' ') {
                ++n4;
            }
            n2 = Integer.parseInt(string.substring(n4, n4 + 3));
        }
        catch (Exception exception) {}
        if (n2 == 100) {
            return this.a(messageHeader, progressEntry);
        }
        string = null;
        try {
            string = messageHeader.findValue("Transfer-Encoding");
        }
        catch (Exception exception) {}
        if (string != null && string.equalsIgnoreCase("chunked")) {
            InputStream inputStream = this.serverInput;
            this.serverInput = new ChunkedInputStream(this.serverInput);
            messageHeader.set("content-length", Integer.toString(this.serverInput.available()));
            messageHeader.mergeHeader(inputStream);
        }
        int n5 = -1;
        try {
            n5 = Integer.parseInt(messageHeader.findValue("content-length"));
        }
        catch (Exception exception) {}
        if (this.m > 1 && n5 > 0) {
            this.l = true;
        } else if (this.l) {
            this.l = false;
        }
        if (n5 > 0) {
            progressEntry.setType(this.url.getFile(), messageHeader.findValue("content-type"));
            progressEntry.update(0, n5);
            if (this.l) {
                this.c = new KeepAliveStream(this.serverInput, progressEntry, this);
                this.serverInput = this.c;
                this.b = false;
            } else {
                this.serverInput = new MeteredStream(this.serverInput, progressEntry);
            }
        } else {
            ProgressData.pdata.unregister(progressEntry);
        }
        return bl2;
    }

    private synchronized void a(final String string, final int n2) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    this.openServer(string, n2);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    private synchronized void b(final String string, final int n2) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    this.c(string, n2);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    public static synchronized void resetProperties() {
    }

    void a(SSLSocketFactory sSLSocketFactory) {
        Thread.dumpStack();
    }

    private void c(String string, int n2) throws IOException, UnknownHostException {
        super.openServer(string, n2);
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "(" + this.url + ")";
    }

    public void writeRequests(MessageHeader messageHeader) {
        this.a = messageHeader;
        this.a.print(this.serverOutput);
        this.serverOutput.flush();
    }
}

