/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.security;

import com.sun.web.security.AuthInfo;
import com.sun.web.security.HttpAuthenticator;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

class BasicAuthentication
extends HttpAuthenticator {
    private static final boolean debug = false;
    private static final String AUTH_REQ_HEADER = "WWW-Authenticate";
    private static final String AUTH_RES_HEADER = "Authorization";

    public BasicAuthentication(HttpServletRequest req, HttpServletResponse res) {
        super(req, res);
    }

    public boolean authenticate() throws IOException {
        if (!this.hasAuthData()) {
            return false;
        }
        AuthInfo info = new AuthInfo(this.getAuthData());
        if (info.getScheme() == null || info.getUser() == null) {
            return false;
        }
        String user = info.getUser();
        String passwd = info.getPassword();
        return this.authenticate(user, passwd);
    }

    private String getAuthData() {
        return this.getRequest().getHeader(AUTH_RES_HEADER);
    }

    private String getRequestHeader() {
        return "Basic realm=\"" + this.getRealm() + "\"";
    }

    private boolean hasAuthData() {
        return this.getAuthData() != null;
    }

    public void init() throws IOException {
    }

    public void sendError() throws IOException {
        HttpServletResponse resp = this.getResponse();
        resp.setHeader(AUTH_REQ_HEADER, this.getRequestHeader());
        resp.sendError(401);
        resp.setStatus(401);
    }
}

