/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.security;

import com.sun.web.security.HttpAuthenticator;
import com.sun.web.security.SecurityInterceptor;
import java.io.IOException;
import java.net.Socket;
import java.security.cert.X509Certificate;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLSocket;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.tomcat.core.HttpServletRequestFacade;
import org.apache.tomcat.server.ServerRequest;

class MutualAuthentication
extends HttpAuthenticator
implements HandshakeCompletedListener {
    private static final String REALM_NAME = "certificate";
    private static final boolean debug = false;
    private boolean rehandshake = false;

    public MutualAuthentication(HttpServletRequest req, HttpServletResponse res) {
        super(req, res);
        this.setRealm(REALM_NAME);
    }

    public boolean authenticate() throws IOException {
        while (this.rehandshake) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        SecurityInterceptor.setSSLAttributes(this.getRequest());
        SSLSocket ssock = this.getSocket();
        if (ssock != null) {
            X509Certificate[] certs;
            try {
                certs = (X509Certificate[])this.getRequest().getAttribute("javax.servlet.request.X509Certificate");
            }
            catch (Exception e10) {
                e10.printStackTrace();
                return false;
            }
            if (certs.length > 0) {
                String principalName = this.getPrincipalName(certs[0]);
                try {
                    return this.authenticate(principalName, REALM_NAME, certs[0].getEncoded());
                }
                catch (Exception exception) {
                    return false;
                }
            }
        }
        return false;
    }

    private String getPrincipalName(X509Certificate cert) {
        String subject = cert.getSubjectDN().getName();
        int start = subject.indexOf("CN=") + 3;
        int end = subject.indexOf(",", start);
        return subject.substring(start, end).trim();
    }

    private SSLSocket getSocket() {
        HttpServletRequest req = this.getRequest();
        ServerRequest sreq = (ServerRequest)((HttpServletRequestFacade)req).getRealRequest();
        Socket s2 = sreq.getSocket();
        if (s2 instanceof SSLSocket) {
            return (SSLSocket)s2;
        }
        return null;
    }

    public void handshakeCompleted(HandshakeCompletedEvent event) {
        SSLSocket sock = event.getSocket();
        sock.removeHandshakeCompletedListener(this);
        this.rehandshake = false;
    }

    public void init() throws IOException {
        try {
            HttpServletRequest req = this.getRequest();
            HttpServletResponse res = this.getResponse();
            SSLSocket ssock = this.getSocket();
            if (ssock != null) {
                ssock.setNeedClientAuth(true);
                ssock.addHandshakeCompletedListener(this);
                this.rehandshake = true;
                ssock.startHandshake();
                ssock.getOutputStream().flush();
            }
        }
        catch (Exception exception) {}
    }

    public void sendError() throws IOException {
        HttpServletResponse res = this.getResponse();
        res.sendError(403);
        res.setStatus(403);
    }
}

